"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const fzLocal = {
    led_trading_9133: {
        cluster: "greenPower",
        type: ["commandNotification", "commandCommissioningNotification"],
        convert: (model, msg, publish, options, meta) => {
            const commandID = msg.data.commandID;
            if (utils.hasAlreadyProcessedMessage(msg, model, msg.data.frameCounter, `${msg.device.ieeeAddr}_${commandID}`))
                return;
            if (commandID === 224)
                return;
            const lookup = {
                19: "press_1",
                20: "press_2",
                21: "press_3",
                22: "press_4",
                27: "hold_1",
                28: "hold_2",
                29: "hold_3",
                30: "hold_4",
            };
            return { action: utils.getFromLookup(commandID, lookup) };
        },
    },
};
exports.definitions = [
    {
        fingerprint: [{ modelID: "GreenPower_2", ieeeAddr: /^0x00000000427.....$/ }],
        model: "9133",
        vendor: "LED-Trading",
        description: "Pushbutton transmitter module",
        fromZigbee: [fzLocal.led_trading_9133],
        toZigbee: [],
        exposes: [e.action(["press_1", "hold_1", "press_2", "hold_2", "press_3", "hold_3", "press_4", "hold_4"])],
    },
    {
        zigbeeModel: ["HK-LN-DIM-A"],
        model: "HK-LN-DIM-A",
        vendor: "LED-Trading",
        description: "ZigBee AC phase-cut dimmer",
        extend: [m.light({ configureReporting: true })],
    },
    {
        zigbeeModel: ["HK-LN-SOCKET-A", "HK-LN-SOCKET-EU-5"],
        model: "9134",
        vendor: "LED-Trading",
        description: "Powerstrip with 4 sockets and USB",
        extend: [m.deviceEndpoints({ endpoints: { l1: 1, l2: 2, l3: 3, l4: 4, l5: 5 } }), m.onOff({ endpointNames: ["l1", "l2", "l3", "l4", "l5"] })],
    },
    {
        zigbeeModel: ["HK-ZCC-ZLL-A"],
        model: "9135",
        vendor: "LED-Trading",
        description: "Curtain motor controller",
        meta: { coverInverted: true },
        fromZigbee: [fz.cover_position_tilt],
        toZigbee: [tz.cover_state, tz.cover_position_tilt],
        exposes: [e.cover_position()],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["closuresWindowCovering"]);
            await reporting.currentPositionLiftPercentage(endpoint);
        },
    },
];
//# sourceMappingURL=led_trading.js.map