"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const zigbee_herdsman_converters_1 = require("zigbee-herdsman-converters");
const logger_1 = __importDefault(require("../util/logger"));
const externalJS_1 = __importDefault(require("./externalJS"));
class ExternalConverters extends externalJS_1.default {
    constructor(zigbee, mqtt, state, publishEntityState, eventBus, enableDisableExtension, restartCallback, addExtension) {
        super(zigbee, mqtt, state, publishEntityState, eventBus, enableDisableExtension, restartCallback, addExtension, 'converter', 'external_converters');
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async removeJS(name, module) {
        (0, zigbee_herdsman_converters_1.removeExternalDefinitions)(name);
        await this.zigbee.resolveDevicesDefinitions(true);
    }
    async loadJS(name, module) {
        try {
            (0, zigbee_herdsman_converters_1.removeExternalDefinitions)(name);
            const definitions = Array.isArray(module) ? module : [module];
            for (const definition of definitions) {
                definition.externalConverterName = name;
                (0, zigbee_herdsman_converters_1.addExternalDefinition)(definition);
                logger_1.default.info(`Loaded external converter '${name}'.`);
            }
            await this.zigbee.resolveDevicesDefinitions(true);
        }
        catch (error) {
            logger_1.default.error(`Failed to load external converter '${name}'`);
            logger_1.default.error(`Check the code for syntax error and make sure it is up to date with the current Zigbee2MQTT version.`);
            logger_1.default.error(`External converters are not meant for long term usage, but for local testing after which a pull request should be created to add out-of-the-box support for the device`);
            throw error;
        }
    }
}
exports.default = ExternalConverters;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZXJuYWxDb252ZXJ0ZXJzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vbGliL2V4dGVuc2lvbi9leHRlcm5hbENvbnZlcnRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSwyRUFBNEY7QUFFNUYsNERBQW9DO0FBQ3BDLDhEQUErQztBQUkvQyxNQUFxQixrQkFBbUIsU0FBUSxvQkFBa0M7SUFDOUUsWUFDSSxNQUFjLEVBQ2QsSUFBVSxFQUNWLEtBQVksRUFDWixrQkFBc0MsRUFDdEMsUUFBa0IsRUFDbEIsc0JBQXdFLEVBQ3hFLGVBQW9DLEVBQ3BDLFlBQXFEO1FBRXJELEtBQUssQ0FDRCxNQUFNLEVBQ04sSUFBSSxFQUNKLEtBQUssRUFDTCxrQkFBa0IsRUFDbEIsUUFBUSxFQUNSLHNCQUFzQixFQUN0QixlQUFlLEVBQ2YsWUFBWSxFQUNaLFdBQVcsRUFDWCxxQkFBcUIsQ0FDeEIsQ0FBQztJQUNOLENBQUM7SUFFRCw2REFBNkQ7SUFDbkQsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFZLEVBQUUsTUFBcUI7UUFDeEQsSUFBQSxzREFBeUIsRUFBQyxJQUFJLENBQUMsQ0FBQztRQUVoQyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVTLEtBQUssQ0FBQyxNQUFNLENBQUMsSUFBWSxFQUFFLE1BQXFCO1FBQ3RELElBQUksQ0FBQztZQUNELElBQUEsc0RBQXlCLEVBQUMsSUFBSSxDQUFDLENBQUM7WUFFaEMsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQzlELEtBQUssTUFBTSxVQUFVLElBQUksV0FBVyxFQUFFLENBQUM7Z0JBQ25DLFVBQVUsQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUM7Z0JBRXhDLElBQUEsa0RBQXFCLEVBQUMsVUFBVSxDQUFDLENBQUM7Z0JBQ2xDLGdCQUFNLENBQUMsSUFBSSxDQUFDLDhCQUE4QixJQUFJLElBQUksQ0FBQyxDQUFDO1lBQ3hELENBQUM7WUFFRCxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDdEQsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixnQkFBTSxDQUFDLEtBQUssQ0FBQyxzQ0FBc0MsSUFBSSxHQUFHLENBQUMsQ0FBQztZQUM1RCxnQkFBTSxDQUFDLEtBQUssQ0FBQyxzR0FBc0csQ0FBQyxDQUFDO1lBQ3JILGdCQUFNLENBQUMsS0FBSyxDQUNSLHdLQUF3SyxDQUMzSyxDQUFDO1lBRUYsTUFBTSxLQUFLLENBQUM7UUFDaEIsQ0FBQztJQUNMLENBQUM7Q0FDSjtBQXZERCxxQ0F1REMifQ==