/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProgressObject;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.Exporter;

final class HTMLExporter
extends Exporter {
    private float step = 1.0f;
    private int lastStep = 0;

    HTMLExporter() {
    }

    @Override
    protected int getSteps(TableModel model) {
        int steps = model.getRowCount();
        if (steps > 300) {
            this.step = 300.0f / (float)steps;
            steps = 300;
        }
        return steps;
    }

    @Override
    protected void writeHeader(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        HTMLExporter.writeLine(writer, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        HTMLExporter.writeLine(writer);
        HTMLExporter.writeLine(writer, "<html>");
        HTMLExporter.writeLine(writer, "<head>");
        HTMLExporter.writeLine(writer, "  <title>");
        HTMLExporter.writeLine(writer, "    " + title);
        HTMLExporter.writeLine(writer, "  </title>");
        HTMLExporter.writeLine(writer, "</head>");
        HTMLExporter.writeLine(writer);
        HTMLExporter.writeLine(writer, "<body>");
    }

    @Override
    protected void writeData(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        int columnsCount = model.getColumnCount();
        int rowsCount = model.getRowCount();
        HTMLExporter.writeLine(writer, "  <table border=\"1\" summary=\"" + title + "\">");
        HTMLExporter.writeLine(writer, "    <thead>");
        HTMLExporter.writeLine(writer, "      <tr>");
        for (int c = 0; c < columnsCount; ++c) {
            HTMLExporter.writeLine(writer, "        <td>" + model.getColumnName(c) + "</td>");
        }
        HTMLExporter.writeLine(writer, "      </tr>");
        HTMLExporter.writeLine(writer, "    </thead>");
        HTMLExporter.writeLine(writer, "    <tbody>");
        for (int r = 0; r < rowsCount; ++r) {
            HTMLExporter.writeLine(writer, "      <tr>");
            for (int c = 0; c < columnsCount; ++c) {
                HTMLExporter.writeLine(writer, "        <td>" + model.getValueAt(r, c) + "</td>");
            }
            HTMLExporter.writeLine(writer, "      </tr>");
            if (progress.isFinished()) break;
            if (this.step == 1.0f) {
                progress.addStep();
                continue;
            }
            int currentStep = (int)((float)r * this.step);
            if (currentStep <= this.lastStep) continue;
            progress.addStep();
            this.lastStep = currentStep;
        }
        HTMLExporter.writeLine(writer, "    </tbody>");
        HTMLExporter.writeLine(writer, "  </table>");
    }

    @Override
    protected void writeFooter(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        HTMLExporter.writeLine(writer, "</body>");
        HTMLExporter.writeLine(writer, "</html>");
    }
}

