/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class CustomTaskButtonBorder
extends AbstractBorder {
    public static final int BORDER_STATE_DEFAULT = 10;
    public static final int BORDER_STATE_FOCUSED = 20;
    public static final int BORDER_STATE_SELECTED = 30;
    private static final Color OUTLINE_CLR = new Color(0, 0, 0);
    private static final Color FOCUSED_TOP_LIGHT_CLR = new Color(206, 231, 255);
    private static final Color FOCUSED_TOP_DARK_CLR = new Color(188, 212, 246);
    private static final Color FOCUSED_BOTTOM_LIGHT_CLR = new Color(137, 173, 228);
    private static final Color FOCUSED_BOTTOM_DARK_CLR = new Color(105, 130, 238);
    private static final Color SELECTED_TOP_LIGHT_CLR = new Color(255, 240, 207);
    private static final Color SELECTED_TOP_DARK_CLR = new Color(253, 216, 137);
    private static final Color SELECTED_BOTTOM_LIGHT_CLR = new Color(248, 178, 48);
    private static final Color SELECTED_BOTTOM_DARK_CLR = new Color(229, 151, 0);
    private Color DEFAULT_BOTTOM_DARK_CLR;
    private Color DEFAULT_BOTTOM_LIGHT_CLR;
    private Color DEFAULT_TOP_DARK_CLR;
    private Color DEFAULT_TOP_LIGHT_CLR;
    private Color backgroundColor;
    private Color backgroundFade;
    private Color startColor;
    private Color stopColor;
    private int borderState;

    public CustomTaskButtonBorder(Color foreground, Color background) {
        this.setForegroundColor(foreground);
        this.setBackgroundColor(background);
        this.setDefault();
    }

    public CustomTaskButtonBorder(Color foreground, Color background, int state) {
        this(foreground, background);
        this.setBorderState(state);
    }

    public void setBackgroundColor(Color background) {
        this.backgroundColor = background;
        this.backgroundFade = UIUtils.getSafeColor((3 * background.getRed() + 1 * OUTLINE_CLR.getRed()) / 4, (3 * background.getGreen() + 1 * OUTLINE_CLR.getGreen()) / 4, (3 * background.getBlue() + 1 * OUTLINE_CLR.getBlue()) / 4);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public static Insets getBorderInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public static CustomTaskButtonBorder getDefaultInstance(Color foreground, Color background) {
        return new CustomTaskButtonBorder(foreground, background, 10);
    }

    public static CustomTaskButtonBorder getFocusedInstance(Color foreground, Color background) {
        return new CustomTaskButtonBorder(foreground, background, 20);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return CustomTaskButtonBorder.getBorderInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setBorderState(int state) {
        this.borderState = state;
    }

    public int getBorderState() {
        return this.borderState;
    }

    public void setFocused() {
        this.setBorderState(20);
    }

    public void setForegroundColor(Color foreground) {
        this.DEFAULT_TOP_LIGHT_CLR = UIUtils.getSafeColor(foreground.getRed() + 15, foreground.getGreen() + 15, foreground.getBlue() + 15);
        this.DEFAULT_TOP_DARK_CLR = UIUtils.getSafeColor(foreground.getRed() + 8, foreground.getGreen() + 8, foreground.getBlue() + 8);
        this.DEFAULT_BOTTOM_LIGHT_CLR = UIUtils.getSafeColor(foreground.getRed() - 11, foreground.getGreen() - 11, foreground.getBlue() - 11);
        this.DEFAULT_BOTTOM_DARK_CLR = UIUtils.getSafeColor(foreground.getRed() - 25, foreground.getGreen() - 25, foreground.getBlue() - 25);
    }

    public Color getForegroundColor() {
        return UIUtils.getSafeColor(this.DEFAULT_TOP_LIGHT_CLR.getRed() - 15, this.DEFAULT_TOP_LIGHT_CLR.getGreen() - 15, this.DEFAULT_TOP_LIGHT_CLR.getBlue() - 15);
    }

    public static CustomTaskButtonBorder getSelectedInstance(Color foreground, Color background) {
        return new CustomTaskButtonBorder(foreground, background, 30);
    }

    public void setDefault() {
        this.setBorderState(10);
    }

    public void setSelected() {
        this.setBorderState(30);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.backgroundColor);
        g2d.drawLine(x, y, x, y);
        g2d.drawLine(x, y + height - 1, x, y + height - 1);
        g2d.drawLine(x + width - 1, y, x + width - 1, y);
        g2d.drawLine(x + width - 1, y + height - 1, x + width - 1, y + height - 1);
        g2d.setColor(this.backgroundFade);
        g2d.drawLine(x + 1, y, x + 1, y);
        g2d.drawLine(x, y + 1, x, y + 1);
        g2d.drawLine(x + 1, y + height - 1, x + 1, y + height - 1);
        g2d.drawLine(x, y + height - 2, x, y + height - 2);
        g2d.drawLine(x + width - 1, y + 1, x + width - 1, y + 1);
        g2d.drawLine(x + width - 2, y, x + width - 2, y);
        g2d.drawLine(x + width - 2, y + height - 1, x + width - 2, y + height - 1);
        g2d.drawLine(x + width - 1, y + height - 2, x + width - 1, y + height - 2);
        g2d.setColor(OUTLINE_CLR);
        g2d.drawLine(x + 1, y + 1, x + 1, y + 1);
        g2d.drawLine(x + width - 2, y + 1, x + width - 2, y + 1);
        g2d.drawLine(x + 1, y + height - 2, x + 1, y + height - 2);
        g2d.drawLine(x + width - 2, y + height - 2, x + width - 2, y + height - 2);
        g2d.setColor(OUTLINE_CLR);
        g2d.drawLine(x + 2, y, x + width - 3, y);
        g2d.drawLine(x, y + 2, x, y + height - 3);
        g2d.drawLine(x + width - 1, y + 2, x + width - 1, y + height - 3);
        g2d.drawLine(x + 2, y + height - 1, x + width - 3, y + height - 1);
        switch (this.borderState) {
            case 10: {
                g2d.setColor(this.DEFAULT_TOP_LIGHT_CLR);
                break;
            }
            case 20: {
                g2d.setColor(FOCUSED_TOP_LIGHT_CLR);
                break;
            }
            case 30: {
                g2d.setColor(SELECTED_TOP_LIGHT_CLR);
            }
        }
        g.drawLine(x + 2, y + 1, x + width - 3, y + 1);
        switch (this.borderState) {
            case 10: {
                g2d.setColor(this.DEFAULT_TOP_DARK_CLR);
                break;
            }
            case 20: {
                g2d.setColor(FOCUSED_TOP_DARK_CLR);
                break;
            }
            case 30: {
                g2d.setColor(SELECTED_TOP_DARK_CLR);
            }
        }
        g2d.drawLine(x + 1, y + 2, x + width - 2, y + 2);
        g2d.drawLine(x + 1, y + 3, x + width - 2, y + 3);
        switch (this.borderState) {
            case 10: {
                g2d.setColor(this.DEFAULT_BOTTOM_LIGHT_CLR);
                break;
            }
            case 20: {
                g2d.setColor(FOCUSED_BOTTOM_LIGHT_CLR);
                break;
            }
            case 30: {
                g2d.setColor(SELECTED_BOTTOM_LIGHT_CLR);
            }
        }
        g2d.drawLine(x + 1, y + height - 4, x + width - 2, y + height - 4);
        g2d.drawLine(x + 1, y + height - 3, x + width - 2, y + height - 3);
        switch (this.borderState) {
            case 10: {
                g2d.setColor(this.DEFAULT_BOTTOM_DARK_CLR);
                break;
            }
            case 20: {
                g2d.setColor(FOCUSED_BOTTOM_DARK_CLR);
                break;
            }
            case 30: {
                g2d.setColor(SELECTED_BOTTOM_DARK_CLR);
            }
        }
        g2d.drawLine(x + 2, y + height - 2, x + width - 3, y + height - 2);
        switch (this.borderState) {
            case 10: {
                this.startColor = this.DEFAULT_TOP_DARK_CLR;
                this.stopColor = this.DEFAULT_BOTTOM_LIGHT_CLR;
                break;
            }
            case 20: {
                this.startColor = FOCUSED_TOP_DARK_CLR;
                this.stopColor = FOCUSED_BOTTOM_LIGHT_CLR;
                break;
            }
            case 30: {
                this.startColor = SELECTED_TOP_DARK_CLR;
                this.stopColor = SELECTED_BOTTOM_LIGHT_CLR;
            }
        }
        g2d.setPaint(new GradientPaint(x + 1, y + 3, this.startColor, x + 1, y + height - 5, this.stopColor));
        g2d.fillRect(x + 1, y + 3, 3, height - 7);
        g2d.fillRect(x + width - 4, y + 3, 3, height - 7);
    }
}

