/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.threads.ScheduledThreadPoolExecutor;

public class FilterValve
extends ValveBase
implements FilterConfig {
    private String filterClassName;
    private HashMap<String, String> filterInitParams;
    private Filter filter;
    private ServletContext application;

    public void setFilterClass(String filterClassName) {
        this.setFilterClassName(filterClassName);
    }

    public void setFilterClassName(String filterClassName) {
        this.filterClassName = filterClassName;
    }

    public String getFilterClassName() {
        return this.filterClassName;
    }

    public void addInitParam(String paramName, String paramValue) {
        if (null == this.filterInitParams) {
            this.filterInitParams = new HashMap();
        }
        this.filterInitParams.put(paramName, paramValue);
    }

    public String getFilterName() {
        return null;
    }

    public ServletContext getServletContext() {
        if (null == this.application) {
            throw new IllegalStateException(sm.getString("filterValve.noContext", new Object[]{this.getFilterClassName()}));
        }
        return this.application;
    }

    public String getInitParameter(String name) {
        if (null == this.filterInitParams) {
            return null;
        }
        return this.filterInitParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        if (null == this.filterInitParams) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.filterInitParams.keySet());
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        if (null == this.getFilterClassName()) {
            throw new LifecycleException(sm.getString("filterValve.nullFilterClassName"));
        }
        Container parent = super.getContainer();
        if (parent instanceof Context) {
            this.application = ((Context)parent).getServletContext();
        } else {
            final ScheduledExecutorService executor = Container.getService(super.getContainer()).getServer().getUtilityExecutor();
            this.application = (ServletContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){
                final /* synthetic */ FilterValve this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("getAttribute".equals(method.getName()) && null != args && 1 == args.length && ScheduledThreadPoolExecutor.class.getName().equals(args[0])) {
                        return executor;
                    }
                    throw new UnsupportedOperationException(ValveBase.sm.getString("filterValve.proxyServletContext"));
                }
            });
        }
        try {
            this.filter = (Filter)Class.forName(this.getFilterClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.filter.init((FilterConfig)this);
        }
        catch (ServletException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException se) {
            throw new LifecycleException(sm.getString("filterValve.initError", new Object[]{this.getFilterClassName()}), se);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (null != this.filter) {
            try {
                this.filter.destroy();
            }
            finally {
                this.filter = null;
            }
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        FilterCallInfo filterCallInfo = new FilterCallInfo();
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterCallInfo);
        if (!filterCallInfo.stop) {
            if (request != filterCallInfo.request) {
                throw new IllegalStateException(sm.getString("filterValve.illegalWrapping", new Object[]{this.getFilterClassName()}));
            }
            if (response != filterCallInfo.response) {
                throw new IllegalStateException(sm.getString("filterValve.illegalWrapping", new Object[]{this.getFilterClassName()}));
            }
            this.getNext().invoke(request, response);
        }
    }

    private static final class FilterCallInfo
    implements FilterChain {
        private boolean stop = true;
        private ServletRequest request;
        private ServletResponse response;

        private FilterCallInfo() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            this.request = request;
            this.response = response;
            this.stop = false;
        }
    }
}

