/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ResourceFile;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JSources;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class JRoot
extends JNode {
    private static final long serialVersionUID = 8888495789773527342L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/rootPackageFolder");
    private final transient JadxWrapper wrapper;
    private transient boolean flatPackages = false;
    private final List<JNode> customNodes = new ArrayList<JNode>();

    public JRoot(JadxWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public final void update() {
        this.removeAllChildren();
        this.add(new JSources(this, this.wrapper));
        List<ResourceFile> resources = this.wrapper.getResources();
        if (!resources.isEmpty()) {
            this.add(this.getHierarchyResources(resources));
        }
        for (JNode customNode : this.customNodes) {
            this.add(customNode);
        }
    }

    private JResource getHierarchyResources(List<ResourceFile> resources) {
        JResource root = new JResource(null, NLS.str("tree.resources_title"), JResource.JResType.ROOT);
        String splitPathStr = Pattern.quote(File.separator);
        for (ResourceFile rf : resources) {
            String rfName = rf.getZipRef() != null ? rf.getDeobfName() : new File(rf.getDeobfName()).getName();
            String[] parts = new File(rfName).getPath().split(splitPathStr);
            JResource curRf = root;
            int count = parts.length;
            for (int i = 0; i < count; ++i) {
                String name = parts[i];
                JResource subRF = this.getResourceByName(curRf, name);
                if (subRF == null) {
                    subRF = i != count - 1 ? new JResource(null, name, JResource.JResType.DIR) : new JResource(rf, rf.getDeobfName(), name, JResource.JResType.FILE);
                    curRf.addSubNode(subRF);
                }
                curRf = subRF;
            }
        }
        root.sortSubNodes();
        root.update();
        return root;
    }

    private JResource getResourceByName(JResource rf, String name) {
        for (JResource sub : rf.getSubNodes()) {
            if (!sub.getName().equals(name)) continue;
            return sub;
        }
        return null;
    }

    public JNode searchNode(JNode node) {
        Enumeration<TreeNode> en = this.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeNode obj = en.nextElement();
            if (!node.equals(obj)) continue;
            return (JNode)obj;
        }
        return null;
    }

    public boolean isFlatPackages() {
        return this.flatPackages;
    }

    public void setFlatPackages(boolean flatPackages) {
        if (this.flatPackages != flatPackages) {
            this.flatPackages = flatPackages;
            this.update();
        }
    }

    public void replaceCustomNode(@Nullable JNode node) {
        if (node == null) {
            return;
        }
        Class<?> nodeCls = node.getClass();
        this.customNodes.removeIf(n -> n.getClass().equals(nodeCls));
        this.customNodes.add(node);
    }

    public List<JNode> getCustomNodes() {
        return this.customNodes;
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String makeString() {
        List<Path> paths = this.wrapper.getProject().getFilePaths();
        int count = paths.size();
        if (count == 0) {
            return "File not open";
        }
        if (count == 1) {
            return paths.get(0).getFileName().toString();
        }
        return count + " files";
    }

    @Override
    public String getTooltip() {
        List<Path> paths = this.wrapper.getProject().getFilePaths();
        int count = paths.size();
        if (count < 2) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (Path p : paths) {
            sb.append(UiUtils.escapeHtml(p.toString()));
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

