/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.TestURL;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestURLLoader {
    private static Map<Character, Character> tokenMap = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('\\'), Character.valueOf('\\'));
            this.put(Character.valueOf('n'), Character.valueOf('\n'));
            this.put(Character.valueOf('r'), Character.valueOf('\r'));
            this.put(Character.valueOf('s'), Character.valueOf(' '));
            this.put(Character.valueOf('t'), Character.valueOf('\t'));
            this.put(Character.valueOf('f'), Character.valueOf('\f'));
        }
    };

    private static String normalize(String input) {
        StringBuilder output = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                char nextC;
                char c2 = nextC = ++i >= input.length() ? (char)'\u0000' : input.charAt(i);
                if (tokenMap.containsKey(Character.valueOf(nextC))) {
                    output.append(tokenMap.get(Character.valueOf(nextC)));
                    continue;
                }
                if (nextC == 'u') {
                    char uChar = (char)Integer.parseInt(input.substring(i + 1, i + 5), 16);
                    output.append(uChar);
                    i += 4;
                    continue;
                }
                throw new RuntimeException("Token error");
            }
            output.append(c);
        }
        return output.toString();
    }

    public static List<TestURL> loadTestURLs(String resource) {
        try {
            String line;
            ArrayList<TestURL> results = new ArrayList<TestURL>();
            BufferedReader br = new BufferedReader(new InputStreamReader(TestURLLoader.class.getResourceAsStream(resource)));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("--")) continue;
                String[] fields = line.split(" ");
                TestURL testURL = new TestURL();
                results.add(testURL);
                testURL.rawURL = TestURLLoader.normalize(fields[0]);
                if (fields.length > 1 && !fields[1].isEmpty()) {
                    testURL.rawBaseURL = TestURLLoader.normalize(fields[1]);
                    try {
                        testURL.parsedBaseURL = URL.parse(testURL.rawBaseURL);
                    }
                    catch (GalimatiasParseException ex) {
                        throw new RuntimeException("Exception while parsing test line: " + line, ex);
                    }
                } else {
                    testURL.rawBaseURL = ((TestURL)results.get((int)(results.size() - 2))).rawBaseURL;
                    testURL.parsedBaseURL = ((TestURL)results.get((int)(results.size() - 2))).parsedBaseURL;
                }
                if (fields.length < 2) continue;
                String scheme = "";
                String schemeData = "";
                String username = "";
                String password = null;
                Host host = null;
                int port = -1;
                String path = null;
                String query = null;
                String fragment = null;
                boolean isHierarchical = false;
                for (int i = 2; i < fields.length; ++i) {
                    String field = TestURLLoader.normalize(fields[i]);
                    if (field.length() < 2) {
                        throw new RuntimeException("Malformed test: " + line);
                    }
                    String value = field.substring(2);
                    if (field.startsWith("s:")) {
                        scheme = value;
                        isHierarchical = URLUtils.isRelativeScheme(scheme);
                        continue;
                    }
                    if (field.startsWith("u:")) {
                        username = value;
                        continue;
                    }
                    if (field.startsWith("pass:")) {
                        password = field.substring(5);
                        continue;
                    }
                    if (field.startsWith("h:")) {
                        try {
                            host = Host.parseHost(value);
                            continue;
                        }
                        catch (GalimatiasParseException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    if (field.startsWith("port:")) {
                        port = Integer.parseInt(field.substring(5));
                        continue;
                    }
                    if (field.startsWith("p:")) {
                        path = value;
                        continue;
                    }
                    if (field.startsWith("q:")) {
                        query = value;
                        if (!query.startsWith("?")) continue;
                        query = query.substring(1);
                        continue;
                    }
                    if (!field.startsWith("f:") || !(fragment = value).startsWith("#")) continue;
                    fragment = fragment.substring(1);
                }
                if (!isHierarchical) {
                    schemeData = path;
                    path = null;
                } else {
                    String defaultPortString = URLUtils.getDefaultPortForScheme(scheme);
                    if (defaultPortString != null && port == Integer.parseInt(defaultPortString)) {
                        port = -1;
                    }
                }
                testURL.parsedURL = new URL(scheme, schemeData, username, password, host, port, path, query, fragment, isHierarchical);
            }
            return results;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

