#include <sys/types.h>
#include "config.h"
#include "termio.h"

/* DANG_BEGIN_MODULE
 * 
 * These are definitions, giving which key is related to which scancode in
 * raw keyboard mode. Basically, the code of 'x' on a US keyboard may be that
 * of a 'Y' on a German keyboard. This way, all types of keyboard can be
 * represented under DOSEMU. Also, the right ALT-key is often a function
 * key in it's own right.
 *
 * DANG_END_MODULE
 */

#define CONST


CONST unsigned char key_map_finnish[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_finnish_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish_latin1[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish_latin1[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_us[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '\\', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_us[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '"', '~', '0', '|', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

#if 0
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#else
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#endif

CONST unsigned char key_map_uk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '#', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_uk[] =
{
  0, 27, '!', '"', 156, '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '@', '~', '0', '~', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_uk[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  DEAD_ACUTE, DEAD_GRAVE, 0, DEAD_TILDE, 0, 0, 0, 0, /*dead keys for testing */
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_de[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', '', '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '',
  '', '^', 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_de[] =
{
  0, 27, '!', '"', '', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', '', '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '',
  '', '', 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_de[] =
{
  0, 0, 0, '', '', 0, 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '', 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_de_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 225, 39, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 129, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 94, 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_de_latin1[] =
{
  0, 27, '!', '"', 21, '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_de_latin1[] =
{
  0, 0, 0, 253, 252, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 230, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr[] =
{
  0, 27, '&', '{', '"', '\'', '(', '-',
  '}', '_', '/', '@', ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  '|', '`', 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', ']', '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '<', '>', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, '#', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '\\', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr_latin1[] =
{
  0, 27, '&', 233, '"', '\'', '(', '-',
  232, '_', 231, 224, ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  249, 178, 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 176, '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 168, 163, 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 0, 0, 181, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', 167, 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr_latin1[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 164, 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 145,
  155, 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
 
CONST unsigned char shift_map_dk[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 146,
  157, 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 230,
  162, 189, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dk_latin1[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 198,
  165, 167, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk_latin1[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dvorak[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\\', '=', 127, 9,
  '\'', ',', '.', 'p', 'y', 'f', 'g', 'c',
  'r', 'l', '/', ']', 13, 0, 'a', 'o',
  'e', 'u', 'i', 'd', 'h', 't', 'n', 's',
  '-', '`', 0, '[', ';', 'q', 'j', 'k',
  'x', 'b', 'm', 'w', 'v', 'z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dvorak[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '|', '+', 127, 9,
  '"', '<', '>', 'P', 'Y', 'F', 'G', 'C',
  'R', 'L', '?', '}', 13, 0, 'A', 'O',
  'E', 'U', 'I', 'D', 'H', 'T', 'N', 'S',
  '_', '~', 0, '{', ':', 'Q', 'J', 'K',
  'X', 'B', 'M', 'W', 'V', 'Z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dvorak[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 192, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg_latin1[] =
{
  0, 27, '+', '"', '*', 128, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg_latin1[] =
{
  0, 0, 179, '@', '#', 0, 0, 170,
  '|', 162, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 233,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_no[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', '~', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_no[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_no[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', 0, '\'', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 232, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  224, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf_latin1[] =
{
  0, 27, '+', '"', '*', 231, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 252, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 246,
  228, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf_latin1[] =
{
  0, 0, 0, '@', '#', 0, 0, 172,
  '|', 162, 0, 0, 180, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_es[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',    0,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '`',  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',    0,
   '\'',  '`',    0,    0,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es[] = {
      0,   27,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',    0,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '^',  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',    0,
      0,  '~',    0,    0,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,    0,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char key_map_es_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',  173,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  DEAD_GRAVE,  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  164,
    DEAD_ACUTE,  167,    0,  135,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es_latin1[] = {
      0,   27,  '!',  '"',  250,  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  168,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  DEAD_DIAERESIS,  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  165,
    DEAD_DIAERESIS,  166,    0,  128,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es_latin1[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,  172,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

/* keyboard driver for BELGIAN KEYBOARD */

CONST unsigned char key_map_be[] =
{
  0, 27, '&', 130, '"', '\'', '(', 21,
  138, '!', 128, 133, ')', '-', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  151, 230, 0, '<', 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '=', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_be[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 248, '_', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 0, '*', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 156, 0, '>', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '+', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_be[] =
{
  0, 0, '|', '@', '#', 0, 0, '^',
  0, 0, '{', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\'', 96, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_po[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '`', 174, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '+', '\'', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 135,
  167, '\\', 0, '~', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_po[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', 175, 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '*', '`', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 128,
  166, '|', '0', '^', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_po[] =
{
  0, 0, 0, '@', 156, 21, 0, 0,
  '{', '[', ']', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_it[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', 141, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 138, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 149,
  133, '\\', 0, 151, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_it[] =
{
  0, 27, '!', '\"', 156, '$', '%', '&',
  '/', '(', ')', '=', '?', '^', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 130, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 135,
  248, '|', '0', 21, 'Z', 'X', 'C', 'V',
   'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_it[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '{', '}', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, '@',
  '#', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sw[] =
{
  0, 0, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, '~', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 21, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sw[] =
{
  171, 0, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sw[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char num_table_dot[]   = "789-456+1230.";
CONST unsigned char num_table_comma[] = "789-456+1230,";


/* DANG_BEGIN_REMARK
 *
 * The DEAD codes must refer to keys that don't exist on any language
 * keyboard. I hope nobody has a smily face key :-)
 * dead_key_table is a list of the dead keys supported. They must
 * be placed on the correct key in the keymaps above. See key_map_es_latin1.
 *
 * DANG_END_REMARK
 */

CONST unsigned char dead_key_table[] = {DEAD_GRAVE,DEAD_ACUTE,DEAD_CIRCUMFLEX,
DEAD_TILDE,DEAD_BREVE,DEAD_ABOVEDOT,DEAD_DIAERESIS,DEAD_ABOVERING,
DEAD_DOUBLEACUTE,DEAD_CEDILLA,DEAD_IOTA, 0};

/* DANG_BEGIN_REMARK
 *
 * dos850_dead_map consists of the triple, {deadkey, letter, result}.
 * It should be correct for all the code page 850 users (Western Europe).
 * If you uses a different code page, please create a map!
 * Jon Tombs jon@gtex02.us.es
 *
 * DANG_END_REMARK
 */

struct dos_dead_key dos850_dead_map[] = {
        {DEAD_GRAVE, DEAD_GRAVE, '`'},  {DEAD_ACUTE, DEAD_ACUTE, '\''},
        {DEAD_CIRCUMFLEX, DEAD_CIRCUMFLEX, '^'}, {DEAD_DIAERESIS, DEAD_DIAERESIS, '"'},
	{DEAD_TILDE, DEAD_TILDE, '~'},

	{DEAD_TILDE, 'n', 164}, {DEAD_TILDE, 'N', 165},
	
	{DEAD_ACUTE, 'A', 181},	{DEAD_ACUTE, 'a', 160},
	{DEAD_ACUTE, 'E', 144},	{DEAD_ACUTE, 'e', 130},
	{DEAD_ACUTE, 'I', 214},	{DEAD_ACUTE, 'i', 161},
	{DEAD_ACUTE, 'O', 224},	{DEAD_ACUTE, 'o', 162},
	{DEAD_ACUTE, 'U', 233},	{DEAD_ACUTE, 'u', 163},

	{DEAD_GRAVE, 'A', 183},	{DEAD_GRAVE, 'a', 133},
	{DEAD_GRAVE, 'E', 212},	{DEAD_GRAVE, 'e', 138},
	{DEAD_GRAVE, 'I', 222},	{DEAD_GRAVE, 'i', 141},
	{DEAD_GRAVE, 'O', 227},	{DEAD_GRAVE, 'o', 149},
	{DEAD_GRAVE, 'U', 235},	{DEAD_GRAVE, 'u', 151},

  	{DEAD_CIRCUMFLEX, 'A', 182},	{DEAD_CIRCUMFLEX, 'a', 160},
	{DEAD_CIRCUMFLEX, 'E', 210},	{DEAD_CIRCUMFLEX, 'e', 210},
	{DEAD_CIRCUMFLEX, 'I', 215},	{DEAD_CIRCUMFLEX, 'i', 140},
	{DEAD_CIRCUMFLEX, 'O', 226},	{DEAD_CIRCUMFLEX, 'o', 147},
	{DEAD_CIRCUMFLEX, 'U', 234},	{DEAD_CIRCUMFLEX, 'u', 150},

	{DEAD_DIAERESIS, 'A', 142},	{DEAD_DIAERESIS, 'a', 132},
	{DEAD_DIAERESIS, 'E', 211},	{DEAD_DIAERESIS, 'e', 137},
	{DEAD_DIAERESIS, 'I', 216},	{DEAD_DIAERESIS, 'i', 139},
	{DEAD_DIAERESIS, 'O', 153},	{DEAD_DIAERESIS, 'o', 148},
	{DEAD_DIAERESIS, 'U', 154},	{DEAD_DIAERESIS, 'u', 129},

        {0, 0, 0}
};

