/*
 * sun-rbootd   yamamori@kt.rim.or.jp
 */

#include "config.h"

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#ifndef LINUX
# include <netinet/if_ether.h>
#endif

#include <netdb.h>

#include "nitlib.h"


#define TFTPBOOT "/tftpboot"

#define u_word_to_ul(v) ( \
  (ntohs(((unsigned short *)&(v))[0])<<16)| \
  (ntohs(((unsigned short *)&(v))[1]))      \
)


int debug = 0;

static struct rmp_packet pb;
static struct ether_addr my_addr;

#define DADDR (*(struct ether_addr *)pb.hp_hdr.daddr)
#define SADDR (*(struct ether_addr *)pb.hp_hdr.saddr)


static char *
#ifdef __GNUC__
my_ether_ntoa(struct ether_addr *ea)
#else
my_ether_ntoa(ea) struct ether_addr *ea;
#endif
{
  static char buf[18];
  sprintf(buf, "%x:%x:%x:%x:%x:%x", 
    ea->ether_addr_octet[0], ea->ether_addr_octet[1], ea->ether_addr_octet[2],
    ea->ether_addr_octet[3], ea->ether_addr_octet[4], ea->ether_addr_octet[5]
  );
  return buf;
}

static void
print_ether_header _P((void))
{
  printf("%s", my_ether_ntoa(&SADDR));
  printf(" -> %s len=%d\n", my_ether_ntoa(&DADDR), ntohs(pb.hp_hdr.len));
}


static int
#ifdef __GNUC__
get_boot_file(struct ether_addr *ea, char *boot_file)
#else
get_boot_file(ea, boot_file) struct ether_addr *ea; char *boot_file;
#endif
{
  int fd_boot;

  char hostname[MAXHOSTNAMELEN];
  struct hostent *hp;

  if (ether_ntohost(hostname, ea) != 0) {
    fprintf(stderr, "%s: ether_addr unknown\n", my_ether_ntoa(ea));
    return -1;
  }
  if ((hp = gethostbyname(hostname)) == NULL) {
    fprintf(stderr, "%s: hostname unknown\n", hostname);
    return -1;
  }
  sprintf(boot_file, "%08X", ntohl(*(long *)hp->h_addr));

  if ((fd_boot = open(boot_file, O_RDONLY, 0)) < 0) {
    perror(boot_file);
    return -1;
  }
  return fd_boot;
}


static int
set_rmp_flnm _P((void))
{
  int fd_boot;

  pb.r_brpl.rmp_flnmsize = 8;
  if ((fd_boot = get_boot_file(&DADDR, &pb.r_brpl.rmp_flnm)) < 0) {
    pb.r_brpl.rmp_retcode = RMP_E_NOFILE;
    return -1;
  } else {
    pb.r_brpl.rmp_retcode = RMP_E_OKAY;
    close(fd_boot);
    return 0;
  }
}



int
#ifdef __GNUC__
main(int argc, char **argv)
#else
main(argc, argv) char **argv;
#endif
{
  int fd_e, fd_boot;
  int size, len;
  unsigned long offset;
  char boot_file[8+1];
  char *if_name = "";
  int pid;
  char machtype[RMP_MACHLEN+1];
  int c;
  extern int opterr;
  extern char *optarg;
  int a_flag = 0, i_flag = 0, err_flag = 0;

  opterr = 0;
  while ((c = getopt(argc, argv, "dai:")) != -1) {
    switch (c) {
      case 'd':
	debug = 1;
	break;

      case 'a':
	a_flag = 1;
	break;

      case 'i':
	i_flag = 1;
	if_name = optarg;
	break;

      case '?':
	err_flag = 1;
	break;
    }
  }

  if (err_flag || (a_flag && i_flag) || (!a_flag && !i_flag)) {
    fprintf(stderr,
      "sun-rbootd 1.3.2\nusage:\n\t%s [-d] -a\n\t%s [-d] -i if_name\n",
      argv[0], argv[0]);
    return 1;
  }

  if (debug) {
    setlinebuf(stdout);
    printf("debug mode, stay in current dir, no fork()\n");
  }

  if (a_flag && (if_name = ether_if()) == NULL) {
    fprintf(stderr, "ether_if not found\n");
    return 1;
  }
  if ((fd_e = ether_open(if_name, &my_addr)) < 0) {
    perror("ether_open");
    return 1;
  }
  if (debug) {printf("my_addr=%s\n", my_ether_ntoa(&my_addr));}

  if (!debug) {
    if (chdir(TFTPBOOT) < 0) {
      perror(TFTPBOOT);
      return 1;
    }
    if ((pid = fork()) < 0) {
      perror("fork");
      return 1;
    }
    if (pid) {
      return 0;
    }
    setsid();
  }


  for (;;) {
    if (ether_read(fd_e, (char *)&pb, 74) <= 0) {
      continue;
    }
    if (debug) {print_ether_header();}

    DADDR = SADDR;
    SADDR = my_addr;
    pb.hp_llc.dxsap = htons(HPEXT_SXSAP);
    pb.hp_llc.sxsap = htons(HPEXT_DXSAP);

    switch (pb.r_type) {
      case RMP_BOOT_REQ:
	if (debug) {
	  strncpy(machtype, pb.r_brq.rmp_machtype, RMP_MACHLEN);
	  machtype[RMP_MACHLEN] = '\0';
	  printf(
	    "  BOOT_REQ ret=%02x seq=%08x sess=%04x ver=%04x mach=\"%s\"\n",
	    pb.r_brq.rmp_retcode,
	    u_word_to_ul(pb.r_brq.rmp_seqno),
	    ntohs(pb.r_brq.rmp_session),
	    ntohs(pb.r_brq.rmp_version),
	    machtype
	  );
	  if (
	    ntohs(pb.hp_hdr.len)
	    > ((char *)&pb.r_brq.rmp_flnmsize - (char *)&pb.hp_llc)
	  ) {
	    (&pb.r_brq.rmp_flnm)[pb.r_brq.rmp_flnmsize] = '\0';
	    printf(
	      "  flnmsize=%d flnm=\"%s\"\n",
	      pb.r_brq.rmp_flnmsize,
	      &pb.r_brq.rmp_flnm
	    );
	  }
	}

        pb.r_brpl.rmp_flnmsize = 0;
	if (pb.r_brq.rmp_session == htons(RMP_PROBESID)) {
	  switch (u_word_to_ul(pb.r_brq.rmp_seqno)) {
	    case 0:
	      if (set_rmp_flnm() < 0) {
		continue;
	      }
	      gethostname(&pb.r_brpl.rmp_flnm, MAXHOSTNAMELEN);
	      pb.r_brpl.rmp_flnmsize = strlen(&pb.r_brpl.rmp_flnm);
	      pb.r_brpl.rmp_retcode = RMP_E_OKAY;
	      break;
	    case 1:
	      set_rmp_flnm();
	      break;
	    default:
	      pb.r_brpl.rmp_retcode = RMP_E_NODFLT;
	      break;
	  }
	  pb.r_brpl.rmp_session = 0;
	} else {
	  set_rmp_flnm();
	  pb.r_brpl.rmp_session = htons(1);
	}

	pb.r_brpl.rmp_type = RMP_BOOT_REPL;
	pb.r_brpl.rmp_version = htons(RMP_VERSION);

        len = RMPBOOTSIZE(pb.r_brpl.rmp_flnmsize);
	pb.hp_hdr.len = htons(len - sizeof (struct ether_header));

	if (debug) {
	  print_ether_header();
	  printf(
"  BOOT_REPL ret=%02x seq=%08x sess=%04x ver=%04x\n\
  flnmsize=%d flnm=\"%s\"\n",
	    pb.r_brpl.rmp_retcode,
	    u_word_to_ul(pb.r_brpl.rmp_seqno),
	    ntohs(pb.r_brpl.rmp_session),
	    ntohs(pb.r_brpl.rmp_version),
	    pb.r_brpl.rmp_flnmsize,
	    &pb.r_brpl.rmp_flnm
	  );
	}

	ether_write(fd_e, (char *)&pb, len);
	break;

      case RMP_READ_REQ:
	size = ntohs(pb.r_rrq.rmp_size);
	offset = u_word_to_ul(pb.r_rrq.rmp_offset);

	if (debug) {
	  printf(
	    "  READ_REQ ret=%02x offs=%08x sess=%04x size=%04x\n",
	    pb.r_rrq.rmp_retcode,
	    offset,
	    ntohs(pb.r_rrq.rmp_session),
	    size
	  );
	}

#ifdef NEWSOS_4
	if (size > 1000) {
	  size = 1000;
	}
#endif

	pb.r_rrpl.rmp_type = RMP_READ_REPL;

        if ((fd_boot = get_boot_file(&DADDR, boot_file)) < 0) {
	  pb.r_rrpl.rmp_retcode = RMP_E_NOFILE;

	} else {
	  lseek(fd_boot, offset, SEEK_SET);
	  if ((size = read(fd_boot, &pb.r_rrpl.rmp_data, size)) <= 0) {
	    size = 0;
	    pb.r_rrpl.rmp_retcode = RMP_E_EOF;
	  } else {
	    pb.r_rrpl.rmp_retcode = RMP_E_OKAY;
	  }
	  close(fd_boot);
	}

        if ((len = RMPREADSIZE(size)) > RMP_MAX_PACKET) {
	  continue;
	}
	pb.hp_hdr.len = htons(len - sizeof (struct ether_header));

	if (debug) {
	  print_ether_header();
	  printf(
	    "  READ_REPL ret=%02x offs=%08x sess=%04x\n",
	    pb.r_rrpl.rmp_retcode,
	    offset,
	    ntohs(pb.r_rrpl.rmp_session)
	  );
	}

	ether_write(fd_e, (char *)&pb, len);
	break;

      case RMP_BOOT_DONE:
	if (debug) {
	  printf(
	    "  BOOT_DONE ret=%02x sess=%04x\n",
	    pb.r_done.rmp_retcode,
	    ntohs(pb.r_done.rmp_session)
	  );
	}
	break;
    }
  }
}
