/* $NetBSD: meson8b_clkc.h,v 1.1 2019/01/19 20:56:03 jmcneill Exp $ */

/*-
 * Copyright (c) 2019 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MESON8B_CLKC_H
#define _MESON8B_CLKC_H

#define	MESON8B_RESET_CPU0_SOFT_RESET	3
#define	MESON8B_RESET_CPU1_SOFT_RESET	4
#define	MESON8B_RESET_CPU2_SOFT_RESET	5
#define	MESON8B_RESET_CPU3_SOFT_RESET	6

#define MESON8B_CLOCK_XTAL		1
#define MESON8B_CLOCK_PLL_FIXED		2
#define MESON8B_CLOCK_PLL_VID		3
#define MESON8B_CLOCK_PLL_SYS		4
#define MESON8B_CLOCK_FCLK_DIV2		5
#define MESON8B_CLOCK_FCLK_DIV3		6
#define MESON8B_CLOCK_FCLK_DIV4		7
#define MESON8B_CLOCK_FCLK_DIV5		8
#define MESON8B_CLOCK_FCLK_DIV7		9
#define MESON8B_CLOCK_CLK81		10
#define MESON8B_CLOCK_MALI		11
#define MESON8B_CLOCK_CPUCLK		12
#define MESON8B_CLOCK_ZERO		13
#define MESON8B_CLOCK_MPEG_SEL		14
#define MESON8B_CLOCK_MPEG_DIV		15
#define MESON8B_CLOCK_DDR		16
#define MESON8B_CLOCK_DOS		17
#define MESON8B_CLOCK_ISA		18
#define MESON8B_CLOCK_PL301		19
#define MESON8B_CLOCK_PERIPHS		20
#define MESON8B_CLOCK_SPICC		21
#define MESON8B_CLOCK_I2C		22
#define MESON8B_CLOCK_SAR_ADC		23
#define MESON8B_CLOCK_SMART_CARD	24
#define MESON8B_CLOCK_RNG0		25
#define MESON8B_CLOCK_UART0		26
#define MESON8B_CLOCK_SDHC		27
#define MESON8B_CLOCK_STREAM		28
#define MESON8B_CLOCK_ASYNC_FIFO	29
#define MESON8B_CLOCK_SDIO		30
#define MESON8B_CLOCK_ABUF		31
#define MESON8B_CLOCK_HIU_IFACE		32
#define MESON8B_CLOCK_ASSIST_MISC	33
#define MESON8B_CLOCK_SPI		34
#define MESON8B_CLOCK_I2S_SPDIF		35
#define MESON8B_CLOCK_ETH		36
#define MESON8B_CLOCK_DEMUX		37
#define MESON8B_CLOCK_AIU_GLUE		38
#define MESON8B_CLOCK_IEC958		39
#define MESON8B_CLOCK_I2S_OUT		40
#define MESON8B_CLOCK_AMCLK		41
#define MESON8B_CLOCK_AIFIFO2		42
#define MESON8B_CLOCK_MIXER		43
#define MESON8B_CLOCK_MIXER_IFACE	44
#define MESON8B_CLOCK_ADC		45
#define MESON8B_CLOCK_BLKMV		46
#define MESON8B_CLOCK_AIU		47
#define MESON8B_CLOCK_UART1		48
#define MESON8B_CLOCK_G2D		49
#define MESON8B_CLOCK_USB0		50
#define MESON8B_CLOCK_USB1		51
#define MESON8B_CLOCK_RESET		52
#define MESON8B_CLOCK_NAND		53
#define MESON8B_CLOCK_DOS_PARSER	54
#define MESON8B_CLOCK_USB		55
#define MESON8B_CLOCK_VDIN1		56
#define MESON8B_CLOCK_AHB_ARB0		57
#define MESON8B_CLOCK_EFUSE		58
#define MESON8B_CLOCK_BOOT_ROM		59
#define MESON8B_CLOCK_AHB_DATA_BUS	60
#define MESON8B_CLOCK_AHB_CTRL_BUS	61
#define MESON8B_CLOCK_HDMI_INTR_SYNC	62
#define MESON8B_CLOCK_HDMI_PCLK		63
#define MESON8B_CLOCK_USB1_DDR_BRIDGE	64
#define MESON8B_CLOCK_USB0_DDR_BRIDGE	65
#define MESON8B_CLOCK_MMC_PCLK		66
#define MESON8B_CLOCK_DVIN		67
#define MESON8B_CLOCK_UART2		68
#define MESON8B_CLOCK_SANA		69
#define MESON8B_CLOCK_VPU_INTR		70
#define MESON8B_CLOCK_SEC_AHB_AHB3_BRIDGE	71
#define MESON8B_CLOCK_CLK81_A9		72
#define MESON8B_CLOCK_VCLK2_VENCI0	73
#define MESON8B_CLOCK_VCLK2_VENCI1	74
#define MESON8B_CLOCK_VCLK2_VENCP0	75
#define MESON8B_CLOCK_VCLK2_VENCP1	76
#define MESON8B_CLOCK_GCLK_VENCI_INT	77
#define MESON8B_CLOCK_GCLK_VENCP_INT	78
#define MESON8B_CLOCK_DAC_CLK		79
#define MESON8B_CLOCK_AOCLK_GATE	80
#define MESON8B_CLOCK_IEC958_GATE	81
#define MESON8B_CLOCK_ENC480P		82
#define MESON8B_CLOCK_RNG1		83
#define MESON8B_CLOCK_GCLK_VENCL_INT	84
#define MESON8B_CLOCK_VCLK2_VENCLMCC	85
#define MESON8B_CLOCK_VCLK2_VENCL	86
#define MESON8B_CLOCK_VCLK2_OTHER	87
#define MESON8B_CLOCK_EDP		88
#define MESON8B_CLOCK_AO_MEDIA_CPU	89
#define MESON8B_CLOCK_AO_AHB_SRAM	90
#define MESON8B_CLOCK_AO_AHB_BUS	91
#define MESON8B_CLOCK_AO_IFACE		92
#define MESON8B_CLOCK_MPLL0		93
#define MESON8B_CLOCK_MPLL1		94
#define MESON8B_CLOCK_MPLL2		95
#define MESON8B_CLOCK_MPLL0_DIV		96
#define MESON8B_CLOCK_MPLL1_DIV		97
#define MESON8B_CLOCK_MPLL2_DIV		98
#define MESON8B_CLOCK_CPU_IN_SEL	99
#define MESON8B_CLOCK_CPU_IN_DIV2	100
#define MESON8B_CLOCK_CPU_IN_DIV3	101
#define MESON8B_CLOCK_CPU_SCALE_DIV	102
#define MESON8B_CLOCK_CPU_SCALE_OUT_SEL	103
#define MESON8B_CLOCK_MPLL_PREDIV	104
#define MESON8B_CLOCK_FCLK_DIV2_DIV	105
#define MESON8B_CLOCK_FCLK_DIV3_DIV	106
#define MESON8B_CLOCK_FCLK_DIV4_DIV	107
#define MESON8B_CLOCK_FCLK_DIV5_DIV	108
#define MESON8B_CLOCK_FCLK_DIV7_DIV	109
#define MESON8B_CLOCK_NAND_SEL		110
#define MESON8B_CLOCK_NAND_DIV		111
#define MESON8B_CLOCK_NAND_CLK		112
#define MESON8B_CLOCK_PLL_FIXED_DCO	113
#define MESON8B_CLOCK_PLL_VID_DCO	114
#define MESON8B_CLOCK_PLL_SYS_DCO	115
#define	MESON8B_CLOCK_CPU_CLK_DIV2	116
#define	MESON8B_CLOCK_CPU_CLK_DIV3	117
#define	MESON8B_CLOCK_CPU_CLK_DIV4	118
#define	MESON8B_CLOCK_CPU_CLK_DIV5	119
#define	MESON8B_CLOCK_CPU_CLK_DIV6	120
#define	MESON8B_CLOCK_CPU_CLK_DIV7	121
#define	MESON8B_CLOCK_CPU_CLK_DIV8	122
#define	MESON8B_CLOCK_PERIPH_SEL	125
#define	MESON8B_CLOCK_PERIPH		126

#endif /* _MESON8B_CLKC_H */
