.\"Do not edit this file.  It was created from ./xboard.texi
.\"using texi2man version 1.01.tpm1 on Sat Oct  1 15:10:47 PDT 2011
.\"If you want a typeset version, you will get better
.\"results with the original file.
.\"
.TH xboard 6 "$Date: " "GNU"
.SH NAME
.PP
xboard \- X graphical user interface for chess
.SH SYNOPSIS
.PP
.B xboard [options]
.br
.B xboard -ics -icshost hostname [options]
.br
.B xboard -ncp [options]
.br
.B |pxboard
.br
.B cmail [options]

.SH DESCRIPTION

XBoard is a graphical chessboard that can serve as a
user interface to chess engines (such as GNU Chess), the
Internet Chess Servers,
electronic mail correspondence chess, or your own collection of saved games.

This manual documents version 4.5.3 of XBoard.

.SH MAJOR MODES
XBoard always runs in one of four major modes.  You select the
major mode from the command line when you start up XBoard.

.TP
.B xboard [options]
As an interface to GNU Chess or another chess engine running on your
machine, XBoard lets you play a game against the machine,
set up arbitrary positions, force variations, watch a game between two
chess engines, interactively analyze your stored games or set up and
analyze arbitrary positions.  (Note: Not all chess engines support
analysis.)
.TP
.B xboard -ics -icshost hostname [options]
As Internet Chess Server (ICS) interface, XBoard
lets you play against other ICS users, observe games
they are playing, or review games that have recently finished.  Most
of the ICS "wild" chess variants are supported, including bughouse.
.TP
.B xboard -ncp [options]
XBoard can also be used simply
as an electronic chessboard to play through games. It will read and
write game files and allow you to play through variations
manually. You can use it to browse games off the net or review games
you have saved.  These features are also available in the other modes.
.TP
.B |pxboard
If you want to pipe games into XBoard, use the supplied shell
script `pxboard'.  For example, from the news reader `xrn',
find a message with one or more games in it, click the Save button,
and type `|pxboard' as the file name.
.TP
.B cmail [options]
As an interface to electronic mail correspondence chess, XBoard
works with the cmail program. See \fICMail\fR below for
instructions.
.PP
.SH BASIC OPERATION
To move a piece, you can drag it with the left mouse button, or you
can click the left mouse button once on the piece, then once more on
the destination square. In crazyhouse, bughouse or shogi you can
drag and drop pieces to the board from the holdings squares 
displayed next to the board.
Old behavior, where right-clicking a square brings up a menu
where you can select what piece to drop on it can still be 
selected through a command-line option.
But only in Edit Position mode right clicking a square is still used to
pop up a menu, where you can select which piece to drop.

The default function of the right mouse button in other modes is 
to display the position the chess program thinks it will end up in.
While moving the mouse vertically with this button pressed 
XBoard will step through the principal variation to show how 
this position will be reached.
Lines of play displayed in the engine-output window,
or PGN variations in the comment window can similarly
be played out on the board, by right-clicking on them.

When connected to an ICS, it is possible to call up a graphical
representation of players seeking a game in stead of the chess board,
when the latter is not in use
(i.e. when you are not playing or observing).
Left-clicking the display area will switch between this 'seek graph'
and the chess board.
Hovering the mouse pointer over a dot will show the details of the
seek ad in the message field above the board.
Left-clicking the dot will challenge that player.
Right-clicking a dot will 'push it to the back',
to reveal any dots that were hidden behind it.
Right-clicking off dots will refresh the graph.

Most other XBoard commands are available from the menu bar. The most
frequently used commands also have shortcut keys or on-screen buttons.
Some rarely used parameters can only be set through options on the
command line used to invoke XBoard.

XBoard uses a settings file, in which it can remember any changes to
the settings that are made through menus or command-line options,
so they will still apply when you restart XBoard for another session.
The settings can be saved into this file automatically when XBoard exits,
or on explicit request of the user.
The default name for the settings file is /etc/xboard/xboard.conf,
but in a standard install this file is only used as a master settings
file that determines the system-wide default settings,
and defers reading and writing of user settings to a user-specific
file like ~/.xboardrc in the user's home directory.

When XBoard is iconized, its graphical icon is a white knight if
it is White's turn to move, a black knight if it is Black's turn.  See
Iconize in \fIKeys\fR below if you have problems getting this
feature to work.

.SH MENUS, BUTTONS, AND KEYS
.SS File Menu
.TP
.B New Game
Resets XBoard and the chess engine to the beginning of a new chess
game. The `Ctrl-N' key is a keyboard equivalent. In Internet Chess
Server mode, clears the current state of XBoard, then
resynchronizes with the ICS by sending a refresh command. If you want to
stop playing, observing, or examining an ICS game, use an
appropriate command from the Action menu, not `New Game'.
See \fIAction Menu\fR.
.TP
.B New Shuffle Game
Similar to `New Game', but allows you to specify a particular initial position 
(according to a standardized numbering system)
in chess variants which use randomized opening positions (e.g. Chess960).
The selected opening position will persistently be chosen on any following
New Game command until you use this menu to select another. Selecting
position number -1 will produce a newly randomized position on any new game.
Using this menu item in variants that normally do not shuffle their opening position
does cause these variants to become shuffle variants until you use the
`New Shuffle Game' menu to explicitly switch the randomization off,
or select a new variant.
.TP
.B New Variant
Allows you to select a new chess variant in non-ICS mode. 
(In ICS play, the ICS is responsible for deciding which variant will be played,
and XBoard adapts automatically.)  The shifted `Alt+V' key is a 
keyboard equivalent. If you play with an engine, the engine must
be able to play the selected variant, or the command will be ignored.
XBoard supports all major variants, such as xiangqi, shogi, chess, chess960,
Capablanca Chess, shatranj, crazyhouse, bughouse.
But not every board size has built-in bitmaps for un-orthodox pieces!
Only sizes bulky (72) and middling (49) have all pieces,
while size petite (33) has most.
These sizes would have to be set at startup through the `size'
command-line option when you start up XBoard for such variants to be playable.

You can overrule the default board format of the selected variant,
(e.g. to play suicide chess on a 6 x 6 board),
in this dialog, but normally you would not do that, 
and leave them at '-1', which means 'default'.
.TP
.B Load Game
Plays a game from a record file. The `Ctrl-O' key is a keyboard equivalent.
A pop-up dialog prompts you for the file name. If the file contains more
than one game, a second pop-up dialog
displays a list of games (with information drawn from their PGN tags, if
any), and you can select the one you want. Alternatively, you can load the
Nth game in the file directly, by typing the number `N' after the
file name, separated by a space.

The game file parser will accept PGN (portable game notation),
or in fact almost any file that contains moves in algebraic
notation. 
Notation of the form `P@f7'
is accepted for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
If the file includes a PGN position (FEN tag), or an old-style
XBoard position diagram bracketed by `[--' and `--]'
before the first move, the game starts from that position. Text
enclosed in parentheses, square brackets, or curly braces is assumed to
be commentary and is displayed in a pop-up window. Any other
text in the file is ignored. PGN variations (enclosed in
parentheses) also are treated as comments;
however, if you rights-click them in the comment window,
XBoard will shelve the current line, and load the the selected variation,
so you can step through it.
You can later revert to the previous line with the `Revert' command.
This way you can walk quite complex varation trees with XBoard.
The nonstandard PGN tag [Variant "varname"] functions similarly to
the -variant command-line option (see below), allowing games in certain chess
variants to be loaded.  
Note that it must appear before any FEN tag for XBoard to recognize
variant FENs appropriately.
There is also a heuristic to 
recognize chess variants from the Event tag, by looking for the strings
that the Internet Chess Servers put there when saving variant ("wild") games.
.TP
.B Load Position
Sets up a position from a position file.  A pop-up dialog prompts
you for the file name.  The shifted `Ctrl-O' key is a keyboard 
equivalent. If the file contains more than one saved
position, and you want to load the Nth one, type the number N
after the file name, separated by a space. Position files must
be in FEN (Forsythe-Edwards notation), or in the format that the
Save Position command writes when oldSaveStyle is turned on.
.TP
.B Load Next Position
Loads the next position from the last position file you loaded.
The shifted `PgDn' key is a keyboard equivalent.
.TP
.B Load Previous Position
Loads the previous position from the last position file you
loaded. The shifted `PgUp' key is a keyboard equivalent.
Not available if the last position was loaded from a pipe.
.TP
.B Save Game
Appends a record of the current game to a file.
The `Ctrl-S' key is a keyboard equivalent.
A pop-up dialog
prompts you for the file name. If the game did not begin with
the standard starting position, the game file includes the
starting position used. Games are saved in the PGN (portable
game notation) format, unless the oldSaveStyle option is true,
in which case they are saved in an older format that is specific
to XBoard. Both formats are human-readable, and both can be
read back by the `Load Game' command.
Notation of the form `P@f7'
is accepted for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
.TP
.B Save Position
Appends a diagram of the current position to a file.
The shifted `Ctrl+S' key is a keyboard equivalent. 
A pop-up dialog prompts you for the file name. Positions are saved in
FEN (Forsythe-Edwards notation) format unless the `oldSaveStyle'
option is true, in which case they are saved in an older,
human-readable format that is specific to XBoard. Both formats
can be read back by the `Load Position' command.
.TP
.B Mail Move
.PD 0
.TP
.B Reload CMail Message
.PD
See \fICMail\fR.
.TP
.B Exit
Exits from XBoard. The `Ctrl-Q' key is a keyboard equivalent.
.PP
.SS Edit Menu
.TP
.B Copy Game
Copies a record of the current game to an internal clipboard in PGN
format and sets the X selection to the game text. The `Ctrl-C' 
key is a keyboard equivalent. The game can be
pasted to another application (such as a text editor or another copy
of XBoard) using that application's paste command.  In many X
applications, such as xterm and emacs, the middle mouse button can be
used for pasting; in XBoard, you must use the Paste Game command.
.TP
.B Copy Position
Copies the current position to an internal clipboard in FEN format and
sets the X selection to the position text. The shifted `Ctrl-C' key 
is a keyboard equivalent.  The position can be pasted
to another application (such as a text editor or another copy of
XBoard) using that application's paste command.  In many X
applications, such as xterm and emacs, the middle mouse button can be
used for pasting; in XBoard, you must use the Paste Position command.
.TP
.B Paste Game
Interprets the current X selection as a game record and loads it, as
with Load Game. The `Ctrl-V' key is a keyboard equivalent.
.TP
.B Paste Position
Interprets the current X selection as a FEN position and loads it, as
with Load Position. The shifted `Ctrl-V' key is a keyboard equivalent.
.TP
.B Edit Game
Allows you to make moves for both Black and White, and to change
moves after backing up with the `Backward' command. The clocks do
not run. The `Ctrl-E' key is a keyboard equivalent.

In chess engine mode, the chess engine continues to check moves for legality
but does not participate in the game. You can bring the chess engine
into the game by selecting `Machine White', `Machine Black',
or `Two Machines'.

In ICS mode, the moves are not sent to the ICS: `Edit Game' takes
XBoard out of ICS Client mode and lets you edit games locally.
If you want to edit games on ICS in a way that other ICS users
can see, use the ICS `examine' command or start an ICS match
against yourself.
.TP
.B Edit Position
Lets you set up an arbitrary board position.
The shifted `Ctrl-E' key is a keyboard equivalent.
Use mouse button 1 to drag pieces to new squares, or to delete a piece
by dragging it off the board or dragging an empty square on top of it.
To drop a new piece on a square, press mouse button 2 or 3 over the
square. This brings up a menu of white pieces (button 2) or
black pieces (button 3). Additional menu choices let you empty the
square or clear the board. You can set the side to play next by
clicking on the word White or Black at the top of the screen.
Selecting `Edit Position' causes XBoard to discard
all remembered moves in the current game.

In ICS mode, changes made to the position by `Edit Position' are
not sent to the ICS: `Edit Position' takes XBoard out of
`ICS Client' mode and lets you edit positions locally. If you want to
edit positions on ICS in a way that other ICS users can see, use
the ICS `examine' command, or start an ICS match against yourself.
(See also the ICS Client topic above.)
.TP
.B Edit Tags
Lets you edit the PGN (portable game notation)
tags for the current game. After editing, the tags must still conform to
the PGN tag syntax:

.nf
    <tag-section> ::= <tag-pair> <tag-section>
                            <empty>
    <tag-pair> ::= [ <tag-name> <tag-value> ]
    <tag-name> ::= <identifier>
    <tag-value> ::= <string>
.fi

See the PGN Standard for full details. Here is an example:

.nf
    [Event "Portoroz Interzonal"]
    [Site "Portoroz, Yugoslavia"]
    [Date "1958.08.16"]
    [Round "8"]
    [White "Robert J. Fischer"]
    [Black "Bent Larsen"]
    [Result "1-0"]
.fi

Any characters that do not match this syntax are silently ignored. Note that
the PGN standard requires all games to have at least the seven tags shown
above. Any that you omit will be filled in by XBoard
with `?' (unknown value), or `-' (inapplicable value).
.TP
.B Edit Comment
Adds or modifies a comment on the current position. Comments are
saved by `Save Game' and are displayed by `Load Game',
`Forward', and `Backward'.
.TP
.B Revert
.PD 0
.TP
.B Annotate
.PD
If you are examining an ICS game and Pause mode is off,
Revert issues the ICS command `revert'.
In local mode, when you were editing or analyzing a game, 
and the `-variations' command-line option is switched on,
you can start a new variation by holding the Shift key down while
entering a move not at the end of the game.
Variations can also become the currently displayed line by
clicking a PGN variation displayed in the Comment window.
This can be applied recursively, 
so that you can analyze variations on variations; 
each time you create a new variation by entering an alternative move
with Shift pressed, or select a new one from the Comment window,
the current variation will be shelved. 
`Revert' allows you to return to the most recently shelved variation.
The difference between `Revert' and `Annotate'
is that with the latter,
the variation you are now abandoning will be added as a comment 
(in PGN variation syntax, i.e. between parentheses)
to the original move where you deviated, for later recalling.
The `Home' key is a keyboard equivalent to `Revert'.
.TP
.B Truncate Game
Discards all remembered moves of the game beyond the current
position. Puts XBoard into `Edit Game' mode if it was not there
already.
The `End' key is a keyboard equivalent.
.TP
.B Backward
Steps backward through a series of remembered moves.
The `[<]' button and the `Alt+LeftArrow' key are equivalents,
as is turning the mouse wheel towards you.
In addition, pressing the Control key steps back one move, and releasing
it steps forward again.

In most modes, `Backward' only lets you look back at old positions;
it does not retract moves. This is the case if you are playing against
a chess engine, playing or observing a game on an ICS, or loading a game.
If you select `Backward' in any of these situations, you will not
be allowed to make a different move. Use `Retract Move' or
`Edit Game' if you want to change past moves.

If you are examining an ICS game, the behavior of `Backward'
depends on whether XBoard is in Pause mode. If Pause mode is
off, `Backward' issues the ICS backward command, which backs up
everyone's view of the game and allows you to make a different
move. If Pause mode is on, `Backward' only backs up your local
view.
.TP
.B Forward
Steps forward through a series of remembered moves (undoing the
effect of `Backward') or forward through a game file. The
`[>]' button and the `Alt+RightArrow' key are equivalents,
as is turning the mouse wheel away from you.

If you are examining an ICS game, the behavior of Forward
depends on whether XBoard is in Pause mode. If Pause mode is
off, `Forward' issues the ICS forward command, which moves
everyone's view of the game forward along the current line. If
Pause mode is on, `Forward' only moves your local view forward,
and it will not go past the position that the game was in when
you paused.
.TP
.B Back to Start
Jumps backward to the first remembered position in the game.
The `[<<]' button and the `Alt+Home' key are equivalents.

In most modes, Back to Start only lets you look back at old
positions; it does not retract moves. This is the case if you
are playing against a local chess engine, playing or observing a game on
a chess server, or loading a game. If you select `Back to Start' in any
of these situations, you will not be allowed to make different
moves. Use `Retract Move' or `Edit Game' if you want to change past
moves; or use Reset to start a new game.

If you are examining an ICS game, the behavior of @samp{Back to
Start} depends on whether XBoard is in Pause mode. If Pause mode
is off, `Back to Start' issues the ICS `backward 999999'
command, which backs up everyone's view of the game to the start and
allows you to make different moves. If Pause mode is on, @samp{Back
to Start} only backs up your local view.
.TP
.B Forward to End
Jumps forward to the last remembered position in the game. The
`[>>]' button and the `Alt+End' key are equivalents.

If you are examining an ICS game, the behavior of @samp{Forward to
End} depends on whether XBoard is in Pause mode. If Pause mode
is off, `Forward to End' issues the ICS `forward 999999'
command, which moves everyone's view of the game forward to the end of
the current line. If Pause mode is on, `Forward to End' only moves
your local view forward, and it will not go past the position
that the game was in when you paused.
.PP
.SS View Menu
.TP
.B Flip View
Inverts your view of the chess board for the duration of the
current game. Starting a new game returns the board to normal.
The `F2' key is a keyboard equivalent.
.TP
.B Show Engine Output
Shows or hides a window in which the thinking output of any loaded engines
is displayed. The shifted `Alt+O' key is a keyboard equivalent.
XBoard will display lines of thinking output of the same depth ordered by score, 
(highest score on top), rather than in the order the engine produced them. 
Usually this amounts to the same, as a normal engine search will only find new PV 
(and emit it as thinking output) 
when it searches a move with a higher score than the previous variation. 
But when the engine is in multi-variation mode this needs not always be true, 
and it is more convenient for someone analyzing games to see the moves sorted by score. 
The order in which the engine found them is only of interest to the engine author, 
and can still be deduced from the time or node count printed with the line.
.TP
.B Show Move History
Shows or hides a list of moves of the current game.
The shifted `Alt+H' key is a keyboard equivalent.
This list allows you to move the display to any earlier position in the game
by clicking on the corresponding move.
.TP
.B Show Evaluation Graph
Shows or hides a window which displays a graph of how the engine score(s)
evolved as a function of the move number. 
The shifted `Alt+E' key is a keyboard equivalent.
Clicking on the graph will bring
the corresponding position in the board display.
.TP
.B Show Game List
Shows or hides the list of games generated by the last `Load Game'
command. The shifted `Alt+G' key is a keyboard equivalent.
.TP
.B Tags
Pops up a window which shows the PGN (portable game notation)
tags for the current game. 
For now this is a duplicate of the `Edit Tags' item in the `Edit' menu.
.TP
.B Comments
Pops up a window which shows any comments to or variations on the current move.
For now this is a duplicate of the `Edit Comment' item in the `Edit' menu.
.TP
.B ICS Input Box
If this option is set in ICS mode,
XBoard
creates an extra window that you can use for typing in ICS commands.
The input box is especially useful if you want to type in something long or do
some editing on your input, because output from ICS doesn't get mixed
in with your typing as it would in the main terminal window.
.TP
.B Board
Summons a dialog where you can customize the look of the chess board.
Here you can specify the directory from which piece images should be taken,
when you don't want to use the built-in piece images
(see `pixmapDirectory' and `bitmapDirectory' options),
an external pixmap to be used for the board squares
(`liteBackTextureFile' and `darkBackTextureFile' options),
and square and piece colors for the built-ins.
.TP
.B Game List Tags
a duplicate of the Game List dialog in the Options menu.
.PP
.SS Mode Menu
.TP
.B Machine White
Tells the chess engine to play White. 
The `Ctrl-W' key is a keyboard equivalent.
.TP
.B Machine Black
Tells the chess engine to play Black.
The `Ctrl-B' key is a keyboard equivalent.
.TP
.B Two Machines
Plays a game between two chess engines.
The `Ctrl-T' key is a keyboard equivalent.
.TP
.B Analysis Mode
XBoard tells the chess engine to start analyzing the current game/position
and shows you the analysis as you move pieces around.
The `Ctrl-A' key is a keyboard equivalent.
Note: Some chess engines do not support Analysis mode.

To set up a position to analyze, you do the following:

1. Select Edit Position from the Mode Menu

2. Set up the position.  Use the middle and right buttons to
bring up the white and black piece menus.

3. When you are finished, click on either the Black or White
clock to tell XBoard which side moves first.

4. Select Analysis Mode from the Mode Menu to start the analysis.

The analysis function can also be used when observing games on an ICS
with an engine loaded (zippy mode); the engine then will analyse
the positions as they occur in the observed game.
.TP
.B Analyze File
This option lets you load a game from a file (PGN, XBoard format, etc.)
and analyze it. The `Ctrl-F' key is a keyboard equivalent.
When you select this menu item, a pop-up window appears
and asks for a file name to load.
If the file contains multiple games, another pop up appears that lets
you select which game you wish to analyze.
After a game is loaded, XBoard will start auto-playing the game,
while the engine is analyzing the current position.
The game will be annotated with the results of these analyses.
In particlar, the score and depth will be added as a comment,
and the PV will be added as a variation.
The time the engine spends on analyzing each move can be controlled
through the command-line option `-timeDelay'.
Note: Some chess engines do not support Analysis mode.
.TP
.B Edit Game
Duplicate of the item in the Edit menu.
Note that `Edit Game' is the idle mode of XBoard, and can be used
to get you out of other modes. E.g. to stop analyzing, stop a game
between two engines or stop editing a position.
.TP
.B Edit Position
Duplicate of the item in the Edit menu.
.TP
.B Training
Training mode lets you interactively guess the moves of a game for one
of the players. You guess the next move of the game by playing the
move on the board. If the move played matches the next move of the
game, the move is accepted and the opponent's response is auto-played.
If the move played is incorrect, an error message is displayed.  You
can select this mode only while loading a game (that is, after
selecting `Load Game' from the File menu).  While XBoard is in 
`Training' mode, the navigation buttons are disabled.
.TP
.B ICS Client
This is the normal mode when XBoard
is connected to a chess server.  If you have moved into
Edit Game or Edit Position mode, you can select this option to get out.

To use xboard in ICS mode, run it in the foreground with the -ics
option, and use the terminal you started it from to type commands and
receive text responses from the chess server.  See
\fIChess Servers\fR below for more information.

XBoard activates some special position/game editing features when you
use the `examine' or `bsetup' commands on ICS and you have
`ICS Client' selected on the Mode menu.  First, you can issue the
ICS position-editing commands with the mouse.  Move pieces by dragging
with mouse button 1.  To drop a new piece on a square, press mouse
button 2 or 3 over the square.  This brings up a menu of white pieces
(button 2) or black pieces (button 3).  Additional menu choices let
you empty the square or clear the board.  Click on the White or Black
clock to set the side to play.  You cannot set the side to play or
drag pieces to arbitrary squares while examining on ICC, but you can
do so in `bsetup' mode on FICS.  In addition, the menu commands
`Forward', `Backward', `Pause', and `Stop Examining'
have special functions in this mode; see below.
.TP
.B Machine Match
Starts a match between two chess programs,
with a number of games and other parameters set through
the `Match Options' menu dialog.
.TP
.B Pause
Pauses updates to the board, and if you are playing against a chess engine,
also pauses your clock. To continue, select `Pause' again, and the
display will automatically update to the latest position.
The `P' button and keyboard `Pause' key are equivalents.

If you select Pause when you are playing against a chess engine and
it is not your move, the chess engine's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop. Since board updates are paused, however,
you will not see the move until you exit from Pause mode (or select Forward).
This behavior is meant to simulate adjournment with a sealed move.

If you select Pause while you are observing or examining a game on a
chess server, you can step backward and forward in the current history
of the examined game without affecting the other observers and
examiners, and without having your display jump forward to the latest
position each time a move is made. Select Pause again to reconnect
yourself to the current state of the game on ICS.

If you select `Pause' while you are loading a game, the game stops
loading. You can load more moves manually by selecting `Forward', or
resume automatic loading by selecting `Pause' again.
.PP
.SS Action Menu
.TP
.B Accept
Accepts a pending match offer. 
The `F3' key is a keyboard equivalent.
If there is more than one offer
pending, you will have to type in a more specific command
instead of using this menu choice.
.TP
.B Decline
Declines a pending offer (match, draw, adjourn, etc.).
The `F4' key is a keyboard equivalent. If there
is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.
.TP
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming
a draw if you are both out of time. 
The `F5' key is a keyboard equivalent.
You can also call your
opponent's flag by clicking on his clock.
.TP
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move
rule, as appropriate. The `F6' key is a keyboard equivalent.
.TP
.B Adjourn
Asks your opponent to agree to adjourning the current game, or
agrees to a pending adjournment offer from your opponent.
The `F7' key is a keyboard equivalent.
.TP
.B Abort
Asks your opponent to agree to aborting the current game, or
agrees to a pending abort offer from your opponent.
The `F8' key is a keyboard equivalent. An aborted
game ends immediately without affecting either player's rating.
.TP
.B Resign
Resigns the game to your opponent. The `F9' key is a
keyboard equivalent.
.TP
.B Stop Observing
Ends your participation in observing a game, by issuing the ICS
observe command with no arguments. ICS mode only.
The `F10' key is a keyboard equivalent.
.TP
.B Stop Examining
Ends your participation in examining a game, by issuing the ICS
unexamine command. ICS mode only.
The `F11' key is a keyboard equivalent.
.TP
.B Upload to Examine
Create an examined game of the proper variant on the ICS,
and send the game there that is currenty loaded in XBoard
(e.g. through pasting or loading from file).
You must be connected to an ICS for this to work.
.TP
.B Adjudicate to White
.PD 0
.TP
.B Adjudicate to Black
.PD
.PD 0
.TP
.B Adjudicate Draw
.PD
Terminate an ongoing game in Two-Machines mode (including match mode),
with as result a win for white, for black, or a draw, respectively.
The PGN file of the game will accompany the result string
by the comment "user adjudication".
.PP
.SS Engine Menu
.TP
.B Engine #N Settings
Pop up a menu dialog to alter the settings specific to the applicable engine.
(The second engine is only accessible once it has been used in Two-Machines mode.)
For each parameter the engine allows to be set,
a control element will appear in this dialog that can be used to alter the value.
Depending on the type of parameter (text string, number, multiple choice,
on/off switch, instantaneous signal) the appropriate control will appear,
with a description next to it.
XBoard has no idea what these values mean; it just passes them on to the engine.
How this dialog looks is completely determined by the engine,
and XBoard just passes it on to the user.
Many engines do not have any parameters that can be set by the user,
and in that case the dialog will be empty (except for the OK and cancel buttons).
UCI engines usually have many parameters. (But these are only visible with
a sufficiently modern version of the Polyglot adapter needed to run UCI engines,
e.g. Polyglot 1.4.55b.) For native XBoard engines this is less common.
.TP
.B Hint
Displays a move hint from the chess engine.
.TP
.B Book
Displays a list of possible moves from the chess engine's opening
book.  The exact format depends on what chess engine you are using.
With GNU Chess 4, the first column gives moves, the second column
gives one possible response for each move, and the third column shows
the number of lines in the book that include the move from the first
column. If you select this option and nothing happens, the chess
engine is out of its book or does not support this feature.
.TP
.B Move Now
Forces the chess engine to move immediately. Chess engine mode only.
The `Ctrl-M' key is a keyboard equivalent.
.TP
.B Retract Move
Retracts your last move. In chess engine mode, you can do this only
after the chess engine has replied to your move; if the chess engine is still
thinking, use `Move Now' first. In ICS mode, `Retract Move'
issues the command `takeback 1' or `takeback 2'
depending on whether it is your opponent's move or yours.
The `Ctrl-X' key is a keyboard equivalent.
.PP
.SS Options Menu
.TP
.B Time Control
Pops up a sub-menu where you can set the time-control parameters interactively.
Allows you to select classical or incremental time controls,
set the moves per session, session duration, and time increment.
Also allows specification of time-odds factors for one or both engines.
If an engine is given a time-odds factor N, all time quota it gets, 
be it at the beginning of a session or through the time increment or
fixed time per move, will be divided by N.
The shifted `Alt+T' key is a keyboard equivalent.
.TP
.B Common Engine
Pops up a sub-menu where you can set some engine parameters common to most engines,
such as hash-table size, tablebase cache size, maximum number of processors
that SMP engines can use, and where to find the Polyglot adapter needed
to run UCI engines under XBoard. The feature that allows setting of these parameters on
engines is new since XBoard 4.3.15, so not many XBoard/WinBoard engines respond
to it yet, but UCI engines should.

It is also possible to specify a GUI opening book here, i.e. an opening
book that XBoard consults for any position a playing engine gets in.
It then forces the engine to play the book move, rather than to think up its own,
if that position is found in the book.
The book can switched on and off independently for either engine.
The way book moves are chosen can be influenced through the settings of
book depth and variety.
After both sides have played more moves than the specified depth,
the book will no longer be consulted.
When the variety is set to 50, moves will be played with the probability
specified in the book.
When set to 0, only the move(s) with the highest probability will be played.
When set to 100, all listed moves will be played with equal pobability.
Other settings interpolate between that.
The shifted `Alt+U' key is a keyboard equivalent.
.TP
.B Adjudications
Pops up a sub-menu where you can enable or disable various adjudications
that XBoard can perform in engine-engine games.
The shifted `Alt+J' key is a keyboard equivalent.
You can instruct XBoard to detect and terminate the game on checkmate
or stalemate, even if the engines would not do so, to verify engine
result claims (forfeiting engines that make false claims), rather than
naively following the engine, to declare draw on positions
which can never be won for lack of mating material, (e.g. KBK),
or which are impossible to win unless the opponent seeks its own demise 
(e.g. KBKN).
For these adjudications to work, `Test Legality' should be switched on.
It is also possible to instruct XBoard to enforce a 50-move or 3-fold-repeat
rule and automatically declare draw (after a user-adjustable number of moves
or repeats) even if the engines are prepared to go on.
It is also possible to have XBoard declare draw on games that seem to drag on 
forever, or adjudicate a loss if both engines agree (for 3 consecutive moves) that one
of them is behind more than a user-adjustable score threshold.
For the latter adjudication to work, XBoard should be able to properly understand
the engine's scores. To facilitate the latter, you can inform xboard here if
the engines report scores from the viewpoint of white, or from that of their own color.
.TP
.B Match Game Options
Summons a dialog where you can set options important for playing automatic 
matches between two chess programs 
(e.g. by using the `Machine Match' menu item in the `Mode' menu).
You can specify the number of games such a match should last,
and the duration of the pause between games
(important for some older engines to not have the last move of a previous
game be given when the next game has already started).
You can also specify a file with opening lines, or a file with initial positions
(the `loadGameFile' and `loadPositionFile' options),
and the number of the game or position to use from these files.
Values -1 and -2 of this 'index' convey a special meaning,
namely that XBoard should automatically step through all lines or positions
in these files.
With -1 such stepping is done every game; with -2 every two games,
so that each line or position is played with both colors before stepping
to the next one.
You can have XBoard automatically rewind to the first line or position
in the file after the index reaches a certain vaue,
which you can also specify here.
.TP
.B Load Game Options
Summons a dialog where you can set the `autoDisplayComment' and 
`autoDisplayTags' options, (which control popups when viewing loaded games),
and specify the rate at which loaded games are auto-played,
in seconds per move (which can be a fractional number, like 1.6).
.TP
.B Save Game Options
Summons a dialog where you can specify the files on which XBoard should
automtically save any played or entered games, 
(the `saveGameFile' option), 
or the final position of such games (the `savePositionfile' option).
You can also select 'auto-save' without a file name,
in which case XBoard will prompt the user for a file name after each game.
You can also set the default value for the PGN Event tag that will
be used for each new game you start.
Various options for the format of the game can be specified as well,
such as whether scores and depths of engine games should be saved as comments,
and if a tag with info about the score with which the engine came out of book
should be included.
For Chess, always set the format to PGN, rather than "old save stye"!
.TP
.B Game List
Pops up a dialog where you can select the PGN tags that should appear
on the lines in the game list, and their order.
.TP
.B Sound Options
Summons a dialog where you can specify the sounds that should accompany
various events that can occur XBoard.
Most events are only relevant to ICS play, 
but the move sound is an important exception.
For each event listed in the dialog, 
you can select a standard sound from a menu.
You can also select a user-supplied sound file,
by typing its name into the designated text-edit field first,
and then selecting "Above WAV File" from the menu for the event.
A dummy event has been provided for trying out the sounds with the
"play" button next to it.
The directory with standard sounds, and the external program for playing
the sounds can be specified too, but normally you would not touch these
once XBoard is properly installed.
.PD 0
.TP
.B Move Sound
.PD
When a move sound other than 'None' is selected, 
XBoard alerts you by playing a sound
after each of your opponent's moves (or after every
move if you are observing a game on the Internet Chess Server).
The sound is not played after moves you make or moves read from a
saved game file.
If you turn on this option when using XBoard with the Internet
Chess Server, you will probably want to give the
`set bell 0'
command to the ICS, since otherwise the ICS will ring the terminal bell
after every move (not just yours). (The `.icsrc' file
is a good place for this; see \fIICS options\fR.)
.TP
.B General Options
The following items to set option values appear in the dialog
summoned by the general Options menu item.
.PD 0
.TP
.B Always Queen
.PD
If this option is off, XBoard brings up a dialog
box whenever you move a pawn to the last rank, asking what piece
you want to promote it to. If the option is true, your pawns are
always promoted to queens. Your opponent can still under-promote.
The shifted `Ctrl-Q' key is a keyboard equivalent.
.PD 0
.TP
.B Animate Dragging
.PD
If Animate Dragging is on, while you are dragging a piece with the
mouse, an image of the piece follows the mouse cursor.
If Animate Dragging is off, there is no visual feedback while you are
dragging a piece, but if Animate Moving is on, the move will be
animated when it is complete. 
.PD 0
.TP
.B Animate Moving
.PD
If Animate Moving is on, all piece moves are animated.  An image of the
piece is shown moving from the old square to the new square when the
move is completed (unless the move was already animated by Animate Dragging).
If Animate Moving is off, a moved piece instantly disappears from its
old square and reappears on its new square when the move is complete.
The shifted `Ctrl-A' key is a keyboard equivalent.
.PD 0
.TP
.B Auto Flag
.PD
If this option is on and one player runs out of time
before the other,
XBoard
will automatically call his flag, claiming a win on time.
The shifted `Ctrl-F' key is a keyboard equivalent.
In ICS mode, Auto Flag will only call your opponent's flag, not yours,
and the ICS may award you a draw instead of a win if you have
insufficient mating material.  In local chess engine mode,
XBoard
may call either player's flag and will not take material into account (?).
.PD 0
.TP
.B Auto Flip View
.PD
If the Auto Flip View option is on when you start a game, the board
will be automatically oriented so that your pawns move from the bottom
of the window towards the top.

If you are playing a game on an ICS, the board is always
oriented at the start of the game so that your pawns move from
the bottom of the window towards the top. Otherwise, the starting
orientation is determined by the `flipView' command line option;
if it is false (the default), White's pawns move from bottom to top
at the start of each game; if it is true, Black's pawns move from
bottom to top. See \fIUser interface options\fR.
.PD 0
.TP
.B Blindfold
.PD
If this option is on, XBoard displays the board as usual but does
not display pieces or move highlights.  You can still move in the
usual way (with the mouse or by typing moves in ICS mode), even though
the pieces are invisible.
.PD 0
.TP
.B Drop Menu
.PD
Controls if right-clicking the board in crazyhouse / bughouse
will pop up a menu to drop a piece on the clicked square
(old, deprecated behavior)
or allow you to step through an engine PV
(new, recommended behavior).
.PD 0
.TP
.B Highlight Dragging
.PD
If Highlight Dragging is on, and the option -showTargetSquares is also on
in the settings file, all squares a piece that is 'picked up' with the mouse
can legally move to are highighted with a fat colored dot in the
highlightColor (non-captures) or premoveHighlightColor (captures).
Legality testing must be on for XBoard to know how the piece moves.
.PD 0
.TP
.B Highlight Last Move
.PD
If Highlight Last Move is on, after a move is made, the starting and
ending squares remain highlighted. In addition, after you use Backward
or Back to Start, the starting and ending squares of the last move to
be unmade are highlighted.
.PD 0
.TP
.B Highlight with Arrow
.PD
Causes the highlighting described in Highlight Last Move to be done
by drawing an arrow between the highlighted squares,
so that it is visible even when the width of the grid lines is set to zero.
.PD 0
.TP
.B One-Click Moving
.PD
If this option is on, XBoard does not wait for you to click both the
from- and the to-square, or drag the piece, but performs a move as soon
as it is uniqely specified.
This applies to clicking an own piece that only has a single legal move,
clicking an empty square or opponent piece where only one of your pieces
can move (or capture) to.
Furthermore, a double-click on a piece that can only make a single capture
will cause that capture to be made.
Promoting a Pawn by clicking its to-square will suppress the promotion
popup, and make it promote to Queen.
.PD 0
.TP
.B Periodic Updates
.PD
If this option is off (or if
you are using a chess engine that does not support periodic updates),
the analysis window
will only be updated when the analysis changes. If this option is
on, the Analysis Window will be updated every two seconds.
.PD 0
.TP
.B Ponder Next Move
.PD
If this option is off, the chess engine will think only when it is on
move.  If the option is on, the engine will also think while waiting
for you to make your move.
The shifted `Ctrl-P' key is a keyboard equivalent.
.PD 0
.TP
.B Popup Exit Message
.PD
If this option is on, when XBoard wants to display a message just
before exiting, it brings up a modal dialog box and waits for you to
click OK before exiting.  If the option is off, XBoard prints the
message to standard error (the terminal) and exits immediately.
.PD 0
.TP
.B Popup Move Errors
.PD
If this option is off, when you make an error in moving (such as
attempting an illegal move or moving the wrong color piece), the
error message is displayed in the message area.  If the option is
on, move errors are displayed in small pop-up windows like other errors.
You can dismiss an error pop-up either by clicking its OK button or by
clicking anywhere on the board, including down-clicking to start a move.
.PD 0
.TP
.B Show Coords
.PD
If this option is on, XBoard displays algebraic coordinates
along the board's left and bottom edges.
.PD 0
.TP
.B Hide Thinking
.PD
If this option is off, the chess engine's notion of the score and best
line of play from the current position is displayed as it is
thinking. The score indicates how many pawns ahead (or if negative,
behind) the chess engine thinks it is. In matches between two
machines, the score is prefixed by `W' or `B' to indicate
whether it is showing White's thinking or Black's, and only the thinking
of the engine that is on move is shown.
The shifted `Ctrl-H' key is a keyboard equivalent.
.PD 0
.TP
.B Test Legality
.PD
If this option is on, XBoard tests whether the moves you try to make
with the mouse are legal and refuses to let you make an illegal move.
The shifted `Ctrl-L' key is a keyboard equivalent.
Moves loaded from a file with `Load Game' are also checked.  If
the option is off, all moves are accepted, but if a local chess engine
or the ICS is active, they will still reject illegal moves.  Turning
off this option is useful if you are playing a chess variant with
rules that XBoard does not understand.  (Bughouse, suicide, and wild
variants where the king may castle after starting on the d file are
generally supported with Test Legality on.)
.PD 0
.TP
.B Flash Moves
.PD
.PD 0
.TP
.B Flash Rate
.PD
If this option is non-zero, whenever a move is completed, 
the moved piece flashes the specified number of times.
The flash-rate setting determines how rapidly this flashing occurs.
.PD 0
.TP
.B Animation Speed
.PD
Determines the duration (in msec) of an animation step,
when `Animate Moving' is swiched on.

.TP
.B ICS Options
The following options occur in a dialog summoned by the 
ICS Options menu item.
.PD 0
.TP
.B Auto Kibitz
.PD
Setting this option when playingwith or aginst a chess program on an ICS
will cause the last line of thinking output of the engine before its move
to be sent to the ICS in a kibitz command.
In addition, any kibitz message received through the ICS from
an opponent chess program will be diverted to the engine-output window,
(and suppressed in the console),
where you can play through its PV by right-clicking it.
.PD 0
.TP
.B Auto Comment
.PD
If this option is on, any remarks made on ICS while you are observing or
playing a game are recorded as a comment on the current move.  This includes
remarks made with the ICS commands `say', `tell', `whisper',
and `kibitz'.
Limitation: remarks that you type yourself are not recognized;
XBoard scans only the output from ICS, not the input you type to it.
.PD 0
.TP
.B Auto Observe
.PD
If this option is on and you add a player to your `gnotify'
list on ICS, XBoard will automatically observe all of that
player's games, unless you are doing something else (such as
observing or playing a game of your own) when one starts.
The games are displayed 
from the point of view of the player on your gnotify list; that is, his
pawns move from the bottom of the window towards the top.
Exceptions:  If both players in a game are on your gnotify list, if
your ICS 
`highlight'
variable is set to 0, or if the ICS you are using does not 
properly support observing from Black's point of view,
you will see the game from White's point of view.
.PD 0
.TP
.B Auto Raise Board
.PD
If this option is on, whenever a new game begins, the chessboard window
is deiconized (if necessary) and raised to the top of the stack of windows.
.PD 0
.TP
.B Auto Save
.PD
If this option is true, at the end of every game XBoard prompts
you for a file name and appends a record of the game to the file
you specify. 
Disabled if the `saveGameFile' command-line
option is set, as in that case all games are saved to the specified file.
See \fILoad and Save options\fR.
.PD 0
.TP
.B Background Observe
.PD
Setting this option will make XBoard suppress display of any boards
from observed games while you are playing.
In stead the last such board will be remembered,
and shown to you when you right-click the board.
This allows you to peek at your bughouse partner's game when you want,
without disturbing your own game too much.
.PD 0
.TP
.B Dual Board
.PD
Setting this option in combination with `Background Observe'
will display boards of observed games while you are playing
on a second board next to that of your own game.
.PD 0
.TP
.B Get Move List
.PD
If this option is on, whenever XBoard
receives the first board of a new ICS game (or a different game from
the one it is currently displaying), it
retrieves the list of past moves from the ICS.
You can then review the moves with the `Forward' and `Backward'
commands
or save them with `Save Game'.  You might want to
turn off this option if you are observing several blitz games at once,
to keep from wasting time and network bandwidth fetching the move lists over
and over.
When you turn this option on from the menu, XBoard
immediately fetches the move list of the current game (if any).
.PD 0
.TP
.B Quiet Play
.PD
If this option is on, XBoard will automatically issue an ICS
`set shout 0'
command whenever you start a game and a
`set shout 1'
command whenever you finish one.  Thus, you will not be distracted
by shouts from other ICS users while playing.
.PD 0
.TP
.B Seek Graph
.PD
Setting this option will cause XBoard to display an graph of
currently active seek ads when you left-click the board
while idle and logged on to an ICS.
.PD 0
.TP
.B Auto-Refresh Seek Graph
.PD
In combination with the `Seek Graph' option this
will cause automatic update of the seek graph while it is up.
This only works on FICS and ICS,
and requires a lot of bandwidth on a busy server.
.PD 0
.TP
.B Premove
.PD
.PD 0
.TP
.B Premove White
.PD
.PD 0
.TP
.B Premove Black
.PD
.PD 0
.TP
.B First White Move
.PD
.PD 0
.TP
.B First Black Move
.PD
If this option is on while playing a game on an ICS, you can register
your next planned move before it is your turn.  Move the piece with
the mouse in the ordinary way, and the starting and ending squares
will be highlighted with a special color (red by default).  When it is
your turn, if your registered move is legal, XBoard will send it to
ICS immediately; if not, it will be ignored and you can make a
different move.  If you change your mind about your premove, either
make a different move, or double-click on any piece to cancel the move
entirely.

You can also enter premoves for the first white and black moves
of the game.
.PD 0
.TP
.B ICS Alarm
.PD
.PD 0
.TP
.B ICS Alarm Time
.PD
When this option is on, an alarm sound is played when your clock
counts down to the icsAlarmTime in an ICS game.
(By default, the time is 5 seconds, but you can pecify other values
with the Alarm Time spin control.) 
For games with time controls that include an increment, the
alarm will sound each time the clock counts down to the icsAlarmTime.
By default, the alarm sound is the terminal bell, but on some systems
you can change it to a sound file using the soundIcsAlarm option; see
below.
.PD 0
.TP
.B Colorize Messages
.PD
Ticking this options causes various types of ICS messages do be
displayed with different foreground or background colors in the console.
The colors can be individually selected for each type,
through the accompanying text edits.

.TP
.B Save Settings Now
Selecting this menu item causes the current XBoard settings to be
written to the settings file, so they will also apply in future sessions.
Note that some settings are 'volatile', and are not saved,
because XBoard considers it too unlikely that you want those to apply
next time.
In particular this applies to the Chess program names, and all options
giving information on those Chess programs (such as their directory,
if they have their own opening book, if they are UCI or native XBoard),
or the variant you are playing.
Such options would still be understood when they appear in the settings
file in case they were put there with the aid of a text editor, but they
would disappear from the file as soon as you save the settings.
.TP
.B Save Settings on Exit
Setting this option has no immediate effect, but causes the settings
to be saved when you quit XBoard. What happens then is otherwise 
identical to what happens when you use select "Save Settings Now",
see there.
.PP
.SS Help Menu
.TP
.B Info XBoard
Displays the XBoard documentation in info format.  For this feature to
work, you must have the GNU info program installed on your system, and
the file `xboard.info' must either be present in the current
working directory, or have been installed by the `make install'
command when you built XBoard.
.TP
.B Man XBoard
Displays the XBoard documentation in man page format.
The `F1' key is a keyboard equivalent.  For this
feature to work, the file `xboard.6' must have been installed by
the `make install' command when you built XBoard, and the
directory it was placed in must be on the search path for your
system's `man' command.
.TP
.B About XBoard
Shows the current XBoard version number.
.PP
.SS Other Shortcut Keys
.TP
.B Iconize
Pressing the `-' key iconizes XBoard. The graphical
icon displays a white knight if it is White's move, or a black knight
if it is Black's move. If your X window manager displays only text
icons, not graphical ones, check its documentation; there is probably
a way to enable graphical icons.  If you get black and white reversed,
we would like to hear about it; see \fIProblems\fR below for
instructions on how to report this problem.
.TP
.B Load Next Game
Loads the next game from the last game record file you loaded.
The `Alt+PgDn' key is a keyboard equivalent.
.TP
.B Load Previous Game
Loads the previous game from the last game record file you
loaded.  The `Alt+PgUp' key is a keyboard equivalent.
Not available if the last game was loaded from a pipe.
.TP
.B Reload Same Game
Reloads the last game you loaded.
Not available if the last game was loaded from a pipe.
.TP
.B Reload Same Position
Reloads the last position you loaded.
Not available if the last position was loaded from a pipe.
.PP
You can add or remove shortcut keys using the X resources
`form.translations'. Here is an example of what would go in your
`.Xresources' file:

.nf
    XBoard*form.translations: \\
      Shift<Key>?: AboutGameProc() \\n\\
      <Key>y: AcceptProc() \\n\\
      <Key>n: DeclineProc() \\n\\
      <Key>i: NothingProc()
.fi

Binding a key to `NothingProc' makes it do nothing, thus removing
it as a shortcut key. The XBoard commands that can be bound to keys
are:

.nf
    AbortProc, AboutGameProc, AboutProc, AcceptProc, AdjournProc,
    AlwaysQueenProc, AnalysisModeProc, AnalyzeFileProc,
    AnimateDraggingProc, AnimateMovingProc, AutobsProc, AutoflagProc,
    AutoflipProc, AutoraiseProc, AutosaveProc, BackwardProc,
    BlindfoldProc, BookProc, CallFlagProc, CopyGameProc, CopyPositionProc,
    DebugProc, DeclineProc, DrawProc, EditCommentProc, EditGameProc,
    EditPositionProc, EditTagsProc, EnterKeyProc, FlashMovesProc,
    FlipViewProc, ForwardProc, GetMoveListProc, HighlightLastMoveProc,
    HintProc, Iconify, IcsAlarmProc, IcsClientProc, IcsInputBoxProc,
    InfoProc, LoadGameProc, LoadNextGameProc, LoadNextPositionProc,
    LoadPositionProc, LoadPrevGameProc, LoadPrevPositionProc,
    LoadSelectedProc, MachineBlackProc, MachineWhiteProc, MailMoveProc,
    ManProc, MoveNowProc, MoveSoundProc, NothingProc, OldSaveStyleProc,
    PasteGameProc, PastePositionProc, PauseProc, PeriodicUpdatesProc,
    PonderNextMoveProc, PopupExitMessageProc, PopupMoveErrorsProc,
    PremoveProc, QuietPlayProc, QuitProc, ReloadCmailMsgProc,
    ReloadGameProc, ReloadPositionProc, RematchProc, ResetProc,
    ResignProc, RetractMoveProc, RevertProc, SaveGameProc,
    SavePositionProc, ShowCoordsProc, ShowGameListProc, ShowThinkingProc,
    StopExaminingProc, StopObservingProc, TestLegalityProc, ToEndProc,
    ToStartProc, TrainingProc, TruncateGameProc, and TwoMachinesProc.
.fi

.SH OPTIONS
This section documents the command-line options to XBoard.  You can
set these options in two ways: by typing them on the shell command
line you use to start XBoard, or by setting them as X resources
(typically in your `.Xresources' file).  Many of the options
cannot be changed while XBoard is running; others set the initial
state of items that can be changed with the \fIOptions\fR menu.

Most of the options have both a long name and a short name. To turn a
boolean option on or off from the command line, either give its long
name followed by the value true or false
(`-longOptionName true'), or give just the short name to turn the
option on (`-opt'), or the short name preceded by `x' to
turn the option off (`-xopt'). For options that take strings or
numbers as values, you can use the long or short option names
interchangeably.

Each option corresponds to an X resource with the same name, so
if you like, you can set options in your `.Xresources' file
or in a file named `XBoard' in your home directory.
For options that have two names, the longer one is the name of
the corresponding X resource; the short name is not recognized.
To turn a boolean option on or off as an
X resource, give its long name followed by the value
true or false (`XBoard*longOptionName: true').

.SS Chess Engine Options
.TP
.B -tc or -timeControl minutes[:seconds]
Each player begins with his clock set to the `timeControl' period.
Default: 5 minutes.
The additional options `movesPerSession' and `timeIncrement'
are mutually exclusive.  
.TP
.B -mps or -movesPerSession moves
When both players have made `movesPerSession' moves, a
new `timeControl' period is added to both clocks.  Default: 40 moves.
.TP
.B -inc or -timeIncrement seconds
If this option is specified, `movesPerSession' is ignored.
Instead, after each player's move, `timeIncrement' seconds are
added to his clock.  
Use `-inc 0' if you want to require the entire
game to be played in one `timeControl' period, with no increment.
Default: -1, which specifies `movesPerSession' mode.
.TP
.B -clock/-xclock or -clockMode true/false
Determines whether or not to display the chess clocks. If clockMode is
false, the clocks are not shown, but the side that is to play next
is still highlighted. Also, unless `searchTime'
is set, the chess engine still keeps track of the clock time and uses it to
determine how fast to make its moves.
.TP
.B -st or -searchTime minutes[:seconds]
Tells the chess engine to spend at most the given amount of time
searching for each of its moves. Without this option, the chess engine
chooses its search time based on the number of moves and amount
of time remaining until the next time control.
Setting this option also sets clockMode to false.
.TP
.B -depth or -searchDepth number
Tells the chess engine to look ahead at most the given number of moves
when searching for a move to make. Without this option, the chess
engine chooses its search depth based on the number of moves and
amount of time remaining until the next time control.  With the option,
the engine will cut off its search early if it reaches the specified depth.
.TP
.B -firstNPS number
.PD 0
.TP
.B -secondNPS number
.PD
Tells the chess engine to use an internal time standard based on its node count, 
rather then wall-clock time, to make its timing decisions. 
The time in virtual seconds should be obtained by dividing the node count 
through the given number, like the number was a rate in nodes per second. 
Xboard will manage the clocks in accordance with this, relying on the number 
of nodes reported by the engine in its thinking output. If the given number equals zero, 
it can obviously not be used to convert nodes to seconds, and the time reported 
by the engine is used to decrement the XBoard clock in stead. The engine is supposed to 
report in CPU time it uses, rather than wall-clock time, in this mode. This option 
can provide fairer conditions for engine-engine matches on heavily loaded machines, 
or with very fast games (where the wall clock is too inaccurate). 
`showThinking' must be on for this option to work. Default: -1 (off).
Not many engines might support this yet!
.TP
.B -firstTimeOdds factor
.PD 0
.TP
.B -secondTimeOdds factor
.PD
Reduces the time given to the mentioned engine by the given factor. 
If pondering is off, the effect is indistinguishable from what would happen 
if the engine was running on an n-times slower machine. Default: 1.
.TP
.B -timeOddsMode mode
This option determines how the case is handled where both engines have a time-odds handicap. 
If mode=1, the engine that gets the most time will always get the nominal time, 
as specified by the time-control options, and its opponent's time is renormalized accordingly. 
If mode=0, both play with reduced time. Default: 0.
.TP
.B -hideThinkingFromHuman true/false
Controls the Hide Thinking option. See \fIOptions Menu\fR. Default: true.
(Replaces the Show-Thinking option of older xboard versions.)
.TP
.B -thinking/-xthinking or -showThinking true/false
Forces the engine to send thinking output to xboard. 
Used to be the only way to control if thinking output was displayed 
in older xboard versions,
but as the thinking output in xboard 4.3 is also used for several other
purposes (adjudication, storing in PGN file) the display of it is now controlled
by the new option Hide Thinking. See \fIOptions Menu\fR. Default: false.
(But if xboard needs the thinking output for some purpose,
it makes the engine send it despite the setting of this option.)
.TP
.B -ponder/-xponder or -ponderNextMove true/false
Sets the Ponder Next Move menu option. See \fIOptions Menu\fR. Default: true.
.TP
.B -smpCores number
Specifies the maximum number of CPUs an SMP engine is allowed to use.
Only works for engines that support the XBoard/WinBoard-protocol cores feature.
.TP
.B -mg or -matchGames n
Automatically runs an n-game match between two chess engines,
with alternating colors.
If the `loadGameFile' or `loadPositionFile' option is set,
XBoard
starts each game with the given opening moves or the given position;
otherwise, the games start with the standard initial chess position.
If the `saveGameFile' option is set, a move record for the
match is appended to the specified file. If the `savePositionFile'
option is set, the final position reached in each game of the match is appended
to the specified file. When the match is over, XBoard
displays the match score and exits. Default: 0 (do not run a match).
.TP
.B -mm/-xmm or -matchMode true/false
Setting `matchMode' to true is equivalent to setting
`matchGames' to 1.
.TP
.B -sameColorGames n
Automatically runs an n-game match between two chess engines,
without alternating colors.
Otherwise the same applies as for the `-matchGames' option,
over which it takes precedence if both are specified. (See there.)
Default: 0 (do not run a match).
.TP
.B -fcp or -firstChessProgram program
Name of first chess engine.
Default: `Fairy-Max'.
.TP
.B -scp or -secondChessProgram program
Name of second chess engine, if needed.
A second chess engine is started only in Two Machines (match) mode.
Default: `Fairy-Max'.
.TP
.B -fb/-xfb or -firstPlaysBlack true/false
In games between two chess engines, firstChessProgram normally plays
white.  If this option is true, firstChessProgram plays black.  In a
multi-game match, this option affects the colors only for the first
game; they still alternate in subsequent games.
.TP
.B -fh or -firstHost host
.PD 0
.TP
.B -sh or -secondHost host
.PD
Hosts on which the chess engines are to run. The default for
each is `localhost'. If you specify another host, XBoard
uses `rsh' to run the chess engine there. (You can substitute a
different remote shell program for rsh using the `remoteShell'
option described below.)
.TP
.B -fd or -firstDirectory dir
.PD 0
.TP
.B -sd or -secondDirectory dir
.PD
Working directories in which the chess engines are to be run.
The default is "", which means to run the chess engine
in the same working directory as XBoard
itself.  (See the CHESSDIR environment variable.)
This option is effective only when the chess engine is being run
on the local host; it does not work if the engine is run remotely
using the -fh or -sh option.
.TP
.B -initString string
.PD 0
.TP
.B -secondInitString string
.PD
The string that is sent to initialize each chess engine for a new game.
Default:

.nf
    new
    random
.fi

Setting this option from the command line is tricky, because you must
type in real newline characters, including one at the very end.
In most shells you can do this by
entering a `\\' character followed by a newline. It is easier to set
the option from your `.Xresources' file; in that case you can
include the character sequence `\\n' in the string, and it will
be converted to a newline.

If you change this option, don't remove the `new' 
command; it is required by all chess engines to
start a new game.

You can remove the `random' command if you like; including it
causes GNU Chess 4 to randomize its move selection slightly so that it
doesn't play the same moves in every game.  Even without
`random', GNU Chess 4 randomizes its choice of moves from its
opening book.  Many other chess engines ignore this command entirely
and always (or never) randomize.

You can also try adding other commands to the initString; see the
documentation of the chess engine you are using for details.
.TP
.B -firstComputerString string
.PD 0
.TP
.B -secondComputerString string
.PD
The string that is sent to the chess engine if its opponent is another
computer chess engine.  The default is `computer\\n'.  Probably the
only useful alternative is the empty string (`'), which keeps the
engine from knowing that it is playing another computer.
.TP
.B -reuse/-xreuse or -reuseFirst true/false
.PD 0
.TP
.B -reuse2/-xreuse2 or -reuseSecond true/false
.PD
If the option is false,
XBoard kills off the chess engine after every game and starts
it again for the next game.  
If the option is true (the default), 
XBoard starts the chess engine only once
and uses it repeatedly to play multiple games.
Some old chess engines may not work properly when
reuse is turned on, but otherwise games will start faster if it is left on.
.TP
.B -firstProtocolVersion version-number
.PD 0
.TP
.B -secondProtocolVersion version-number
.PD
This option specifies which version of the chess engine communication
protocol to use.  By default, version-number is 2.  In version 1, the
"protover" command is not sent to the engine; since version 1 is a
subset of version 2, nothing else changes.  Other values for
version-number are not supported.
.TP
.B -firstScoreAbs true/false
.PD 0
.TP
.B -secondScoreAbs true/false
.PD
If this option is set, the score reported by the engine is taken to be 
that in favor of white, even when the engine plays black. 
Important when XBoard uses the score for adjudications, or in PGN reporting. 
.TP
.B -niceEngines priority
This option allows you to lower the priority of the engine processes, 
so that the generally insatiable hunger for CPU time of chess engines does not interfere so much 
with smooth operation of XBoard (or the rest of your system). 
Negative values could increase the engine priority, which is not recommended.
.TP
.B -firstOptions string
.PD 0
.TP
.B -secondOptions string
.PD
The given string is a comma-separated list of (option name=option value) pairs, 
like the following example: "style=Karpov,blunder rate=0". 
If an option announced by the engine at startup through the feature commands of the XBoard/WinBoard protocol 
matches one of the option names (i.e. "style" or "blunder rate"), 
it would be set to the given value (i.e. "Karpov" or 0) 
through a corresponding option command to the engine. 
This provided that the type of the value (text or numeric) matches as well.
.TP
.B -firstNeedsNoncompliantFEN string
.PD 0
.TP
.B -secondNeedsNoncompliantFEN string
.PD
The castling rights and e.p. fields of the FEN sent to the mentioned engine 
with the setboard command will be replaced by the given string. This can for 
instance be used to run engines that do not understand Chess960 FENs in 
variant fischerandom, to make them at least understand the opening position, 
through setting the string to "KQkq -". (Note you also have to give the e.p. field!) 
Other possible applications are to provide work-arounds for engines that want to see 
castling and e.p. fields in variants that do not have castling or e.p. 
(shatranj, courier, xiangqi, shogi) so that XBoard would normally omit them 
(string = "- -"), or to add variant-specific fields that are not yet supported by XBoard 
(e.g. to indicate the number of checks in 3check).
.TP
.B -shuffleOpenings
Forces shuffling of the opening setup in variants that normally have a fixed initial position.
Shufflings are symmetric for black and white, and exempt King and Rooks in variants
with normal castling.
Remains in force until a new variant is selected.
.PP
.SS UCI + WB Engine Settings
.TP
.B -fUCI or -firstIsUCI true/false
.PD 0
.TP
.B -sUCI or -secondIsUCI true/false
.PD
Indicates if the mentioned engine executable file is an UCI engine, 
and should be run with the aid of the Polyglot adapter rather than directly. 
Xboard will then pass the other UCI options and engine name to Polyglot 
through a .ini temporary file created for the purpose.
.TP
.B -polyglotDir filename
Gives the name of the directory in which the Polyglot adapter for UCI engines resides.
Default: "".
.TP
.B -usePolyglotBook true/false
Specifies if the Polyglot book should be used.
.TP
.B -polyglotBook filename
Gives the filename of the opening book that Polyglot should use. 
From XBoard 4.3.15 on, native XBoard/WinBoard engines will also use the opening book specified here, 
provided the `usePolyglotBook' option is set to true,
and the option `firstHasOwnBookUCI' or `secondHasOwnBookUCI' applying to the engine
is set to false.
The engine will be kept in force mode as long as the current position is in book, 
and XBoard will select the book moves for it. Default: "".
.TP
.B -fNoOwnBookUCI or -firstXBook or -firstHasOwnBookUCI true/false
.PD 0
.TP
.B -sNoOwnBookUCI or -secondXBook or -secondHasOwnBookUCI true/false
.PD
Indicates if the mentioned engine has its own opening book it should play from,
rather than using the external book through XBoard. Default: false.
.TP
.B -defaultHashSize n
Sets the size of the hash table to n MegaBytes. Together with the EGTB cache size 
this number is also used to calculate the memory setting of XBoard/WinBoard engines, 
for those that support the memory feature of the XBoard/WinBoard protocol. Default: 64.
.TP
.B -defaultCacheSizeEGTB n
Sets the size of the EGTB cache to n MegaBytes. Together with the hash-table size 
this number is also used to calculate the memory setting of XBoard/WinBoard engines, 
for those that support the memory feature of the XBoard/WinBoard protocol. Default: 4.
.TP
.B -defaultPathEGTB filename
Gives the name of the directory where the end-game tablebases are installed, for UCI engines.
Default: "/usr/local/share/egtb".
.TP
.B -egtFormats string
Specifies which end-game tables are installed on the computer, and where. 
The argument is a comma-separated list of format specifications, 
each specification consisting of a format name, a colon, and a directory path name, 
e.g. "nalimov:/usr/local/share/egtb". 
If the name part matches that of a format that the engine requests through a feature command, 
xboard will relay the path name for this format to the engine through an egtpath command. 
One egtpath command for each matching format will be sent. 
Popular formats are "nalimov" DTM tablebases and "scorpio" bitbases.
Default: "".
.PP
.SS ICS options
.TP
.B -ics/-xics or -internetChessServerMode true/false
Connect with an Internet Chess Server to play chess against its
other users, observe games they are playing, or review games
that have recently finished. Default: false.
.TP
.B -icshost or -internetChessServerHost host
The Internet host name or address of the chess server to connect
to when in ICS mode. Default: `chessclub.com'.
Another popular chess server to try is `freechess.org'.
If your site doesn't have a working Internet name server, try
specifying the host address in numeric form. 
You may also need
to specify the numeric address when using the icshelper option
with timestamp or timeseal (see below).
.TP
.B -icsport or -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS
mode. Default: 5000.
.TP
.B -icshelper or -internetChessServerHelper prog-name
An external helper program used to communicate with the chess server.
You would set it to "timestamp" for ICC (chessclub.com) or
"timeseal" for FICS (freechess.org), after
obtaining the correct version of timestamp or timeseal for your
computer.  See "help timestamp" on ICC and "help timeseal" on FICS.
This option is shorthand for `-useTelnet -telnetProgram program'.
.TP
.B -telnet/-xtelnet or -useTelnet true/false
This option is poorly named; it should be called useHelper.
If set to true, it instructs XBoard to run an external
program to communicate with the Internet Chess Server. 
The program to use is given by the telnetProgram option.
If the option is
false (the default), XBoard opens a TCP socket and uses its own
internal implementation of the telnet protocol to communicate with the
ICS. See \fIFirewalls\fR.
.TP
.B -telnetProgram prog-name
This option is poorly named; it should be called helperProgram.
It gives the name of the telnet program to be used with
the `gateway' and `useTelnet' options.  The default is
`telnet'. The telnet program is invoked with the value of
`internetChessServerHost' as its first argument and the value
of `internetChessServerPort' as its second argument.
See \fIFirewalls\fR.
.TP
.B -gateway host-name
If this option is set to a host name, XBoard communicates with the
Internet Chess Server by using `rsh' to run
the `telnetProgram' on the given host,
instead of using its own internal implementation
of the telnet protocol. You can substitute a different remote shell
program for `rsh' using the `remoteShell' option described below.
See \fIFirewalls\fR.
.TP
.B -internetChessServerCommPort or -icscomm dev-name
If this option is set, XBoard communicates with the ICS through
the given character I/O device instead of opening a TCP connection.
Use this option if your system does not have any kind of
Internet connection itself (not even a SLIP or PPP connection),
but you do have dial-up access (or a hardwired terminal line) to
an Internet service provider from which you can telnet to the ICS.

The support for this option in XBoard is minimal. You need to
set all communication parameters and tty modes before you enter
XBoard.

Use a script something like this:

.nf
    stty raw -echo 9600 > /dev/tty00
    xboard -ics -icscomm /dev/tty00
.fi

Here replace `/dev/tty00' with the name of the device that your
modem is connected to. You might have to add several more
options to these stty commands. See the man pages for `stty'
and `tty' if you run into problems. Also, on many systems stty
works on its standard input instead of standard output, so you
have to use `<' instead of `>'.

If you are using linux, try starting with the script below.
Change it as necessary for your installation.

.nf
    #!/bin/sh -f
    # configure modem and fire up XBoard
    
    # configure modem
    (
      stty 2400 ; stty raw ; stty hupcl ; stty -clocal
      stty ignbrk ; stty ignpar ; stty ixon ; stty ixoff
      stty -iexten ; stty -echo
    ) < /dev/modem
    xboard -ics -icscomm /dev/modem
.fi

After you start XBoard in this way, type whatever commands are
necessary to dial out to your Internet provider and log in.
Then telnet to ICS, using a command like
`telnet chessclub.com 5000'.
Important: See the paragraph below about extra echoes, 
in \fILimitations\fR.
.TP
.B -icslogon or -internetChessServerLogonScript file-name
Whenever XBoard connects to the Internet Chess Server,
if it finds a file with the name given in this option, it feeds the
file's contents to the ICS as commands. The default file name
is `.icsrc'.
Usually the first two lines of the file should be
your ICS user name and password.
The file can be either in $CHESSDIR, in XBoard's working
directory if CHESSDIR is not set, or in your home directory.
.TP
.B -msLoginDelay delay
If you experience trouble logging on to an ICS when using the
`-icslogon' option, inserting some delay between characters
of the logon script may help. This option adds `delay'
milliseconds of delay between characters. Good values to try
are 100 and 250.
.TP
.B -icsinput/-xicsinput or -internetChessServerInputBox true/false
Sets the ICS Input Box menu option. See \fIMode Menu\fR. Default: false.
.TP
.B -autocomm/-xautocomm or -autoComment true/false
Sets the Auto Comment menu option. See \fIOptions Menu\fR. Default: false.
.TP
.B -autoflag/-xautoflag or -autoCallFlag true/false
Sets the Auto Flag menu option.  See \fIOptions Menu\fR. Default: false.
.TP
.B -autobs/-xautobs or -autoObserve true/false
Sets the Auto Observe menu option.  See \fIOptions Menu\fR. Default: false.
.TP
.B -autoKibitz
Enables kibitzing of the engines last thinking output (depth, score, time, speed, PV) 
before it moved
to the ICS, in zippy mode. The option `showThinking' must be switched on for 
this option to work.
Also diverts similar kibitz information of an opponent engine that is playing you 
through the ICS to the engine-output window, as if the engine was playing locally.
.TP
.B -seekGraph true/false or -sg
Enables displaying of the seek graph by left-clicking the board when
you are logged on to an ICS and currently idle.
The seek graph show all players currently seeking games on the ICS,
plotted according to their rating and the time control of the game they seek,
in three different colors (for rated, unrated and wild games).
Computer ads are displayed as squares, human ads are dots.
Default: false.
.TP
.B -autoRefresh true/false
Enables automatic updating of the seek graph,
by having the ICS send a running update of all newly placed
and removed seek ads.
This consumes a substantial amount of communication bandwidth,
and is only supported for FICS and ICC.
Default: false.
.TP
.B -backgroundObserve true/false
When true, boards sent to you by the ICS from other games while you are playing
(e.g. because you are observing them)
will not be automatically displayed.
Only a summary of time left and material of both players will appear
in the message field above the board.
XBoard will remember the last board it has received this way,
and will display it in stead of the position in your own game
when you press the right mouse button.
No other information is stored on such games observed in the background;
you cannot save such a game later, or step through its moves.
This feature is provided solely for the benefit of bughouse players,
to enable them to peek at their partner's game without the need
to logon twice.
Default: false.
.TP
.B -dualBoard true/false
In combination with -backgroundObserve true, this option will display
the board of the background game side by side with that of your own game,
so you can have it in view permanently.
Any board or holdings info coming in will be displayed on the secondary
board immediately.
This feature is still experimental and largely unfinished.
There is no animation or highlighting of moves on the secondary board.
Default: false.
.TP
.B -oneClickMove true/false
When set, this option allows you to enter moves by only clicking the to-
or from-square, when only a single legal move to or from that square
is possible.
Double-clicking a piece (or clicking an already selected piece)
will instruct that piece to make the only capture it can legally do.
Default: false.
.TP
.B -moves/-xmoves or -getMoveList true/false
Sets the Get Move List menu option.  See \fIOptions Menu\fR.  Default: true.
.TP
.B -alarm/-xalarm or -icsAlarm true/false
Sets the ICS Alarm menu option.  See \fIOptions Menu\fR. Default: true.
.TP
.B -icsAlarmTime ms
Sets the time in milliseconds for the ICS Alarm menu option.
See \fIOptions Menu\fR. Default: 5000.
.TP
.B lowTimeWarning true/false
Controls a color change of the board as a warning your time is running out.
See \fIOptions Menu\fR. Default: false.
.TP
.B -pre/-xpre \\fRor\\fB -premove true/false
Sets the Premove menu option. See \fIOptions Menu\fR. Default: true.
.TP
.B -quiet/-xquiet or -quietPlay true/false
Sets the Quiet Play menu option.  See \fIOptions Menu\fR.  Default: false.
.TP
.B -colorizeMessages or -colorize
Setting colorizeMessages
to true tells XBoard to colorize the messages received from
the ICS.  Colorization works only if your xterm 
supports ISO 6429 escape sequences for changing text colors.
.TP
.B -colorShout foreground,background,bold
.PD 0
.TP
.B -colorSShout foreground,background,bold
.PD
.PD 0
.TP
.B -colorChannel1 foreground,background,bold
.PD
.PD 0
.TP
.B -colorChannel foreground,background,bold
.PD
.PD 0
.TP
.B -colorKibitz foreground,background,bold
.PD
.PD 0
.TP
.B -colorTell foreground,background,bold
.PD
.PD 0
.TP
.B -colorChallege foreground,background,bold
.PD
.PD 0
.TP
.B -colorRequest foreground,background,bold
.PD
.PD 0
.TP
.B -colorSeek foreground,background,bold
.PD
.PD 0
.TP
.B -colorNormal foreground,background,bold
.PD
These options set the colors used when colorizing ICS messages.
All ICS messages are grouped into one of these categories:
shout, sshout, channel 1, other channel, kibitz, tell, challenge, 
request (including abort, adjourn, draw, pause, and takeback), or
normal (all other messages).  

Each foreground or background argument can be one of the following:
black, red, green, yellow, blue, magenta, cyan, white, or default.
Here ``default'' means the default foreground or background color of
your xterm.  Bold can be 1 or 0.  If background is omitted, ``default''
is assumed; if bold is omitted, 0 is assumed.

Here is an example of how to set the colors in your `.Xresources' file.
The colors shown here are the default values; you will get
them if you turn `-colorize' on without specifying your own colors.

.nf
    xboard*colorizeMessages: true	
    xboard*colorShout: green
    xboard*colorSShout: green, black, 1
    xboard*colorChannel1: cyan
    xboard*colorChannel: cyan, black, 1
    xboard*colorKibitz: magenta, black, 1
    xboard*colorTell: yellow, black, 1
    xboard*colorChallenge: red, black, 1
    xboard*colorRequest: red
    xboard*colorSeek: blue
    xboard*colorNormal: default
.fi
.TP
.B -soundProgram progname
If this option is set to a sound-playing program that is installed and
working on your system, XBoard can play sound files when certain
events occur, listed below.  The default program name is "play".  If
any of the sound options is set to "$", the event rings the terminal
bell by sending a ^G character to standard output, instead of playing
a sound file.  If an option is set to the empty string "", no sound is
played for that event.
.TP
.B -soundDirectory directoryname
This option specifies where XBoard will look for sound files,
when these are not given as an absolute path name.
.TP
.B -soundShout filename
.PD 0
.TP
.B -soundSShout filename
.PD
.PD 0
.TP
.B -soundChannel filename
.PD
.PD 0
.TP
.B -soundKibitz filename
.PD
.PD 0
.TP
.B -soundTell filename
.PD
.PD 0
.TP
.B -soundChallenge filename
.PD
.PD 0
.TP
.B -soundRequest filename
.PD
.PD 0
.TP
.B -soundSeek filename
.PD
These sounds are triggered in the same way as the colorization events
described above.  They all default to "", no sound.  They are played
only if the colorizeMessages is on.
.TP
.B -soundMove filename
This sound is used by the Move Sound menu option.  Default: "$".
.TP
.B -soundIcsAlarm filename
This sound is used by the ICS Alarm menu option.  Default: "$".
.TP
.B -soundIcsWin filename
This sound is played when you win an ICS game.  Default: "" (no sound).
.TP
.B -soundIcsLoss filename
This sound is played when you lose an ICS game.  Default: "" (no sound).
.TP
.B -soundIcsDraw filename
This sound is played when you draw an ICS game.  Default: "" (no sound).
.TP
.B -soundIcsUnfinished filename
This sound is played when an ICS game that you are participating in is
aborted, adjourned, or otherwise ends inconclusively.  Default: "" (no
sound).

Here is an example of how to set the sounds in your `.Xresources' file:

.nf
    xboard*soundShout: shout.wav
    xboard*soundSShout: sshout.wav
    xboard*soundChannel1: channel1.wav
    xboard*soundChannel: channel.wav
    xboard*soundKibitz: kibitz.wav
    xboard*soundTell: tell.wav
    xboard*soundChallenge: challenge.wav
    xboard*soundRequest: request.wav
    xboard*soundSeek: seek.wav
    xboard*soundMove: move.wav
    xboard*soundIcsWin: win.wav
    xboard*soundIcsLoss: lose.wav
    xboard*soundIcsDraw: draw.wav
    xboard*soundIcsUnfinished: unfinished.wav
    xboard*soundIcsAlarm: alarm.wav
.fi
.TP
.B -dropMenu true|false
This option allows you to emulate old behavior, 
where the right mouse button brings up the (now deprecated) drop menu 
rather than displaying the position at the end of the principal variation. 
Default: False.
.TP
.B -variations true|false
When this option is on, you can start new variations in Edit Game or
Analyze mode by holding the Shift key down while entering a move.
When it is off, the Shift key will be ignored.
Default: False.
.PP
.SS Load and Save options
.TP
.B -lgf or -loadGameFile file
.PD 0
.TP
.B -lgi or -loadGameIndex index
.PD
If the `loadGameFile' option is set, XBoard loads the specified
game file at startup. The file name `-' specifies the standard
input. If there is more than one game in the file, XBoard
pops up a menu of the available games, with entries based on their PGN 
(Portable Game Notation) tags.
If the `loadGameIndex' option is set to `N', the menu is suppressed
and the N th game found in the file is loaded immediately.
The menu is also suppressed if `matchMode' is enabled or if the game file
is a pipe; in these cases the first game in the file is loaded immediately.
Use the `pxboard' shell script provided with XBoard if you
want to pipe in files containing multiple games and still see the menu.
If the loadGameIndex specifies an index -1, this triggers auto-increment
of the index in `matchMode', which means that after every game the
index is incremented by one, causing each game of the match to be played
from the next game in the file. Similarly, specifying an index value of -2
causes the index to be incremented every two games, so that each game
in the file is used twice (with reversed colors).
The `rewindIndex' option causes the index to be reset to the
first game of the file when it has reached a specified value.
.TP
.B -rewindIndex n
Causes a position file or game file to be rewound to its beginning after n
positions or games in auto-increment `matchMode'. 
See `loadPositionIndex' and `loadGameIndex'.
default: 0 (no rewind).
.TP
.B -td or -timeDelay seconds
Time delay between moves during `Load Game' or `Analyze File'. 
Fractional seconds are allowed; try `-td 0.4'. 
A time delay value of -1 tells
XBoard not to step through game files automatically. Default: 1 second.
.TP
.B -sgf or -saveGameFile file
If this option is set, XBoard appends a record of every game
played to the specified file. The file name `-' specifies the
standard output.
.TP
.B -autosave/-xautosave or -autoSaveGames true/false
Sets the Auto Save menu option.  See \fIOptions Menu\fR.  Default: false.
Ignored if `saveGameFile' is set.
.TP
.B -lpf or -loadPositionFile file
.PD 0
.TP
.B -lpi or -loadPositionIndex index
.PD
If the `loadPositionFile' option is set, XBoard loads the
specified position file at startup. The file name `-' specifies the
standard input. If the `loadPositionIndex' option is set to N,
the Nth position found in the file is loaded; otherwise the
first position is loaded.
If the loadPositionIndex specifies an index -1, this triggers auto-increment
of the index in `matchMode', which means that after every game the
index is incremented by one, causing each game of the match to be played
from the next position in the file. Similarly, specifying an index value of -2
causes the index to be incremented every two games, so that each position
in the file is used twice (with the engines playing opposite colors).
The `rewindIndex' option causes the index to be reset to the
first position of the file when it has reached a specified value.
.TP
.B -spf or -savePositionFile file
If this option is set, XBoard appends the final position reached
in every game played to the specified file. The file name `-'
specifies the standard output.
.TP
.B -pgnExtendedInfo true/false
If this option is set, XBoard saves depth, score and time used for each 
move that the engine found as a comment in the PGN file.
Default: false.
.TP
.B -pgnEventHeader string
Sets the name used in the PGN event tag to string. 
Default: "Computer Chess Game".
.TP
.B -saveOutOfBookInfo true/false
Include the information on how the engine(s) game out of its opening book 
in a special 'annotator' tag with the PGN file.
.TP
.B -oldsave/-xoldsave or -oldSaveStyle true/false
Sets the Old Save Style menu option.  See \fIOptions Menu\fR.  Default: false.
.TP
.B -gameListTags string
The character string lists the PGN tags that should be printed in the
Game List, and their order. The meaning of the codes is e=event,
s=site, d=date, o=round, p=players, r=result, w=white Elo, b=black Elo,
t=time control, v=variant, a=out-of-book info, c=result comment.
Default: "eprd"
.TP
.B -ini or -settingsFile filename
.PD 0
.TP
.B -saveSettingsFile filename
.PD
.PD 0
.TP
.B @filename
.PD
When XBoard encounters an option -settingsFile (or -ini for short),
or @filename, it tries to read the mentioned file,
and substitutes the contents of it (presumaby more command-line options)
in place of the option.
In the case of -ini or -settingsFile, the name of a successfully read
settings file is also remembered as the file to use for saving settings
(automatically on exit, or on user command).
An option of the form @filename does not affect saving.
The option -saveSettingsFile does specify a name of the file to use
for saving, without reading any options from it, and is thus also effective
when the file did not exist yet.
So the settings will be saved to the file specified in the last
-saveSettingsFile or succesfull -settingsFile / -ini command,
if any, and in /etc/xboard/xboard.conf otherwise.
Usualy the latter is only accessible for the system administrator, though, 
and will be used to contain system-wide default setings, amongst which
a -saveSettingsFile and -settingsFile options to specify a settings file
accessible to the individual user, such as ~/.xboardrc in the user's
home directory.
.PP
.SS User interface options
.TP
.B -display
.PD 0
.TP
.B -geometry
.PD
.PD 0
.TP
.B -iconic
.PD
These and most other standard Xt options are accepted.
.TP
.B -noGUI
Suppresses all GUI functions of XBoard 
(to speed up automated ultra-fast engine-engine games, which you dont want to watch). 
There will be no board or clock updates, no printing of moves, 
and no update of the icon on the task bar in this mode.
.TP
.B -movesound/-xmovesound or -ringBellAfterMoves true/false
Sets the Move Sound menu option.  See \fIOptions Menu\fR.  Default: false.
For compatibility with old XBoard versions, -bell/-xbell are also 
accepted as abbreviations for this option.
.TP
.B -exit/-xexit or -popupExitMessage true/false
Sets the Popup Exit Message menu option.  See \fIOptions Menu\fR. Default: true.
.TP
.B -popup/-xpopup or -popupMoveErrors true/false
Sets the Popup Move Errors menu option.  See \fIOptions Menu\fR. Default: false.
.TP
.B -queen/-xqueen or -alwaysPromoteToQueen true/false
Sets the Always Queen menu option.  See \fIOptions Menu\fR.  Default: false.
.TP
.B -legal/-xlegal or -testLegality true/false
Sets the Test Legality menu option.  See \fIOptions Menu\fR.  Default: true.
.TP
.B -size or -boardSize (sizeName | n1,n2,n3,n4,n5,n6,n7)
Determines how large the board will be, by selecting the pixel size
of the pieces and setting a few related parameters.
The sizeName can be one of: Titanic, giving 129x129 pixel pieces,
Colossal 116x116, Giant 108x108, Huge 95x95, Big 87x87, Large 80x80, Bulky 72x72,
Medium 64x64, Moderate 58x58, Average 54x54, Middling 49x49, Mediocre
45x45, Small 40x40, Slim 37x37, Petite 33x33, Dinky 29x29, Teeny 25x25,
or Tiny 21x21.
Orthodox pieces of all these sizes are built into XBoard.
Other sizes can
be used if you have them; see the pixmapDirectory and bitmapDirectory
options.
Complete sets of un-orthodox pieces are only provided in sizes
Bulky, Middling and (to a lesser extent) Petite;
Archbishop, Marshall and Amazon are also available in all sizes between
Bulky and Petite.
When no bitmap is available, the piece will be displayed as Amazon or King.
The default depends on the size of your screen; it is approximately the
largest size that will fit without clipping.

You can select other sizes or vary other layout parameters by providing
a list of comma-separated values (with no spaces) as the argument.
You do not need to provide all the values; for any you omit from the
end of the list, defaults are taken from the nearest built-in size.
The value `n1' gives the piece size, `n2' the width of the
black border
between squares, `n3' the desired size for the 
clockFont, `n4' the desired size for the coordFont,
`n5' the desired size for the default font,
`n6' the smallLayout flag (0 or 1), 
and `n7' the tinyLayout flag (0 or 1).  
All dimensions are in pixels.
If the border between squares is eliminated (0 width), the various
highlight options will not work, as there is nowhere to draw the highlight.
If smallLayout is 1 and `titleInWindow' is true, 
the window layout is rearranged to make more room for the title.
If tinyLayout is 1, the labels on the menu bar are abbreviated
to one character each and the buttons in the button bar are made narrower.
.TP
.B -coords/-xcoords or -showCoords true/false
Sets the Show Coords menu option.  See \fIOptions Menu\fR.  Default: false.
The `coordFont' option specifies what font to use.
.TP
.B -autoraise/-xautoraise or -autoRaiseBoard true/false
Sets the Auto Raise Board menu option.  See \fIOptions Menu\fR.  Default: true.
.TP
.B -autoflip/-xautoflip or -autoFlipView true/false
Sets the Auto Flip View menu option.  See \fIOptions Menu\fR.  Default: true.
.TP
.B -flip/-xflip or -flipView true/false
If Auto Flip View is not set, or if you are observing but not participating
in a game, then the positioning of the board at the start of each game
depends on the flipView option.  If flipView is false (the default),
the board is positioned so that the white pawns move from the bottom to the
top; if true, the black pawns move from the bottom to the top.
In any case, the Flip menu option (see \fIOptions Menu\fR)
can be used to flip the board after
the game starts.
.TP
.B -title/-xtitle or -titleInWindow true/false
If this option is true, XBoard displays player names (for ICS
games) and game file names (for `Load Game') inside its main
window. If the option is false (the default), this information is
displayed only in the window banner. You probably won't want to
set this option unless the information is not showing up in the
banner, as happens with a few X window managers.
.TP
.B -buttons/-xbuttons or -showButtonBar True/False
If this option is False, xboard omits the [<<] [<] [P] [>] [>>] button
bar from the window, allowing the message line to be wider.  You can
still get the functions of these buttons using the menus or their keyboard
shortcuts.  Default: true.
.TP
.B -mono/-xmono or -monoMode true/false
Determines whether XBoard displays its pieces and squares with
two colors (true) or four (false). You shouldn't have to
specify `monoMode'; XBoard will determine if it is necessary.
.TP
.B -showTargetSquares true/false
Determines whether XBoard can highlight the squares a piece has
legal moves to, when you grab that piece with the mouse.
If this option is set, this feature can be controlled through
the Highlight Dragging menu item.
.TP
.B -flashCount count
.PD 0
.TP
.B -flashRate rate
.PD
.PD 0
.TP
.B -flash/-xflash
.PD
These options enable flashing of pieces when they
land on their destination square.
`flashCount'
tells XBoard how many times to flash a piece after it
lands on its destination square.
`flashRate'
controls the rate of flashing (flashes/sec).
Abbreviations:
`flash'
sets flashCount to 3.
`xflash'
sets flashCount to 0.
Defaults:  flashCount=0 (no flashing), flashRate=5.
.TP
.B -highlight/-xhighlight or -highlightLastMove true/false
Sets the Highlight Last Move menu option. See \fIOptions Menu\fR. Default: false.
.TP
.B -highlightMoveWithArrow true/false
Sets the Highlight with Arrow menu option. See \fIOptions Menu\fR. Default: false.
.TP
.B -blind/-xblind or -blindfold true/false
Sets the Blindfold menu option.  See \fIOptions Menu\fR.  Default: false.
.TP
.B -clockFont font
The font used for the clocks. If the option value is a pattern
that does not specify the font size, XBoard tries to choose an
appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP
.B -coordFont font
The font used for rank and file coordinate labels if `showCoords'
is true. If the option value is a pattern that does not specify
the font size, XBoard tries to choose an appropriate font for
the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP
.B -font font
The font used for popup dialogs, menus, comments, etc.
If the option value is a pattern that does not specify
the font size, XBoard tries to choose an appropriate font for
the board size being used.
Default: -*-helvetica-medium-r-normal--*-*-*-*-*-*-*-*.
.TP
.B -fontSizeTolerance tol
In the font selection algorithm, a nonscalable font will be preferred
over a scalable font if the nonscalable font's size differs
by `tol' pixels
or less from the desired size.  A value of -1 will force
a scalable font to always be used if available; a value of 0 will
use a nonscalable font only if it is exactly the right size; 
a large value (say 1000) will force a nonscalable font to always be
used if available.  Default: 4.
.TP
.B -bm or -bitmapDirectory dir
.PD 0
.TP
.B -pixmap or -pixmapDirectory dir
.PD
These options control what piece images xboard uses.  The XBoard
distribution includes one set of pixmap pieces in xpm format, in the
directory `pixmaps', and one set of bitmap pieces in xbm format,
in the directory `bitmaps'.  Pixmap
pieces give a better appearance on the screen: the white pieces have
dark borders, and the black pieces have opaque internal details.  With
bitmaps, neither piece color has a border, and the internal details
are transparent; you see the square color or other background color
through them.

If XBoard is configured and compiled on a system that includes libXpm,
the X pixmap library, the xpm pixmap pieces are compiled in as the
default.  A different xpm piece set can be selected at runtime with
the `pixmapDirectory' option, or a bitmap piece set can be selected
with the `bitmapDirectory' option.

If XBoard is configured and compiled on a system that does not include
libXpm (or the `--disable-xpm' option is given to the configure
program), the bitmap pieces are compiled in as the default.  It is not
possible to use xpm pieces in this case, but pixmap pieces in another
format called "xim" can be used by giving the `pixmapDirectory' option.
Or again, a different bitmap piece set can be selected with the
`bitmapDirectory' option.

Files in the `bitmapDirectory' must be named as follows:
The first character of a piece bitmap name gives the piece it 
represents (`p', `n', `b', `r', `q', or `k'),
the next characters give the size in pixels, the
following character indicates whether the piece is
solid or outline (`s' or `o'),
and the extension is `.bm'.
For example, a solid 80x80 knight would be named `n80s.bm'.
The outline bitmaps are used only in monochrome mode.
If bitmap pieces are compiled in and the bitmapDirectory is missing
some files, the compiled in pieces are used instead.

If the bitmapDirectory option is given,
it is also possible to replace xboard's icons and menu checkmark,
by supplying files named `icon_white.bm', `icon_black.bm', and
`checkmark.bm'.

For more information about pixmap pieces and how to get additional
sets, see \fIzic2xpm\fR below.
.TP
.B -whitePieceColor color
.PD 0
.TP
.B -blackPieceColor color
.PD
.PD 0
.TP
.B -lightSquareColor color
.PD
.PD 0
.TP
.B -darkSquareColor color
.PD
.PD 0
.TP
.B -highlightSquareColor color
.PD
.PD 0
.TP
.B -lowTimeWarningColor color
.PD
Colors to use for the pieces, squares, and square highlights.
Defaults:

.nf
    -whitePieceColor       #FFFFCC
    -blackPieceColor       #202020
    -lightSquareColor      #C8C365
    -darkSquareColor       #77A26D
    -highlightSquareColor  #FFFF00
    -premoveHighlightColor #FF0000
    -lowTimeWarningColor   #FF0000
.fi

On a grayscale monitor you might prefer:

.nf
    -whitePieceColor       gray100
    -blackPieceColor       gray0
    -lightSquareColor      gray80
    -darkSquareColor       gray60
    -highlightSquareColor  gray100
    -premoveHighlightColor gray70
    -lowTimeWarningColor   gray70
.fi
.TP
.B -drag/-xdrag or -animateDragging true/false
Sets the Animate Dragging menu option. See \fIOptions Menu\fR.  Default: true.
.TP
.B -animate/-xanimate or -animateMoving true/false
Sets the Animate Moving menu option. See \fIOptions Menu\fR.  Default: true.
.TP
.B -animateSpeed n
Number of milliseconds delay between each animation frame when Animate
Moves is on.
.TP
.B -autoDisplayComment true/false
.PD 0
.TP
.B -autoDisplayTags true/false
.PD
If set to true, these options cause the window with the move comments,
and the window with PGN tags, respectively, to pop up automatically when
such tags or comments are encountered during the replaying a stored or
loaded game.  Default: true.
.TP
.B -pasteSelection true/false
If this option is set to true, the Paste Position and Paste Game
options paste from the currently selected text.  If false, they paste
from the clipboard.  Default: false.
.PP
.SS Adjudication Options
.TP
.B -adjudicateLossThreshold n
If the given value is non-zero, XBoard adjudicates the game as a loss 
if both engines agree for a duration of 6 consecutive ply that the score 
is below the given score threshold for that engine. Make sure the score 
is interpreted properly by XBoard, 
using `-firstScoreAbs' and `-secondScoreAbs' if needed. 
Default: 0 (no adjudication)
.TP
.B -adjudicateDrawMoves n
If the given value is non-zero, XBoard adjudicates the game as a draw 
if after the given number of moves it was not yet decided. Default: 0 (no adjudication)
.TP
.B -checkMates true/false
If this option is set, XBoard detects all checkmates and stalemates, 
and ends the game as soon as they occur. 
Legality-testing must be switched on for this option to work.
Default: true
.TP
.B -testClaims true/false
If this option is set, XBoard verifies all result claims made by engines, 
and those who send false claims will forfeit the game because of it. 
Legality-testing must be switched on for this option to work. Default: true
.TP
.B -materialDraws true/false
If this option is set, XBoard adjudicates games as draws when there is 
no sufficient material left to inflict a checkmate. 
This applies to KBKB with like bishops (any number, actually), and to KBK, KNK and KK. 
Legality-testing must be switched on for this option to work. Default: true
.TP
.B -trivialDraws true/false
If this option is set, XBoard adjudicates games as draws that cannot be 
usually won without opponent cooperation. This applies to KBKB with unlike bishops, 
and to KBKN, KNKN, KNNK, KRKR and KQKQ. The draw is called after 6 ply into these end-games, 
to allow quick mates that can occur in some exceptional positions to be found by the engines. 
KQKQ does not really belong in this category, and might be taken out in the future. 
(When bitbase-based adjudications are implemented.) 
Legality-testing must be on for this option to work. Default: false
.TP
.B -ruleMoves n
If the given value is non-zero, XBoard adjudicates the game as a draw after the given 
number of consecutive reversible moves. Engine draw claims are always accepted after 50 moves, 
irrespective of the given value of n.
.TP
.B -repeatsToDraw n
If the given value is non-zero, xboard adjudicates the game as a draw if a position 
is repeated the given number of times. Engines draw claims are always accepted after 3 repeats, 
(on the 3rd occurrence, actually), irrespective of the value of n. 
Beware that positions that have different castling or en-passant rights do not count 
as repeats, XBoard is fully e.p. and castling aware!
.PP
.SS Other options
.TP
.B -ncp/-xncp or -noChessProgram true/false
If this option is true, XBoard acts as a passive chessboard; it
does not start a chess engine at all. Turning on this option
also turns off clockMode. Default: false.
.TP
.B -mode or -initialMode modename
If this option is given, XBoard selects the given modename
from the Mode menu after starting and (if applicable) processing the
loadGameFile or loadPositionFile option. Default: "" (no selection). 
Other supported values are 
MachineWhite, MachineBlack, TwoMachines, Analysis, 
AnalyzeFile, EditGame, EditPosition, and Training.
.TP
.B -variant varname
Activates preliminary, partial support for playing chess variants
against a local engine or editing variant games.  This flag is not
needed in ICS mode.  Recognized variant names are:

.nf
    normal        Normal chess
    wildcastle    Shuffle chess, king can castle from d file
    nocastle      Shuffle chess, no castling allowed
    fischerandom  Fischer Random shuffle chess
    bughouse      Bughouse, ICC/FICS rules
    crazyhouse    Crazyhouse, ICC/FICS rules
    losers        Lose all pieces or get mated (ICC wild 17)
    suicide       Lose all pieces including king (FICS)
    giveaway      Try to have no legal moves (ICC wild 26)
    twokings      Weird ICC wild 9
    kriegspiel    Opponent's pieces are invisible
    atomic        Capturing piece explodes (ICC wild 27)
    3check        Win by giving check 3 times (ICC wild 25)
    shatranj      An ancient precursor of chess (ICC wild 28)
    xiangqi       Chinese Chess (on a 9x10 board)
    shogi         Japanese Chess (on a 9x9 board & piece drops) 
    capablanca    Capablanca Chess (10x8 board, with Archbishop 
                  and Chancellor pieces)
    gothic        similar, with a better initial position
    caparandom    An FRC-like version of Capablanca Chess (10x8) 
    janus         A game with two Archbishops (10x8 board)
    courier       Medieval intermediate between shatranj and 
                  modern Chess (on 12x8 board) 
    falcon        Patented 10x8 variant with two Falcon pieces
    berolina      Pawns capture straight ahead, and move diagonal 
    cylinder      Pieces wrap around the board edge
    knightmate    King moves as Knight, and vice versa 
    super         Superchess (shuffle variant with 4 exo-pieces)
    makruk        Thai Chess (shatranj-like, P promotes on 6th rank)
    spartan       Spartan Chess (black has unorthodox pieces)
    fairy         A catchall variant in which all piece types 
                  known to XBoard can participate (8x8)
    unknown       Catchall for other unknown variants
.fi

NOT ALL BOARDSIZES PROVIDE A COMPLETE SET OF BUILT-IN BITMAPS FOR ALL
UN-ORTHODOX PIECES, though. Only in `boardSize' middling and bulky
all 22 piece types are provided, while -boardSize petite has most
of them. Archbishop, Chancellor and Amazon are supported in every
size from petite to bulky. Kings or Amazons are substituted for
missing bitmaps. You can still play variants needing un-orthodox
pieces in other board sizes providing your own bitmaps through the
`bitmapDirectory' or `pixmapDirectory' options.

In the shuffle variants, XBoard now does shuffle the pieces, although
you can still do it by hand using Edit Position.  Some variants are
supported only in ICS mode, including bughouse, and
kriegspiel.  The winning/drawing conditions in crazyhouse (off-board
interposition on mate) are not fully understood, but losers, suicide, 
giveaway, atomic, and 3check should be OK.
Berolina and cylinder chess can only be played with legality testing off.
In crazyhouse, XBoard now does keep
track of off-board pieces.  In shatranj it does implement the baring
rule when mate detection is switched on.
.TP
.B -boardHeight N
Allows you to set a non-standard number of board ranks in any variant. 
If the height is given as -1, the default height for the variant is used.
Default: -1
.TP
.B -boardWidth N
Allows you to set a non-standard number of board files in any variant. 
If the width is given as -1, the default width for the variant is used. 
With a non-standard width, the initial position will always be an empty board, 
as the usual opening array will not fit.
Default: -1
.TP
.B -holdingsSize N
Allows you to set a non-standard size for the holdings in any variant. 
If the size is given as -1, the default holdings size for the variant is used. 
The first N piece types will go into the holdings on capture, and you will be 
able to drop them on the board in stead of making a normal move. If size equals 0, 
there will be no holdings.
Default: -1
.TP
.B -defaultFrcPosition N
Specifies the number of the opening position in shuffle games like Chess960. 
A value of -1 means the position is randomly generated by XBoard
at the beginning of every game.
Default: -1
.TP
.B -pieceToSquareTable string
The characters that are used to represent the piece types XBoard knows in FEN 
diagrams and SAN moves. The string argument has to have an even length 
(or it will be ignored), as white and black pieces have to be given separately 
(in that order). The last letter for each color will be the King. 
The letters before that will be PNBRQ and then a whole host of fairy pieces 
in an order that has not fully crystallized yet (currently FEACWMOHIJGDVSLU, 
F=Ferz, Elephant, A=Archbishop, C=Chancellor, W=Wazir, M=Commoner, O=Cannon, 
H=Nightrider). You should list at least all pieces that occur in the variant 
you are playing. If you have less than 44 characters in the string, the pieces 
not mentioned will get assigned a period, and you will not be able to distinguish 
them in FENs. You can also explicitly assign pieces a period, in which case they 
will not be counted in deciding which captured pieces can go into the holdings.
A tilde '~' as a piece name does mean this piece is used to represent a promoted 
Pawn in crazyhouse-like games, i.e. on capture it turns back onto a Pawn. 
A '+' similarly indicates the piece is a shogi-style promoted piece, that should 
revert to its non-promoted version on capture (rather than to a Pawn).
Note that promoted pieces are represented by pieces 11 further in the list.
You should not have to use this option often: each variant has its own default 
setting for the piece representation in FEN, which should be sufficient in normal use.
Default: ""
.TP
.B -debug/-xdebug or -debugMode true/false
Turns on debugging printout.
.TP
.B -debugFile filename or -nameOfDebugFile filename
Sets the name of the file to which XBoard saves debug information 
(including all communication to and from the engines).
.TP
.B -engineDebugOutput number
Specifies how XBoard should handle unsolicited output from the engine, 
with respect to saving it in the debug file. 
The output is further (hopefully) ignored. 
If number=0, XBoard refrains from writing such spurious output to the debug file. 
If number=1, all engine output is written faithfully to the debug file. 
If number=2, any protocol-violating line is prefixed with a '#' character, 
as the engine itself should have done if it wanted to submit info for inclusion in the debug file.
This option is provided for the benefit of applications that use the debug file 
as a source of information, such as the broadcaster of live games TLCV / TLCS. 
Such applications can be protected from spurious engine output that might otherwise confuse them.
.TP
.B -rsh or -remoteShell shell-name
Name of the command used to run programs remotely. The default
is `rsh' or `remsh', determined when XBoard is
configured and compiled.
.TP
.B -ruser or -remoteUser user-name
User name on the remote system when running programs with the
`remoteShell'. The default is your local user name.
.TP
.B -userName username
Name under which the Human player will be listed in the PGN file. 
Default is the login name on your local computer.
.TP
.B -delayBeforeQuit number
.PD 0
.TP
.B -delayAfterQuit number
.PD
These options specify how long XBoard has to wait before sending a termination signal to rogue engine processes, that do not want to react to the 'quit' command. The second one determines the pause after killing the engine, to make sure it dies.

.PP
.SH CHESS SERVERS
An "Internet Chess Server", or "ICS", is a place on the
Internet where people can get together to play chess, watch other
people's games, or just chat.  You can use either `telnet' or a
client program like XBoard to connect to the server.  There are
thousands of registered users on the different ICS hosts, and it is
not unusual to meet 200 on both chessclub.com and freechess.org.

Most people can just type `xboard -ics' to start XBoard as an ICS
client.  Invoking XBoard in this way connects you to the Internet
Chess Club (ICC), a commercial ICS.  You can log in there as a guest
even if you do not have a paid account.  To connect to the largest
Free ICS (FICS), use the command `xboard -ics -icshost freechess.org'
instead, or substitute a different host name to connect to your
favorite ICS.
For a full description of command-line options that control 
the connection to ICS and change the default values of ICS options, see
\fIICS options\fR.  

While you are running XBoard as an ICS client,
you use the terminal window that you started XBoard from
as a place to type in commands and read information that is
not available on the chessboard.

The first time you need to use the terminal is to enter your login name
and password, if you are a registered player. (You don't need to do
this manually; the `icsLogon' option can do it for you.
See \fIICS options\fR.)  If you are not registered, 
enter `g' as your name, and the server will pick a
unique guest name for you.

Some useful ICS commands
include
.TP
.B help <topic>
to get help on the given <topic>. To get a list of possible topics type
"help" without topic.  Try the help command before you ask other
people on the server for help.

For example `help register' tells you how to become a registered
ICS player.
.TP
.B who <flags>
to see a list of people who are logged on.  Administrators
(people you should talk to if you have a problem) are marked
with the character `*', an asterisk. The <flags> allow you to
display only selected players: For example, `who of' shows a
list of players who are interested in playing but do not have
an opponent.
.TP
.B games
to see what games are being played
.TP
.B match <player> [<mins>] [<inc>]
to challenge another player to a game. Both opponents get <mins> minutes
for the game, and <inc> seconds will be added after each move.
If another player challenges you, the server asks if you want to
accept the challenge; use the `accept' or `decline' commands
to answer.
.TP
.B accept
.PD 0
.TP
.B decline
.PD
to accept or decline another player's offer. 
The offer may be to start a new game, or to agree to a 
`draw', `adjourn' or `abort' the current game. See \fIAction Menu\fR.

If you have more than one pending offer (for example, if more than one player
is challenging you, or if your opponent offers both a draw and to adjourn the
game), you have to supply additional information, by typing something
like `accept <player>', `accept draw', or `draw'.
.TP
.B draw
.PD 0
.TP
.B adjourn
.PD
.PD 0
.TP
.B abort
.PD
asks your opponent to terminate a game by mutual agreement. Adjourned
games can be continued later. 
Your opponent can either `decline' your offer or accept it (by typing the
same command or typing `accept').  In some cases these commands work
immediately, without asking your opponent to agree.  For example, you can
abort the game unilaterally if your opponent is out of time, and you can claim
a draw by repetition or the 50-move rule if available simply by typing 
`draw'.
.TP
.B finger <player>
to get information about the given <player>. (Default: yourself.)
.TP
.B vars
to get a list of personal settings
.TP
.B set <var> <value>
to modify these settings
.TP
.B observe <player>
to observe an ongoing game of the given <player>.
.TP
.B examine
.PD 0
.TP
.B oldmoves
.PD
to review a recently completed game
.PP
Some special XBoard features are activated when you are
in examine mode on ICS.  See the descriptions of the menu commands
`Forward', `Backward', `Pause', `ICS Client', 
and `Stop Examining' on the \fIEdit Menu\fR, \fIMode Menu\fR, and
\fIAction Menu\fR.

.SH FIREWALLS
By default, XBoard communicates with an Internet Chess Server
by opening a TCP socket directly from the machine it is running on
to the ICS. If there is a firewall between your machine and the ICS,
this won't work. Here are some recipes for getting around common
kinds of firewalls using special options to XBoard.
Important: See the paragraph in the below about extra echoes, in
\fILimitations\fR.

Suppose that you can't telnet directly to ICS, but you can telnet
to a firewall host, log in, and then telnet from there to ICS.
Let's say the firewall is called `firewall.example.com'. Set
command-line options as follows:

.nf
    xboard -ics -icshost firewall.example.com -icsport 23
.fi

Or in your `.Xresources' file:

.nf
    XBoard*internetChessServerHost: firewall.example.com
    XBoard*internetChessServerPort: 23
.fi

Then when you run XBoard in ICS mode, you will be prompted
to log in to the firewall host. This works because port 23 is the
standard telnet login service. Do so, then telnet to ICS, using a
command like `telnet chessclub.com 5000', or whatever command
the firewall provides for telnetting to port 5000.

If your firewall lets you telnet (or rlogin) to remote hosts but
doesn't let you telnet to port 5000, you may be able to connect to the
chess server on port 23 instead, which is the port the telnet program
uses by default.  Some chess servers support this (including
chessclub.com and freechess.org), while some do not.

If your chess server does not allow connections on port 23 and your
firewall does not allow you to connect to other ports, you may be able
to connect by hopping through another host outside the firewall that
you have an account on.  For instance, suppose you have a shell
account at `foo.edu'. Follow the recipe above, but instead of
typing `telnet chessclub.com 5000' to the firewall, type
`telnet foo.edu' (or `rlogin foo.edu'), log in there, and
then type `telnet chessclub.com 5000'.

Suppose that you can't telnet directly to ICS, but you can use rsh
to run programs on a firewall host, and that host can telnet to ICS.
Let's say the firewall is called `rsh.example.com'. Set
command-line options as follows:

.nf
    xboard -ics -gateway rsh.example.com -icshost chessclub.com
.fi

Or in your `.Xresources' file:

.nf
    XBoard*gateway: rsh.example.com
    XBoard*internetChessServerHost: chessclub.com
.fi

Then when you run XBoard in ICS mode, it will connect to
the ICS by using `rsh' to run the command
`telnet chessclub.com 5000' on host `rsh.example.com'.

Suppose that you can telnet anywhere you want, but you have to
run a special program called `ptelnet' to do so.

First, we'll consider the easy case, in which
`ptelnet chessclub.com 5000' gets you to the chess server.
In this case set command line options as follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet
.fi

Or in your `.Xresources' file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
.fi

Then when you run XBoard in ICS mode, it will issue the
command `ptelnet chessclub.com 5000' to connect to the ICS.

Next, suppose that `ptelnet chessclub.com 5000' doesn't work;
that is, your `ptelnet' program doesn't let you connect to
alternative ports. As noted above, your chess server may allow you to
connect on port 23 instead.  In that case, just add the option
`-icsport ""' to the above command, or add
`XBoard*internetChessServerPort:' to your `.Xresources' file.
But if your chess server doesn't let you connect on port 23, you will have
to find some other host outside the firewall and hop through it. For
instance, suppose you have a shell account at `foo.edu'. Set
command line options as follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet -icshost foo.edu -icsport ""
.fi

Or in your `.Xresources' file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
    XBoard*internetChessServerHost: foo.edu
    XBoard*internetChessServerPort:
.fi

Then when you run XBoard in ICS mode, it will issue the
command `ptelnet foo.edu' to connect to your account at
`foo.edu'. Log in there, then type `telnet chessclub.com 5000'.

ICC timestamp and FICS timeseal do not work through some
firewalls.  You can use them only if your firewall gives a clean TCP
connection with a full 8-bit wide path.  If your firewall allows you
to get out only by running a special telnet program, you can't use
timestamp or timeseal across it.  But if you have access to a
computer just outside your firewall, and you have much lower netlag
when talking to that computer than to the ICS, it might be worthwhile
running timestamp there.  Follow the instructions above for hopping
through a host outside the firewall (foo.edu in the example),
but run timestamp or timeseal on that host instead of telnet.

Suppose that you have a SOCKS firewall that will give you a clean
8-bit wide TCP connection to the chess server, but only after you
authenticate yourself via the SOCKS protocol.  In that case, you could
make a socksified version of XBoard and run that.  If you are using
timestamp or timeseal, you will to socksify it, not XBoard; this may
be difficult seeing that ICC and FICS do not provide source code for
these programs.  Socksification is beyond the scope of this document,
but see the SOCKS Web site at http://www.socks.permeo.com/.
If you are missing SOCKS, try http://www.funbureau.com/.

.SH ENVIRONMENT VARIABLES
Game and position files are found in a directory named by the
`CHESSDIR' environment variable. If this variable is not set, the
current working directory is used. If `CHESSDIR' is set,
XBoard actually changes its working directory to
`$CHESSDIR', so any files written by the chess engine
will be placed there too.

.SH LIMITATIONS AND KNOWN BUGS
There is no way for two people running copies of XBoard to play
each other without going through an Internet Chess Server.

Under some circumstances, your ICS password may be echoed when you log on.

If you are connecting to the ICS by running telnet on an Internet
provider or firewall host, you may find that each line you type is
echoed back an extra time after you hit <Enter>. If your Internet
provider is a Unix system, you can probably turn its echo off by
typing `stty -echo' after you log in, and/or typing
<^E><Enter> (Ctrl+E followed by the Enter key) to the telnet
program after you have logged into ICS.  It is a good idea to do this
if you can, because the extra echo can occasionally confuse XBoard's
parsing routines.

The game parser recognizes only algebraic notation.

Many of the following points used to be limitations in XBoard 4.2.7 and earlier, 
but are now fixed:
The internal move legality tester in XBoard 4.3.xx does look at the game history, 
and is fully aware of castling or en-passant-capture rights. It permits castling with 
the king on the d file because this is possible in some "wild 1" games on ICS. 
The piece-drop menu does not check piece drops in bughouse to see if you actually hold 
the piece you are trying to drop. But this way of dropping pieces should be considered 
an obsolete feature, now that pieces can be dropped by dragging them from the holdings 
to the board. Anyway, if you would attempt an illegal move when using a chess engine or the ICS, 
XBoard will accept the error message that comes back, undo the move, and let you try another.
FEN positions saved by XBoard do include correct information about whether castling or 
en passant are legal, and also handle the 50-move counter.
The mate detector does not understand that non-contact mate is not really mate in bughouse. 
The only problem this causes while playing is minor: a "#" (mate indicator) character will 
show up after a non-contact mating move in the move list. XBoard will not assume the game 
is over at that point, not even when the option Detect Mates is on.
Edit Game mode always uses the rules of the selected variant, 
which can be a variant that uses piece drops.  
You can load and edit games that contain piece drops. 
The (obsolete) piece menus are not active, 
but you can perform piece drops by dragging pieces from the holdings.
Fischer Random castling is fully understood. 
You can enter castlings by dragging the King on top of your Rook. 
You can probably also play Fischer Random successfully on ICS by typing 
castling moves into the ICS Interaction window.

The menus may not work if your keyboard is in Caps Lock or Num Lock mode.
This seems to be a problem with the Athena menu widget,
not an XBoard bug.

Also see the ToDo file included with the distribution for many other
possible bugs, limitations, and ideas for improvement that have been
suggested.
.SH REPORTING PROBLEMS
You can report bugs and problems with XBoard using
the bug tracker at `https://savannah.gnu.org/projects/xboard/'
or by sending mail to `<bug-xboard@gnu.org>'.  It can also
be useful to report or discuss bugs in the WinBoard Forum at
`http://www.open-aurec.com/wbforum/', 
WinBoard development section.

Please use the `script' program to start a typescript, run 
XBoard with the `-debug' option, and include the typescript
output in your message.
Also tell us what kind of machine and what operating system version
you are using.  The command `uname -a' will often tell you this.

If you improve XBoard, please send a message about your changes,
and we will get in touch with you about merging them in
to the main line of development.

.SH AUTHORS AND CONTRIBUTORS
Chris Sears and Dan Sears wrote the original XBoard.  They were
responsible for versions 1.0 through 1.2.  The color scheme was taken
from Wayne Christopher's `XChess' program.

Tim Mann was primarily responsible for XBoard versions 1.3 through
4.2.7, and for WinBoard (a port of XBoard to Microsoft Win32) from its
inception through version 4.2.7.

John Chanak contributed the initial implementation of ICS mode.  Evan
Welsh wrote `CMail', and Patrick Surry helped in designing,
testing, and documenting it.  Elmar Bartel contributed the new piece
bitmaps introduced in version 3.2.  Jochen Wiedmann converted the
documentation to texinfo.  Frank McIngvale added click/click moving,
the Analysis modes, piece flashing, ZIICS import, and ICS text
colorization to XBoard.  Hugh Fisher added animated piece movement to
XBoard, and Henrik Gram added it to WinBoard.  Mark Williams
contributed the initial (WinBoard-only) implementation of many new
features added to both XBoard and WinBoard in version 4.1.0, including
copy/paste, premove, icsAlarm, autoFlipView, training mode, auto
raise, and blindfold.  Ben Nye contributed X copy/paste code for
XBoard.

In a fork from version 4.2.7, Alessandro Scotti added many elements to
the user interface of WinBoard, including the board textures and
font-based rendering, the evaluation-graph, move-history and
engine-output window.  He was also responsible for adding the UCI
support.

H. G. Muller continued this fork of the project, producing version
4.3.  He made WinBoard castling- and e.p.-aware, added variant support
with adjustable board sizes, the crazyhouse holdings, and the fairy
pieces.  In addition he added most of the adjudication options, made
WinBoard more robust in dealing with buggy and crashing engines, and
extended time control with a time-odds and node-count-based modes.
Most of the options that initially were WinBoard only have now been
back-ported to XBoard.

Michel van den Bergh provided the code for reading Polyglot opening books.

Meanwhile, some work continued on the GNU XBoard project maintained at
savannah.gnu.org, but version 4.2.8 was never released.  Daniel
Mehrmann was responsible for much of this work.

Most recently, Arun Persaud worked with H. G. Muller to merge all
the features of the never-released XBoard/WinBoard 4.2.8 of the GNU
XBoard project and the never-released 4.3.16 from H. G.'s fork into a
unified XBoard/WinBoard 4.4, which is now available both from the
savannah.gnu.org web site and the WinBoard forum.

.SH CMAIL
The `cmail' program can help you play chess by email with opponents of
your choice using XBoard as an interface.

You will usually run `cmail' without giving any options.

.SS CMail options
.TP
.B -h
Displays `cmail' usage information.
.TP
.B -c
Shows the conditions of the GNU General Public License.
See \fICopying\fR.
.TP
.B -w
Shows the warranty notice of the GNU General Public License.
See \fICopying\fR.
.TP
.B -v
.PD 0
.TP
.B -xv
.PD
Provides or inhibits verbose output from `cmail' and XBoard,
useful for debugging. The
`-xv'
form also inhibits the cmail introduction message.
.TP
.B -mail
.PD 0
.TP
.B -xmail
.PD
Invokes or inhibits the sending of a mail message containing the move.
.TP
.B -xboard
.PD 0
.TP
.B -xxboard
.PD
Invokes or inhibits the running of XBoard on the game file.
.TP
.B -reuse
.PD 0
.TP
.B -xreuse
.PD
Invokes or inhibits the reuse of an existing XBoard to display the
current game.
.TP
.B -remail
Resends the last mail message for that game. This inhibits running
XBoard.
.TP
.B -game <name>
The name of the game to be processed.
.TP
.B -wgames <number>
.PD 0
.TP
.B -bgames <number>
.PD
.PD 0
.TP
.B -games <number>
.PD
Number of games to start as White, as Black or in total. Default is 1 as
white and none as black. If only one color is specified then none of the
other color is assumed. If no color is specified then equal numbers of
White and Black games are started, with the extra game being as White if an
odd number of total games is specified.
.TP
.B -me <short name>
.PD 0
.TP
.B -opp <short name>
.PD
A one-word alias for yourself or your opponent.
.TP
.B -wname <full name>
.PD 0
.TP
.B -bname <full name>
.PD
.PD 0
.TP
.B -name <full name>
.PD
.PD 0
.TP
.B -oppname <full name>
.PD
The full name of White, Black, yourself or your opponent.
.TP
.B -wna <net address>
.PD 0
.TP
.B -bna <net address>
.PD
.PD 0
.TP
.B -na <net address>
.PD
.PD 0
.TP
.B -oppna <net address>
.PD
The email address of White, Black, yourself or your opponent.
.TP
.B -dir <directory>
The directory in which `cmail' keeps its files. This defaults to the
environment variable `$CMAIL_DIR' or failing that, `$CHESSDIR',
`$HOME/Chess' or `~/Chess'. It will be created if it does not exist.
.TP
.B -arcdir <directory>
The directory in which `cmail' archives completed games. Defaults to
the environment variable `$CMAIL_ARCDIR' or, in its absence, the same
directory as cmail keeps its working files (above).
.TP
.B -mailprog <mail program>
The program used by cmail to send email messages. This defaults to the
environment variable `$CMAIL_MAILPROG' or failing that
`/usr/ucb/Mail', `/usr/ucb/mail' or `Mail'. You will need
to set this variable if none of the above paths fit your system.
.TP
.B -logFile <file>
A file in which to dump verbose debugging messages that are invoked with
the `-v'
option.
.TP
.B -event <event>
The PGN Event tag (default `Email correspondence game').
.TP
.B -site <site>
The PGN Site tag (default `NET').
.TP
.B -round <round>
The PGN Round tag (default `-', not applicable).
.TP
.B -mode <mode>
The PGN Mode tag (default `EM', Electronic Mail).
.TP
.B Other options
Any option flags not listed above are passed through to XBoard.
Invoking XBoard through CMail changes the default values of two XBoard
options: The default value for `-noChessProgram' is changed to
true; that is, by default no chess engine is started.  The default
value for `-timeDelay' is changed to 0; that is, by default
XBoard immediately goes to the end of the game as played so far,
rather than stepping through the moves one by one.  You can still set
these options to whatever values you prefer by supplying them on
CMail's command line.  See \fIOptions\fR.
.PP
.SS Starting a CMail Game
Type `cmail' from a shell to start a game as white. After an opening
message, you will be prompted for a game name, which is optional -- if you
simply press <Enter>, the game name will take the form
`you-VS-opponent'. You will next be prompted for the short name
of your opponent. If you haven't played this person before, you will also
be prompted for his/her email address. `cmail' will then invoke
XBoard in the background. Make your first move and select
`Mail Move' from the `File' menu. See \fIFile Menu\fR. If all is well,
`cmail' will mail a copy of the move to your opponent. If you select
`Exit' without having selected `Mail Move' then no move will be
made.

.SS Answering a Move
When you receive a message from an opponent containing a move in one of
your games, simply pipe the message through `cmail'. In some mailers
this is as simple as typing `| cmail' when viewing the message, while in
others you may have to save the message to a file and do `cmail < file'
at the command line. In either case `cmail' will display the game using
XBoard. If you didn't exit XBoard when you made your first move
then `cmail' will do its best to use the existing XBoard instead
of starting a new one. As before, simply make a move and select
`Mail Move' from the `File' menu. See \fIFile Menu\fR. `cmail'
will try to use the
XBoard that was most recently used to display the current game. This
means that many games can be in progress simultaneously, each with its own
active XBoard.

If you want to look at the history or explore a variation, go ahead, but
you must return to the current position before XBoard will allow you
to mail a move. If you edit the game's history you must select
`Reload Same Game' from the `File' menu to get back to the original
position, then make the move you want and select `Mail Move'.
As before, if you decide you aren't ready to make a move just yet you can
either select `Exit' without sending a move or just leave
XBoard running until you are ready.

.SS Multi-Game Messages
It is possible to have a `cmail' message carry more than one game.
This feature was implemented to handle IECG (International Email Chess
Group) matches, where a match consists of one game as white and one as black,
with moves transmitted simultaneously. In case there are more general uses,
`cmail' itself places no limit on the number of black/white games
contained in a message; however, XBoard does.

.SS Completing a Game
Because XBoard can detect checkmate and stalemate, `cmail'
handles game termination sensibly. As well as resignation, the
`Action' menu allows draws to be offered and accepted for
`cmail' games.

For multi-game messages, only unfinished and just-finished games will be
included in email messages. When all the games are finished, they are
archived in the user's archive directory, and similarly in the opponent's
when he or she pipes the final message through `cmail'. The archive
file name includes the date the game was started.

.SS Known CMail Problems
It's possible that a strange conjunction of conditions may occasionally
mean that `cmail' has trouble reactivating an existing
XBoard. If this should happen, simply trying it again should work.
If not, remove the file that stores the XBoard's PID
(`game.pid') or use the `-xreuse' option to force
`cmail' to start a new XBoard.

Versions of `cmail' after 2.16 no longer understand the old file format
that XBoard used to use and so cannot be used to correspond with
anyone using an older version.

Versions of `cmail' older than 2.11 do not handle multi-game messages,
so multi-game correspondence is not possible with opponents using an older
version.

.SH OTHER PROGRAMS YOU CAN USE WITH XBOARD
Here are some other programs you can use with XBoard

.SS GNU Chess
The GNU Chess engine is available from:

ftp://ftp.gnu.org/gnu/gnuchess/

You can use XBoard to play a game against GNU Chess, or to
interface GNU Chess to an ICS.

.SS Fairy-Max
Fairy-Max is a derivative from the once World's smallest Chess program micro-Max,
which measures only about 100 lines of source code.
The main difference with micro-Max is that Fairy-Max loads its move-generator
tables from a file, so that the rules for piece movement can be easily configured
to implement unorthodox pieces.
Fairy-Max can therefore play a large number of variants, normal Chess being one of those.
In addition it plays Knightmate, Capablanca and Gothic Chess, Shatranj, Courier Chess,
Cylinder chess, Berolina Chess, while the user can easily define new variants.
It can be obtained from:

http://home.hccnet.nl/h.g.muller/dwnldpage.html

.SS HoiChess
HoiChess is a not-so-very-strong Chess engine, which comes with a derivative HoiXiangqi,
able to play Chinese Chess. It can be obtained from the standard Linux repositories
through:

sudo apt-get install hoichess

.SS Crafty
Crafty is a chess engine written by Bob Hyatt.
You can use XBoard to play a game against Crafty, hook Crafty up
to an ICS, or use Crafty to interactively analyze games and positions
for you.

Crafty is a strong, rapidly evolving chess program. This rapid
pace of development is good, because it means Crafty is always
getting better.  This can sometimes cause problems with
backwards compatibility, but usually the latest version of Crafty
will work well with the latest version of XBoard.
Crafty can be obtained from its author's FTP site:
ftp://ftp.cis.uab.edu/hyatt/.

To use Crafty with XBoard, give the -fcp and -fd options as follows, where
<crafty's directory> is the directory in which you installed Crafty
and placed its book and other support files.

.SS zic2xpm
The ``zic2xpm'' program is used to import chess sets from the ZIICS(*)
program into XBoard. ``zic2xpm'' is part of the XBoard distribution.
ZIICS is available from:

ftp://ftp.freechess.org/pub/chess/DOS/ziics131.exe

To import ZIICS pieces, do this:
.TP
.B 1. Unzip ziics131.exe into a directory:

.nf
    unzip -L ziics131.exe -d ~/ziics
.fi
.TP
.B 2. Use zic2xpm to convert a set of pieces to XBoard format.

For example, let's say you want to use the
FRITZ4 set. These files are named ``fritz4.*'' in the ZIICS distribution.

.nf
    mkdir ~/fritz4
    cd ~/fritz4
    zic2xpm ~/ziics/fritz4.*
.fi
.TP
.B 3. Give XBoard the ``-pixmap'' option when starting up, e.g.:

.nf
    xboard -pixmap ~/fritz4
.fi

Alternatively, you can add this line to your `.Xresources' file:

.nf
    xboard*pixmapDirectory: ~/fritz4
.fi
.PP
(*) ZIICS is a separate copyrighted work of Andy McFarland.
The ``ZIICS pieces'' are copyrighted works of their respective
creators. Files produced by ``zic2xpm'' are for PERSONAL USE ONLY
and may NOT be redistributed without explicit permission from
the original creator(s) of the pieces.

.SH COPYRIGHT
Copyright (C) 1991 Digital Equipment Corporation, Maynard, Massachusetts.

All Rights Reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Digital disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness.  In no event shall
Digital be liable for any special, indirect or consequential damages or
any damages whatsoever resulting from loss of use, data or profits,
whether in an action of contract, negligence or other tortious action,
arising out of or in connection with the use or performance of this
software.

Enhancements copyright (C) 1992-2003, 2004, 2005, 2006, 2007,
2008, 2009, 2010, 2011 Free Software Foundation, Inc.

.nf
Published by the Free Software Foundation
59 Temple Place - Suite 330
Boston, MA 02111-1307 USA
.fi

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided also that the
section entitled ``GNU General Public License,''
is included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

Permission is granted to copy and distribute translations of this manual
into another language, under the above conditions for modified versions,
except that the section entitled ``GNU General Public License,''
and this permission notice, may be included in translations approved by
the Free Software Foundation instead of in the original English.

.SH GNU GENERAL PUBLIC LICENSE
.nf
Copyright (C) 2007 Free Software Foundation, Inc. `http://fsf.org/'

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.
.fi

The GNU General Public License is a free, copyleft license for
software and other kinds of works.

The licenses for most software and other practical works are designed
to take away your freedom to share and change the works.  By contrast,
the GNU General Public License is intended to guarantee your freedom
to share and change all versions of a program -- to make sure it remains
free software for all its users.  We, the Free Software Foundation,
use the GNU General Public License for most of our software; it
applies also to any other work released this way by its authors.  You
can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
them if you wish), that you receive source code or can get it if you
want it, that you can change the software or use pieces of it in new
free programs, and that you know you can do these things.

To protect your rights, we need to prevent others from denying you
these rights or asking you to surrender the rights.  Therefore, you
have certain responsibilities if you distribute copies of the
software, or if you modify it: responsibilities to respect the freedom
of others.

For example, if you distribute copies of such a program, whether
gratis or for a fee, you must pass on to the recipients the same
freedoms that you received.  You must make sure that they, too,
receive or can get the source code.  And you must show them these
terms so they know their rights.

Developers that use the GNU GPL protect your rights with two steps:
(1) assert copyright on the software, and (2) offer you this License
giving you legal permission to copy, distribute and/or modify it.

For the developers' and authors' protection, the GPL clearly explains
that there is no warranty for this free software.  For both users' and
authors' sake, the GPL requires that modified versions be marked as
changed, so that their problems will not be attributed erroneously to
authors of previous versions.

Some devices are designed to deny users access to install or run
modified versions of the software inside them, although the
manufacturer can do so.  This is fundamentally incompatible with the
aim of protecting users' freedom to change the software.  The
systematic pattern of such abuse occurs in the area of products for
individuals to use, which is precisely where it is most unacceptable.
Therefore, we have designed this version of the GPL to prohibit the
practice for those products.  If such problems arise substantially in
other domains, we stand ready to extend this provision to those
domains in future versions of the GPL, as needed to protect the
freedom of users.

Finally, every program is threatened constantly by software patents.
States should not allow patents to restrict development and use of
software on general-purpose computers, but in those that do, we wish
to avoid the special danger that patents applied to a free program
could make it effectively proprietary.  To prevent this, the GPL
assures that patents cannot be used to render the program non-free.

The precise terms and conditions for copying, distribution and
modification follow.

.TP
.B Definitions.
``This License'' refers to version 3 of the GNU General Public License.

``Copyright'' also means copyright-like laws that apply to other kinds
of works, such as semiconductor masks.

``The Program'' refers to any copyrightable work licensed under this
License.  Each licensee is addressed as ``you''.  ``Licensees'' and
``recipients'' may be individuals or organizations.

To ``modify'' a work means to copy from or adapt all or part of the work
in a fashion requiring copyright permission, other than the making of
an exact copy.  The resulting work is called a ``modified version'' of
the earlier work or a work ``based on'' the earlier work.

A ``covered work'' means either the unmodified Program or a work based
on the Program.

To ``propagate'' a work means to do anything with it that, without
permission, would make you directly or secondarily liable for
infringement under applicable copyright law, except executing it on a
computer or modifying a private copy.  Propagation includes copying,
distribution (with or without modification), making available to the
public, and in some countries other activities as well.

To ``convey'' a work means any kind of propagation that enables other
parties to make or receive copies.  Mere interaction with a user
through a computer network, with no transfer of a copy, is not
conveying.

An interactive user interface displays ``Appropriate Legal Notices'' to
the extent that it includes a convenient and prominently visible
feature that (1) displays an appropriate copyright notice, and (2)
tells the user that there is no warranty for the work (except to the
extent that warranties are provided), that licensees may convey the
work under this License, and how to view a copy of this License.  If
the interface presents a list of user commands or options, such as a
menu, a prominent item in the list meets this criterion.

.TP
.B Source Code.
The ``source code'' for a work means the preferred form of the work for
making modifications to it.  ``Object code'' means any non-source form
of a work.

A ``Standard Interface'' means an interface that either is an official
standard defined by a recognized standards body, or, in the case of
interfaces specified for a particular programming language, one that
is widely used among developers working in that language.

The ``System Libraries'' of an executable work include anything, other
than the work as a whole, that (a) is included in the normal form of
packaging a Major Component, but which is not part of that Major
Component, and (b) serves only to enable use of the work with that
Major Component, or to implement a Standard Interface for which an
implementation is available to the public in source code form.  A
``Major Component'', in this context, means a major essential component
(kernel, window system, and so on) of the specific operating system
(if any) on which the executable work runs, or a compiler used to
produce the work, or an object code interpreter used to run it.

The ``Corresponding Source'' for a work in object code form means all
the source code needed to generate, install, and (for an executable
work) run the object code and to modify the work, including scripts to
control those activities.  However, it does not include the work's
System Libraries, or general-purpose tools or generally available free
programs which are used unmodified in performing those activities but
which are not part of the work.  For example, Corresponding Source
includes interface definition files associated with source files for
the work, and the source code for shared libraries and dynamically
linked subprograms that the work is specifically designed to require,
such as by intimate data communication or control flow between those
subprograms and other parts of the work.

The Corresponding Source need not include anything that users can
regenerate automatically from other parts of the Corresponding Source.

The Corresponding Source for a work in source code form is that same
work.

.TP
.B Basic Permissions.
All rights granted under this License are granted for the term of
copyright on the Program, and are irrevocable provided the stated
conditions are met.  This License explicitly affirms your unlimited
permission to run the unmodified Program.  The output from running a
covered work is covered by this License only if the output, given its
content, constitutes a covered work.  This License acknowledges your
rights of fair use or other equivalent, as provided by copyright law.

You may make, run and propagate covered works that you do not convey,
without conditions so long as your license otherwise remains in force.
You may convey covered works to others for the sole purpose of having
them make modifications exclusively for you, or provide you with
facilities for running those works, provided that you comply with the
terms of this License in conveying all material for which you do not
control copyright.  Those thus making or running the covered works for
you must do so exclusively on your behalf, under your direction and
control, on terms that prohibit them from making any copies of your
copyrighted material outside their relationship with you.

Conveying under any other circumstances is permitted solely under the
conditions stated below.  Sublicensing is not allowed; section 10
makes it unnecessary.

.TP
.B Protecting Users' Legal Rights From Anti-Circumvention Law.
No covered work shall be deemed part of an effective technological
measure under any applicable law fulfilling obligations under article
11 of the WIPO copyright treaty adopted on 20 December 1996, or
similar laws prohibiting or restricting circumvention of such
measures.

When you convey a covered work, you waive any legal power to forbid
circumvention of technological measures to the extent such
circumvention is effected by exercising rights under this License with
respect to the covered work, and you disclaim any intention to limit
operation or modification of the work as a means of enforcing, against
the work's users, your or third parties' legal rights to forbid
circumvention of technological measures.

.TP
.B Conveying Verbatim Copies.
You may convey verbatim copies of the Program's source code as you
receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy an appropriate copyright notice;
keep intact all notices stating that this License and any
non-permissive terms added in accord with section 7 apply to the code;
keep intact all notices of the absence of any warranty; and give all
recipients a copy of this License along with the Program.

You may charge any price or no price for each copy that you convey,
and you may offer support or warranty protection for a fee.

.TP
.B Conveying Modified Source Versions.
You may convey a work based on the Program, or the modifications to
produce it from the Program, in the form of source code under the
terms of section 4, provided that you also meet all of these
conditions:

The work must carry prominent notices stating that you modified it,
and giving a relevant date.

The work must carry prominent notices stating that it is released
under this License and any conditions added under section 7.  This
requirement modifies the requirement in section 4 to ``keep intact all
notices''.

You must license the entire work, as a whole, under this License to
anyone who comes into possession of a copy.  This License will
therefore apply, along with any applicable section 7 additional terms,
to the whole of the work, and all its parts, regardless of how they
are packaged.  This License gives no permission to license the work in
any other way, but it does not invalidate such permission if you have
separately received it.

If the work has interactive user interfaces, each must display
Appropriate Legal Notices; however, if the Program has interactive
interfaces that do not display Appropriate Legal Notices, your work
need not make them do so.

A compilation of a covered work with other separate and independent
works, which are not by their nature extensions of the covered work,
and which are not combined with it such as to form a larger program,
in or on a volume of a storage or distribution medium, is called an
``aggregate'' if the compilation and its resulting copyright are not
used to limit the access or legal rights of the compilation's users
beyond what the individual works permit.  Inclusion of a covered work
in an aggregate does not cause this License to apply to the other
parts of the aggregate.

.TP
.B  Conveying Non-Source Forms.
You may convey a covered work in object code form under the terms of
sections 4 and 5, provided that you also convey the machine-readable
Corresponding Source under the terms of this License, in one of these
ways:

Convey the object code in, or embodied in, a physical product
(including a physical distribution medium), accompanied by the
Corresponding Source fixed on a durable physical medium customarily
used for software interchange.

Convey the object code in, or embodied in, a physical product
(including a physical distribution medium), accompanied by a written
offer, valid for at least three years and valid for as long as you
offer spare parts or customer support for that product model, to give
anyone who possesses the object code either (1) a copy of the
Corresponding Source for all the software in the product that is
covered by this License, on a durable physical medium customarily used
for software interchange, for a price no more than your reasonable
cost of physically performing this conveying of source, or (2) access
to copy the Corresponding Source from a network server at no charge.

Convey individual copies of the object code with a copy of the written
offer to provide the Corresponding Source.  This alternative is
allowed only occasionally and noncommercially, and only if you
received the object code with such an offer, in accord with subsection
6b.

Convey the object code by offering access from a designated place
(gratis or for a charge), and offer equivalent access to the
Corresponding Source in the same way through the same place at no
further charge.  You need not require recipients to copy the
Corresponding Source along with the object code.  If the place to copy
the object code is a network server, the Corresponding Source may be
on a different server (operated by you or a third party) that supports
equivalent copying facilities, provided you maintain clear directions
next to the object code saying where to find the Corresponding Source.
Regardless of what server hosts the Corresponding Source, you remain
obligated to ensure that it is available for as long as needed to
satisfy these requirements.

Convey the object code using peer-to-peer transmission, provided you
inform other peers where the object code and Corresponding Source of
the work are being offered to the general public at no charge under
subsection 6d.

A separable portion of the object code, whose source code is excluded
from the Corresponding Source as a System Library, need not be
included in conveying the object code work.

A ``User Product'' is either (1) a ``consumer product'', which means any
tangible personal property which is normally used for personal,
family, or household purposes, or (2) anything designed or sold for
incorporation into a dwelling.  In determining whether a product is a
consumer product, doubtful cases shall be resolved in favor of
coverage.  For a particular product received by a particular user,
``normally used'' refers to a typical or common use of that class of
product, regardless of the status of the particular user or of the way
in which the particular user actually uses, or expects or is expected
to use, the product.  A product is a consumer product regardless of
whether the product has substantial commercial, industrial or
non-consumer uses, unless such uses represent the only significant
mode of use of the product.

``Installation Information'' for a User Product means any methods,
procedures, authorization keys, or other information required to
install and execute modified versions of a covered work in that User
Product from a modified version of its Corresponding Source.  The
information must suffice to ensure that the continued functioning of
the modified object code is in no case prevented or interfered with
solely because modification has been made.

If you convey an object code work under this section in, or with, or
specifically for use in, a User Product, and the conveying occurs as
part of a transaction in which the right of possession and use of the
User Product is transferred to the recipient in perpetuity or for a
fixed term (regardless of how the transaction is characterized), the
Corresponding Source conveyed under this section must be accompanied
by the Installation Information.  But this requirement does not apply
if neither you nor any third party retains the ability to install
modified object code on the User Product (for example, the work has
been installed in ROM).

The requirement to provide Installation Information does not include a
requirement to continue to provide support service, warranty, or
updates for a work that has been modified or installed by the
recipient, or for the User Product in which it has been modified or
installed.  Access to a network may be denied when the modification
itself materially and adversely affects the operation of the network
or violates the rules and protocols for communication across the
network.

Corresponding Source conveyed, and Installation Information provided,
in accord with this section must be in a format that is publicly
documented (and with an implementation available to the public in
source code form), and must require no special password or key for
unpacking, reading or copying.

.TP
.B Additional Terms.
``Additional permissions'' are terms that supplement the terms of this
License by making exceptions from one or more of its conditions.
Additional permissions that are applicable to the entire Program shall
be treated as though they were included in this License, to the extent
that they are valid under applicable law.  If additional permissions
apply only to part of the Program, that part may be used separately
under those permissions, but the entire Program remains governed by
this License without regard to the additional permissions.

When you convey a copy of a covered work, you may at your option
remove any additional permissions from that copy, or from any part of
it.  (Additional permissions may be written to require their own
removal in certain cases when you modify the work.)  You may place
additional permissions on material, added by you to a covered work,
for which you have or can give appropriate copyright permission.

Notwithstanding any other provision of this License, for material you
add to a covered work, you may (if authorized by the copyright holders
of that material) supplement the terms of this License with terms:

Disclaiming warranty or limiting liability differently from the terms
of sections 15 and 16 of this License; or

Requiring preservation of specified reasonable legal notices or author
attributions in that material or in the Appropriate Legal Notices
displayed by works containing it; or

Prohibiting misrepresentation of the origin of that material, or
requiring that modified versions of such material be marked in
reasonable ways as different from the original version; or

Limiting the use for publicity purposes of names of licensors or
authors of the material; or

Declining to grant rights under trademark law for use of some trade
names, trademarks, or service marks; or

Requiring indemnification of licensors and authors of that material by
anyone who conveys the material (or modified versions of it) with
contractual assumptions of liability to the recipient, for any
liability that these contractual assumptions directly impose on those
licensors and authors.

All other non-permissive additional terms are considered ``further
restrictions'' within the meaning of section 10.  If the Program as you
received it, or any part of it, contains a notice stating that it is
governed by this License along with a term that is a further
restriction, you may remove that term.  If a license document contains
a further restriction but permits relicensing or conveying under this
License, you may add to a covered work material governed by the terms
of that license document, provided that the further restriction does
not survive such relicensing or conveying.

If you add terms to a covered work in accord with this section, you
must place, in the relevant source files, a statement of the
additional terms that apply to those files, or a notice indicating
where to find the applicable terms.

Additional terms, permissive or non-permissive, may be stated in the
form of a separately written license, or stated as exceptions; the
above requirements apply either way.

.TP
.B Termination.
You may not propagate or modify a covered work except as expressly
provided under this License.  Any attempt otherwise to propagate or
modify it is void, and will automatically terminate your rights under
this License (including any patent licenses granted under the third
paragraph of section 11).

However, if you cease all violation of this License, then your license
from a particular copyright holder is reinstated (a) provisionally,
unless and until the copyright holder explicitly and finally
terminates your license, and (b) permanently, if the copyright holder
fails to notify you of the violation by some reasonable means prior to
60 days after the cessation.

Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, you do not qualify to receive new licenses for the same
material under section 10.

.TP
.B Acceptance Not Required for Having Copies.
You are not required to accept this License in order to receive or run
a copy of the Program.  Ancillary propagation of a covered work
occurring solely as a consequence of using peer-to-peer transmission
to receive a copy likewise does not require acceptance.  However,
nothing other than this License grants you permission to propagate or
modify any covered work.  These actions infringe copyright if you do
not accept this License.  Therefore, by modifying or propagating a
covered work, you indicate your acceptance of this License to do so.

.TP
.B Automatic Licensing of Downstream Recipients.
Each time you convey a covered work, the recipient automatically
receives a license from the original licensors, to run, modify and
propagate that work, subject to this License.  You are not responsible
for enforcing compliance by third parties with this License.

An ``entity transaction'' is a transaction transferring control of an
organization, or substantially all assets of one, or subdividing an
organization, or merging organizations.  If propagation of a covered
work results from an entity transaction, each party to that
transaction who receives a copy of the work also receives whatever
licenses to the work the party's predecessor in interest had or could
give under the previous paragraph, plus a right to possession of the
Corresponding Source of the work from the predecessor in interest, if
the predecessor has it or can get it with reasonable efforts.

You may not impose any further restrictions on the exercise of the
rights granted or affirmed under this License.  For example, you may
not impose a license fee, royalty, or other charge for exercise of
rights granted under this License, and you may not initiate litigation
(including a cross-claim or counterclaim in a lawsuit) alleging that
any patent claim is infringed by making, using, selling, offering for
sale, or importing the Program or any portion of it.

.TP
.B Patents.
A ``contributor'' is a copyright holder who authorizes use under this
License of the Program or a work on which the Program is based.  The
work thus licensed is called the contributor's ``contributor version''.

A contributor's ``essential patent claims'' are all patent claims owned
or controlled by the contributor, whether already acquired or
hereafter acquired, that would be infringed by some manner, permitted
by this License, of making, using, or selling its contributor version,
but do not include claims that would be infringed only as a
consequence of further modification of the contributor version.  For
purposes of this definition, ``control'' includes the right to grant
patent sublicenses in a manner consistent with the requirements of
this License.

Each contributor grants you a non-exclusive, worldwide, royalty-free
patent license under the contributor's essential patent claims, to
make, use, sell, offer for sale, import and otherwise run, modify and
propagate the contents of its contributor version.

In the following three paragraphs, a ``patent license'' is any express
agreement or commitment, however denominated, not to enforce a patent
(such as an express permission to practice a patent or covenant not to
sue for patent infringement).  To ``grant'' such a patent license to a
party means to make such an agreement or commitment not to enforce a
patent against the party.

If you convey a covered work, knowingly relying on a patent license,
and the Corresponding Source of the work is not available for anyone
to copy, free of charge and under the terms of this License, through a
publicly available network server or other readily accessible means,
then you must either (1) cause the Corresponding Source to be so
available, or (2) arrange to deprive yourself of the benefit of the
patent license for this particular work, or (3) arrange, in a manner
consistent with the requirements of this License, to extend the patent
license to downstream recipients.  ``Knowingly relying'' means you have
actual knowledge that, but for the patent license, your conveying the
covered work in a country, or your recipient's use of the covered work
in a country, would infringe one or more identifiable patents in that
country that you have reason to believe are valid.

If, pursuant to or in connection with a single transaction or
arrangement, you convey, or propagate by procuring conveyance of, a
covered work, and grant a patent license to some of the parties
receiving the covered work authorizing them to use, propagate, modify
or convey a specific copy of the covered work, then the patent license
you grant is automatically extended to all recipients of the covered
work and works based on it.

A patent license is ``discriminatory'' if it does not include within the
scope of its coverage, prohibits the exercise of, or is conditioned on
the non-exercise of one or more of the rights that are specifically
granted under this License.  You may not convey a covered work if you
are a party to an arrangement with a third party that is in the
business of distributing software, under which you make payment to the
third party based on the extent of your activity of conveying the
work, and under which the third party grants, to any of the parties
who would receive the covered work from you, a discriminatory patent
license (a) in connection with copies of the covered work conveyed by
you (or copies made from those copies), or (b) primarily for and in
connection with specific products or compilations that contain the
covered work, unless you entered into that arrangement, or that patent
license was granted, prior to 28 March 2007.

Nothing in this License shall be construed as excluding or limiting
any implied license or other defenses to infringement that may
otherwise be available to you under applicable patent law.

.TP
.B No Surrender of Others' Freedom.
If conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot convey
a covered work so as to satisfy simultaneously your obligations under
this License and any other pertinent obligations, then as a
consequence you may not convey it at all.  For example, if you agree
to terms that obligate you to collect a royalty for further conveying
from those to whom you convey the Program, the only way you could
satisfy both those terms and this License would be to refrain entirely
from conveying the Program.

.TP
.B Use with the GNU Affero General Public License.
Notwithstanding any other provision of this License, you have
permission to link or combine any covered work with a work licensed
under version 3 of the GNU Affero General Public License into a single
combined work, and to convey the resulting work.  The terms of this
License will continue to apply to the part which is the covered work,
but the special requirements of the GNU Affero General Public License,
section 13, concerning interaction through a network will apply to the
combination as such.

.TP
.B Revised Versions of this License.
The Free Software Foundation may publish revised and/or new versions
of the GNU General Public License from time to time.  Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies that a certain numbered version of the GNU General Public
License ``or any later version'' applies to it, you have the option of
following the terms and conditions either of that numbered version or
of any later version published by the Free Software Foundation.  If
the Program does not specify a version number of the GNU General
Public License, you may choose any version ever published by the Free
Software Foundation.

If the Program specifies that a proxy can decide which future versions
of the GNU General Public License can be used, that proxy's public
statement of acceptance of a version permanently authorizes you to
choose that version for the Program.

Later license versions may give you additional or different
permissions.  However, no additional obligations are imposed on any
author or copyright holder as a result of your choosing to follow a
later version.

.TP
.B Disclaimer of Warranty.
THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM ``AS IS'' WITHOUT
WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND
PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE
DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
CORRECTION.

.TP
.B Limitation of Liability.
IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR
CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT
NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR
LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM
TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER
PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

.TP
.B Interpretation of Sections 15 and 16.
If the disclaimer of warranty and limitation of liability provided
above cannot be given local legal effect according to their terms,
reviewing courts shall apply local law that most closely approximates
an absolute waiver of all civil liability in connection with the
Program, unless a warranty or assumption of liability accompanies a
copy of the Program in return for a fee.

If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these
terms.

To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
state the exclusion of warranty; and each file should have at least
the ``copyright'' line and a pointer to where the full notice is found.

.nf
ONE LINE TO GIVE THE PROGRAM'S NAME AND A BRIEF IDEA OF WHAT IT DOES.
Copyright (C) YEAR NAME OF AUTHOR

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see `http://www.gnu.org/licenses/'.
.fi

Also add information on how to contact you by electronic and paper mail.

If the program does terminal interaction, make it output a short
notice like this when it starts in an interactive mode:

.nf
PROGRAM Copyright (C) YEAR NAME OF AUTHOR
This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
This is free software, and you are welcome to redistribute it
under certain conditions; type `show c' for details.
.fi

The hypothetical commands `show w' and `show c' should show
the appropriate parts of the General Public License.  Of course, your
program's commands might be different; for a GUI interface, you would
use an ``about box''.

You should also get your employer (if you work as a programmer) or school,
if any, to sign a ``copyright disclaimer'' for the program, if necessary.
For more information on this, and how to apply and follow the GNU GPL, see
`http://www.gnu.org/licenses/'.

The GNU General Public License does not permit incorporating your
program into proprietary programs.  If your program is a subroutine
library, you may consider it more useful to permit linking proprietary
applications with the library.  If this is what you want to do, use
the GNU Lesser General Public License instead of this License.  But
first, please read `http://www.gnu.org/philosophy/why-not-lgpl.html'.

