@c -*-texinfo-*-
@c This is part of the GNU edition of V.E.R.A.
@c Copyright (C) 1993/2020 Oliver Heidelbach
@c See the file vera.texi for copying conditions.
@c 
@c Syntax:
@c ACRONYM
@c Expansion[ (Reference)][, "Style"]
@c Additional explanations are included in [square brackets]

@table @asis
@item I16L32P16
Integer 16 [bit], Long 32 [bit], Pointer 16 [bit] (BIT)

@item I16LP32
Integer 16 [bit], Long and Pointer 32 [bit] (BIT)

@item I2C
Inter Integrated Circuit [bus]

@item I2O
Intelligent Input/Output (Intel)

@item I2O
Intelligent Input/Output [bus]

@item I32LP64
Integer 32 [bit], Long and Pointer 64 [bit] (BIT)

@item I3C
International Imaging Industry Association (org., PIMA, successorr)

@item I3DL2
Interactive 3D Audio Level 2 (audio)

@item I4DL
Interface, Inheritance, Implementation, Installation Definition Language (DME, OSF)

@item I4L
ISDN for Linux (Linux, ISDN)

@item IA
Identification and Authentication, "I & A"

@item IA32
Intel Architecture - 32 [BIT] (Intel, BIT), "IA-32"

@item IA32E
Intel Architecture - 32 [BIT] Enhanced (Intel, IA32), "IA32e"

@item IA64
Intel Architecture - 64 [BIT] (Intel, BIT), "IA-64"

@item IAA
Initial Address Acknowledgment

@item IAA
Intel Application Accelerator

@item IAAIL
International Association for Artificial Intelligence and Law (org., AI)

@item IAAS
Infrastructure As A Service

@item IAB
Internet Activities / Architecture Board (RFC 1160/1601, Internet)

@item IAC
InterApplication Communication (Apple)

@item IAC
International Association for Cybernetics (org.)

@item IACT
International Alliance for Compatible Technology (org.)

@item IAE
ISDN AnschlussEinheit (ISDN, DTAG)

@item IAF
Internet Address Finder (WWW)

@item IAFNAB
It's A Feature, Not A Bug (slang, Cygwin)

@item IAHC
Internet Ad Hoc Committee (org., Internet)

@item IAI
Institut fuer Angewandte Informatik (org.)

@item IAK
Internet explorer Administrator Kit (MS, Internet)

@item IAK2
Internet Access Kit / 2 (IBM, OS/2), "IAK/2"

@item IAL
Intel Architecture Labs (Intel)

@item IAM
Identity and Access Management

@item IAM
Initial Address Message

@item IAMT
Intel Active Management Technology (Intel), "iAMT"

@item IANA
Internet Assigned Numbers Authority (Internet)

@item IANACE
I Am Not A Cygwin Expert (slang, Cygwin)

@item IANAL
I Am Not A Lawyer (slang, Usenet, IRC)

@item IANS
Intel Advanced Networking Services, "iANS"

@item IANW
International Academic Networkshops (Konferenz)

@item IAO
[Fraunhofer] Institut fuer Arbeitswirtschaft und Organisation (org., Stuttgart, Germany)

@item IAOG
International ADMD Operators Group (org., ADMD, X.400)

@item IAONA
Industrial Automation Open Networking Alliance (org., Europe)

@item IAP
In-App Purchase

@item IAP
Internet Access Provider (Internet)

@item IAPC
Instantly Available Personal Computer (Intel, PC)

@item IAPC
Intel Architecture Personal Computer (PC, Intel), "IA-PC"

@item IAPP
Inter Access Point Protocol (AP, WLAN, IEEE 802.11f)

@item IAPR
International Association on Pattern Recognition (org.)

@item IAR
Initial Address Reject

@item IARP
International Advanced Robotic Program (org.)

@item IAS
Interactive Application System (DEC)

@item IAS
Internet Authentication Server (MS, Windows)

@item IASA
IETF Administrative Support Activity (IETF, RFC 4071/4371)

@item IAT
Information Access Technology (Provider)

@item IAUG
International AIX User Group (org., Unix, AIX, user group)

@item IAW
In Accordance With (slang, Usenet, IRC)

@item IAX
Inter Asterisk eXchange (VoIP, OSS)

@item IB
In Band (S-ATA)

@item IB4J
Instant BASIC for Java (Java, BASIC)

@item IBA
Infini-Band Architecture (Intel, Infiniband)

@item IBAN
International Bank Account Number (banking)

@item IBASES
Intel Baseline AGP System Evaluation Suite (AGP, Intel)

@item IBB
Internet Bug Bounty (Internet, OSS)

@item IBC
InterBase Components (Borland, Delphi, InterBase)

@item IBCN
Integrated Broadband Communication Network

@item IBCS2
Intel Binary Compatibilty Specification 2 [emulator], "iBCS2"

@item IBEX
International Business EXchange (network)

@item IBFI
Internationales Begegnungs- und Forschungszentrum fuer Informatik (org., GI)

@item IBFN
Integriertes BreitbandFernmeldeNetz

@item IBGP
Internal Border Gateway Protocol (BGP, eBGP), "iBGP"

@item IBM
International Business Machines (manufacturer, IBM)

@item IBMS
Integrated Broadband Mobile System

@item IBN
Integrated Business Network

@item IBO
InterBase Objects (Borland, InterBase)

@item IBPB
Indirect Branch Prediction Barrier

@item IBSS
Independent Basic Service Set (IEEE 802.11i, WLAN)

@item IBTA
InfiniBand Trade Association (org., IBM, HP, Compaq, Sun, Dell, MS, ...)

@item IC
Integrated Circuit

@item ICA
Image Scanner Acquisition

@item ICA
Independent Computing Architecture (Cytrix, Windows NT, ASP)

@item ICA
Information Connection Architecture (SGI)

@item ICA
Integrated Chameleon Architecture (SGML)

@item ICA
Integrated Communications Architecture

@item ICA
Intelligent Communication Adapter (Banyan, VINES)

@item ICA
International Communications Association (org.)

@item ICADD
International Committee for Accessible Document Design (org.)

@item ICAL
Internet CALendar [protocol], "iCAL"

@item ICALP
International Colloquium on Automata, Languages and Programming (EATCS, conference)

@item ICAN
Individual Customer Access Network

@item ICAN
Integrated Composite Application Network (Seebeyond, Java)

@item ICANN
Internet Corporation for Assigned Names and Numbers (org., Internet, ICANN)

@item ICAP
Internet Calendar Access Protocol (TCP/IP, Lotus)

@item ICARA
International Conference on Autonomous Robots and Agents

@item ICAT
Interactive Code Analysis Tool [debugger] (IBM, Java)

@item ICC
Intelligent Communications Control

@item ICC
Intergrated Circuit Card (ICC)

@item ICC
International Color Committee (org., DTP)

@item ICC
International Conference on Communications (Konferenz)

@item ICC
Internode Communication Channel (SMP, Scalis)

@item ICC
Interrupt Controller Communications [bus] (PC)

@item ICCAD
International Conference on Computer Aided Design (IEEE, conference)

@item ICCB
Internet Control and Configuration Board (IAB, predecessor)

@item ICCC
InterClient Communication Convention (X-windows)

@item ICCC
International Conference on Computer Communication (Konferenz)

@item ICCC
International Council on Computer Communication (org.)

@item ICCCM
InterClient Communication Convention Manual (X-Windows)

@item ICCD
International Conference on Computer Design (IEEE, conference)

@item ICCI
International Conference on Computing and Information (Konferenz)

@item ICCIMA
International Conference on Computational Intelligence and Multimedia Applications (AI, conference)

@item ICCP
Inter Control Center Protocol (TASE)

@item ICCS
Integrated Communications Cabling System (SNI)

@item ICD
Installable Client Driver (OpenGL)

@item ICD
International Code Designator (ATM)

@item ICDA
Integrated Cached Disk-Arrays

@item ICDB
Integrated Communications DataBase (DB)

@item ICDCS
International Conference on Distributed Computing Systems (INRIA, IEEE-CS)

@item ICE
Image Correction Enhancement (Minolta, Nikon, Epson, Scanner)

@item ICE
In-Circuit-Emulation

@item ICE
Information and Content Exchange [protocol] (XML)

@item ICE
Insane Creator Enterprise, "iCE"

@item ICE
Internal Compiler Error (GCC)

@item ICF
Integrated Coupling Facility (IBM, PU)

@item ICF
International Cryptographic Framework (HP, cryptography)

@item ICH
I/O Controller Hub [aka Southbridge] (Intel, I/O, GMCH)

@item ICH
Intelligent Connection Handling (BIG)

@item ICI
Industrial Computing Initiative (LLNL, LANL, Cray, ..., HPC, MPP)

@item ICIA
International Communications Industries Association (org.)

@item ICIAI
International Communications Industries Association Inc. (org.)

@item ICIE
International Center for Information Ethics (org.)

@item ICIEA
IEEE Conference on Industrial Electronics and Applications (IEEE)

@item ICL
International Computers Limited (manufacturer, UK, USA, Japan, Fujitsu)

@item ICM
Image Color Matching (MS, Windows 95, API)

@item ICMB
Intelligent Chassis Management Bus (IPMI)

@item ICMC
International Computer Music Conference (fair)

@item ICMP
Internet Control Message Protocol [version 4] (TCP/IP, RFC 792, Internet)

@item ICMPV6
Internet Control Message Protocol Version 6 (Internet, IPV6, RFC 1885), "ICMPv6"

@item ICMX
Interface for Communications Manager uniX (Unix, CMX)

@item ICONZ
Internet Company Of New Zealand (org., Usenet)

@item ICOT
Institute for new generation COmputer Technology (org., Japan, FGCS)

@item ICP
Independent Content Provider (MSN)

@item ICP
Intelligent Computer Peripherals (manufacturer)

@item ICP
Interface Change Proposal

@item ICP
International Client Pack (MS)

@item ICP
Internet Caching Protocol (Internet)

@item ICPS
Image et Calcul Parallele de Scientifique (org., France, HPC)

@item ICPS
Informatique et Calcul Parallele de Strasbourg [old term] (org., France, HPC)

@item ICQ
[I seek you] (Internet, ICQ, IM)

@item ICR
Intelligent Character Recognition

@item ICRA
International Conference on Robotics and Automation

@item ICRA
Internet Content Rating Association (Internet, org., IBM, MS, AOL, ...)

@item ICRC
Invariant Cyclic Redundancy Check (Infiniband), "I-CRC"

@item ICS
IBM Cabling System

@item ICS
Ice Cream Sandwich (Android, OS)

@item ICS
International Classification for Standards (ISO)

@item ICS
Internet Connection Sharing (MS, IE, DHCP)

@item ICS
Irish Computer Society (org., Irland)

@item ICSC
Intelligent Channel/Storage Control, "IC/SC" 

@item ICSI
International Computer Science Institute (org., USA)

@item ICSP
In Circuit Serial Programming

@item ICSS
Internet Connection Secure Server (IBM, WWW)

@item ICST
International Conference on Sensing Technology

@item ICT
Image Constraint Token (DOT)

@item ICT
Information and Communication Technology

@item ICT
Information and Communications Technologies

@item ICT
Institute of Computing Technology (org., China)

@item ICTF
Internet Content Task Force (org., Internet)

@item ICTS
[Champion] Integrated Cached Tape Subsystem (EMC, AS/400)

@item ICU
Instruction Cache Unit (CPU, POWER)

@item ICU
Interactive Chart Utility (IBM, GDDM)

@item ICU
International Components for Unicode (IBM, API, Unicode)

@item ICU
ISA Configuration Utility (BIOS, PNP, ISA)

@item ICURYY
I see you are too wise (slang)

@item ID
IDentification

@item IDA
Interchange of Data between Administrations (org., Europe)

@item IDA
Interface for Distributed Automation (TCP/IP)

@item IDAC
Infobus Data Access Component (Lotus, Java)

@item IDAPI
Integrated Database API (DB, IBM, Novell, Borland, predecessor, BDE, API)

@item IDAS
Interchange DAta Structure

@item IDB
Integrated DataBase (DB)

@item IDBEF
Integrated DataBase Extract Format (IDB, DB)

@item IDBTF
Integrated DataBase Transaction Format (IDB, DB)

@item IDC
Inter-Device Communication (IBM, OS/2)

@item IDC
International Data Corporation

@item IDC
Internet Database Connector (MS, WWW)

@item IDCT
Inverse Discrete Cosine Transformation (DCT)

@item IDDD
International Direct Distance Dialing

@item IDE
Integrated Development Environment

@item IDE
Integrated Drive Electronics (HDD)

@item IDEA
International Data Encryption Algorithm (cryptography)

@item IDEA
Internet Design, Engineering, and Analysis notes (IETF)

@item IDEC
I Don't Even Care (slang, Usenet, IRC)

@item IDEF
Integrated [CAM] DEFinition (CAM)

@item IDES
International Demonstration and Education System (R/3, SAP)

@item IDES
Intrusion Detection Expert System (IBM, IDS, XPS)

@item IDF
Intel Developer Forum (Intel, conference)

@item IDF
International DOI Foundation (org., DOI)

@item IDG
International Data Group (org.)

@item IDI
Initial Domain Identifier (NSAP, IDP)

@item IDIS
Integrated Dealer and Importer System (MBAG)

@item IDL
Interactive Data Language (Research Systems)

@item IDL
Interface Definition Language (DCE, CORBA, Java)

@item IDLC
ISDN Data Link Control (ISDN)

@item IDLE
Integrated DeveLopment Environment (Python)

@item IDLE
International Date Line, East [+1200] (TZ)

@item IDLW
International Date Line, West [-1200] (TZ)

@item IDML
InDesign Markup Language

@item IDMR
Inter-Domain Multicast Routing (IETF, WG, Multicast)

@item IDMT
[Fraunhofer] Institut fuer Digitale MedienTechnologie (org.)

@item IDN
Integrated Digital Network

@item IDN
Internationalized Domain Names (Domain, Internet)

@item IDNA
Internationalized Domain Names in Applications (Domain, RFC 3490)

@item IDOC
Intermediate DOCuments (ALE, SAP)

@item IDOMENEUS
Information and Data on Open MEdia for NEtworks of USers (WWW, Uni Hamburg, Germany)

@item IDP
Initial Domain Part (NSAP)

@item IDP
Internal DisplayPort, "iDP"

@item IDP
Internet Datagram Protocol (XNS)

@item IDP
Intrusion Detection and Prevention (IDS)

@item IDQ
Instruction Decode Queue (Intel, CPU)

@item IDRC
Improved Data Recovery Capability (Datenkompression)

@item IDS
Information Delivery System

@item IDS
Informix Dynamic Server (Informix, DB)

@item IDS
Intelligent Decision Server (IBM)

@item IDS
Inter Data Systems [gmbh] (manufacturer)

@item IDS
Internal Directory System

@item IDS
Intrusion Detection System (IDS, IPS)

@item IDSA
Interactive Digital Software Association (org., Nintendo, Sony, MS, ...)

@item IDSS
Interoperability Decision Support System

@item IDT
Integrated Device Technology (manufacturer)

@item IDT
Interrupt Descriptor Table

@item IDTRC
Interrupt Descriptor Table Register Cache (IDT, CPU, Intel)

@item IDU
Interface Data Unit

@item IDUPGSSAPI
Independent Data Unit Protection Generic Security Service API (GSS, API), "IDUP-GSS-API"

@item IDV
Individuelle DatenVerarbeitung

@item IDVC
Integrated Data/Voice Channel

@item IE
Informal Exceptions (HDD, SCSI)

@item IE
Information Element (ATM, ISDN)

@item IE
Information Engineering

@item IEAAIE
[international conference on] Industrial and Engineering Applications of Artificial Intelligence and Expert systems (conference, ISAI, ..., AI), "IEA/AIE"

@item IEC
Inter-Exchange Carrier (AT&T, MCI, LEC)

@item IEC
International Electrotechnical Commission (org., Switzerland)

@item IECC
Informix Enterprise Command Center (Informix)

@item IED
Intelligent Electronic Device

@item IEDM
International Electron Device Meeting (Konferenz)

@item IEE
Institute of Electrical Engineers (org., UK)

@item IEEE
Institute of Electrical and Electronic Engineers (org., USA)

@item IEEECS
Institute of Electrical and Electronic Engineers - Computer Society (org., IEEE), "IEEE-CS"

@item IEEESA
Institute of Electrical and Electronic Engineers Standards Association (org., IEEE), "IEEE-SA"

@item IEEJ
Institute of Electrical Engineers of Japan (org., Japan)

@item IEF
Information Engineering Facility

@item IEICE
Institute of Electronics, Information and Communication Engineers (org., Japan)

@item IEMMC
Internet EMail Marketing Council (Internet, org., spam)

@item IEMSI
Interactive Electronic Mail Standard Identification

@item IEN
Internet Engineering Notes

@item IEN
Internet Experiment Notebook (predecessor, RFC)

@item IEPA
Individual Expert Participation Agreement (Sun)

@item IEPG
Internet Engineering and Planning Group (Internet, RFC 1690)

@item IEPRC
International Electronic Publishing Research Centre (org., PIRA)

@item IERAT
Instruction cache Effective to Real Address Translation [table] (Power4, IBM, CPU, ERAT)

@item IES
Integrated Engineering Station (Toshiba, TOSMAP-DS)

@item IES
Intelligent Emulation Switching (Epson)

@item IESE
[Fraunhofer] Institut fuer Experimentelles Software Engineering (org.)

@item IESF
International Esports Federation (org.), "IeSF"

@item IESG
Internet Engineering Steering Group (IETF)

@item IETF
Internet Engineering Task Force (org., IAB, Internet, RFC 1603/2418/3233)

@item IETFWG
Internet Engineering Task Force - Working Group (RFC 1603, IETF), "IETF-WG"

@item IETM
Interactive Electronic Technical Manual

@item IETS
Interim European Telecommunications Standards (GSM, mobile-systems)

@item IEW
Information Engineering Workbench (IBM)

@item IF
Information Flow (IN)

@item IFAC
International Federation for Automatic Control (org., Austria)

@item IFAD
Institute of Applied Computer Science (org., Denmark)

@item IFAR
Instruction Fetch Address Register (Power4, IBM, CPU)

@item IFC
Industry Foundation Classes (CAD)

@item IFC
InterFace Clear (GPIB)

@item IFC
Internet FAQ Consortium (Internet, FAQ, org.)

@item IFC
Internet Foundation Classes (ONE, Netscape, Java)

@item IFCM
Independent Flow Control Messages (SSP)

@item IFCP
Internet Fibre Channel Protocol (SAN, FC, IP), "iFCP"

@item IFD
Information Flow Diagram (IRM)

@item IFE
Internet Forum Europe (fair)

@item IFEO
Image File Execution Options (MS)

@item IFIOM
Intelligent FDDI Input Output Module (SMC, ES/1, FDDI)

@item IFIP
International Federation for Information Processing (org.)

@item IFL
Integrated Facility for Linux (IBM)

@item IFMP
Ipsilon Flow Management Protocol (IP, RFC 1953)

@item IFNA
International FidoNet Association (org., Fido)

@item IFP
Instruction Fetch Pipeline (Motorola, CPU)

@item IFR
Interleaved Frame Recording (video)

@item IFROSS
Institut fuer Rechtsfragen der Freien und Open Source Software Org., OSS, Germany, "ifrOSS"

@item IFS
ICOT Free Software (ICOT)

@item IFS
Installable File System (OS/2, DOS)

@item IFS
Intelligent Fax System (Ricoh)

@item IFS
InterFrame Space (MAC, 802.11a)

@item IFS
Internal Field Separator (Unix, AWK)

@item IFS
Internet File System (Oracle, DB, Internet)

@item IFX
Interactive Financial eXchange (USA, banking)

@item IGBT
Insulated Gate Bipolar Transistor (IC)

@item IGC
Institute for Global Communications (USA)

@item IGD
[Fraunhofer] Institut fuer Graphische Datenverarbeitung (org., Darmstadt, Germany)

@item IGD
Internet Gateway Device (Internet)

@item IGES
Initial Graphics Exchange Specification (ANSI, USA, CIM, CAD)

@item IGMP
Internet Group Management / Multicast Protocol (RFC 1112/2236, IP, Multicast)

@item IGN
IBM Global Network (network)

@item IGOS
Indonesia Goes Open Source [initiative] (OSS)

@item IGOSS
Industry/Government Open System Specification

@item IGP
Integrated Graphics Processor (IC, Nvidia)

@item IGP
Interior Gateway Protocol

@item IGRP
Interior Gateway Routing Protocol (IPX, Novell)

@item IGS
IBM Global Services (IBM)

@item IGZO
Indium Gallium Zinc Oxide (LCD)

@item IHS
Integrated Heat Spreader (CPU)

@item IHV
Independent Hardware Vendor

@item IIA
Information Industry Association (org.)

@item IIASA
International Institute for Applied Systems Analysis (org., Austria)

@item IIC
Industrial Internet Consortium (org.)

@item IICM
Institute for Information processing and Computer supported new Media (org., OEstereich)

@item IID
Interface IDentifier (COM)

@item IIF
Incoming InterFace (PIM, OIF, Multicast)

@item IIF
Internal Internegotiation Function (ETSI, ES 201671)

@item IIIR
Integration of Internet Information Resources (IETF)

@item IIIS
International Institute of Informatics and Systemics (org., USA)

@item IIL
Integrated Injection Logic

@item IIM
Internet Identified Mail (Cisco, SPAM)

@item IIN
Integrated Information Network

@item IIOP
Internet Inter-ORB Protocol (CORBA, Internet, ONE, GIOP, TCP/IP)

@item IIP
Interoperability Improvement Panel

@item IIR
Infinite Impulse Response (DSP)

@item IIRA
Industrial Internet Reference Architecture (IIC)

@item IIRC
If I Remember/Recall Correctly (Usenet, IRC, slang)

@item IIRWIIR
It Is Ready When It Is Ready (slang, IRC, Usenet)

@item IIS
[Fraunhofer] Institut fuer Integrierte Schaltungen (org.)

@item IIS
Intelligence Information System (mil.)

@item IIS
Internet Information Server / Services (MS)

@item IISP
Interim Inter-Switch Signaling Protocol (P-NNI, ATM)

@item IIT
Integrated Information Technology

@item IITC
Ingress Intel Total Conversion

@item IITF
Information Infrastructure Task Force (org., USA)

@item IIUC
If I Understand Correctly (slang, Usenet, IRC)

@item IJCAI
International Joint Committee / Conference on Artificial Intelligence (conference, org., AI)

@item IJG
Independent JPEG Group (org., JPEG)

@item IJH
Initial Java Heap (Java)

@item IJIE
International Journal of Information Ethics [old term] (ICIE)

@item IKD
Integrated Kernel Debugger (Linux)

@item IKE
IBM Kiosk for Education (IBM)

@item IKE
Internet Key Exchange [protocol] (IPSEC, IPV6)

@item IKP
Internet Keyed Payment [protocols] (IBM, WWW), "iKP"

@item IKT
Informations- und Kommunikationstechnik

@item IKWUM
I Know What You Mean (slang, Usenet, IRC)

@item IKYABWAI
I know You Are But What Am I? (slang, Usenet, IRC)

@item IL
Instruction List

@item IL32P64
Integer and Long 32 [bit], Pointer 64 [bit] (BIT)

@item ILEC
Independent Local Exchange Carrier

@item ILETS
International Law Enforcement Telecom Seminars (ETSI)

@item ILFA
Integrierte Logische Funktionen fuer Anwendungen (IWBS, Uni Karlsruhe, Germany, Uni Duisburg, Germany)

@item ILLIGAL
ILLinois Genetic Algorithm Laboratory (org., Uni Illinois, USA), "IlliGAL"

@item ILLINET
ILlinois LIbrary NETwork (network, USA)

@item ILM
Information Lifecycle Management (HSM)

@item ILMI
Interim Link / Local Management Interface (ATM)

@item ILO
Integrated Lights Out (HP, JAVA, BMC), "iLO"

@item ILP
Instruction Level Parallelism (CPU)

@item ILP32
Integer, Long and Pointer 32 [bit] (BIT)

@item ILPNET
[european] Inductive Logic Programming scientific NETwork

@item ILS
Intelligente LernSysteme

@item ILS
Internet Locator Service (MS)

@item ILSVRC
Imagenet Large Scale Visual Recognition Competition (ImageNet)

@item ILT
[Linux] Instructor Led Training (Linux, Caldera)

@item ILVU
InterLeaved Video Units (VOB, DVD, video)

@item IM
Information Management

@item IM
Instant Messaging (IM)

@item IM
Interface Module

@item IMA
Integrated Modular Avionics (Airbus, A380)

@item IMA
Interactive Multimedia Association (org.)

@item IMA
International MIDI Association (org.)

@item IMA
Internationalized e-Mail Address

@item IMAC
Isochronous Media Access Control (FDDI), "I-MAC"

@item IMACS
International Association for Mathematics and Computers in Simulation (org.)

@item IMAIL
Intelligent MAIL

@item IMAL
Integrated Media Architecture Laboratory (Bell, org., USA)

@item IMAO
In My Arrogant Opinion (slang, Usenet, IRC)

@item IMAP
Internet Message Access Protocol (RFC 2060)

@item IMAPI
Image Mastering Applications Programming Interface (API)

@item IMAV
IT Management Added Value (IT)

@item IMB
Intel Media Bench

@item IMC
Information Management and Communication (org., UK, Liverpool Hope University), "IM&C"

@item IMC
Information Management Concept

@item IMC
Information, Management und Consulting [GmbH] Germany

@item IMCC
InterMediate Code Compiler (PERL)

@item IMCO
In My Considered Opinion (slang, Usenet, IRC)

@item IMD
Integrated Management Display (Compaq)

@item IMD
Internet Multimedia Development (Internet)

@item IMDB
Internet Movie DataBase (Internet, WWW, DB), "IMDb"

@item IME
Input Method Editor (MS, Windows)

@item IMEI
International Mobile Equipment Identity (MS, GSM, mobile-systems)

@item IMFT
Intel Micron Flash Technologies (Intel, manufacturer)

@item IMG
IMplementation Guide (R/3, SAP)

@item IMHO
In My Humble Opinion (slang, Usenet, IRC)

@item IMIA
International Medical Informatics Association

@item IML
Initial Machine Load

@item IMLE
Intelligent Mechatronic Solution Elements (Uni Paderborn, Germany)

@item IMMD
Institut fuer Mathematische Maschinen und Datenverarbeitung (org., Uni Erlangen, Germany)

@item IMNSCO
In My Not So Considered Opinion (slang, Usenet, IRC)

@item IMNSHO
In My Not So Humble / Honest Opinion (slang, Usenet, IRC)

@item IMO
In My Opinion (slang, Usenet, IRC)

@item IMP
Interface Message Processors (ARPANET, MILNET)

@item IMPACT
Information Market Policy ACTions (ECHO)

@item IMPP
Instant Messaging and Presence Protocol (IETF, IM)

@item IMR
Information Management Representitive (IM)

@item IMR
Internet Monthly Report (Internet)

@item IMR
Interrupt Mask Register (IC)

@item IMS
[Fraunhofer] Institut fuer Mikroelektronische Schaltungen und systeme (org., Dresden, Germany)

@item IMS
Information Management System (IBM)

@item IMS
Integrated Management System

@item IMS
Integrated Measurement Systems [inc] (manufacturer)

@item IMS
Intelligent Manufacturing System (MITI)

@item IMS
International Meta Systems (manufacturer)

@item IMS
Internet Multimedia Subsystem (Internet, 3GPP)

@item IMS
IP Multimedia Subsystem (PoC, IP)

@item IMSESA
Information Management System/Enterprise Systems Architecture (IBM), "IMS/ESA"

@item IMSI
International Mobile Subscriber Identity (MM, GSM, mobile-systems)

@item IMSO
Integrated Micro Systems Operation (Intel)

@item IMSP
Internet Message Support Protocol (Internet)

@item IMSVS
Information Management System/Virtual Storage, "IMS/VS" 

@item IMT2000
International Mobile Telecommunications [at] 2000 [Mhz] (mobile-systems), "IMT-2000"

@item IMTC
International Multimedia Teleconferencing Consortium (org., MS, Intel, Apple, IBM, SNI, AT&T, ...)

@item IMU
Inertial Measurement Unit

@item IMUNE
Intrusion Mitigation Unified Network Engine (Symantec, IDS)

@item IMVP
Intel Mobile Voltage Positioning (Intel)

@item IMY
I Miss You (slang, Usenet, IRC)

@item IN
Individual Network [e.v.] (org., ISP)

@item IN
Intelligent Network (ITU-T, Q.1200)

@item INA
Intelligent Network Architecture (IN)

@item INAP
Intelligent Network Application Part / Protocol (IN, SS7)

@item INCITS
International Committee for Information Technology Standards (org., USA)

@item INCM
Intelligent Network Conceptual Model (IN)

@item INCORE
INternet COntent Rating for Europe (org., Internet)

@item INDC
[international conference on] Information Networks and Data Communication (IFIP, conference)

@item INDE
Integrated Native Developer Experience (Intel)

@item INET
International NETworking conference (Konferenz), "iNET" 

@item INGRES
INteractive Graphic REtrieval System

@item INHOPE
INternet HOtline Providers in Europe (org., ISP)

@item INL
Inter Node Link

@item INMS
Integrated Network Management System

@item INN
Inter Node Network

@item INNC
International Neural Network Conference (INNS, conference, NN)

@item INNS
International Neural Network Society (org., AI, NN)

@item INOC
Internet Network Operations Center

@item INPOL
INformationssystem der POLizei

@item INRIA
Institut National de Recherche en Informatique et Automatique (org., France)

@item INSITS
INternational Symposium on IT Standardization (conference, IFIP, GI)

@item INST
INformation Standards and technology Standardization

@item INTA
International Trademark Association (org.)

@item INTAP
Interoperability Technology Association for Information Processing (org.)

@item INTEL
INtegriertes TEileLogistiksystem (MBAG)

@item INTERNIC
Inter Network Information Center (org., Internet), "InterNIC"

@item INTP
INTercom Profile (Bluetooth), "IntP"

@item INX
INformation eXchange

@item INXS
INternet eXchange Service (ECRC)

@item IO
Input/Output, "I/O" 

@item IOAT
Input/Output Acceleration Technology (Intel, Xeon), "I/OAT"

@item IOC
Initial Operational Capability

@item IOC
Input / Output Controller

@item IOC
Input/Output Cluster (Cray, I/O)

@item IOCCC
International Obfuscated C Code Contest

@item IOCS
Input Output Control System (OS, IBM 7090)

@item IOCTA
Internet Organised Crime Threat Assessment (EC3)

@item IOCTL
I/O ConTroL (I/O)

@item IOM
Integrated Object Model

@item IOMMU
Input Output Memory Management Unit (AMD, Athlon)

@item ION
Internetworking Over NBMA (LIS, LAG, ATM, NBMA)

@item IONL
Internal Organization of the Network Layer (OSI)

@item IOOC
Integrated Optics and Optical fiber Communication (Konferenz)

@item IOP
Input / Output Processor

@item IOPL
Input Output Privilege Level

@item IOPLL
IO Phase Lock Loop (IO, Intel, CPU)

@item IOPS
Input Output Per Second

@item IOS
Internetworking Operating System (Cisco, OS)

@item IOS
InterOrganizational Systems

@item IOT
Index Organized Table (Oracle, DB)

@item IOT
Internet Of Things (Internet), "IoT"

@item IOTE
Initial Operational Test and Evaluation, "IOT & E"

@item IOTTMCO
Intuitively Obvious To The Most Casual Observer (slang, Usenet, IRC)

@item IOUG
International Oracle Users Group (org., DB, Oracle, user group)

@item IOW
In Other Words (telecommunication, Usenet, IRC)

@item IP
Information Provider

@item IP
Instruction Pointer [register] (CPU, Intel, assembler)

@item IP
Intellectual Property

@item IP
Intelligent Peripheral (IN)

@item IP
Intelligent Peripheral

@item IP
intercept Point

@item IP
Internet Protocol [version 4] (RFC 791)

@item IP16
Integer and Pointer 16 [bit] (BIT)

@item IPA
[Fraunhofer] Institut fuer Produktionstechnik und Automation (org., Stuttgart, Germany)

@item IPA
Information Processing promotion Agency (org., MITI, Japan)

@item IPAM
IP Address Management (IP, DNS)

@item IPC
Instructions Per Cycle (CPU)

@item IPC
Integrated Polymer Circuit (IC)

@item IPC
Internet Privacy Coalition (Internet)

@item IPC
InterProcess Communications [protocol]

@item IPCE
InterProcess Communication Environment

@item IPCP
[PPP] Internet Protocol Control Protocol (PPP, RFC 1332)

@item IPCR
International Conference on Pattern Recognition (conference, IAPR)

@item IPCS
Interactive Problem Control System

@item IPD
Intelligent Printer Data

@item IPDC
Internet Protocol Device Control (MGCP)

@item IPDS
IBM Personal Dictation System (IBM, voice processing)

@item IPDS
Intelligent Printer Data Stream (IBM, CCS)

@item IPDU
Internet Protocol Data Unit (PDU)

@item IPDVMRP
IP Distance Vector Multicast Routing Protocol (RFC 1075, IP, Multicast), "IP-DVMRP"

@item IPE
Integrated Programming Environment

@item IPES
Improved Proposed Encryption Standard (IDEA, PES, cryptography)

@item IPFC
Information Presentation Facility Compiler (IBM, OS/2)

@item IPFFS
IPod Free File Sync, "iPFFS"

@item IPFS
InterPlanetary File System (FS)

@item IPG
International Programmers Guild (org.)

@item IPG
InterPacket Gap (IPX, IP (???))

@item IPI
Intelligent Peripheral Interface [protocol]

@item IPI
Inter-Processor Interrupt (CPU, SMP)

@item IPL
IBM Public License

@item IPL
Initial Program Load

@item IPL
Ionenstrahl-ProjektionsLithographie

@item IPM
Impulses Per Minute

@item IPM
InterPersonal Messaging

@item IPM
Interruptions Per Minute

@item IPMB
Intelligent Platform Management Bus (IPMI, BMC)

@item IPMI
Intelligent Platform Management Interface (Intel, HP, DELL)

@item IPMS
InterPersonal Messaging System

@item IPN
Info Pool Network (ISP)

@item IPNG
Internet Protocol Next Generation (IP, RFC 1550/1752), "IPng"

@item IPOC
Interim Policy Oversight Committee (Internet, TLD)

@item IPP
Intel Primitive Performance [library] (Intel)

@item IPP
Internet Peering Point (Internet, IXP, ISP)

@item IPP
Internet Presence Provider (Internet)

@item IPP
Internet Printing Protocol (IBM, OS/400, RFC 2639/3196)

@item IPPM
Internet Protocol Performance Metrics (IP)

@item IPS
Inches Per Second

@item IPS
Information Processing Standards

@item IPS
InPlane Switching [technology] (LCD, Sony, Philips, NEC, Iiyama, Eizo, Dell, BenQ, Apple)

@item IPS
Intrusion Protection System (IDS)

@item IPSE
Integrated Programming Support Environment (CASE)

@item IPSEC
Internet Protocol SECurity (org., Internet, IETF, DES), "IPSec"

@item IPSJ
Information Processing Society of Japan (org., Japan)

@item IPSP
Internet Protocol Security Protocol

@item IPSP
IP Security Policy (IP, Internet, IPSec, RFC 3586)

@item IPTC
International Press Telecommunications Council (org.)

@item IPTD
[microsoft] Internet Platform and Tools Division (MS)

@item IPTO
Information Processing Techniques Office (ARPA)

@item IPTV
Internet Protocol TeleVision (IP)

@item IPU
Intelligent Processing Unit

@item IPU
ISDN-datex-P-Umsetzer

@item IPV6
Internet Protocol Version 6 (IP, RFC 1883/1884), IPv6

@item IPVR
Institut fuer Parallele und Verteilte Rechensysteme (org., Uni Stuttgart, Germany)

@item IPW
Incremental Packet Writing (CD-R)

@item IPX
Internet Packet eXchange (Novell, Netware)

@item IPXCP
[PPP] Internetwork Packet eXchange Control Protocol (PPP, RFC 1552)

@item IPXODI
IPX Open Datalink Interface (Novell, Netware)

@item IPXSPX
IPX / Sequenced Packet eXchange (Novell, Netware), "IPX/SPX"

@item IPXWAN
Internet Packet eXchange over various WAN media (Novell, IPX, WAN, RFC 1634)

@item IR
Information Retrieval

@item IR
Interface Repository (ORB)

@item IR
Internet Registry

@item IRC
InformationsRessourcen Controlling (IM)

@item IRC
Internet Relay Chat [protocol] (RFC 1459, Internet)

@item IRCS
Institute for Research in Cognitive Science (org., Uni Pennsylvania, USA)

@item IRD
Integrated Resource Director (IBM)

@item IRDA
InfraRed Data Association (org., manufacturer, IRDA), "IrDA" 

@item IRDP
ICMP Router Discovery Protocol (ICMP, RFC 1256)

@item IRDS
Information Resource Dictionary System (ANSI, ISO, IM)

@item IRF
Integer Register File (DEC, Alpha, CPU)

@item IRIE
International Review of Information Ethics (ICIE)

@item IRIS
Incident Response Intelligence Services (IBM)

@item IRIS
Institute for Robotics and Intelligent Systems (org., Canada)

@item IRIS
Internet Registry Information Service (XML, Internet)

@item IRL
In Real Life (slang, Usenet, IRC)

@item IRL
Industrial Robot Language (HLL)

@item IRLAN
InfraRed Local Area Network (IRDA, LAN, TTP), "IrLAN"

@item IRLAP
InfraRed Link Access Protocol (IRDA, IRLAP), "IrLAP"

@item IRLMP
InfraRed Link Management Protocol (IRDA, IRLAP), "IrLMP"

@item IRLMPTP
InfraRed Link Management Protocol/Transport Protocol (IRDA, IRLMP), "IrLMP/TP"

@item IRLPT
InfraRed Line PrinTer (IRDA, LPT, TTP), "IrLPT"

@item IRM
Information Resources Management

@item IRMX
Intel Real time Multitasking eXecutive (OS, Intel), "iRMX"

@item IROBEX
InfraRed OBject EXchange protocol (IRDA, TTP), "IrOBEX"

@item IRP
I/O Request Packet (I/O)

@item IRQ
Interrupt ReQuest

@item IRR
Interrupt Request Register (IC)

@item IRRE
Inline Relational Record Editing (TYPO3)

@item IRRP
Inter-Domain Routing Protocol (ISO 10747)

@item IRSG
Internet Research Steering Group (org., Internet)

@item IRT
Interrupt Response Time

@item IRTF
Internet Research Task Force (IAB, Internet)

@item IRTP
Internet Reliable Transaction Protocol (RFC 938)

@item IRTRANP
InfraRed TRANsfer Picture (IRDA)

@item IRV
International Reference Version [character set] (ISO, IS 646)

@item IS
Intermediate System (ATM)

@item IS
International Standard (ISO)

@item IS
International Supplement (ODT)

@item ISA
Industry Standard Architecture (PC)

@item ISA
Instruction Set Architecture (CPU)

@item ISA
Instrumentation, Systems, and Automation society (org.)

@item ISA
Integrated Systems Architecture (ESPRIT, ANSA)

@item ISA
Interactive Services Association (org., USA)

@item ISA
Internet Security and Acceleration server (MS, Firewall)

@item ISACA
Information Systems Audit and Control Association (org.)

@item ISADS
International Symposium on Autonomous Decentralized Systems (IEEE-CS, conference)

@item ISAGAT
Industry Standard Architecture - Guaranteed Access Time (ISA, DMA, PCI)

@item ISAKMP
Internet Security Association and Key Management Protocol

@item ISAM
Index-Sequential Access Mode (DB, SAM)

@item ISAPI
Internet Server Application Programmer's Interface (MS, C/S, WWW, API)

@item ISBN
International Standard Book Number

@item ISC
Intelligent Screen Cognition

@item ISC
International Supercomputer Conference

@item ISC
Internet Service Center (ISP)

@item ISC
Internet Software Consortium (org., Internet)

@item ISC2
International Information Systems Security Certification Consortium (org.)

@item ISCA
International Society for Computers and their Applications (org., AI)

@item ISCSI
Internet Small Computer Systems Interface (SCSI, SAN, IETF, RFC 3720/3721/3722), "iSCSI"

@item ISD
Integrated Sensor Device (Wacom, LCD)

@item ISD
Interface Summary Design

@item ISDBC
ISAM to SQL DataBase Connectivity (DB, ISAM, SQL)

@item ISDN
Integrated Services Digital Network (ITU)

@item ISDNUP
ISDN User Part (ISDN, GSM, mobile-systems), "ISDN-UP"

@item ISDV
Integrated Software Development and Verification

@item ISE
Instant Secure Erase (Seagate)

@item ISEE
Information System Engineering Environment (Westmount, CASE)

@item ISEE
Integrated Software Engineering Environment [reference model] (NIST, ECMA, CASE)

@item ISFUG
Integrated Software Federal User Group (org., user group)

@item ISH
Information SuperHighway

@item ISI
[Fraunhofer] Institut fuer Systemtechnik und Innovationsforschung (org.)

@item ISI
Information Sciences Institute (org., USA)

@item ISI
Information Society Initiative (UK)

@item ISIL
Internet Search Interface Language (Internet, Sherlock, Apple)

@item ISIS
Image and Scanner Interface Specification

@item ISIS
Industrial Signature Interoperability Specification (cryptography)

@item ISIS
Integrated Systems and Information Services (OS, Intel)

@item ISIS
Intermediate System to Intermediate System [protocol / routing] (OSI, RFC 1195), "IS-IS"

@item ISIT
[Fraunhofer] Institut fuer SiliziumTechnologie (org., Itzehoe, Germany), "ISiT"

@item ISKO
International Society for Knowledge Organisation (org.)

@item ISL
Inter-Switch Link (FC)

@item ISLM
Integrated Services Line Module

@item ISLN
Integrated Services Local Network

@item ISLU
Integrated Services Line Unit

@item ISM
Industrial, Science, Medical [ = 2,4 GHz ] (WLAN)

@item ISM
Intel Server Management (Intel)

@item ISM
InterSystems M (MUMPS, InterSytems)

@item ISMA
Internet Streaming Media Alliance (org., Internet, Apple, Cisco, IBM, Philips, ...)

@item ISML
Interface Specification Meta-Language

@item ISMS
Integrated Security Model for SNMP (SNMP)

@item ISMS
Inventory Sampling Measurememt System (CC)

@item ISN
Information Systems Network

@item ISN
Initial Segment / Sequence Number (TCP/IP)

@item ISN
Integrated Systems Network

@item ISN
Internet Shopping Network (network, WWW)

@item ISNS
Internet Storage Name Service (RFC 4171), "iSNS"

@item ISO
International Standards Organisation [International Organization for Standardization] (org.)

@item ISOBMFF
ISO Base Media File Format (ISO)

@item ISOC
Internet SOCiety (org., Internet)

@item ISODE
ISO Development Environment (OSI)

@item ISOE
ISCSI Offload Engine (ISCSI), "iSOE"

@item ISONET
ISO information NETwork (ISO, network)

@item ISP
Image Synthesis Processor (IC, graphics, TSP)

@item ISP
Integrated System Peripheral control (Wyse)

@item ISP
Interactive String Processor (BS2000)

@item ISP
International Standardized Profiles (ISO)

@item ISP
Internet Service Provider (Internet)

@item ISPA
Internet Service Provider Austria (org., ISP)

@item ISPA
Internet Services Providers' Association (org., UK)

@item ISPA
ISDN PAcket [driver] (ISDN)

@item ISPC
Internet Service Providers' Consortium (ISP, IPP, org.), "ISP/C"

@item ISPF
Interactive System Productivity Facility (IBM)

@item ISPN
International Standard Program Number

@item ISPO
Information Society Project Office [of the european commission] (org., Europe, ECHO)

@item ISPS
Instruction Set Processor Specifications (HDL)

@item ISQI
International Software Quality Institute (org.), "iSQI"

@item ISQL
Interactive Structured Query Language

@item ISR
Interrupt Service Register (IC)

@item ISR
Interrupt Service Request

@item ISR
Interrupt Service Routine

@item ISRC
International Standard Recording Code

@item ISS
Internet Security Systems (manufacturer)

@item ISSAC
International Symposium on Symbolic and Algebraic Computation (ACM, conference)

@item ISSCC
International Solid State Circuits Conference (Konferenz)

@item ISSE
Internet Streaming SIMD Extension (Intel, Pentium, Katmai, SIMD)

@item ISSN
Integrated Special Services Network

@item ISSN
International Standard Serial Number

@item ISSRE
International Symposium on Software Reliability Engineering (IEEE-CS, conference)

@item ISSS
Information Society Standardization System (CEN, org.)

@item ISST
[Fraunhofer] Institut fuer Software- und SystemTechnik (org., Dortmund, Germany)

@item IST
Immerse System Technology (VR)

@item IST
Indian Standard Time [+0530] (TZ)

@item IST
Initial System Test

@item IST
Intelligent Transportation System

@item ISTA
International Security Tuition Association (org.)

@item ISTM
It Seems To Me (telecommunication, Usenet, IRC)

@item ISTO
Information Science and Technology Office (org., DARPA)

@item ISTQB
International Software Testing Qualification Board (iSQI)

@item ISTR
I Seem To Recall / Remember (telecommunication, Usenet, IRC)

@item ISUP
Integrated Services User Part (ISDN)

@item ISV
Independent Software Vendor

@item ISV
Independent Solution Vendor (DEC)

@item ISV
Information Service Vendor

@item IT
Information Technology

@item IT
Iran Time [+0300] (TZ)

@item ITA
Interim Type Approval

@item ITAA
Information Technology Association of America (org., USA)

@item ITAC
Information Technology Association of Canada (org., Canada)

@item ITAF
International Teletext Art Festival

@item ITAM
Information Technology Asset Management

@item ITAN
Indizierte TransaktionsNummer (banking), "iTAN"

@item ITCM
Instruction Tightly Coupled Memory (IC)

@item ITE
InformationsTechnische Einrichtungen

@item ITESFA1EHS
Information Technology Enterprise Solutions - Function Area 1 - Enterprise Hardware Solutions (mil., USA), "ITES-FA1-EHS"

@item ITG
InformationsTechnische Gesellschaft (org., VDE)

@item ITIL
Information Technology Infrastructure Library (CCTA, OGC)

@item ITLB
Instruction Translation Look-aside Buffer (CPU)

@item ITM
Information Technology Management

@item ITMA
Information Technology Management Association (org., USA)

@item ITMS
Immediate check Truth Maintenance System (AI)

@item ITMS
ITunes Music Store (WWW), "iTMS"

@item ITOT
ISO Transport service on TCP/IP (ISO, TCP/IP, RFC 2126)

@item ITP
Intend / Intent To Package (slang, Cygwin)

@item ITP
Intent to Package (Linux, Debian)

@item ITR
International Telecommunication Regulations (ITU)

@item ITR
Internet Talk Radio (Internet)

@item ITRC
Information Technology Research Centre (org., Canada)

@item ITRON
Industrial TRON (TRON, OS)

@item ITRS
International Technology Roadmap for Semiconductors

@item ITS
Incompatible Time-sharing System (DEC)

@item ITS
International Telecommunications Society (org.)

@item ITSDN
Integrated Tactical/Strategic Data Network (mil., USA, network)

@item ITSEC
[european] Information Technology Security Evaluation Criteria (Europe)

@item ITSEM
Information Technology Security Evaluation Manual / Methodology (ITSEC)

@item ITSP
Internet Telephony Service Provider (Internet, CAT)

@item ITSPO
Information Technology Standards Program Office (org., USA)

@item ITT
International Telegraph and Telephone (org.)

@item ITTI
Information Technology Training Initiative (org., UK)

@item ITTM
Institut Telekomunikasi dan Teknologi Maklumat (org., Malaysia)

@item ITU
Information Transport Utility

@item ITU
International Telecommunications Union (org.)

@item ITUR
International Telecommunications Union - Radiocommunications sector (ITU, org.), "ITU-R"

@item ITUSA
Information Technology Users Standards Association (org., USA)

@item ITUT
ITU Telecommunications [standards group] (org., successorr, CCITT), "ITU-T"

@item ITUTSS
International Telecommunications Union Telecommunication Standards Sector (ITU)

@item ITW
In The Wild [viruses]

@item ITX
??? Technology eXtended [form factor]

@item ITYM
I Think You Meant (telecommunication, Usenet, IRC)

@item IU
Integer Unit (CPU)

@item IUCV
Inter-User Communications Vehicle (IBM, TCP/IP, API, VM/ESA, CP)

@item IUK
Informations- und Kommunikationstechnik, "IuK" 

@item IUKDG
Informations- Und KommunikationsDiensteGesetz telecommunication, Germany

@item IUMA
Internet Underground Music Archive (WWW)

@item IUP
Interim Update Package (3COM)

@item IUR
International User Requirements (ETSI, TS 101331)

@item IUT
Implementation Under Test

@item IUTSUT
Implementation Under Test - System Under Test, "IUT-SUT"

@item IV
InformationsVerarbeitung

@item IV
Initialisation Vector (cryptography)

@item IVA
International Voice Association (org.)

@item IVC
Integrated Visual Computing [architecture] (SGI)

@item IVDENIC
InteressenVerbund DEutsches Network Information Center (org., Internet), "IV-DENIC"

@item IVDLAN
Integrated Voice and Data Local Area Network

@item IVM
Internet Voice Messaging (Internet, RFC 4239)

@item IVR
Interactive Voice Response (CTI)

@item IVS
IBM Verkabelungs-System

@item IVS
Interactive Visualization Systems

@item IVTS
International Video Teleconferencing Service

@item IVW
Informationsgemeinschaft zur feststellung der Verbreitung von Werbetraegern [e. V.] (org.)

@item IWA
International Webmasters Association (org., WWW)

@item IWAM
Internet server Web Application Manager (MS, Windows, Internet)

@item IWBS
Institut fuer WissensBasierte Systeme (org., IBM)

@item IWC
Inside Wire Cable

@item IWF
InterWorking Function (IN, GSM, ...)

@item IWFM
It Works for Me (telecommunication, Usenet, IRC)

@item IWOP
Ingenic Wearable Open Platform

@item IWS
Intelligent Work-Station

@item IWT
International Workshop on Telematics (conference, IEEE-CS, SEE)

@item IWU
InterWorking Unit (IN)

@item IWV
ImpulsWahlVerfahren (MODEM)

@item IXA
Integrated Xseries Adapter [= Integrated xSeries Adapter] (IBM)

@item IXC
IntereXchange Carrier (FCC, LATA)

@item IXI
International X.25 Infrastructure (COSINE, CORDIS)

@item IXP
Internet eXchange Point (Internet, IPP, ISP)

@item IXS
Integrated Xseries Server [= Integrated xSeries Server] (IBM)

@item IYSWIM
If You See What I Mean (slang, Usenet, IRC)

@item IZM
[Fraunhofer] Institut fuer Zuverlaessigkeit und Mikrointegration (org., Berlin, Germany)

@end table

