/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import { createWalletDaemonWithClient } from "../harness/environments.js";

export async function runWalletDevExperimentsTest(t: GlobalTestState) {
  const w1 = await createWalletDaemonWithClient(t, {
    name: "w1",
    config: {
      testing: {
        devModeActive: true,
      },
    },
  });

  await w1.walletClient.call(WalletApiOperation.ApplyDevExperiment, {
    devExperimentUri: "taler://dev-experiment/insert-pending-refresh",
  });

  const txnResp = await w1.walletClient.call(
    WalletApiOperation.GetTransactions,
    {
      includeRefreshes: true,
    },
  );

  t.assertTrue(txnResp.transactions.length > 0);
}

runWalletDevExperimentsTest.suites = ["wallet"];
