/*
  This file is part of TALER
  Copyright (C) 2014-2017 Inria & GNUnet e.V.

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 *
 */
#ifndef SYNC_DB_LIB_H
#define SYNC_DB_LIB_H

#include <taler/taler_util.h>
#include "sync_database_plugin.h"

/**
 * Initialize the plugin.
 *
 * @param cfg configuration to use
 * @return NULL on failure
 */
struct SYNC_DatabasePlugin *
SYNC_DB_plugin_load (const struct GNUNET_CONFIGURATION_Handle *cfg);


/**
 * Shutdown the plugin.
 *
 * @param[in] plugin plugin to unload
 */
void
SYNC_DB_plugin_unload (struct SYNC_DatabasePlugin *plugin);


#endif  /* SYNC_DB_LIB_H */

/* end of sync_database_lib.h */
