/*
** Copyright (C) 1999, 2000, 2002 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// factory for HTML generators

#ifndef HTMLGENERATORFACTORY_H
#define HTMLGENERATORFACTORY_H

#include "generatorfactory.h"

class HtmlGeneratorFactory : public GeneratorFactory
{
 protected:
  virtual TextDecorator *createBoldDecorator(TextGenerator *);
  virtual TextDecorator *createItalicDecorator(TextGenerator *);
  virtual TextDecorator *createUnderlineDecorator(TextGenerator *);
  virtual TextDecorator *createColorDecorator(TextGenerator *, char *color);

  virtual CharTranslator *createCharTranslator();

 public:
  HtmlGeneratorFactory(bool line_number);
};

#endif // HTMLGENERATORFACTORY_H
