/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// htmlgeneratorfactory.cc

#include "escgeneratorfactory.h"

#include "chartranslator.h"
#include "escdecorator.h"
#include "colors.h"
#include "colormap.h"

EscGeneratorFactory::EscGeneratorFactory(bool line_number) :
  GeneratorFactory (line_number)
{
}

// if it is another EscDecorator then enrich its face
// otherwise create a new one
TextGenerator *
EscGeneratorFactory::merge(TextGenerator *gen, const string &face)
{
  EscDecorator *esc_dec = dynamic_cast<EscDecorator *>(gen);

  if (esc_dec)
    {
      esc_dec->enrich_face (face);
      return esc_dec;
    }
  else
    return new EscDecorator( gen, char_translator, face ) ;
}

TextGenerator *
EscGeneratorFactory::createBoldDecorator(TextGenerator *gen)
{
  return merge( gen, "01" ) ;
}

TextGenerator *
EscGeneratorFactory::createItalicDecorator(TextGenerator *gen)
{
  // seems to be no code for italics
  // TODO: generate a warning?
  return gen ;
}

TextGenerator *
EscGeneratorFactory::createUnderlineDecorator(TextGenerator *gen)
{
  return merge( gen, "04" ) ;
}

TextGenerator *
EscGeneratorFactory::createColorDecorator(TextGenerator *gen, const string &color)
{
  return merge( gen, color ) ;
}

CharTranslator *
EscGeneratorFactory::createCharTranslator()
{
  return new CharTranslator ();
}

ColorMap *
EscGeneratorFactory::createColorMap()
{
  ColorMap *cm = new ColorMap;

  (*cm)[ GREEN ] = "32";
  (*cm)[ RED ] = "31";
  (*cm)[ DARKRED ] = "31";
  (*cm)[ BLUE ] = "34";
  (*cm)[ BROWN ] = "31";
  (*cm)[ YELLOW ] = "33";
  (*cm)[ CYAN ] = "36";
  (*cm)[ PURPLE ] = "35";
  (*cm)[ PINK ] = "35";
  (*cm)[ ORANGE ] = "31";
  (*cm)[ BRIGHTORANGE ] = "31";
  (*cm)[ BRIGHTGREEN ] = "32";
  (*cm)[ DARKGREEN ] = "32";
  (*cm)[ BLACK ] = "30";
  (*cm)[ TEAL ] = "37";
  (*cm)[ GRAY ] = "37";
  (*cm)[ DARKBLUE ] = "34";

  cm->setDefault ("30;");

  return cm;
}
