# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004, 2005  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__exercise_data__ = {
    'exercise_name': 'example',
    'stock-icon': 'solfege-icon',
    'menupath': '/Menubar/FileMenu/JunkMenu',
    'name': _("_Example exercise"),
}
import exercise_setup
exercise_setup.register_exercise(__exercise_data__)

import gtk, gnome.ui, gobject
import abstract, const, gu, mpd, soundcard
import random
import cfg

class Teacher(abstract.Teacher):
    exercise_data = __exercise_data__
    OK = 0
    ERR_PICKY = 1
    ERR_NO_QUESTION_LEFT = 2
    def __init__(self, exname, app, config):
        abstract.Teacher.__init__(self, exname, app, config)
    def new_question(self):
        """
        The Gui call this method to get a new question.
        The return value should say if there are any more questions.
        """
        if self.m_timeout_handle:
            gobject.source_remove(self.m_timeout_handle)
            self.m_timeout_handle = None

        if self.get_bool('config/picky_on_new_question') \
                 and self.q_status in [const.QSTATUS_NEW, const.QSTATUS_WRONG]:
            return Teacher.ERR_PICKY

        self.q_status = const.QSTATUS_NO

        return Teacher.ERR_NO_QUESTION_LEFT
    def play_question(self):
        if self.q_status == const.QSTATUS_NO:
            return
        # Do whatever to play the question
    def guess_answer(self, a):
        """
        a is the answer from the user. Return True if correct, False if wrong.
        """
        assert self.q_status in [const.QSTATUS_NEW, const.QSTATUS_WRONG]


class Gui(abstract.Gui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window)
        # Fill the gui used to practise into self.practise_box
        hbox = gu.bHBox(self.practise_box, False)
        self.g_flashbar = gu.FlashBar()
        self.practise_box.pack_start(self.g_flashbar, False, False)
        # action area
        self.g_new = gu.bButton(self.action_area, _("_New"), self.new_question)
        self.g_repeat = gu.bButton(self.action_area, _("_Repeat"), self.repeat_question)
        self.g_repeat.set_sensitive(False)
        self.g_show = gu.bButton(self.action_area, _("_Give up"), self.give_up)
        self.g_show.set_sensitive(False)

        self.practise_box.show_all()
        ##############
        # config_box #
        ##############
        # self.config_box h
    def new_question(self, widget=None):
        g = self.m_t.new_question()
        if g == Teacher.OK:
            self.g_repeat.set_sensitive(True)
            self.g_new.set_sensitive(
               not self.get_bool('config/picky_on_new_question'))
            self.m_t.play_question()
        elif g == Teacher.ERR_PICKY:
            self.g_flashbar.flash(_("You have to solve this question first."))
        else:
            assert g == Teacher.ERR_NO_QUESTION_LEFT
            self.g_repeat.set_sensitive(False)
            self.g_flashbar.flash(_("You have to configure this exercise properly"))
    def repeat_question(self, *w):
        self.m_t.play_question()
    def on_start_practise(self):
        self.g_flashbar.flash(_("Click 'New' to begin."))
        self.g_new.grab_focus()
    def on_end_practise(self):
        self.m_t.end_practise()
        self.g_new.set_sensitive(True)
        self.g_repeat.set_sensitive(False)
        self.g_show.set_sensitive(False)
    def give_up(self, widget=None):
        if self.m_t.q_status == const.QSTATUS_NO:
            return
        self.m_t.q_status = const.QSTATUS_SOLVED
        self.g_new.set_sensitive(True)
        self.g_new.grab_focus()
        self.g_show.set_sensitive(False)

