/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1995/01/17 - 1995/03/14 by Erik Schnetter
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <alloca.h>
#include "header.h"



INT X_StandardColormap_size (void)
{ return (sizeof(XStandardColormap)+sizeof(INT)-1)/sizeof(INT); }



void X_StandardColormap_colormap_set (XStandardColormap* standard_colormap, INT colormap)
{ standard_colormap->colormap = colormap; }

void X_StandardColormap_red_max_set (XStandardColormap* standard_colormap, INT red_max)
{ standard_colormap->red_max = red_max; }

void X_StandardColormap_red_mult_set (XStandardColormap* standard_colormap, INT red_mult)
{ standard_colormap->red_mult = red_mult; }

void X_StandardColormap_green_max_set (XStandardColormap* standard_colormap, INT green_max)
{ standard_colormap->green_max = green_max; }

void X_StandardColormap_green_mult_set (XStandardColormap* standard_colormap, INT green_mult)
{ standard_colormap->green_mult = green_mult; }

void X_StandardColormap_blue_max_set (XStandardColormap* standard_colormap, INT blue_max)
{ standard_colormap->blue_max = blue_max; }

void X_StandardColormap_blue_mult_set (XStandardColormap* standard_colormap, INT blue_mult)
{ standard_colormap->blue_mult = blue_mult; }

void X_StandardColormap_base_pixel_set (XStandardColormap* standard_colormap, INT base_pixel)
{ standard_colormap->base_pixel = base_pixel; }

void X_StandardColormap_visualid_set (XStandardColormap* standard_colormap, INT visualid)
{ standard_colormap->visualid = visualid; }

void X_StandardColormap_killid_set (XStandardColormap* standard_colormap, INT killid)
{ standard_colormap->killid = killid; }



INT X_StandardColormap_colormap_get (XStandardColormap* standard_colormap)
{ return standard_colormap->colormap; }

INT X_StandardColormap_red_max_get (XStandardColormap* standard_colormap)
{ return standard_colormap->red_max; }

INT X_StandardColormap_red_mult_get (XStandardColormap* standard_colormap)
{ return standard_colormap->red_mult; }

INT X_StandardColormap_green_max_get (XStandardColormap* standard_colormap)
{ return standard_colormap->green_max; }

INT X_StandardColormap_green_mult_get (XStandardColormap* standard_colormap)
{ return standard_colormap->green_mult; }

INT X_StandardColormap_blue_max_get (XStandardColormap* standard_colormap)
{ return standard_colormap->blue_max; }

INT X_StandardColormap_blue_mult_get (XStandardColormap* standard_colormap)
{ return standard_colormap->blue_mult; }

INT X_StandardColormap_base_pixel_get (XStandardColormap* standard_colormap)
{ return standard_colormap->base_pixel; }

INT X_StandardColormap_visualid_get (XStandardColormap* standard_colormap)
{ return standard_colormap->visualid; }

INT X_StandardColormap_killid_get (XStandardColormap* standard_colormap)
{ return standard_colormap->killid; }



void X_SetRGBColormaps (Display* display, INT w, INT* ints, INT count,
			INT property)
{
  XStandardColormap* stdcmap =
    (XStandardColormap*) alloca (count * sizeof(XStandardColormap));
  int i;
  for (i=count; i--;) {
    stdcmap[i].colormap   = ints[  i*10];
    stdcmap[i].red_max    = ints[1+i*10];
    stdcmap[i].red_mult   = ints[2+i*10];
    stdcmap[i].green_max  = ints[3+i*10];
    stdcmap[i].green_mult = ints[4+i*10];
    stdcmap[i].blue_max   = ints[5+i*10];
    stdcmap[i].blue_mult  = ints[6+i*10];
    stdcmap[i].base_pixel = ints[7+i*10];
    stdcmap[i].visualid   = ints[8+i*10];
    stdcmap[i].killid     = ints[9+i*10];
  }
  XSetRGBColormaps (display, w, stdcmap, count, property);
}



INT X_GetRGBColormaps_first (Display* display, INT w, INT* count,
			     XStandardColormap** stdcmap, INT property)
{
  Status res;
  int count_ret;
  res = XGetRGBColormaps (display, w, stdcmap, &count_ret, property);
  *count = count_ret;
  return res;
}

void X_GetRGBColormaps_last (INT* ints, INT count, XStandardColormap* stdcmap)
{
  int i;
  for (i=count; i--;) {
    ints[  i*10] = stdcmap[i].colormap;
    ints[1+i*10] = stdcmap[i].red_max;
    ints[2+i*10] = stdcmap[i].red_mult;
    ints[3+i*10] = stdcmap[i].green_max;
    ints[4+i*10] = stdcmap[i].green_mult;
    ints[5+i*10] = stdcmap[i].blue_max;
    ints[6+i*10] = stdcmap[i].blue_mult;
    ints[7+i*10] = stdcmap[i].base_pixel;
    ints[8+i*10] = stdcmap[i].visualid;
    ints[9+i*10] = stdcmap[i].killid;
  }
}
