/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

#include "events.h"
#include "Types.h"
#include "ithreads.h"

int main(int argc, char *argv[])
{

	UInt32 priority, loopvar, priority_mark;
  	TNPTR me;
 
	GC_init();

	Initialize_Threads();

	init_events();

	if (argc > 1 && (strcmp(argv[1], "-nostart") == 0)) {
		initialize_networking(false);
		register_with_boot_processor(argc, argv);
	} else
		initialize_networking(true);

	Main();

	/* Now we use our bastardized version of Thread_Closing to
     	close this thread */

  	me = PQH(DEFAULT_PRIORITY);
  
  	if (PQH(DEFAULT_PRIORITY)->previous == NULL) {
    		PQH(DEFAULT_PRIORITY) = PQT(DEFAULT_PRIORITY) = NULL;
  	} else {
    		/* Make the next thread, the head of the queue */
    		PQH(DEFAULT_PRIORITY) -> previous -> next = 0;
    		PQH(DEFAULT_PRIORITY) = PQH(DEFAULT_PRIORITY)->previous;
  		}

	/* We dont queue the main thread for termination, as
     	it is a system allocated stack etc. */
  
  /* Half-Schedule */

  priority_mark = -1;

  for (loopvar = 0; loopvar < PRIORITY_LEVELS; loopvar++) {
    
    if (PQH(loopvar) != NULL) {
      priority_mark = loopvar;
      loopvar = PRIORITY_LEVELS; /* Get us out of here */
    }
    
  }
  
  Load_Context(PQH(priority_mark)->save_area_base);

}
