#!/bin/sh
#  shell script to help automate genration of lexer parser files (OBSOLETE)
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

VER=5.1
BUGFIX=0
TEST_DIR=testing7
CC="cc" # -DDMALLOC -DDMALLOC_FUNC_CHECK"

#FLEX="/usr/user1/capadvt/BIN/flex -Cfa -s"
FLEX="flex -Cfa -s"
#FLEX="/usr/user1/capadvt/BIN/flex -Cfa -s"
#YACC="/usr/bin/byacc"
#YACC="/usr/user1/capadvt/BIN/bison"
YACC="bison"
MV="mv"


#echo "${CC}"
ARCH=`uname`
#echo "${ARCH}"
# have to put " around the multiple line string

PAR_OBJ="${ARCH}/capaCommon.o ${ARCH}/capaLexerFun.o \
          ${ARCH}/capaParserFun.o ${ARCH}/capaFunction.o ${ARCH}/capaParserUtils.o \
          ${ARCH}/capaMapExpr.o ${ARCH}/capaUnit.o ${ARCH}/com.o ${ARCH}/linpack.o ${ARCH}/ranlib.o \
          ${ARCH}/capaCgiUtils.o ${ARCH}/capaRQO.o ${ARCH}/capaFormulaLexer.o  ${ARCH}/capaFormulaParser.o \
          ${ARCH}/capaSubjective.o"

#echo "OBJ:${PAR_OBJ}"


prefix="" 
CCFLAG="-g -DUSE_DYNAMIC_SYMBOLS"

PLIBS="-ll -lm -lcurses -ltermcap"



if [ ${ARCH} = "AIX" ]
then 
CCFLAG="-O3 -DAIX"
fi

if [ ${ARCH} = "OSF1" ]
then 
#CCFLAG="-O3 -Olimit 1024 -DUSE_DYNAMIC_SYMBOLS -DUSE_DYNAMIC_LEXBUFS"
CCFLAG="-O3 -Olimit 2048 -DUSE_DYNAMIC_SYMBOLS -DCAPA_VER=\"${VER}.${BUGFIX}\" -DCOMPILE_DATE=\"`date +'%b-%d-%Y'`\""
fi

if [ ${ARCH} = "NEXTSTEP" ]
then 
CCFLAG="-arch i386 -arch m68k"
fi

if [ ${ARCH} = "SunOS" ]
then 
CCFLAG="-xO3"
fi

if [ ${ARCH} = "HP-UX" ]
then 
CCFLAG="-O -Ae -Dhpux"
fi

if [ ${ARCH} = "IRIX" ]
then 
CCFLAG="-O2 -DIRIX"
fi


# echo "ALL: $*"
# echo "ONE: $1"
# echo "TWO: $2"

compileUnits()
{

  ofile="${ARCH}/capaUnit.o" 
  cfile="capaUnit.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

lexCAPA()
{
  echo "${FLEX} capaLexerDef.flex"
#
  ${FLEX} capaLexerDef.flex

  echo "mv lex.yy.c capaLexerFun.c"
  mv lex.yy.c capaLexerFun.c
  
  ofile="${ARCH}/capaLexerFun.o" 
  cfile="capaLexerFun.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

lexCAPAdmalloc()
{
  echo "${FLEX} capaLexerDef.flex"
#
  ${FLEX} capaLexerDef.flex

  echo "mv lex.yy.c capaLexerFun.c"
  mv lex.yy.c capaLexerFun.c
  
  ofile="${ARCH}/capaLexerFun.o" 
  cfile="capaLexerFun.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

lexdbug()
{
  echo "${FLEX} capaLexerDef.flex"
#
  ${FLEX} capaLexerDef.flex

  echo "mv lex.yy.c capaLexerFun.c"
  mv lex.yy.c capaLexerFun.c
  
  ofile="${ARCH}/capaLexerFun.o" 
  cfile="capaLexerFun.c"
  cmd="${CC} $CCFLAG -DLEX_DBUG  -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

yaccCAPA()
{
  echo "${YACC} capaGrammarDef.y 
#  -ocapaParserFun.c"
#
  ${YACC} -d capaGrammarDef.y 
  # mv  y.tab.c capaParserFun.c
  echo "mv capaGrammarDef.tab.c capaParserFun.c"
  mv  capaGrammarDef.tab.c capaParserFun.c
  
  ofile="${ARCH}/capaParserFun.o" 
  cfile="capaParserFun.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

yaccCAPAdmalloc()
{
  echo "${YACC} capaGrammarDef.y 
#  -ocapaParserFun.c"
#
  ${YACC} -d capaGrammarDef.y 
  echo "mv y.tab.c capaParserFun.c"
  mv  y.tab.c capaParserFun.c
  
  ofile="${ARCH}/capaParserFun.o" 
  cfile="capaParserFun.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

yaccdbug()
{
  echo "${YACC} capaGrammarDef.y -ocapaParserFun.c"
#
  ${YACC} -d capaGrammarDef.y 

#-ocapaParserFun.c
  
#  echo "mv y.tab.c capaParserFun.c"
#  mv  y.tab.c capaParserFun.c
#  echo "mv y.tab.h capaToken.h"
#  mv y.tab.h capaToken.h

  echo "mv capaGrammarDef.tab.c capaParserFun.c"
  mv  capaGrammarDef.tab.c capaParserFun.c
  
  ofile="${ARCH}/capaParserFun.o" 
  cfile="capaParserFun.c"
  cmd="${CC} $CCFLAG -DYACC_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

formulaParser()
{

  echo "${YACC} -p fml_ -d capaFormula.y"
  ${YACC} -b fma -p fml_  -d capaFormula.y

  echo "MV fma.tab.c  capaFormulaParser.c"
  echo "MV fma.tab.h  capaFormula.h"
  
  ${MV} fma.tab.c  capaFormulaParser.c
  ${MV} fma.tab.h  capaFormula.h
  
  ofile="${ARCH}/capaFormulaParser.o" 
  cfile="capaFormulaParser.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
  
}

formulaDbug()
{

  echo "YACC -p fml_ -d capaFormula.y"
  ${YACC} -b fma -p fml_  -d capaFormula.y

  echo "MV fma.tab.c  capaFormulaParser.c"
  echo "MV fma.tab.h  capaFormula.h"
  
  ${MV} fma.tab.c  capaFormulaParser.c
  ${MV} fma.tab.h  capaFormula.h
  
  ofile="${ARCH}/capaFormulaParser.o" 
  cfile="capaFormulaParser.c"
  cmd="${CC} $CCFLAG -DFML_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd

  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}



symboldbug()
{
  echo "${YACC} capaGrammarDef.y "
#
  ${YACC} capaGrammarDef.y 

  echo "mv y.tab.c capaParserFun.c"
#
  mv  y.tab.c capaParserFun.c
  
  ofile="${ARCH}/capaParserFun.o" 
  cfile="capaParserFun.c"
  cmd="${CC} $CCFLAG -DSYMBOL_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd
  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG -DSYMBOL_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd
#  ofile="${ARCH}/capaFunction.o" 
#  cfile="capaFunction.c"
#  cmd="${CC} $CCFLAG -DSYMBOL_DBUG -c $cfile -o $ofile"
#  echo $cmd
#  $cmd
}

dynamicsymbol()
{
  echo "${FLEX} capaLexerDef.flex"
#
  ${FLEX} capaLexerDef.flex

  echo "mv lex.yy.c capaLexerFun.c"
#
  mv lex.yy.c capaLexerFun.c
  
  ofile="${ARCH}/capaLexerFun.o" 
  cfile="capaLexerFun.c"
  cmd="${CC} $CCFLAG -DUSE_DYNAMIC_SYMBOLS -c $cfile -o $ofile"
  echo $cmd
  $cmd
  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG -DUSE_DYNAMIC_SYMBOLS -c $cfile -o $ofile"
  echo $cmd
  $cmd
  ofile="${ARCH}/capaCommon.o" 
  cfile="capaCommon.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

arraysymbol()
{
  echo "${FLEX} capaLexerDef.flex"
#
  ${FLEX} capaLexerDef.flex

  echo "mv lex.yy.c capaLexerFun.c"
#
  mv lex.yy.c capaLexerFun.c
  
  ofile="${ARCH}/capaLexerFun.o" 
  cfile="capaLexerFun.c"
  cmd="${CC} $CCFLAG  -c $cfile -o $ofile"
  echo $cmd
  $cmd
  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG  -c $cfile -o $ofile"
  echo $cmd
  $cmd
  ofile="${ARCH}/capaCommon.o" 
  cfile="capaCommon.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

CAPAParserUtilsdbug()
{
  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG -DPARSER_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

Ranlib()
{
  ofile="${ARCH}/ranlib.o" 
  cfile="ranlib.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

CAPAParserUtils()
{
  ofile="${ARCH}/capaParserUtils.o" 
  cfile="capaParserUtils.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}

CAPAFunction()
{
  ofile="${ARCH}/capaFunction.o" 
  cfile="capaFunction.c"
  cmd="${CC} $CCFLAG -c $cfile -o $ofile"
  echo $cmd
  $cmd
}
createCAPAlib()
{

if [ -f ${ARCH}/libcapa${VER}.a ]
then 
rm ${ARCH}/libcapa${VER}.a 
fi

echo "ar q ${ARCH}/libcapa${VER}.a ${PAR_OBJ}"

ar q ${ARCH}/libcapa${VER}.a ${PAR_OBJ}

}

compileLexTest()
{
if [ -f ${TEST_DIR}/testL ]
then 
rm  ${TEST_DIR}/testL
fi

(cd ${TEST_DIR}; make testL)

}

compileParseTest()
{
if [ -f ${TEST_DIR}/testP ]
then 
rm  ${TEST_DIR}/testP
fi

(cd ${TEST_DIR}; make testP)

}

compileParseTestDmalloc()
{
if [ -f ${TEST_DIR}/testP ]
then 
rm  ${TEST_DIR}/testP
fi

(cd ${TEST_DIR}; make testPdmalloc)

}

compileLoginTest()
{
if [ -f ${TEST_DIR}/testLogin ]
then 
rm  ${TEST_DIR}/testLogin
fi

  ofile="${ARCH}/capaLoginTest.o" 
  cfile="capalogin.c"
  cmd="${CC} $CCFLAG -DLOGIN_DBUG -c $cfile -o $ofile"
  echo $cmd
  $cmd
  
  cmd="${CC} $CCFLAG -Wall ${ARCH}/libcapa${VER}.a $ofile -L${ARCH} -lcapa${VER} ${PLIBS} -o ${TEST_DIR}/testLogin"
  echo $cmd
  $cmd
  
}

compileFormulaTest()
{
if [ -f ${TEST_DIR}/testFormula ]
then 
rm  ${TEST_DIR}/testFormula
fi

  ofile="${ARCH}/capaTestFormula.o" 
  cfile="${TEST_DIR}/tformula_main.c"
  cmd="${CC} $CCFLAG -DLOGIN_DBUG -I. -I.. -c $cfile -o $ofile"
  echo $cmd
  $cmd
  
  cmd="${CC} $CCFLAG ${ARCH}/libcapa${VER}.a $ofile -L${ARCH} -lcapa${VER} ${PLIBS} -o
  ${TEST_DIR}/testFormula"
  echo $cmd
  $cmd
  
}

for i in $* ; do
  case "$i" in 
      *FP)
          formulaParser
        ;;
      *LD)
          lexCAPAdmalloc
        ;;
      *X|*x)
          lexdbug
        ;;
      *L|*l)
          lexCAPA
        ;;
      *P|*p)
          yaccdbug
        ;;
      *Y|*y)
          yaccCAPA
        ;;
      *R|*r)
          Ranlib
        ;;
      *PD)
          CAPAParserUtilsdbug
        ;;
      *PU|*pu)
          CAPAParserUtils
        ;;
      *SS)
          symboldbug 
        ;;
      *DS)
          dynamicsymbol 
        ;;
      *AS)
          arraysymbol 
        ;;
      *D)
          formulaDbug 
        ;;
      *F|*f)
          CAPAFunction
        ;;
      *lib|*Lib)
          createCAPAlib
        ;;
      *PT|*pt)
          compileParseTest
        ;;
  esac
done

exit 0

