/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include <string>
#include "Serializer.h"
#include "JSON.h"
class Player
{
public:
	enum PLAYERTYPE
	{
		HUMAN,
		COMPUTER
	};
	Player(std::string name="a",PLAYERTYPE pp=HUMAN);

	~Player(void);
	std::string getName();
	void setName(std::string);
	void setType(PLAYERTYPE);
	PLAYERTYPE getType();
	bool hasLost();
	void setLost(bool );
	std::string generateJson();
	static Player *createFromNode(json_parser::Object* my_object);
	friend std::istream& operator>> (std::istream& out, Player& per);
	friend std::ostream& operator<< (std::ostream& out, Player& per);
	friend Serializer& operator>> (Serializer& out, Player& per);
	friend Serializer& operator<< (Serializer& out, Player& per);
	
protected:
	std::string name_;
	PLAYERTYPE type_;
	bool hasLost_;
};

