/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <config.h>

#ifdef HAVE_LIBX11

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xinit.h"
#include "xwin.h"
#include "map.h"
#include "occupy.h"

extern Window main_win;
extern Window but_win[NBUTS];
extern Window map_win;
extern Window turn_win;
extern Cursor active_cursor, disabled_cursor;

extern Display *display;
extern int screen_num;

static int check_uses_def_mode (void);
static void resolve_map_mouse (const XEvent);

static int
check_uses_def_mode ()
{
  register int i;
  for (i = 0; i < 5; i++)
    if (db_val_tab.mouse[i] == act)
      return 1;
  return 0;
}

static void
resolve_map_mouse (report)
     const XEvent report;
{
  enum mouse_action button_action;
  /* Unfortunately we can't be sure of the internal representation of
     button field, therefore this is unnecessarily ugly.  */
  switch (report.xbutton.button)
    {
    case Button1:
      button_action = db_val_tab.mouse[0];
      break;
    case Button2:
      button_action = db_val_tab.mouse[1];
      break;
    case Button3:
      button_action = db_val_tab.mouse[2];
      break;
    case Button4:
      button_action = db_val_tab.mouse[3];
      break;
    case Button5:
      button_action = db_val_tab.mouse[4];
      break;
    }
  switch (button_action)
    {
      Action map_events;
      Coord coord;
    case mark:
      coord = win_pos2map_coord (report.xbutton.x, report.xbutton.y);
      if (toggle_cross (coord))
	{
	  draw_map (report.xbutton.x, report.xbutton.y, 0, 0);
	  update_cross_win (0);
	}
      break;
    case sel:
      select_next ();
      break;
    case act:
      action (game_map.sel_mode, &map_events);
      draw_effects (map_events);
      break;
    case last_place:
      /* Yet unimplemented.  */
    case attack:
      action (MODE_ATT, &map_events);
      draw_effects (map_events);
      break;
    case defend:
      action (MODE_DEF, &map_events);
      draw_effects (map_events);
      break;
    case guerilla:
      action (MODE_GUE, &map_events);
      draw_effects (map_events);
      break;
    case reset:
      clear_crosses ();
      map_events.type = EVENT_REFRESH;
      map_events.loc = map_events.count = 0;
      draw_effects (map_events);
      update_cross_win (0);
      break;
    }
}

extern void
event_loop ()
{
  int uses_def_mode = check_uses_def_mode ();

  XSelectInput (display, main_win, 0);
  XSelectInput (display, but_win[ATT], ButtonPressMask);
  XSelectInput (display, but_win[DEF], ButtonPressMask);
  XSelectInput (display, but_win[GUE], ButtonPressMask);
  XSelectInput (display, turn_win, ExposureMask);
  XSelectInput (display, map_win, ExposureMask | ButtonPressMask);

  XMapWindow (display, map_win);
  XMapWindow (display, but_win[ATT]);
  XMapWindow (display, but_win[DEF]);
  XMapWindow (display, but_win[GUE]);
  XMapWindow (display, turn_win);
  XMapWindow (display, main_win);
  update_buttons (uses_def_mode);

  while (1)
    {
      XEvent report;
      XNextEvent (display, &report);

      switch (report.type)
	{
	  Action map_events;

	case Expose:
	  if (report.xexpose.window == map_win)
	    draw_map (report.xexpose.x, report.xexpose.y,
		      report.xexpose.width, report.xexpose.height);
	  else
	    update_cross_win (0);
	  break;

	case ButtonPress:
	  if (!report.xbutton.same_screen) break;
	  if (report.xbutton.window == but_win[ATT])
	    {
	      action (MODE_ATT, &map_events);
	      draw_effects (map_events);
	    }
	  else if (report.xbutton.window == but_win[DEF])
	    {
	      action (MODE_DEF, &map_events);
	      draw_effects (map_events);
	    }
	  else if (report.xbutton.window == but_win[GUE])
	    {
	      action (MODE_GUE, &map_events);
	      draw_effects (map_events);
	    }
	  else if (report.xbutton.window == map_win)
	    resolve_map_mouse (report);
	  update_buttons (uses_def_mode);
	  break;
	}
    }
}
#endif /* have_libx11 */
