/* Some random 'long double' numbers used by gnulib tests.
   Copyright (C) 2012-2021 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#include <config.h>

/* Specification.  */
#include "macros.h"

/* Some numbers in the interval [0,1).  */

const long double randoml[1000] =
{
  /* Some not so random numbers at the beginning.  */
  0.0L,
  /* Then some numbers generated by GNU clisp.  */
  0.709874756135422554674614242046304686448L,
  0.486497838502717923110029188864352615388L,
  0.474019570990182753146861083750226106848L,
  0.998821069612940336401792152067298257397L,
  0.68230324395444341476284133813649237509L,
  0.0812383212795450007980350531141537177532L,
  0.43131112016001535977175708439191217567L,
  0.1596337172541222285215378906083607753005L,
  0.0447361192177328171952931546845870270203L,
  0.669148550486018286115665314826153614017L,
  0.398752708644620313955955676251505325896L,
  0.600019492390024166744893736290881101244L,
  0.78337397012688890834008412364808365851L,
  0.747414410152603863408503379239564644402L,
  0.550615721371501982864462175362996180322L,
  0.0073983673767251687422683917248311760491L,
  0.693846360902780799478892082407382699085L,
  0.751592057901191172906159475240427353057L,
  0.74000578784995401707243054106755282117L,
  0.847264623235961908747497547605068838836L,
  0.917431426585209425652777605148791919017L,
  0.267532476015101748449269162884835638528L,
  0.486834088208986505203048715784492259319L,
  0.4580154564181484580770749178538567666L,
  0.391521076582874764982597286237947922907L,
  0.69173131929214083677828129436922728366L,
  0.995268639187054867212755710743514657877L,
  0.553189251912843822062196619876802699895L,
  0.632300552505301947698796653386744186037L,
  0.445572801006840927064646197943103543344L,
  0.993634311396905276414701816228609517838L,
  0.611582274481091436495638926486363711255L,
  0.017611091105275929341544154464243038417L,
  0.598936378040443270534796418637146416803L,
  0.939730325871014729497001074244817030738L,
  0.385712528561693907444911228190200940125L,
  0.48796444333495738271693214259711532603L,
  0.508634972895891442259656591497940133962L,
  0.88453398179301716552318999435310293852L,
  0.509099535482633468613040057130206639612L,
  0.333677997666677081186230843198919594355L,
  0.82715349353996770180499230535973424237L,
  0.0372593663309767971914036990047894757662L,
  0.932828780275931267421133064996449298348L,
  0.486099261359133830842098860485004683725L,
  0.987156392631551825781809767746170502002L,
  0.824739790678073493124786291053674093535L,
  0.671869573118280976952523743592826377585L,
  0.48088844444394888967684860088619551899L,
  0.017233021606613044454327510797750273989L,
  0.988102711714879869326666071903065279145L,
  0.091615081537455465573860363408517029583L,
  0.0113278995312253231106729997476313183323L,
  0.294349528513080028346115860151112891433L,
  0.0097058790914280197566968241982258935964L,
  0.715113281550035710673074854712220192465L,
  0.739627170474553083453358265804562580162L,
  0.588476045636558489860462119645353521893L,
  0.91330346819098343970944232526748274664L,
  0.281457572112513183673653575304242456425L,
  0.784192391468991402261628322552430383283L,
  0.504857923842698553133786835061714061812L,
  0.230410937725986177704701374433825197397L,
  0.535805811877939822805608704986961969659L,
  0.0508287955596506952822240797812703550548L,
  0.179399756999629053194209501169297540332L,
  0.675837373242984020977236431747771655704L,
  0.981496523455084073391380532008173135055L,
  0.325845075647804753424852268729037997407L,
  0.832630951427200447589084239299500129776L,
  0.825354056334755646582091209610369762364L,
  0.574731012869980895104127749738122205757L,
  0.799028354294603017571131513193291020045L,
  0.537721586879667191016369071169775496218L,
  0.83846801885738807298552515294277869191L,
  0.0922901597877978587435698953162723703674L,
  0.434458505758559675954739433438496373717L,
  0.308017320632506922735963882703835222897L,
  0.0192693232310748837390370764187488626234L,
  0.65275462537999797862908920689650691667L,
  0.357130585286320841741290333260811815153L,
  0.359562085720204868627653630044659240449L,
  0.758320826841831017712067337815543048118L,
  0.62169722559489484088614873429559348682L,
  0.17335411409874538731529771306978631118L,
  0.154077331752487118534287271363344964006L,
  0.148559174998934930922746358844164455867L,
  0.881316225913391098839630896554038163768L,
  0.89289796752480477623907740261818685845L,
  0.57786655574695620371527391411424563834L,
  0.318175774295281868509200498351278930862L,
  0.194978302204782205514236430086515458283L,
  0.87084962252516402992532937666368998137L,
  0.362113882465068209502300826516448793743L,
  0.273446496762640462316848141032810658473L,
  0.1471399192242189033406154289397228481905L,
  0.937157507052090331728212622934524925056L,
  0.600045430164287985733450402316667890373L,
  0.794478865621258499047814379367829521507L,
  0.889115878933706260333129391997704491913L,
  0.631825206206982866021784416451887594472L,
  0.966422225095067311240936396545408962515L,
  0.676845470105427028205320649846678927664L,
  0.671163783319728784750606328490914935783L,
  0.213726274743505026386536996423761328083L,
  0.99483340496284948345969144891145513965L,
  0.362072360280863974302182899205431874295L,
  0.89135316959373017710710890812308229361L,
  0.861008403776277958081202417380537907424L,
  0.518258469677886348298849030872657409393L,
  0.74995117457421590827489329835282465567L,
  0.141688060236646135992059548400562463963L,
  0.231055693687838328234866575264314255906L,
  0.128367320195147852998795956530756587271L,
  0.735643745226188370911313880883935933086L,
  0.481951681233521227023903083881246017963L,
  0.29797778097740396719094352844253033076L,
  0.259026843185033526978277511857498182853L,
  0.76454793636766387350530239448634042225L,
  0.921742101320371872828332060575170679558L,
  0.135594574885855893452962438848740230435L,
  0.249482789438500604376469100084029356821L,
  0.447893460512394580798054060401740249162L,
  0.841167533365717681130523968098862274883L,
  0.063885342343669943206116658917625959392L,
  0.49268569222220133343083683720155184169L,
  0.0320364278163828327673837310979596079469L,
  0.83067006037141488187036282222404336846L,
  0.32687090604018629599351990634445890267L,
  0.524229581985562678867475657633756672726L,
  0.26442137331545990230136529620604338964L,
  0.1804465247704923307363156457827584866855L,
  0.219897692414720290686302976466475627349L,
  0.657372240957848561373923532613997515665L,
  0.94917951707325275578037456019158874452L,
  0.999935336870950506894538846120127792282L,
  0.334292387732229479489367107895450895382L,
  0.519605753222230586160238890634421180626L,
  0.2353320030331258205431171147281090084686L,
  0.697837952881171466097464830413620278996L,
  0.337355949172173312279209733133367570558L,
  0.59624609578396787690174902306338541087L,
  0.430566868363073838098964774826687118822L,
  0.303143768470597821848720008902412356097L,
  0.45566572082779255052299434804712613961L,
  0.63651052470632278377988990008643926753L,
  0.88355849548999550762491205909993278845L,
  0.857627182143034336666679544569747793963L,
  0.579654405386150422035981447661995358225L,
  0.527551502180559045145630115424486189773L,
  0.227798290812497436015108334865799792168L,
  0.860285575656798735433746383563482660567L,
  0.657434642899561800145850990323893418457L,
  0.991915916857419346367596676050775541352L,
  0.0299053482258395117883768309912517801074L,
  0.494186962160200346319995839440170254278L,
  0.795837941248740362154274095100822390282L,
  0.213898349709271555518444444268604992712L,
  0.635385838537788174234352352696939407706L,
  0.1161960540496013767418067989853615145483L,
  0.236636716576793997613161803474856412323L,
  0.250257128320679509772248555959408855321L,
  0.754809883956726591031066199439807350575L,
  0.240047496212680591313028855365466345707L,
  0.125918185384015376472834932789271923263L,
  0.830761928512260978768305988740912711273L,
  0.0833746595456954680423678981938324373477L,
  0.993235018876045312632920249583820095078L,
  0.74457886551486005017424251252790500917L,
  0.904041666312003998553971236017433817041L,
  0.99682247674917724207607173416904094376L,
  0.778185258630194559195184600522592063632L,
  0.617908428541966249479693433082678846704L,
  0.034201434638706652764862810175677292771L,
  0.1166825963578175046863759835887066398776L,
  0.618184997077951045734597662867931774914L,
  0.67223166229200793562043589747700629457L,
  0.50367723015643325152991864733820551338L,
  0.287805524504497224349445840278160308547L,
  0.418530565562949537953621246456529701546L,
  0.356577284504836083965140033686046682705L,
  0.727797226876543100474285620953868682292L,
  0.261158535215243995918166290296126543963L,
  0.1233681715943113445590872776925938156L,
  0.397342365090131218507373938120760734013L,
  0.33651833905580176460704582099080050591L,
  0.124851176251609572087737060478799388707L,
  0.49869389018540295598691678028277690211L,
  0.603921102513219725593707198424421456834L,
  0.0288068305492076274901316515486696644854L,
  0.27635950491121559708402485015430409745L,
  0.0219820746750707161670181537628175322048L,
  0.893266704905772978187424688068554761406L,
  0.055131714446612192984065196401480701447L,
  0.478917803887421452005543212818108274705L,
  0.1089109338581245135310441557812062287244L,
  0.451355129465699006367714322379179082201L,
  0.933539696310061306235683130737189659555L,
  0.295046527696521751967458467625754033345L,
  0.657654030109877699469191835246373699585L,
  0.699519422709288537538980841108763784234L,
  0.754780411476609088293217972311402262028L,
  0.940185229424181440596885768821586612845L,
  0.641206442188302531301220212171259413504L,
  0.483623421775598486212538785028426545698L,
  0.1819507033406890598006456890391145571876L,
  0.3493992184159313422014002142021878866L,
  0.2282143482135155999703670773974654680736L,
  0.65404355620292102948676570623901452325L,
  0.000126697620991797753719907018394969483701L,
  0.000128697615694221449450257101713351917085L,
  0.66277677565136622936757573048183355679L,
  0.954427508631091518542647272554320259L,
  0.821452416615550557725422642536361482673L,
  0.783949133156224682132225528942727293192L,
  0.883688268329322182794294084718215227776L,
  0.887198477924019626901140168907684736036L,
  0.301153686936585019868640358522761168745L,
  0.97031160152938862140377079439908121466L,
  0.613591225576913510391808189718881180802L,
  0.973773801885628446394837963774216539007L,
  0.969946092528631153860793542995840284225L,
  0.0552318705490405481104532089875456066346L,
  0.398506652226642658353465649824893657953L,
  0.577466681084525459648007205600389579233L,
  0.538305717497527581210294472297571817608L,
  0.0378969572225333661087665511893845011475L,
  0.82821208446292402852221418490682507414L,
  0.207039760611344134455359310666092356869L,
  0.278071434395492049592363658721835175976L,
  0.418157919791356829061560807874478279737L,
  0.917935426878916775097393966246600470752L,
  0.968879316988430839484738642933327229065L,
  0.836847484003257581736597938908686488306L,
  0.95787762740618523171012745852536482523L,
  0.381833463284092269744674988738521423563L,
  0.585758801118634412354899474049588357203L,
  0.590675098878457580254555486356030743515L,
  0.999102261786447498899644398829003134788L,
  0.278723779765613710807952395929736248799L,
  0.150160483677965826860533794972733497469L,
  0.39044191915595120943090707935299688844L,
  0.882025297705744570797306391637391855587L,
  0.26053886056730883704893455389142056588L,
  0.530123960707389279621444598593626923328L,
  0.307497951588709795568291546230129131789L,
  0.755712717002473210112772528495042985208L,
  0.403971099596680128749039001982260210321L,
  0.0955902605698226580325595772471302440213L,
  0.733946822526846681865131682504158670327L,
  0.824558199580936798107294631591949429405L,
  0.355777480091076251706346214380424670616L,
  0.183210308747040172107746729630689571628L,
  0.943081072447366944673610412439697363267L,
  0.823437046917209496498923793615721213912L,
  0.272212671889142468847791216625072718846L,
  0.467586497114075237282436742306271250655L,
  0.965430243779957305809196327799423550657L,
  0.264527585376739963287684763043832918263L,
  0.78305929918791974277407705060017330726L,
  0.1569161089271269079867408493909342109635L,
  0.385890512318945048667111881493883277209L,
  0.748768801714747310036929893375463390286L,
  0.9607241213632062657075501565333113635L,
  0.681005349771442926258254424282975745535L,
  0.417404611754855157969846623218352380733L,
  0.384922954690351156114438668003273806442L,
  0.0248688875333777009659560293287195312336L,
  0.289622732329138351547499030028075517487L,
  0.356660798938142089830284922931103513564L,
  0.1092119220339924538904809107210351902013L,
  0.263044604533896828574983495057823392153L,
  0.72916056882229781356884933113775509031L,
  0.277279616044198734111166028359400949283L,
  0.448496025651349045553194567962243478962L,
  0.397797975606664545700620422788810306397L,
  0.915573317477921170464219734057440942223L,
  0.565957191780698852582910000301549192135L,
  0.0199640867363067059474765492007910956547L,
  0.380718754942963039702539139065633248878L,
  0.271561535356661429325107452975658450244L,
  0.65703383768996023094650337496290243735L,
  0.810303462640169412310932301780031244584L,
  0.34389677270659068303923976829417662132L,
  0.1459701849396526086771469906702178205394L,
  0.0709566883230581731990192048699199874356L,
  0.0273188133279639766234319338307950998466L,
  0.189257375093862859152281617127963424911L,
  0.483370049027267515091110020077746913052L,
  0.6121051307445822901845022667347352688L,
  0.0669683489197768142011855877890933175548L,
  0.0462440353376468071116256899031962430102L,
  0.66179099750239749196171922709429044667L,
  0.331447780875915347204488922360787127231L,
  0.88878630766137716878808504113561041651L,
  0.57831688009568937419273238575083437733L,
  0.1665758643537997337473156606765968668944L,
  0.609499751553850514507525575752744468325L,
  0.842660412678850878529299409778020570114L,
  0.868735885617006579468607975714721515953L,
  0.518323673739076029376626898444587264186L,
  0.465048961779768578307935679739067346325L,
  0.739933063031511059934522150792493137138L,
  0.366097491036976922528977805725731033037L,
  0.622890978255856721366594654155975719428L,
  0.945120241233001881267096151974150875442L,
  0.711795000549305806399598132955701848342L,
  0.120093380051693652573317820347038096902L,
  0.461420048084338423641881546847056927696L,
  0.201645977777376722385295339631509175754L,
  0.1479402104137110360277226090924965371445L,
  0.287960179369955828242600303166176042591L,
  0.788362667534075941033937374958276358103L,
  0.610312055398887641020833805884097007991L,
  0.758450801974187424825814780682156814865L,
  0.64208882693968320907867911523798381855L,
  0.255468285690834138126389042932304445888L,
  0.0370478385689831649949675007793815537737L,
  0.551880617631056560992613768623601574096L,
  0.559262357532227558112085482526038868046L,
  0.129705275018847798920129782613409588523L,
  0.1076289463968801831500602693982998566697L,
  0.272506325706516323678193293634687081578L,
  0.721990855538151706841764025895777805643L,
  0.523084042169573467351077180119310086396L,
  0.0858615712848179826840482241961243288956L,
  0.589714739430299853251893655400362103563L,
  0.512412326166823937685402214713910254025L,
  0.802350747297003067442509635888112412853L,
  0.715817091619681167941132068164905209087L,
  0.0824951218034037355816988555328185436778L,
  0.829228234554153070848595829448989414728L,
  0.59652037694553054648270061009002150308L,
  0.133585725647906582691822880117773950377L,
  0.812005216254498654412124509257882599085L,
  0.808142463854396488512203093936737654517L,
  0.570217922503074432494487309472855783614L,
  0.704017977813333280013384719294741845102L,
  0.0251797587779118690185681150429720019843L,
  0.676272439608475367571481578590700290242L,
  0.880796414989798318500723261307937258554L,
  0.387922631107753361553377889431536170676L,
  0.282350224157064849683455744598629321323L,
  0.721001172978128539392551761867898599807L,
  0.98720056526474911920598612334425157851L,
  0.9951900286811655251775209231187451065L,
  0.051844546479017627818996668613208776283L,
  0.103738972117399718145836730690615155693L,
  0.228544758674525285763674099492074936604L,
  0.429309402103194762341587536897342160049L,
  0.564535575507982971760351294178163523416L,
  0.999063571593237112671743187500362701266L,
  0.340374156369508513494787137157934959152L,
  0.778748988242111504661479799747122556733L,
  0.471307010869691772647781526213794708743L,
  0.289707428078962269353959639691462373973L,
  0.826577651264033230456965284610788939828L,
  0.860667694131974131835140122175480202008L,
  0.596405567348984902495263677852931818947L,
  0.79786093770390728560184577433203234578L,
  0.85492142888696693237980696048371212203L,
  0.57242705004809831263405538576519171441L,
  0.829648119655355629047392239460860046016L,
  0.783260316181642610272420809845230036294L,
  0.0941718863377651336163202407301145871807L,
  0.156372209579300482444127671309443664823L,
  0.95045258077372510217507306087908380692L,
  0.1885289021059534081345247308001373861575L,
  0.660776653890123229320677431688026234587L,
  0.2333507388961794003755022400755269739225L,
  0.926661255852332295794894190183342387092L,
  0.862240624886232672002503279536846219655L,
  0.093072473040365648693897225471155002338L,
  0.210437952956145192084247103889970459783L,
  0.98112543168220233380555460117617724093L,
  0.740174391774267645790688716222038485627L,
  0.0209886798500615011013258311339617682421L,
  0.41833754096087514377582590206105535614L,
  0.469019942905167330505858885046130048223L,
  0.715228143253914303084091910768414947468L,
  0.949215045400946624794326433082702896278L,
  0.0839262379919984011512905346130401074556L,
  0.358856470231875479544116669678510859691L,
  0.676461324144301815445903930221360844898L,
  0.321802718137104975636543941512529575137L,
  0.993411285955596090334951526803325817472L,
  0.860164319140927797258503749506400508873L,
  0.94773452678939638468420772776729628408L,
  0.786167026315331965750413583155691260173L,
  0.45156944204188755542678210840170293585L,
  0.490807428869058127589400400723875752095L,
  0.1064150484458768919266881304357565451445L,
  0.324460881496927069927267886879512784128L,
  0.892536276084459403262968666925514247957L,
  0.626906362142556286375622503025155623158L,
  0.912617117728752553677432546319200457076L,
  0.670287539555608481364011494943625670644L,
  0.247614513279178220157281399165275150246L,
  0.328334024179281412037962820247065990969L,
  0.829445540957824174480776183273738605512L,
  0.1787214688659462728637669907628671276175L,
  0.925570168885833135397413435137754040344L,
  0.98275386432184844551191217367555375122L,
  0.364711512670624901280733420446798813805L,
  0.0676060703890593392691073615176801081634L,
  0.01088522590112897075539168583333589679446L,
  0.0611693052224598303672047526429160913973L,
  0.214589347780615411637055343786045569195L,
  0.698097005257153990899739747284349971478L,
  0.0354356066334430559162358810601367856981L,
  0.0279531560831790454930326667914520406377L,
  0.939682879995515407044885888120427639943L,
  0.312419879113847025637130107480365284706L,
  0.429063186024752762548549652686423948472L,
  0.198325752893057589388425455067795077316L,
  0.653970278037364931023007417819508007502L,
  0.396811027519564931158159336303275106925L,
  0.50451059823222344440248588902992099958L,
  0.0862505815838354201964323759027263746603L,
  0.957096030216378795442646824371057760147L,
  0.587610162738417619467784731999441435863L,
  0.582187586992416238476426545279573456436L,
  0.535716130421670802716666237861890374707L,
  0.090478847153957807764386571203708454605L,
  0.788473620511487574655894325144660477707L,
  0.610237648835883657058234607228408957708L,
  0.678372723016422015853594971922211368707L,
  0.0477042323920128297852928999674240977938L,
  0.916676966783686851658830754268116450562L,
  0.385373716764729378193009393283577714611L,
  0.51049308234047313597601380814795899816L,
  0.1196704708003806819299545192341910042065L,
  0.446475706132336496196697021305914636716L,
  0.22995164195921866005337396330755244987L,
  0.632225374693904589951305492826903497058L,
  0.1049567841702419598059377515889392050297L,
  0.66749284825574584532432314559877621928L,
  0.730750212627697291852996268443402535667L,
  0.44210748459007730373853303409845654876L,
  0.165882407048533464405922485111215401752L,
  0.326102079042974476137893383568312181916L,
  0.894926469777796621626659556932174565354L,
  0.829811268916354531033773068150153342864L,
  0.0607253283595596933368529290946492114805L,
  0.0677752868787034912813695724240479638585L,
  0.82861506635734784945473366382511846348L,
  0.160085543323090657960949278634908144601L,
  0.232569451519550129004668131405568301759L,
  0.848363194546104528297512566450812116666L,
  0.793640414525406609723674517332020118566L,
  0.0908665486135344605492576594616215607582L,
  0.98524892289773367881284955458176900047L,
  0.232277847265217861619371474795084074907L,
  0.2478103820537262599906715455471023544214L,
  0.518524645780409202282547691600231775584L,
  0.726858378884955244314303315523158335615L,
  0.245545705017836867827662773158398435754L,
  0.2242602776132220616213985660229694803996L,
  0.69321599409749039262414070240230983052L,
  0.0112978587458533729787299027903363211672L,
  0.201700091442640051051557572594860881596L,
  0.1553158804742445432796353137546288871905L,
  0.297307958467221836656545818754009116053L,
  0.858321137590160233755873079497950982112L,
  0.66848174756798322137180974713907803341L,
  0.996344263106353369755981871581860505522L,
  0.0298469963581545313060582891253178820216L,
  0.5825562269883888340326171333296281312L,
  0.493316240919863194534203651249074989694L,
  0.25506115557073666386519530923416434445L,
  0.990037777634583670683401168871182857585L,
  0.111966792328779238876716387539738843995L,
  0.555536981182848652400091282463345207445L,
  0.281763605895317871765768390877174374161L,
  0.902702281907817546029803311979267829958L,
  0.526223239446627547666226037912343453756L,
  0.663322588876953268851644820272004691035L,
  0.925956679854174995001911256195736125327L,
  0.978687628923344717267490649565202182013L,
  0.295452218109470204949110043833472171496L,
  0.763317372768444290934585368155544717374L,
  0.41484295515622153189510360412010755096L,
  0.95319138766107113957717501566306191772L,
  0.449833295238493367386837134824022661087L,
  0.380903660964162496124546078818966824203L,
  0.0591435603332779390763767398658188273838L,
  0.594973116752510574186847848340951992488L,
  0.66051154347057943107777082783767373976L,
  0.9590947364014878778361002605613544034L,
  0.141719503437180601174660143271258240733L,
  0.72942088503531365739564056985302156428L,
  0.96229479992042091317494337141213026865L,
  0.51401712994901482942061876482808737646L,
  0.09446204537625467018781365109090483186L,
  0.568441523568450417056301286402539600564L,
  0.598604342726174263070596195546293250945L,
  0.774951017988365558347613104226790833317L,
  0.81892086730816467017537310019875247387L,
  0.890143355483709851496792149649550808793L,
  0.2191477338352410954693547610221317715285L,
  0.726897475480314385643181203422499653L,
  0.756138778886812022822443490226271392144L,
  0.36128016023552084266898937740898271179L,
  0.410782581318000192446155911986931996913L,
  0.223641334296034708685419059866928946095L,
  0.0611617201563377229556630546893173872466L,
  0.0454251140845604672274274573289906520655L,
  0.292039969549662442463090760177927466818L,
  0.0892783972345646734854765244000589132126L,
  0.98769280749877429524697464655962686569L,
  0.889843464657722517503667653048728011052L,
  0.651776307404858375062718114948328477704L,
  0.87617575855504123004785690824244025026L,
  0.338359170956885135997817905734588127076L,
  0.734032684330295341291816774804886223887L,
  0.862422342223053851459695185679195132964L,
  0.197333977370262353727756586852240555633L,
  0.586060335783457129849055206578505427124L,
  0.132898852938756538479400358451026471607L,
  0.548298096092246267871555639877296879195L,
  0.301119859270324657077136364646995297056L,
  0.02186689635349189676964089313754648484195L,
  0.037538023766844046167768352700498359816L,
  0.739462465806194132819844936199304370748L,
  0.306338591475158278790432712666553704959L,
  0.0349382326130091592369352494672121905505L,
  0.12659131714329909411210854142389581492L,
  0.991566243159047696662802015340988687108L,
  0.265613985138476447081523915107505113653L,
  0.379928020809782559672193104868857287448L,
  0.3311424971073397473661763760151895103L,
  0.702177302636984264408758773725210449873L,
  0.975045571615360787500646118846671455125L,
  0.0373462862349996603561237755410350012631L,
  0.846126776062337124521510357150131165153L,
  0.604046707233534456382774833817964498043L,
  0.1981113045697699450375369418161865703455L,
  0.0223467484405979164693956414316536174577L,
  0.67121960182601511325776586363807504696L,
  0.165784481427263519151726479123968726022L,
  0.721784618575898210943875783221281669927L,
  0.247408211201465904622132596487935205602L,
  0.474174174442367430962454680799704832459L,
  0.38041380356189313505762491005159753494L,
  0.412834591083812886132307610186713638625L,
  0.294378742681402760124595985235966036022L,
  0.319576442623415298744966071520183847465L,
  0.17227236515412864866186439447886640924L,
  0.19227796294349462194111033545303573433L,
  0.701351402612222654905938605774127547107L,
  0.55598633289035034815584162421930015865L,
  0.402729648554369906881359212431684355721L,
  0.595951760748834493622338584190905994085L,
  0.119840257870361007206544525046135477756L,
  0.90443395581066590152525534589406902782L,
  0.205188871300477881549673944463237196075L,
  0.339175278174772519132232276502457660768L,
  0.447725444308107151040888910769680233742L,
  0.541239546708188153505885726785683096117L,
  0.12984235126732767588700711245028426254L,
  0.0534701599183773436559514525508752846737L,
  0.793436019832695131646422778046763975325L,
  0.718125883729211211336344362949260539072L,
  0.328649037343445105052694618356980072933L,
  0.113307342739499399477248133420602576291L,
  0.87683936228301044929749768481864525904L,
  0.212591937265603187751611886807532831791L,
  0.761002958456888912899646497131654914807L,
  0.220849601519164170820922984026707209176L,
  0.222305857213559738578093188054272365062L,
  0.651516500020930005107266726995614198887L,
  0.1505613416188572288472651067305496894266L,
  0.166658450989632252583252879193540688162L,
  0.249417632511505538283736333645627460544L,
  0.50096054904291170172998992288713266662L,
  0.173701146801321486346972068110605414347L,
  0.93433415280052265881674202089278791561L,
  0.1167900820460300938880016624066890278452L,
  0.265137084235229705213901240937609442947L,
  0.110072770364904306470596762714108445086L,
  0.0670575770615268870829070207384379655213L,
  0.92447493539224566948960065689964970346L,
  0.187517201307673207566548753071237315229L,
  0.935719666366703749433556454391358561756L,
  0.964002672100646458888742916175546552353L,
  0.6304136194377902875122727617639812134L,
  0.497041144725381002743104205240568050483L,
  0.589232636183711897405482721407549359295L,
  0.524588285641300028631908965527617181296L,
  0.786409662511483672510756944887012261427L,
  0.9924030873238807048291154748671174581L,
  0.891407534733792276848059682970952672076L,
  0.308538095910260975496982224956384014562L,
  0.949088891149549225900320967233005245566L,
  0.507378396004105004571665876613293881214L,
  0.348875146873077771786031143309488031474L,
  0.129717394366372388305812826098578876617L,
  0.371316171885006633822161450072014737125L,
  0.550162123072752251266003313454007126843L,
  0.822171979807031777641565545578299345138L,
  0.75171547658293988559512988487590040284L,
  0.329537443635543385256682239450819107475L,
  0.159687481361602477899361671181005148163L,
  0.788720723813465707294018605642035752394L,
  0.1031423865826241581828274573741444954832L,
  0.1925157943560383416361499973635531049876L,
  0.771893047929845637497166550933789470487L,
  0.681189132819106369246924892765206195007L,
  0.180608768713011918428603967211913698036L,
  0.0869303304414286810402604783458783443746L,
  0.63890744831302111307395023326393791462L,
  0.531696069328179766265158866360885671855L,
  0.557357572478102464274432325432400878297L,
  0.765306589402879669413870462450921612475L,
  0.0941202729911292570046371838018359372082L,
  0.902333472113108821746674873990738636997L,
  0.165516366160118370026922089795742876131L,
  0.0317472434880413278821576585103363607157L,
  0.706107972335163251316361316043030620453L,
  0.832472986392763388669796997227437520663L,
  0.769939001736494466971306881365718899207L,
  0.83093185023987157595917781461722256739L,
  0.1143834825195292986705373579359335590854L,
  0.283326017120251162360393258571085609729L,
  0.301605389836836671045912951769199753359L,
  0.855854391727628505548518803309296566532L,
  0.089938332734139699450960989316391404434L,
  0.310225946153425747793112265736973169299L,
  0.96854812596413627994714291059983626441L,
  0.279767360423571836833858253122290577619L,
  0.113545981876279916290815278422648489865L,
  0.943101270554056170747004305255027939268L,
  0.812274724978801470221644756549524210083L,
  0.9678011347395447510273023981530290554L,
  0.514795136336602722878788704708053145966L,
  0.50560840616487841567055789750974674943L,
  0.127654209842819812026603428361923670116L,
  0.273727399985085036497076514726791191553L,
  0.964821797874257789566527793136425594082L,
  0.853392912197074096341317268954834390727L,
  0.914236806849585335611299422695886165192L,
  0.277335361137281076359079507288838688219L,
  0.865708792613433194377422367016717680172L,
  0.761947879929658945814013586634774725302L,
  0.276975494384441865188273120642155257808L,
  0.0678895000408079241574268817560335475378L,
  0.929521528875748672899760603996998763144L,
  0.44453824299955605846877126958322272066L,
  0.444318159420536625223816052640621069982L,
  0.42913762214779045597457741573009821738L,
  0.98994873802399078252493194985812582986L,
  0.93065975343157446755652147574743540714L,
  0.821639107980128580428385838275355600123L,
  0.031337950421787684669360817154012683829L,
  0.839516942888416107002513723437531514126L,
  0.785501376812531727571251496474527490183L,
  0.247978681554054401906203846371863203863L,
  0.985774009303654108868853196421131421187L,
  0.635347409930173147315815281304257764708L,
  0.40087985483327734740658289294086718422L,
  0.374059729085540852289174052767716446502L,
  0.367226053686019780853702834825808619761L,
  0.166424328898161772576167906091392715805L,
  0.838115185925303343477055122060982270143L,
  0.829549684532006011608856001441012324216L,
  0.059867788238866724897690318151639504149L,
  0.0253429734563284738087263277549928280781L,
  0.953315773263436653713242828719775352192L,
  0.597536998796130884349662459732857817956L,
  0.0320571321493587106457025626624408278814L,
  0.477506594803204144826488443400695434979L,
  0.285541992141868221897101891229394096707L,
  0.764190678950226854486968785768647879005L,
  0.895489776830293129781335242249167913705L,
  0.570740793029533496018083006013191540077L,
  0.938316924714444954315906773563465846538L,
  0.56157168133328941481074926451373503549L,
  0.354184283860505415751320741296599995231L,
  0.778294119283540721552919906619543293274L,
  0.434953011661757598127924745629053141294L,
  0.37156491156117895854194599593687697796L,
  0.898767478977082606651667259049374990828L,
  0.21819365919403129548458400006737057993L,
  0.278163373548978939704874687746089548269L,
  0.1089005781457343817756962209721573336768L,
  0.85152888717082537570752846642305937149L,
  0.2419243481761527583754399630924438738944L,
  0.69442654829377168239365980152821108287L,
  0.1512336533453368944625038813397779875445L,
  0.617712962492924013140729661730350287525L,
  0.935400762900002313827620435729493050175L,
  0.79357339902161958573967958515254111256L,
  0.734250188990467683521536859220675412636L,
  0.748517858206364295837674601491185485078L,
  0.82520014781239194590337105462135253912L,
  0.1240649365160101108753438662971422995014L,
  0.479769236133748631678854875312914195598L,
  0.171269492636258554036912204801376697988L,
  0.833025419245729049117746814929956940986L,
  0.354429813451205200141830318428840891828L,
  0.474809123369344367691189422128776480146L,
  0.692239655770541262287308180705629028608L,
  0.271366901464125731413801963807240905363L,
  0.561330233800121182669429172066686942393L,
  0.0695868383638479426233449148171168522655L,
  0.627576910684655924911125045007979454546L,
  0.423331542652214907262628326674848471962L,
  0.354725031694671387579309719042578580595L,
  0.312419264533145363169359084710774849388L,
  0.167819037053563697473931127337972350099L,
  0.99960836112225007722014049168024866743L,
  0.820598666739967434549389339457492152643L,
  0.689495024741546551592649728378054973272L,
  0.831455766750164249604246627812180304754L,
  0.515538871956858025876039391193370146897L,
  0.011724889011994886395520178564059346913L,
  0.587485679650311054946861235938601293477L,
  0.113010564497810081892271654273794311467L,
  0.381261245177928587613552004600730320213L,
  0.466933821322235841488251157296771536952L,
  0.646965031311287534221872388017990968767L,
  0.1811101995014685369939482409137380098995L,
  0.247896943912780884738461558340983142645L,
  0.989351208835640462928338658234638846217L,
  0.924605283008839688813842975338096967047L,
  0.232010860908797395869871518793187418799L,
  0.90274859050487649728273938229764570199L,
  0.664078588165617572819884867627266650356L,
  0.532118803501055886836301096658125012493L,
  0.854049566634563277356849166147057535436L,
  0.756477818237029394317820041473365538516L,
  0.84578312219074068824832318394711642503L,
  0.169914247711153055959592721695068126213L,
  0.50848961455796310913779527189620088788L,
  0.715231849280217810525151667911662744854L,
  0.59666585539439202929452535210623694053L,
  0.72343578283497935670188130618697814035L,
  0.982228826906846431195861293729527133844L,
  0.98068755339273420823366752414155272462L,
  0.805277135157133623039231303778838094716L,
  0.840154168539481858495551656699708834713L,
  0.41783933695481411993780663692806809771L,
  0.070981740672048589027432942629842679319L,
  0.96664795205679820656636930925268162457L,
  0.155178444292580006807274171645675417735L,
  0.276407670358590477524508525465318694191L,
  0.1054964292635286397825421772930229411286L,
  0.354205947516472098240472076653525679013L,
  0.583456972150065135260312420865576513532L,
  0.338643867118430587299252775116788065723L,
  0.146467849593879827355466951871059968293L,
  0.0639448405747942007938896940026153617467L,
  0.846536583732599902600485371566229612512L,
  0.599728399399342923058515558777947417833L,
  0.140387922890235239162309673093379598453L,
  0.1613160217694973394489944660056369626715L,
  0.151848582163159668039725770584081620756L,
  0.663365628518336712743995463098831995163L,
  0.752166976367665534193146852225632451022L,
  0.911311062532571765386023433215793121138L,
  0.692490353635171096989434518397248623866L,
  0.990512559245857089458980255962574316578L,
  0.135026433195284768293027372762691869458L,
  0.82220389984592453325084678614092535756L,
  0.385471328555065081327630832374267955206L,
  0.108251633446048989722318564345306848022L,
  0.429090236713339412878596384043906547999L,
  0.983421429305507423332481562450757515935L,
  0.0163920521681887489391607174895946079877L,
  0.634276319224952361916496263299135133978L,
  0.53164375434562160610011793242431018808L,
  0.92801127390978303506935520414803575609L,
  0.708525110316144414918831897015500504675L,
  0.722458240987313977092360928226487539067L,
  0.432028911017122242491499522489684865593L,
  0.0001754664935299182587224394863719217640876L,
  0.384266658709383389800969077999970411222L,
  0.284964603427904715461598563563830112021L,
  0.1541443027599544245798778784933517572175L,
  0.958338802063400795313378181913830622686L,
  0.636927309395779701122460610729048286624L,
  0.0963946603295477475541191401069719222887L,
  0.0995190436935072136624400787867889652226L,
  0.294220607618706451139091631947946466958L,
  0.180831121994104393794487526888221966969L,
  0.635403971764105414766318934434540385347L,
  0.333929089029202997624323059191296321991L,
  0.498378678845335358166419186432789231466L,
  0.79769145046274241777533636404451138797L,
  0.269285209299779365433012558225847643041L,
  0.110524792990169183853219228066613162975L,
  0.252694136970632381193559370648931722998L,
  0.447232396115786457656991370803052298542L,
  0.136974250599080636030665381278567779455L,
  0.67243844394695156696032636816317618716L,
  0.280265952023932940327982570523639258968L,
  0.960024614746466668963206103951264089396L,
  0.83595031847062668345135859090890188348L,
  0.127840531352213174558502027846545305518L,
  0.333183884044346150282363573006579940787L,
  0.480504229384957927069515726093850498988L,
  0.768498913093287331615443023486434378468L,
  0.940413493411219283289136687423264928073L,
  0.548648592555019577089750862504091661273L,
  0.57814360039222917342516307696519676185L,
  0.752806287004316513987155718410926624384L,
  0.328211694133870995310455637563825433641L,
  0.153907665030571878436793446358668488233L,
  0.694742699178286984320321272531890059073L,
  0.25435421168640709608520313542078743933L,
  0.61387638208113240104328972389071498415L,
  0.250476311300881635346483832554226742174L,
  0.345809836897231980069633800588202859833L,
  0.343083789419841923142937785323119943136L,
  0.319174378869537109008405333721782689566L,
  0.158111477528301687597604325494967120237L,
  0.244000500810322900960285910812181460829L,
  0.23179705702278726416861948783067588642L,
  0.54682924846605062799436489677774333716L,
  0.549008127982055819651521103931442895238L,
  0.262583044663608129412956518168777449925L,
  0.00126513153702681878410946802239924274583L,
  0.942613696151881635585127791325641506562L,
  0.352686443706689559388572818776843215083L,
  0.90689998425792029984240460273113807702L,
  0.867511650419363872431681377574762734184L,
  0.280671949468087158951852027769013272607L,
  0.162038690615698843560500386213858514888L,
  0.71179364933082197276587611716632482938L,
  0.0967402545497599384082792036477527703823L,
  0.465040868275334873151726613879001199556L,
  0.621004503662486553272117361134036130264L,
  0.732964940483576253705474121238830973672L,
  0.423374863473223783721502627532544136435L,
  0.490338535425760290944218064913112069833L,
  0.0243433415988311460557576165617657963508L,
  0.0502339423891456566961808478207103394328L,
  0.57668149339841029115236469576085057193L,
  0.654589079253818313716855283653923913987L,
  0.1099728579252794893221972017964445810946L,
  0.95067113980240197864048876003001477344L,
  0.271440369581834169312179003284604198334L,
  0.067152474145377434478612939162576726923L,
  0.77434193893477314687843638736266814713L,
  0.2095679937785625400917773512669417520444L,
  0.7681370807102749183539277908648691358L,
  0.24472807400083103884984122018932641814L,
  0.191307162486577428460074174309309551616L,
  0.637215617752531571162184184570005111405L,
  0.858141525396878877938747690015117846998L,
  0.338400625200720062249435065450813258281L,
  0.564981422008979753676981861330327611986L,
  0.809460314261206431741632790718777271837L,
  0.879343403409393604462128113991125533726L,
  0.284697509116613252542034824007026845569L,
  0.497023470648395180497606069099534119801L,
  0.650004713241995983979792197286941523L,
  0.1177129995341492896184329340448111002318L,
  0.923625966014428778639333261268345799732L,
  0.698837131343914189577155394009532120604L,
  0.28242326745092132457477019796509942259L,
  0.70025600885251684699238650783454037429L,
  0.876659050276528114198964471020380705343L,
  0.52914892693002332233566353042454639365L,
  0.319860854431864688430502078275989809115L,
  0.83483115610648557287441551698147898778L,
  0.727639064249568383685922880431792837046L,
  0.58743287662861037184349933549802687836L,
  0.510383231616356949495559076196319035197L,
  0.00229935944348919214521608305418404052343L,
  0.799567224020488433652933994297769381902L,
  0.343651210821093611687224166251624444254L,
  0.405948097827175151257603419529941300798L,
  0.456473183882957921169800992232941517586L,
  0.570248304776860782392105323292264026118L,
  0.534779754769153667870756893044557559557L,
  0.472965511839676757434979299779809656808L,
  0.137335340499076127280155831169214403285L,
  0.51975901660926295231312276736119435645L,
  0.8085867293332018994761547260739912451L,
  0.812416413241484848007226874256949892893L,
  0.852994977709961112714176162016389410712L,
  0.95270886248643660114015239563660004248L,
  0.845133719240648570417568652136630304138L,
  0.4074980021816323645978397907609428101L,
  0.335850514497730546494305840184055599972L,
  0.0882622233237065445998153436898044995127L,
  0.936467561027640943446178111237050277205L,
  0.56676472173638044722431698799123577376L,
  0.528427769051008704179988533062745663408L,
  0.460890427579778855697205646060084318038L,
  0.754971897131798313468797543428083655928L,
  0.980733597969419782109470537306886067907L,
  0.204362127415649555111877580124343815074L,
  0.424822548090499017266619697426652494042L,
  0.790847149074521364262028407892114384257L,
  0.559922683392730473870877613727301497865L,
  0.779993507158626042106006393237738208875L,
  0.30516368089713691312418593599115685319L,
  0.68918765842229398168455844072311006826L,
  0.972291357858071465096079542885284602882L,
  0.92204286423973856982373873105566928589L,
  0.488649453783638471576482476648021023315L,
  0.467124744623849284659862825278549932824L,
  0.548051233865943557014854568009331816852L,
  0.306838990296265483205551142903402056051L,
  0.497005516835688988273805238236922199451L,
  0.341504433884138135798086132528045458722L,
  0.969816416247460790089503289400709886528L,
  0.63656435610220447227337751650167349487L,
  0.83588076122262875881859751942918794857L,
  0.647568600604975972308348018018445212894L,
  0.916061870307308870029862807808332479077L,
  0.767988745496844638880672392122527991445L,
  0.1623230195628039449666927123215281227666L,
  0.0791082835859634251558587844284289799848L,
  0.575858643610197202634665099752882990844L,
  0.559159434263749620344702466000799724913L,
  0.063765998380760211208741798736948488376L,
  0.230557913975359017084357477142151415967L,
  0.702854691657277602758421942319022953845L,
  0.789516660466782621905392733079230211954L,
  0.491496186820051632244513986127898500904L,
  0.171499215418269578563458417238340672634L,
  0.626470061831746666081979158043673024967L,
  0.258903137813870706268979320963343541457L,
  0.64156850108405218894694811301875120511L,
  0.534043520260340661507140771088018906496L,
  0.388275182018399247097875416106759899469L,
  0.920936363560998030495046998224168162945L,
  0.826139404694006088220407338888245165242L,
  0.343561253523163451528918423980552161597L,
  0.921521003270491194867019217479780072647L,
  0.656212467754097185125864111703195343744L,
  0.628186262290474398328350301885606581942L,
  0.573227336542237665153422986363073650388L,
  0.94178975003001342039795597242477049832L,
  0.0408103561362355768975182155847755354614L,
  0.382581672073273072487550945526454964287L,
  0.152851256046525520308098129538613498254L,
  0.966735024597183045592313880114075824298L,
  0.215564894798334550271993595018433286244L,
  0.776491530531523589201618375156272004616L,
  0.912460554179311241821569665648929177608L,
  0.632880016212040018958086886452474382272L,
  0.711577891112709305169603082360885583086L,
  0.1120655756066491784920471129299439607153L,
  0.691106483958832651050573402690448368687L,
  0.227442567846797646970770128970529357636L,
  0.837435613090485891584882062239924101455L,
  0.524389161590691896070067767400758142565L,
  0.591360583466508186135247682666313136762L,
  0.103155847462960450706124014839446958843L,
  0.98360160577671960281465138408293984545L,
  0.197665014114674630647437622579741018817L,
  0.1099709194312379594014239398842185159354L,
  0.394053373921474751303577685990936074485L,
  0.94945354787200894450508557094182436657L,
  0.372593716084661547440393809983835348274L,
  0.62514674616343692328572382301636412566L,
  0.2001871481416310130073795585638383984926L,
  0.148432902421401306477690922498335475507L,
  0.687921673269487018193347305425182239764L,
  0.470940334348984370262797433659013738143L,
  0.1592476430730276812200821020958787823795L,
  0.296776110696565927524970058176467314578L,
  0.1491253105142218631726813695413369166796L,
  0.579194717868638955003571989739802264354L,
  0.0730543936466744761440131951539370917776L,
  0.941296077873340797733875467209629660594L,
  0.76720024949523806992504865943580486187L,
  0.419526107681583337049761526455092560735L,
  0.00688594806937144144337797612615981618743L,
  0.931682704636487927763651991274577493318L,
  0.660524215847727125058815911433184924133L,
  0.71780972384903067744609138100002205676L,
  0.02961791918271995070621856302848439458175L,
  0.692791206212428997136050006631240567502L,
  0.162762426697948445642880183096693062538L,
  0.183637795551464341949019870428026949035L,
  0.51263789620316407488619761125039609046L,
  0.90238698122728366178818828411640824056L,
  0.229784208410123517024401367798925386038L,
  0.227218480059027721044118324890061381517L,
  0.6555059570778176955459672492237825867L,
  0.929815767583615624563413584598741896834L,
  0.188559597559312695774663933876436875041L,
  0.396184448063913762028147791554346199354L,
  0.656329540957568516760105602115555736073L,
  0.1410678455413176345310401990667063246115L,
  0.621004667838855651847651367745487628637L,
  0.01277988784767030635209958407461792778387L,
  0.69482142276844418673788732511112265014L,
  0.925705031133221932065307191539105635005L,
  0.925744341385232535963050430363763081603L,
  0.24189467813699258571134382505828701386L,
  0.646009544609703485845605410919901799L,
  0.051119212999532673562206731603906295406L,
  0.85076142804383409765024452942896578158L
};
