/*
 * Copyright (C) 1999-2003 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, see <https://www.gnu.org/licenses/>.
 */

/*
 * Transliteration table
 */

static const unsigned int translit_data[10411] = {
   1, ' ',
   1, '!',
   1, 'c',
   2, 'l', 'b',
   3, 'y', 'e', 'n',
   1, '|',
   2, 'S', 'S',
   1, '"',
   3, '(', 'c', ')',
   1, 'a',
   2, '<', '<',
   3, 'n', 'o', 't',
   1, '-',
   3, '(', 'R', ')',
   2, '^', '0',
   3, '+', '/', '-',
   2, '^', '2',
   2, '^', '3',
   1,'\'',
   1, 'u',
   1, 'P',
   1, '.',
   1, ',',
   2, '^', '1',
   1, 'o',
   2, '>', '>',
   5, ' ', '1',0x2044, '4', ' ',
   5, ' ', '1',0x2044, '2', ' ',
   5, ' ', '3',0x2044, '4', ' ',
   1, '?',
   2, '`', 'A',
   2,0xB4, 'A',
   2, '^', 'A',
   2, '~', 'A',
   2, '"', 'A',
   1, 'A',
   2, 'A', 'E',
   1, 'C',
   2, '`', 'E',
   2,0xB4, 'E',
   2, '^', 'E',
   2, '"', 'E',
   2, '`', 'I',
   2,0xB4, 'I',
   2, '^', 'I',
   2, '"', 'I',
   1, 'D',
   2, '~', 'N',
   2, '`', 'O',
   2,0xB4, 'O',
   2, '^', 'O',
   2, '~', 'O',
   2, '"', 'O',
   1, 'x',
   1, 'O',
   2, '`', 'U',
   2,0xB4, 'U',
   2, '^', 'U',
   2, '"', 'U',
   2,0xB4, 'Y',
   2, 'T', 'h',
   2, 's', 's',
   2, '`', 'a',
   2,0xB4, 'a',
   2, '^', 'a',
   2, '~', 'a',
   2, '"', 'a',
   1, 'a',
   2, 'a', 'e',
   1, 'c',
   2, '`', 'e',
   2,0xB4, 'e',
   2, '^', 'e',
   2, '"', 'e',
   2, '`', 'i',
   2,0xB4, 'i',
   2, '^', 'i',
   2, '"', 'i',
   1, 'd',
   2, '~', 'n',
   2, '`', 'o',
   2,0xB4, 'o',
   2, '^', 'o',
   2, '~', 'o',
   2, '"', 'o',
   1, ':',
   1, 'o',
   2, '`', 'u',
   2,0xB4, 'u',
   2, '^', 'u',
   2, '"', 'u',
   2,0xB4, 'y',
   2, 't', 'h',
   2, '"', 'y',
   1, 'A',
   1, 'a',
   1, 'A',
   1, 'a',
   1, 'A',
   1, 'a',
   2,0xB4, 'C',
   2,0xB4, 'c',
   2, '^', 'C',
   2, '^', 'c',
   1, 'C',
   1, 'c',
   1, 'C',
   1, 'c',
   1, 'D',
   1, 'd',
   1, 'D',
   1, 'd',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   1, 'E',
   1, 'e',
   2, '^', 'G',
   2, '^', 'g',
   1, 'G',
   1, 'g',
   1, 'G',
   1, 'g',
   1, 'G',
   1, 'g',
   2, '^', 'H',
   2, '^', 'h',
   1, 'H',
   1, 'h',
   2, '~', 'I',
   2, '~', 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   1, 'I',
   1, 'i',
   2, 'I', 'J',
   2, 'i', 'j',
   2, '^', 'J',
   2, '^', 'j',
   1, 'K',
   1, 'k',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   1, 'L',
   1, 'l',
   2,0xB4, 'N',
   2,0xB4, 'n',
   1, 'N',
   1, 'n',
   1, 'N',
   1, 'n',
   2,'\'', 'n',
   1, 'O',
   1, 'o',
   1, 'O',
   1, 'o',
   2, '"', 'O',
   2, '"', 'o',
   2, 'O', 'E',
   2, 'o', 'e',
   2,0xB4, 'R',
   2,0xB4, 'r',
   1, 'R',
   1, 'r',
   1, 'R',
   1, 'r',
   2,0xB4, 'S',
   2,0xB4, 's',
   2, '^', 'S',
   2, '^', 's',
   1, 'S',
   1, 's',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   1, 'T',
   1, 't',
   1, 'T',
   1, 't',
   2, '~', 'U',
   2, '~', 'u',
   1, 'U',
   1, 'u',
   1, 'U',
   1, 'u',
   1, 'U',
   1, 'u',
   2, '"', 'U',
   2, '"', 'u',
   1, 'U',
   1, 'u',
   2, '^', 'W',
   2, '^', 'w',
   2, '^', 'Y',
   2, '^', 'y',
   2, '"', 'Y',
   2,0xB4, 'Z',
   2,0xB4, 'z',
   1, 'Z',
   1, 'z',
   1, 'Z',
   1, 'z',
   1, 's',
   1, 'f',
   2, 'D',0x017D,
   2, 'D',0x017E,
   2, 'd',0x017E,
   2, 'L', 'J',
   2, 'L', 'j',
   2, 'l', 'j',
   2, 'N', 'J',
   2, 'N', 'j',
   2, 'n', 'j',
   2, 'D', 'Z',
   2, 'D', 'z',
   2, 'd', 'z',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   1,0x2032,
   1,0x2033,
   1,0x2018,
   1,0x2019,
   1,0x201B,
   1, '^',
   1,'\'',
   1,0xAF,
   1,0xB4,
   1, '`',
   1, '_',
   1, '~',
   1, '"',
   1,0x03B2,
   1,0x03B8,
   1,0x03A5,
   1,0x03C6,
   1,0x03C0,
   1,0x03BA,
   1,0x03C1,
   1,0x03C2,
   1,0x0398,
   1,0x03B5,
   1,0x03A3,
   2,0x0565,0x0582,
   2,0x05D5,0x05D5,
   2,0x05D5,0x05D9,
   2,0x05D9,0x05D9,
   2,0x0627,0x0674,
   2,0x0648,0x0674,
   2,0x06C7,0x0674,
   2,0x064A,0x0674,
   2,0x0E4D,0x0E32,
   2,0x0ECD,0x0EB2,
   2,0x0EAB,0x0E99,
   2,0x0EAB,0x0EA1,
   2,0x0FB2,0x0F81,
   2,0x0FB3,0x0F81,
   1, 'B',
   1, 'b',
   1, 'D',
   1, 'd',
   1, 'F',
   1, 'f',
   1, 'M',
   1, 'm',
   1, 'P',
   1, 'p',
   1, 'S',
   1, 's',
   1, 'T',
   1, 't',
   2, '`', 'W',
   2, '`', 'w',
   2,0xB4, 'W',
   2,0xB4, 'w',
   2, '"', 'W',
   2, '"', 'w',
   2, 'a',0x02BE,
   2, '`', 'Y',
   2, '`', 'y',
   1, ' ',
   1, ' ',
   1, ' ',
   1, ' ',
   1, ' ',
   1, ' ',
   1, ' ',
   1, ' ',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1, '-',
   1,'\'',
   1,'\'',
   1, ',',
   1,'\'',
   1, '"',
   1, '"',
   1, '"',
   1, '"',
   1, '+',
   1, 'o',
   1, '.',
   2, '.', '.',
   3, '.', '.', '.',
   4, 'o', '/', 'o', 'o',
   1,0xB4,
   2,0xB4,0xB4,
   3,0xB4,0xB4,0xB4,
   2,0x2035,0x2035,
   3,0x2035,0x2035,0x2035,
   1, '<',
   1, '>',
   2, '!', '!',
   1, '/',
   2, '?', '?',
   2, '?', '!',
   2, '!', '?',
   4,0xB4,0xB4,0xB4,0xB4,
   2, 'R', 's',
   4,0x0110,0x1ED3, 'n', 'g',
   3, 'E', 'U', 'R',
   3, 'a', '/', 'c',
   3, 'a', '/', 's',
   1, 'C',
   2,0xB0, 'C',
   3, 'c', '/', 'o',
   3, 'c', '/', 'u',
   1,0x0190,
   2,0xB0, 'F',
   1, 'g',
   1, 'H',
   1, 'H',
   1, 'H',
   1, 'h',
   1,0x0127,
   1, 'I',
   1, 'I',
   1, 'L',
   1, 'l',
   1, 'N',
   2, 'N', 'o',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'R',
   1, 'R',
   3, 'T', 'E', 'L',
   2, 'T', 'M',
   1, 'Z',
   3, 'O', 'h', 'm',
   1, 'Z',
   1, 'B',
   1, 'C',
   1, 'e',
   1, 'e',
   1, 'E',
   1, 'F',
   1, 'M',
   1, 'o',
   1,0x05D0,
   1,0x05D1,
   1,0x05D2,
   1,0x05D3,
   1, 'i',
   3, 'F', 'A', 'X',
   1,0x03C0,
   1,0x03B3,
   1,0x0393,
   1,0x03A0,
   1,0x2211,
   1, 'D',
   1, 'd',
   1, 'e',
   1, 'i',
   1, 'j',
   5, ' ', '1',0x2044, '3', ' ',
   5, ' ', '2',0x2044, '3', ' ',
   5, ' ', '1',0x2044, '5', ' ',
   5, ' ', '2',0x2044, '5', ' ',
   5, ' ', '3',0x2044, '5', ' ',
   5, ' ', '4',0x2044, '5', ' ',
   5, ' ', '1',0x2044, '6', ' ',
   5, ' ', '5',0x2044, '6', ' ',
   5, ' ', '1',0x2044, '8', ' ',
   5, ' ', '3',0x2044, '8', ' ',
   5, ' ', '5',0x2044, '8', ' ',
   5, ' ', '7',0x2044, '8', ' ',
   3, ' ', '1',0x2044,
   1, 'I',
   2, 'I', 'I',
   3, 'I', 'I', 'I',
   2, 'I', 'V',
   1, 'V',
   2, 'V', 'I',
   3, 'V', 'I', 'I',
   4, 'V', 'I', 'I', 'I',
   2, 'I', 'X',
   1, 'X',
   2, 'X', 'I',
   3, 'X', 'I', 'I',
   1, 'L',
   1, 'C',
   1, 'D',
   1, 'M',
   1, 'i',
   2, 'i', 'i',
   3, 'i', 'i', 'i',
   2, 'i', 'v',
   1, 'v',
   2, 'v', 'i',
   3, 'v', 'i', 'i',
   4, 'v', 'i', 'i', 'i',
   2, 'i', 'x',
   1, 'x',
   2, 'x', 'i',
   3, 'x', 'i', 'i',
   1, 'l',
   1, 'c',
   1, 'd',
   1, 'm',
   2, '<', '-',
   1, '^',
   2, '-', '>',
   1, 'V',
   3, '<', '-', '>',
   2, '<', '=',
   2, '=', '>',
   3, '<', '=', '>',
   1, '-',
   1, '/',
   1,'\\',
   1, '*',
   1,0x2022,
   1, '|',
   2,0x222B,0x222B,
   3,0x222B,0x222B,0x222B,
   2,0x222E,0x222E,
   3,0x222E,0x222E,0x222E,
   1, ':',
   1, '~',
   2, '/', '=',
   2, '<', '=',
   2, '>', '=',
   2, '<', '<',
   2, '>', '>',
   1,0xB7,
   3, '<', '<', '<',
   3, '>', '>', '>',
   3,0xB7,0xB7,0xB7,
   5, '[', 'N', 'U', 'L', ']',
   5, '[', 'S', 'O', 'H', ']',
   5, '[', 'S', 'T', 'X', ']',
   5, '[', 'E', 'T', 'X', ']',
   5, '[', 'E', 'O', 'T', ']',
   5, '[', 'E', 'N', 'Q', ']',
   5, '[', 'A', 'C', 'K', ']',
   5, '[', 'B', 'E', 'L', ']',
   4, '[', 'B', 'S', ']',
   4, '[', 'H', 'T', ']',
   4, '[', 'L', 'F', ']',
   4, '[', 'V', 'T', ']',
   4, '[', 'F', 'F', ']',
   4, '[', 'C', 'R', ']',
   4, '[', 'S', 'O', ']',
   4, '[', 'S', 'I', ']',
   5, '[', 'D', 'L', 'E', ']',
   5, '[', 'D', 'C', '1', ']',
   5, '[', 'D', 'C', '2', ']',
   5, '[', 'D', 'C', '3', ']',
   5, '[', 'D', 'C', '4', ']',
   5, '[', 'N', 'A', 'K', ']',
   5, '[', 'S', 'Y', 'N', ']',
   5, '[', 'E', 'T', 'B', ']',
   5, '[', 'C', 'A', 'N', ']',
   4, '[', 'E', 'M', ']',
   5, '[', 'S', 'U', 'B', ']',
   5, '[', 'E', 'S', 'C', ']',
   4, '[', 'F', 'S', ']',
   4, '[', 'G', 'S', ']',
   4, '[', 'R', 'S', ']',
   4, '[', 'U', 'S', ']',
   4, '[', 'S', 'P', ']',
   5, '[', 'D', 'E', 'L', ']',
   4, '[', 'N', 'L', ']',
   3, '(', '1', ')',
   3, '(', '2', ')',
   3, '(', '3', ')',
   3, '(', '4', ')',
   3, '(', '5', ')',
   3, '(', '6', ')',
   3, '(', '7', ')',
   3, '(', '8', ')',
   3, '(', '9', ')',
   4, '(', '1', '0', ')',
   4, '(', '1', '1', ')',
   4, '(', '1', '2', ')',
   4, '(', '1', '3', ')',
   4, '(', '1', '4', ')',
   4, '(', '1', '5', ')',
   4, '(', '1', '6', ')',
   4, '(', '1', '7', ')',
   4, '(', '1', '8', ')',
   4, '(', '1', '9', ')',
   4, '(', '2', '0', ')',
   3, '(', '1', ')',
   3, '(', '2', ')',
   3, '(', '3', ')',
   3, '(', '4', ')',
   3, '(', '5', ')',
   3, '(', '6', ')',
   3, '(', '7', ')',
   3, '(', '8', ')',
   3, '(', '9', ')',
   4, '(', '1', '0', ')',
   4, '(', '1', '1', ')',
   4, '(', '1', '2', ')',
   4, '(', '1', '3', ')',
   4, '(', '1', '4', ')',
   4, '(', '1', '5', ')',
   4, '(', '1', '6', ')',
   4, '(', '1', '7', ')',
   4, '(', '1', '8', ')',
   4, '(', '1', '9', ')',
   4, '(', '2', '0', ')',
   2, '1', '.',
   2, '2', '.',
   2, '3', '.',
   2, '4', '.',
   2, '5', '.',
   2, '6', '.',
   2, '7', '.',
   2, '8', '.',
   2, '9', '.',
   3, '1', '0', '.',
   3, '1', '1', '.',
   3, '1', '2', '.',
   3, '1', '3', '.',
   3, '1', '4', '.',
   3, '1', '5', '.',
   3, '1', '6', '.',
   3, '1', '7', '.',
   3, '1', '8', '.',
   3, '1', '9', '.',
   3, '2', '0', '.',
   3, '(', 'a', ')',
   3, '(', 'b', ')',
   3, '(', 'c', ')',
   3, '(', 'd', ')',
   3, '(', 'e', ')',
   3, '(', 'f', ')',
   3, '(', 'g', ')',
   3, '(', 'h', ')',
   3, '(', 'i', ')',
   3, '(', 'j', ')',
   3, '(', 'k', ')',
   3, '(', 'l', ')',
   3, '(', 'm', ')',
   3, '(', 'n', ')',
   3, '(', 'o', ')',
   3, '(', 'p', ')',
   3, '(', 'q', ')',
   3, '(', 'r', ')',
   3, '(', 's', ')',
   3, '(', 't', ')',
   3, '(', 'u', ')',
   3, '(', 'v', ')',
   3, '(', 'w', ')',
   3, '(', 'x', ')',
   3, '(', 'y', ')',
   3, '(', 'z', ')',
   3, '(', 'A', ')',
   3, '(', 'B', ')',
   3, '(', 'C', ')',
   3, '(', 'D', ')',
   3, '(', 'E', ')',
   3, '(', 'F', ')',
   3, '(', 'G', ')',
   3, '(', 'H', ')',
   3, '(', 'I', ')',
   3, '(', 'J', ')',
   3, '(', 'K', ')',
   3, '(', 'L', ')',
   3, '(', 'M', ')',
   3, '(', 'N', ')',
   3, '(', 'O', ')',
   3, '(', 'P', ')',
   3, '(', 'Q', ')',
   3, '(', 'R', ')',
   3, '(', 'S', ')',
   3, '(', 'T', ')',
   3, '(', 'U', ')',
   3, '(', 'V', ')',
   3, '(', 'W', ')',
   3, '(', 'X', ')',
   3, '(', 'Y', ')',
   3, '(', 'Z', ')',
   3, '(', 'a', ')',
   3, '(', 'b', ')',
   3, '(', 'c', ')',
   3, '(', 'd', ')',
   3, '(', 'e', ')',
   3, '(', 'f', ')',
   3, '(', 'g', ')',
   3, '(', 'h', ')',
   3, '(', 'i', ')',
   3, '(', 'j', ')',
   3, '(', 'k', ')',
   3, '(', 'l', ')',
   3, '(', 'm', ')',
   3, '(', 'n', ')',
   3, '(', 'o', ')',
   3, '(', 'p', ')',
   3, '(', 'q', ')',
   3, '(', 'r', ')',
   3, '(', 's', ')',
   3, '(', 't', ')',
   3, '(', 'u', ')',
   3, '(', 'v', ')',
   3, '(', 'w', ')',
   3, '(', 'x', ')',
   3, '(', 'y', ')',
   3, '(', 'z', ')',
   3, '(', '0', ')',
   1, '-',
   1, '|',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, '+',
   1, 'o',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   2, '[', '|',
   2, '|', ']',
   1, '<',
   1, '>',
   2, '<', '<',
   2, '>', '>',
   2, '(', '(',
   2, ')', ')',
   1, '(',
   1, ')',
   3, '|', '|', '|',
   2, '{', '|',
   2, '|', '}',
   2, '(', '(',
   2, ')', ')',
   2, '(', '|',
   2, '|', ')',
   2, '<', '|',
   2, '|', '>',
   1, '#',
   1, '#',
   1,'\\',
   1, '/',
   1,'\\',
   1, '<',
   1, '>',
   1, '+',
   1, '-',
   4,0x222B,0x222B,0x222B,0x222B,
   3, ':', ':', '=',
   2, '=', '=',
   3, '=', '=', '=',
   1,0x6BCD,
   1,0x9F9F,
   1,0x4E00,
   1,0x4E28,
   1,0x4E36,
   1,0x4E3F,
   1,0x4E59,
   1,0x4E85,
   1,0x4E8C,
   1,0x4EA0,
   1,0x4EBA,
   1,0x513F,
   1,0x5165,
   1,0x516B,
   1,0x5182,
   1,0x5196,
   1,0x51AB,
   1,0x51E0,
   1,0x51F5,
   1,0x5200,
   1,0x529B,
   1,0x52F9,
   1,0x5315,
   1,0x531A,
   1,0x5338,
   1,0x5341,
   1,0x535C,
   1,0x5369,
   1,0x5382,
   1,0x53B6,
   1,0x53C8,
   1,0x53E3,
   1,0x56D7,
   1,0x571F,
   1,0x58EB,
   1,0x5902,
   1,0x590A,
   1,0x5915,
   1,0x5927,
   1,0x5973,
   1,0x5B50,
   1,0x5B80,
   1,0x5BF8,
   1,0x5C0F,
   1,0x5C22,
   1,0x5C38,
   1,0x5C6E,
   1,0x5C71,
   1,0x5DDB,
   1,0x5DE5,
   1,0x5DF1,
   1,0x5DFE,
   1,0x5E72,
   1,0x5E7A,
   1,0x5E7F,
   1,0x5EF4,
   1,0x5EFE,
   1,0x5F0B,
   1,0x5F13,
   1,0x5F50,
   1,0x5F61,
   1,0x5F73,
   1,0x5FC3,
   1,0x6208,
   1,0x6236,
   1,0x624B,
   1,0x652F,
   1,0x6534,
   1,0x6587,
   1,0x6597,
   1,0x65A4,
   1,0x65B9,
   1,0x65E0,
   1,0x65E5,
   1,0x66F0,
   1,0x6708,
   1,0x6728,
   1,0x6B20,
   1,0x6B62,
   1,0x6B79,
   1,0x6BB3,
   1,0x6BCB,
   1,0x6BD4,
   1,0x6BDB,
   1,0x6C0F,
   1,0x6C14,
   1,0x6C34,
   1,0x706B,
   1,0x722A,
   1,0x7236,
   1,0x723B,
   1,0x723F,
   1,0x7247,
   1,0x7259,
   1,0x725B,
   1,0x72AC,
   1,0x7384,
   1,0x7389,
   1,0x74DC,
   1,0x74E6,
   1,0x7518,
   1,0x751F,
   1,0x7528,
   1,0x7530,
   1,0x758B,
   1,0x7592,
   1,0x7676,
   1,0x767D,
   1,0x76AE,
   1,0x76BF,
   1,0x76EE,
   1,0x77DB,
   1,0x77E2,
   1,0x77F3,
   1,0x793A,
   1,0x79B8,
   1,0x79BE,
   1,0x7A74,
   1,0x7ACB,
   1,0x7AF9,
   1,0x7C73,
   1,0x7CF8,
   1,0x7F36,
   1,0x7F51,
   1,0x7F8A,
   1,0x7FBD,
   1,0x8001,
   1,0x800C,
   1,0x8012,
   1,0x8033,
   1,0x807F,
   1,0x8089,
   1,0x81E3,
   1,0x81EA,
   1,0x81F3,
   1,0x81FC,
   1,0x820C,
   1,0x821B,
   1,0x821F,
   1,0x826E,
   1,0x8272,
   1,0x8278,
   1,0x864D,
   1,0x866B,
   1,0x8840,
   1,0x884C,
   1,0x8863,
   1,0x897E,
   1,0x898B,
   1,0x89D2,
   1,0x8A00,
   1,0x8C37,
   1,0x8C46,
   1,0x8C55,
   1,0x8C78,
   1,0x8C9D,
   1,0x8D64,
   1,0x8D70,
   1,0x8DB3,
   1,0x8EAB,
   1,0x8ECA,
   1,0x8F9B,
   1,0x8FB0,
   1,0x8FB5,
   1,0x9091,
   1,0x9149,
   1,0x91C6,
   1,0x91CC,
   1,0x91D1,
   1,0x9577,
   1,0x9580,
   1,0x961C,
   1,0x96B6,
   1,0x96B9,
   1,0x96E8,
   1,0x9751,
   1,0x975E,
   1,0x9762,
   1,0x9769,
   1,0x97CB,
   1,0x97ED,
   1,0x97F3,
   1,0x9801,
   1,0x98A8,
   1,0x98DB,
   1,0x98DF,
   1,0x9996,
   1,0x9999,
   1,0x99AC,
   1,0x9AA8,
   1,0x9AD8,
   1,0x9ADF,
   1,0x9B25,
   1,0x9B2F,
   1,0x9B32,
   1,0x9B3C,
   1,0x9B5A,
   1,0x9CE5,
   1,0x9E75,
   1,0x9E7F,
   1,0x9EA5,
   1,0x9EBB,
   1,0x9EC3,
   1,0x9ECD,
   1,0x9ED1,
   1,0x9EF9,
   1,0x9EFD,
   1,0x9F0E,
   1,0x9F13,
   1,0x9F20,
   1,0x9F3B,
   1,0x9F4A,
   1,0x9F52,
   1,0x9F8D,
   1,0x9F9C,
   1,0x9FA0,
   1, ' ',
   1,0x3012,
   1,0x5341,
   1,0x5344,
   1,0x5345,
   1,0x3042,
   1,0x3044,
   1,0x3046,
   1,0x3048,
   1,0x304A,
   1,0x3064,
   1,0x3084,
   1,0x3086,
   1,0x3088,
   1,0x308F,
   1,0x304B,
   1,0x3051,
   2, ' ',0x3099,
   2, ' ',0x309A,
   1, '=',
   1,0x30A2,
   1,0x30A4,
   1,0x30A6,
   1,0x30A8,
   1,0x30AA,
   1,0x30C4,
   1,0x30E4,
   1,0x30E6,
   1,0x30E8,
   1,0x30EF,
   1,0x30AB,
   1,0x30B1,
   1,0x1100,
   1,0x1101,
   1,0x11AA,
   1,0x1102,
   1,0x11AC,
   1,0x11AD,
   1,0x1103,
   1,0x1104,
   1,0x1105,
   1,0x11B0,
   1,0x11B1,
   1,0x11B2,
   1,0x11B3,
   1,0x11B4,
   1,0x11B5,
   1,0x111A,
   1,0x1106,
   1,0x1107,
   1,0x1108,
   1,0x1121,
   1,0x1109,
   1,0x110A,
   1,0x110B,
   1,0x110C,
   1,0x110D,
   1,0x110E,
   1,0x110F,
   1,0x1110,
   1,0x1111,
   1,0x1112,
   1,0x1161,
   1,0x1162,
   1,0x1163,
   1,0x1164,
   1,0x1165,
   1,0x1166,
   1,0x1167,
   1,0x1168,
   1,0x1169,
   1,0x116A,
   1,0x116B,
   1,0x116C,
   1,0x116D,
   1,0x116E,
   1,0x116F,
   1,0x1170,
   1,0x1171,
   1,0x1172,
   1,0x1173,
   1,0x1174,
   1,0x1175,
   1,0x1160,
   1,0x1114,
   1,0x1115,
   1,0x11C7,
   1,0x11C8,
   1,0x11CC,
   1,0x11CE,
   1,0x11D3,
   1,0x11D7,
   1,0x11D9,
   1,0x111C,
   1,0x11DD,
   1,0x11DF,
   1,0x111D,
   1,0x111E,
   1,0x1120,
   1,0x1122,
   1,0x1123,
   1,0x1127,
   1,0x1129,
   1,0x112B,
   1,0x112C,
   1,0x112D,
   1,0x112E,
   1,0x112F,
   1,0x1132,
   1,0x1136,
   1,0x1140,
   1,0x1147,
   1,0x114C,
   1,0x11F1,
   1,0x11F2,
   1,0x1157,
   1,0x1158,
   1,0x1159,
   1,0x1184,
   1,0x1185,
   1,0x1188,
   1,0x1191,
   1,0x1192,
   1,0x1194,
   1,0x119E,
   1,0x11A1,
   1,0x30AF,
   1,0x30B7,
   1,0x30B9,
   1,0x30C8,
   1,0x30CC,
   1,0x30CF,
   1,0x30D2,
   1,0x30D5,
   1,0x30D8,
   1,0x30DB,
   1,0x30E0,
   1,0x30E9,
   1,0x30EA,
   1,0x30EB,
   1,0x30EC,
   1,0x30ED,
   3, '(',0x1100, ')',
   3, '(',0x1102, ')',
   3, '(',0x1103, ')',
   3, '(',0x1105, ')',
   3, '(',0x1106, ')',
   3, '(',0x1107, ')',
   3, '(',0x1109, ')',
   3, '(',0x110B, ')',
   3, '(',0x110C, ')',
   3, '(',0x110E, ')',
   3, '(',0x110F, ')',
   3, '(',0x1110, ')',
   3, '(',0x1111, ')',
   3, '(',0x1112, ')',
   4, '(',0x1100,0x1161, ')',
   4, '(',0x1102,0x1161, ')',
   4, '(',0x1103,0x1161, ')',
   4, '(',0x1105,0x1161, ')',
   4, '(',0x1106,0x1161, ')',
   4, '(',0x1107,0x1161, ')',
   4, '(',0x1109,0x1161, ')',
   4, '(',0x110B,0x1161, ')',
   4, '(',0x110C,0x1161, ')',
   4, '(',0x110E,0x1161, ')',
   4, '(',0x110F,0x1161, ')',
   4, '(',0x1110,0x1161, ')',
   4, '(',0x1111,0x1161, ')',
   4, '(',0x1112,0x1161, ')',
   4, '(',0x110C,0x116E, ')',
   7, '(',0x110B,0x1169,0x110C,0x1165,0x11AB, ')',
   6, '(',0x110B,0x1169,0x1112,0x116E, ')',
   3, '(',0x4E00, ')',
   3, '(',0x4E8C, ')',
   3, '(',0x4E09, ')',
   3, '(',0x56DB, ')',
   3, '(',0x4E94, ')',
   3, '(',0x516D, ')',
   3, '(',0x4E03, ')',
   3, '(',0x516B, ')',
   3, '(',0x4E5D, ')',
   3, '(',0x5341, ')',
   3, '(',0x6708, ')',
   3, '(',0x706B, ')',
   3, '(',0x6C34, ')',
   3, '(',0x6728, ')',
   3, '(',0x91D1, ')',
   3, '(',0x571F, ')',
   3, '(',0x65E5, ')',
   3, '(',0x682A, ')',
   3, '(',0x6709, ')',
   3, '(',0x793E, ')',
   3, '(',0x540D, ')',
   3, '(',0x7279, ')',
   3, '(',0x8CA1, ')',
   3, '(',0x795D, ')',
   3, '(',0x52B4, ')',
   3, '(',0x4EE3, ')',
   3, '(',0x547C, ')',
   3, '(',0x5B66, ')',
   3, '(',0x76E3, ')',
   3, '(',0x4F01, ')',
   3, '(',0x8CC7, ')',
   3, '(',0x5354, ')',
   3, '(',0x796D, ')',
   3, '(',0x4F11, ')',
   3, '(',0x81EA, ')',
   3, '(',0x81F3, ')',
   3, '(',0x554F, ')',
   3, '(',0x5E7C, ')',
   3, '(',0x6587, ')',
   3, '(',0x7B8F, ')',
   3, 'P', 'T', 'E',
   4, '(', '2', '1', ')',
   4, '(', '2', '2', ')',
   4, '(', '2', '3', ')',
   4, '(', '2', '4', ')',
   4, '(', '2', '5', ')',
   4, '(', '2', '6', ')',
   4, '(', '2', '7', ')',
   4, '(', '2', '8', ')',
   4, '(', '2', '9', ')',
   4, '(', '3', '0', ')',
   4, '(', '3', '1', ')',
   4, '(', '3', '2', ')',
   4, '(', '3', '3', ')',
   4, '(', '3', '4', ')',
   4, '(', '3', '5', ')',
   3, '(',0x1100, ')',
   3, '(',0x1102, ')',
   3, '(',0x1103, ')',
   3, '(',0x1105, ')',
   3, '(',0x1106, ')',
   3, '(',0x1107, ')',
   3, '(',0x1109, ')',
   3, '(',0x110B, ')',
   3, '(',0x110C, ')',
   3, '(',0x110E, ')',
   3, '(',0x110F, ')',
   3, '(',0x1110, ')',
   3, '(',0x1111, ')',
   3, '(',0x1112, ')',
   4, '(',0x1100,0x1161, ')',
   4, '(',0x1102,0x1161, ')',
   4, '(',0x1103,0x1161, ')',
   4, '(',0x1105,0x1161, ')',
   4, '(',0x1106,0x1161, ')',
   4, '(',0x1107,0x1161, ')',
   4, '(',0x1109,0x1161, ')',
   4, '(',0x110B,0x1161, ')',
   4, '(',0x110C,0x1161, ')',
   4, '(',0x110E,0x1161, ')',
   4, '(',0x110F,0x1161, ')',
   4, '(',0x1110,0x1161, ')',
   4, '(',0x1111,0x1161, ')',
   4, '(',0x1112,0x1161, ')',
   7, '(',0x110E,0x1161,0x11B7,0x1100,0x1169, ')',
   6, '(',0x110C,0x116E,0x110B,0x1174, ')',
   4, '(',0x110B,0x116E, ')',
   3, '(',0x4E00, ')',
   3, '(',0x4E8C, ')',
   3, '(',0x4E09, ')',
   3, '(',0x56DB, ')',
   3, '(',0x4E94, ')',
   3, '(',0x516D, ')',
   3, '(',0x4E03, ')',
   3, '(',0x516B, ')',
   3, '(',0x4E5D, ')',
   3, '(',0x5341, ')',
   3, '(',0x6708, ')',
   3, '(',0x706B, ')',
   3, '(',0x6C34, ')',
   3, '(',0x6728, ')',
   3, '(',0x91D1, ')',
   3, '(',0x571F, ')',
   3, '(',0x65E5, ')',
   3, '(',0x682A, ')',
   3, '(',0x6709, ')',
   3, '(',0x793E, ')',
   3, '(',0x540D, ')',
   3, '(',0x7279, ')',
   3, '(',0x8CA1, ')',
   3, '(',0x795D, ')',
   3, '(',0x52B4, ')',
   3, '(',0x79D8, ')',
   3, '(',0x7537, ')',
   3, '(',0x5973, ')',
   3, '(',0x9069, ')',
   3, '(',0x512A, ')',
   3, '(',0x5370, ')',
   3, '(',0x6CE8, ')',
   3, '(',0x9805, ')',
   3, '(',0x4F11, ')',
   3, '(',0x5199, ')',
   3, '(',0x6B63, ')',
   3, '(',0x4E0A, ')',
   3, '(',0x4E2D, ')',
   3, '(',0x4E0B, ')',
   3, '(',0x5DE6, ')',
   3, '(',0x53F3, ')',
   3, '(',0x533B, ')',
   3, '(',0x5B97, ')',
   3, '(',0x5B66, ')',
   3, '(',0x76E3, ')',
   3, '(',0x4F01, ')',
   3, '(',0x8CC7, ')',
   3, '(',0x5354, ')',
   3, '(',0x591C, ')',
   4, '(', '3', '6', ')',
   4, '(', '3', '7', ')',
   4, '(', '3', '8', ')',
   4, '(', '3', '9', ')',
   4, '(', '4', '0', ')',
   4, '(', '4', '1', ')',
   4, '(', '4', '2', ')',
   4, '(', '4', '3', ')',
   4, '(', '4', '4', ')',
   4, '(', '4', '5', ')',
   4, '(', '4', '6', ')',
   4, '(', '4', '7', ')',
   4, '(', '4', '8', ')',
   4, '(', '4', '9', ')',
   4, '(', '5', '0', ')',
   2, '1',0x6708,
   2, '2',0x6708,
   2, '3',0x6708,
   2, '4',0x6708,
   2, '5',0x6708,
   2, '6',0x6708,
   2, '7',0x6708,
   2, '8',0x6708,
   2, '9',0x6708,
   3, '1', '0',0x6708,
   3, '1', '1',0x6708,
   3, '1', '2',0x6708,
   2, 'H', 'g',
   3, 'e', 'r', 'g',
   2, 'e', 'V',
   3, 'L', 'T', 'D',
   3, '(',0x30A2, ')',
   3, '(',0x30A4, ')',
   3, '(',0x30A6, ')',
   3, '(',0x30A8, ')',
   3, '(',0x30AA, ')',
   3, '(',0x30AB, ')',
   3, '(',0x30AD, ')',
   3, '(',0x30AF, ')',
   3, '(',0x30B1, ')',
   3, '(',0x30B3, ')',
   3, '(',0x30B5, ')',
   3, '(',0x30B7, ')',
   3, '(',0x30B9, ')',
   3, '(',0x30BB, ')',
   3, '(',0x30BD, ')',
   3, '(',0x30BF, ')',
   3, '(',0x30C1, ')',
   3, '(',0x30C4, ')',
   3, '(',0x30C6, ')',
   3, '(',0x30C8, ')',
   3, '(',0x30CA, ')',
   3, '(',0x30CB, ')',
   3, '(',0x30CC, ')',
   3, '(',0x30CD, ')',
   3, '(',0x30CE, ')',
   3, '(',0x30CF, ')',
   3, '(',0x30D2, ')',
   3, '(',0x30D5, ')',
   3, '(',0x30D8, ')',
   3, '(',0x30DB, ')',
   3, '(',0x30DE, ')',
   3, '(',0x30DF, ')',
   3, '(',0x30E0, ')',
   3, '(',0x30E1, ')',
   3, '(',0x30E2, ')',
   3, '(',0x30E4, ')',
   3, '(',0x30E6, ')',
   3, '(',0x30E8, ')',
   3, '(',0x30E9, ')',
   3, '(',0x30EA, ')',
   3, '(',0x30EB, ')',
   3, '(',0x30EC, ')',
   3, '(',0x30ED, ')',
   3, '(',0x30EF, ')',
   3, '(',0x30F0, ')',
   3, '(',0x30F1, ')',
   3, '(',0x30F2, ')',
   2,0x4EE4,0x548C,
   4,0x30A2,0x30D1,0x30FC,0x30C8,
   4,0x30A2,0x30EB,0x30D5,0x30A1,
   4,0x30A2,0x30F3,0x30DA,0x30A2,
   3,0x30A2,0x30FC,0x30EB,
   4,0x30A4,0x30CB,0x30F3,0x30B0,
   3,0x30A4,0x30F3,0x30C1,
   3,0x30A6,0x30A9,0x30F3,
   5,0x30A8,0x30B9,0x30AF,0x30FC,0x30C9,
   4,0x30A8,0x30FC,0x30AB,0x30FC,
   3,0x30AA,0x30F3,0x30B9,
   3,0x30AA,0x30FC,0x30E0,
   3,0x30AB,0x30A4,0x30EA,
   4,0x30AB,0x30E9,0x30C3,0x30C8,
   4,0x30AB,0x30ED,0x30EA,0x30FC,
   3,0x30AC,0x30ED,0x30F3,
   3,0x30AC,0x30F3,0x30DE,
   2,0x30AE,0x30AC,
   3,0x30AE,0x30CB,0x30FC,
   4,0x30AD,0x30E5,0x30EA,0x30FC,
   4,0x30AE,0x30EB,0x30C0,0x30FC,
   2,0x30AD,0x30ED,
   5,0x30AD,0x30ED,0x30B0,0x30E9,0x30E0,
   6,0x30AD,0x30ED,0x30E1,0x30FC,0x30C8,0x30EB,
   5,0x30AD,0x30ED,0x30EF,0x30C3,0x30C8,
   3,0x30B0,0x30E9,0x30E0,
   5,0x30B0,0x30E9,0x30E0,0x30C8,0x30F3,
   5,0x30AF,0x30EB,0x30BC,0x30A4,0x30ED,
   4,0x30AF,0x30ED,0x30FC,0x30CD,
   3,0x30B1,0x30FC,0x30B9,
   3,0x30B3,0x30EB,0x30CA,
   3,0x30B3,0x30FC,0x30DD,
   4,0x30B5,0x30A4,0x30AF,0x30EB,
   5,0x30B5,0x30F3,0x30C1,0x30FC,0x30E0,
   4,0x30B7,0x30EA,0x30F3,0x30B0,
   3,0x30BB,0x30F3,0x30C1,
   3,0x30BB,0x30F3,0x30C8,
   3,0x30C0,0x30FC,0x30B9,
   2,0x30C7,0x30B7,
   2,0x30C9,0x30EB,
   2,0x30C8,0x30F3,
   2,0x30CA,0x30CE,
   3,0x30CE,0x30C3,0x30C8,
   3,0x30CF,0x30A4,0x30C4,
   5,0x30D1,0x30FC,0x30BB,0x30F3,0x30C8,
   3,0x30D1,0x30FC,0x30C4,
   4,0x30D0,0x30FC,0x30EC,0x30EB,
   5,0x30D4,0x30A2,0x30B9,0x30C8,0x30EB,
   3,0x30D4,0x30AF,0x30EB,
   2,0x30D4,0x30B3,
   2,0x30D3,0x30EB,
   5,0x30D5,0x30A1,0x30E9,0x30C3,0x30C9,
   4,0x30D5,0x30A3,0x30FC,0x30C8,
   5,0x30D6,0x30C3,0x30B7,0x30A7,0x30EB,
   3,0x30D5,0x30E9,0x30F3,
   5,0x30D8,0x30AF,0x30BF,0x30FC,0x30EB,
   2,0x30DA,0x30BD,
   3,0x30DA,0x30CB,0x30D2,
   3,0x30D8,0x30EB,0x30C4,
   3,0x30DA,0x30F3,0x30B9,
   3,0x30DA,0x30FC,0x30B8,
   3,0x30D9,0x30FC,0x30BF,
   4,0x30DD,0x30A4,0x30F3,0x30C8,
   3,0x30DC,0x30EB,0x30C8,
   2,0x30DB,0x30F3,
   3,0x30DD,0x30F3,0x30C9,
   3,0x30DB,0x30FC,0x30EB,
   3,0x30DB,0x30FC,0x30F3,
   4,0x30DE,0x30A4,0x30AF,0x30ED,
   3,0x30DE,0x30A4,0x30EB,
   3,0x30DE,0x30C3,0x30CF,
   3,0x30DE,0x30EB,0x30AF,
   5,0x30DE,0x30F3,0x30B7,0x30E7,0x30F3,
   4,0x30DF,0x30AF,0x30ED,0x30F3,
   2,0x30DF,0x30EA,
   5,0x30DF,0x30EA,0x30D0,0x30FC,0x30EB,
   2,0x30E1,0x30AC,
   4,0x30E1,0x30AC,0x30C8,0x30F3,
   4,0x30E1,0x30FC,0x30C8,0x30EB,
   3,0x30E4,0x30FC,0x30C9,
   3,0x30E4,0x30FC,0x30EB,
   3,0x30E6,0x30A2,0x30F3,
   4,0x30EA,0x30C3,0x30C8,0x30EB,
   2,0x30EA,0x30E9,
   3,0x30EB,0x30D4,0x30FC,
   4,0x30EB,0x30FC,0x30D6,0x30EB,
   2,0x30EC,0x30E0,
   5,0x30EC,0x30F3,0x30C8,0x30B2,0x30F3,
   3,0x30EF,0x30C3,0x30C8,
   2, '0',0x70B9,
   2, '1',0x70B9,
   2, '2',0x70B9,
   2, '3',0x70B9,
   2, '4',0x70B9,
   2, '5',0x70B9,
   2, '6',0x70B9,
   2, '7',0x70B9,
   2, '8',0x70B9,
   2, '9',0x70B9,
   3, '1', '0',0x70B9,
   3, '1', '1',0x70B9,
   3, '1', '2',0x70B9,
   3, '1', '3',0x70B9,
   3, '1', '4',0x70B9,
   3, '1', '5',0x70B9,
   3, '1', '6',0x70B9,
   3, '1', '7',0x70B9,
   3, '1', '8',0x70B9,
   3, '1', '9',0x70B9,
   3, '2', '0',0x70B9,
   3, '2', '1',0x70B9,
   3, '2', '2',0x70B9,
   3, '2', '3',0x70B9,
   3, '2', '4',0x70B9,
   3, 'h', 'P', 'a',
   2, 'd', 'a',
   2, 'A', 'U',
   3, 'b', 'a', 'r',
   2, 'o', 'V',
   2, 'p', 'c',
   2, 'd', 'm',
   4, 'd', 'm', '^', '2',
   4, 'd', 'm', '^', '3',
   2, 'I', 'U',
   2,0x5E73,0x6210,
   2,0x662D,0x548C,
   2,0x5927,0x6B63,
   2,0x660E,0x6CBB,
   4,0x682A,0x5F0F,0x4F1A,0x793E,
   2, 'p', 'A',
   2, 'n', 'A',
   2,0x03BC, 'A',
   2, 'm', 'A',
   2, 'k', 'A',
   2, 'K', 'B',
   2, 'M', 'B',
   2, 'G', 'B',
   3, 'c', 'a', 'l',
   4, 'k', 'c', 'a', 'l',
   2, 'p', 'F',
   2, 'n', 'F',
   2,0x03BC, 'F',
   2,0x03BC, 'g',
   2, 'm', 'g',
   2, 'k', 'g',
   2, 'H', 'z',
   3, 'k', 'H', 'z',
   3, 'M', 'H', 'z',
   3, 'G', 'H', 'z',
   3, 'T', 'H', 'z',
   2,0x03BC, 'l',
   2, 'm', 'l',
   2, 'd', 'l',
   2, 'k', 'l',
   2, 'f', 'm',
   2, 'n', 'm',
   2,0x03BC, 'm',
   2, 'm', 'm',
   2, 'c', 'm',
   2, 'k', 'm',
   4, 'm', 'm', '^', '2',
   4, 'c', 'm', '^', '2',
   3, 'm', '^', '2',
   4, 'k', 'm', '^', '2',
   4, 'm', 'm', '^', '3',
   4, 'c', 'm', '^', '3',
   3, 'm', '^', '3',
   4, 'k', 'm', '^', '3',
   3, 'm', '/', 's',
   5, 'm', '/', 's', '^', '2',
   2, 'P', 'a',
   3, 'k', 'P', 'a',
   3, 'M', 'P', 'a',
   3, 'G', 'P', 'a',
   3, 'r', 'a', 'd',
   5, 'r', 'a', 'd', '/', 's',
   7, 'r', 'a', 'd', '/', 's', '^', '2',
   2, 'p', 's',
   2, 'n', 's',
   2,0x03BC, 's',
   2, 'm', 's',
   2, 'p', 'V',
   2, 'n', 'V',
   2,0x03BC, 'V',
   2, 'm', 'V',
   2, 'k', 'V',
   2, 'M', 'V',
   2, 'p', 'W',
   2, 'n', 'W',
   2,0x03BC, 'W',
   2, 'm', 'W',
   2, 'k', 'W',
   2, 'M', 'W',
   2, 'k',0x03A9,
   2, 'M',0x03A9,
   4, 'a', '.', 'm', '.',
   2, 'B', 'q',
   2, 'c', 'c',
   2, 'c', 'd',
   4, 'C', '/', 'k', 'g',
   3, 'C', 'o', '.',
   2, 'd', 'B',
   2, 'G', 'y',
   2, 'h', 'a',
   2, 'H', 'P',
   2, 'i', 'n',
   2, 'K', 'K',
   2, 'K', 'M',
   2, 'k', 't',
   2, 'l', 'm',
   2, 'l', 'n',
   3, 'l', 'o', 'g',
   2, 'l', 'x',
   2, 'm', 'b',
   3, 'm', 'i', 'l',
   3, 'm', 'o', 'l',
   2, 'P', 'H',
   4, 'p', '.', 'm', '.',
   3, 'P', 'P', 'M',
   2, 'P', 'R',
   2, 's', 'r',
   2, 'S', 'v',
   2, 'W', 'b',
   3, 'V', '/', 'm',
   3, 'A', '/', 'm',
   2, '1',0x65E5,
   2, '2',0x65E5,
   2, '3',0x65E5,
   2, '4',0x65E5,
   2, '5',0x65E5,
   2, '6',0x65E5,
   2, '7',0x65E5,
   2, '8',0x65E5,
   2, '9',0x65E5,
   3, '1', '0',0x65E5,
   3, '1', '1',0x65E5,
   3, '1', '2',0x65E5,
   3, '1', '3',0x65E5,
   3, '1', '4',0x65E5,
   3, '1', '5',0x65E5,
   3, '1', '6',0x65E5,
   3, '1', '7',0x65E5,
   3, '1', '8',0x65E5,
   3, '1', '9',0x65E5,
   3, '2', '0',0x65E5,
   3, '2', '1',0x65E5,
   3, '2', '2',0x65E5,
   3, '2', '3',0x65E5,
   3, '2', '4',0x65E5,
   3, '2', '5',0x65E5,
   3, '2', '6',0x65E5,
   3, '2', '7',0x65E5,
   3, '2', '8',0x65E5,
   3, '2', '9',0x65E5,
   3, '3', '0',0x65E5,
   3, '3', '1',0x65E5,
   3, 'g', 'a', 'l',
   1,0x8C48,
   1,0x66F4,
   1,0x8ECA,
   1,0x8CC8,
   1,0x6ED1,
   1,0x4E32,
   1,0x53E5,
   1,0x9F9C,
   1,0x9F9C,
   1,0x5951,
   1,0x91D1,
   1,0x5587,
   1,0x5948,
   1,0x61F6,
   1,0x7669,
   1,0x7F85,
   1,0x863F,
   1,0x87BA,
   1,0x88F8,
   1,0x908F,
   1,0x6A02,
   1,0x6D1B,
   1,0x70D9,
   1,0x73DE,
   1,0x843D,
   1,0x916A,
   1,0x99F1,
   1,0x4E82,
   1,0x5375,
   1,0x6B04,
   1,0x721B,
   1,0x862D,
   1,0x9E1E,
   1,0x5D50,
   1,0x6FEB,
   1,0x85CD,
   1,0x8964,
   1,0x62C9,
   1,0x81D8,
   1,0x881F,
   1,0x5ECA,
   1,0x6717,
   1,0x6D6A,
   1,0x72FC,
   1,0x90CE,
   1,0x4F86,
   1,0x51B7,
   1,0x52DE,
   1,0x64C4,
   1,0x6AD3,
   1,0x7210,
   1,0x76E7,
   1,0x8001,
   1,0x8606,
   1,0x865C,
   1,0x8DEF,
   1,0x9732,
   1,0x9B6F,
   1,0x9DFA,
   1,0x788C,
   1,0x797F,
   1,0x7DA0,
   1,0x83C9,
   1,0x9304,
   1,0x9E7F,
   1,0x8AD6,
   1,0x58DF,
   1,0x5F04,
   1,0x7C60,
   1,0x807E,
   1,0x7262,
   1,0x78CA,
   1,0x8CC2,
   1,0x96F7,
   1,0x58D8,
   1,0x5C62,
   1,0x6A13,
   1,0x6DDA,
   1,0x6F0F,
   1,0x7D2F,
   1,0x7E37,
   1,0x964B,
   1,0x52D2,
   1,0x808B,
   1,0x51DC,
   1,0x51CC,
   1,0x7A1C,
   1,0x7DBE,
   1,0x83F1,
   1,0x9675,
   1,0x8B80,
   1,0x62CF,
   1,0x6A02,
   1,0x8AFE,
   1,0x4E39,
   1,0x5BE7,
   1,0x6012,
   1,0x7387,
   1,0x7570,
   1,0x5317,
   1,0x78FB,
   1,0x4FBF,
   1,0x5FA9,
   1,0x4E0D,
   1,0x6CCC,
   1,0x6578,
   1,0x7D22,
   1,0x53C3,
   1,0x585E,
   1,0x7701,
   1,0x8449,
   1,0x8AAA,
   1,0x6BBA,
   1,0x8FB0,
   1,0x6C88,
   1,0x62FE,
   1,0x82E5,
   1,0x63A0,
   1,0x7565,
   1,0x4EAE,
   1,0x5169,
   1,0x51C9,
   1,0x6881,
   1,0x7CE7,
   1,0x826F,
   1,0x8AD2,
   1,0x91CF,
   1,0x52F5,
   1,0x5442,
   1,0x5973,
   1,0x5EEC,
   1,0x65C5,
   1,0x6FFE,
   1,0x792A,
   1,0x95AD,
   1,0x9A6A,
   1,0x9E97,
   1,0x9ECE,
   1,0x529B,
   1,0x66C6,
   1,0x6B77,
   1,0x8F62,
   1,0x5E74,
   1,0x6190,
   1,0x6200,
   1,0x649A,
   1,0x6F23,
   1,0x7149,
   1,0x7489,
   1,0x79CA,
   1,0x7DF4,
   1,0x806F,
   1,0x8F26,
   1,0x84EE,
   1,0x9023,
   1,0x934A,
   1,0x5217,
   1,0x52A3,
   1,0x54BD,
   1,0x70C8,
   1,0x88C2,
   1,0x8AAA,
   1,0x5EC9,
   1,0x5FF5,
   1,0x637B,
   1,0x6BAE,
   1,0x7C3E,
   1,0x7375,
   1,0x4EE4,
   1,0x56F9,
   1,0x5BE7,
   1,0x5DBA,
   1,0x601C,
   1,0x73B2,
   1,0x7469,
   1,0x7F9A,
   1,0x8046,
   1,0x9234,
   1,0x96F6,
   1,0x9748,
   1,0x9818,
   1,0x4F8B,
   1,0x79AE,
   1,0x91B4,
   1,0x96B8,
   1,0x60E1,
   1,0x4E86,
   1,0x50DA,
   1,0x5BEE,
   1,0x5C3F,
   1,0x6599,
   1,0x6A02,
   1,0x71CE,
   1,0x7642,
   1,0x84FC,
   1,0x907C,
   1,0x9F8D,
   1,0x6688,
   1,0x962E,
   1,0x5289,
   1,0x677B,
   1,0x67F3,
   1,0x6D41,
   1,0x6E9C,
   1,0x7409,
   1,0x7559,
   1,0x786B,
   1,0x7D10,
   1,0x985E,
   1,0x516D,
   1,0x622E,
   1,0x9678,
   1,0x502B,
   1,0x5D19,
   1,0x6DEA,
   1,0x8F2A,
   1,0x5F8B,
   1,0x6144,
   1,0x6817,
   1,0x7387,
   1,0x9686,
   1,0x5229,
   1,0x540F,
   1,0x5C65,
   1,0x6613,
   1,0x674E,
   1,0x68A8,
   1,0x6CE5,
   1,0x7406,
   1,0x75E2,
   1,0x7F79,
   1,0x88CF,
   1,0x88E1,
   1,0x91CC,
   1,0x96E2,
   1,0x533F,
   1,0x6EBA,
   1,0x541D,
   1,0x71D0,
   1,0x7498,
   1,0x85FA,
   1,0x96A3,
   1,0x9C57,
   1,0x9E9F,
   1,0x6797,
   1,0x6DCB,
   1,0x81E8,
   1,0x7ACB,
   1,0x7B20,
   1,0x7C92,
   1,0x72C0,
   1,0x7099,
   1,0x8B58,
   1,0x4EC0,
   1,0x8336,
   1,0x523A,
   1,0x5207,
   1,0x5EA6,
   1,0x62D3,
   1,0x7CD6,
   1,0x5B85,
   1,0x6D1E,
   1,0x66B4,
   1,0x8F3B,
   1,0x884C,
   1,0x964D,
   1,0x898B,
   1,0x5ED3,
   1,0x5140,
   1,0x55C0,
   1,0x585A,
   1,0x6674,
   1,0x51DE,
   1,0x732A,
   1,0x76CA,
   1,0x793C,
   1,0x795E,
   1,0x7965,
   1,0x798F,
   1,0x9756,
   1,0x7CBE,
   1,0x7FBD,
   1,0x8612,
   1,0x8AF8,
   1,0x9038,
   1,0x90FD,
   1,0x98EF,
   1,0x98FC,
   1,0x9928,
   1,0x9DB4,
   1,0x90DE,
   1,0x96B7,
   1,0x4FAE,
   1,0x50E7,
   1,0x514D,
   1,0x52C9,
   1,0x52E4,
   1,0x5351,
   1,0x559D,
   1,0x5606,
   1,0x5668,
   1,0x5840,
   1,0x58A8,
   1,0x5C64,
   1,0x5C6E,
   1,0x6094,
   1,0x6168,
   1,0x618E,
   1,0x61F2,
   1,0x654F,
   1,0x65E2,
   1,0x6691,
   1,0x6885,
   1,0x6D77,
   1,0x6E1A,
   1,0x6F22,
   1,0x716E,
   1,0x722B,
   1,0x7422,
   1,0x7891,
   1,0x793E,
   1,0x7949,
   1,0x7948,
   1,0x7950,
   1,0x7956,
   1,0x795D,
   1,0x798D,
   1,0x798E,
   1,0x7A40,
   1,0x7A81,
   1,0x7BC0,
   1,0x7DF4,
   1,0x7E09,
   1,0x7E41,
   1,0x7F72,
   1,0x8005,
   1,0x81ED,
   1,0x8279,
   1,0x8279,
   1,0x8457,
   1,0x8910,
   1,0x8996,
   1,0x8B01,
   1,0x8B39,
   1,0x8CD3,
   1,0x8D08,
   1,0x8FB6,
   1,0x9038,
   1,0x96E3,
   1,0x97FF,
   1,0x983B,
   1,0x6075,
   1,0x242EE,
   1,0x8218,
   1,0x4E26,
   1,0x51B5,
   1,0x5168,
   1,0x4F80,
   1,0x5145,
   1,0x5180,
   1,0x52C7,
   1,0x52FA,
   1,0x559D,
   1,0x5555,
   1,0x5599,
   1,0x55E2,
   1,0x585A,
   1,0x58B3,
   1,0x5944,
   1,0x5954,
   1,0x5A62,
   1,0x5B28,
   1,0x5ED2,
   1,0x5ED9,
   1,0x5F69,
   1,0x5FAD,
   1,0x60D8,
   1,0x614E,
   1,0x6108,
   1,0x618E,
   1,0x6160,
   1,0x61F2,
   1,0x6234,
   1,0x63C4,
   1,0x641C,
   1,0x6452,
   1,0x6556,
   1,0x6674,
   1,0x6717,
   1,0x671B,
   1,0x6756,
   1,0x6B79,
   1,0x6BBA,
   1,0x6D41,
   1,0x6EDB,
   1,0x6ECB,
   1,0x6F22,
   1,0x701E,
   1,0x716E,
   1,0x77A7,
   1,0x7235,
   1,0x72AF,
   1,0x732A,
   1,0x7471,
   1,0x7506,
   1,0x753B,
   1,0x761D,
   1,0x761F,
   1,0x76CA,
   1,0x76DB,
   1,0x76F4,
   1,0x774A,
   1,0x7740,
   1,0x78CC,
   1,0x7AB1,
   1,0x7BC0,
   1,0x7C7B,
   1,0x7D5B,
   1,0x7DF4,
   1,0x7F3E,
   1,0x8005,
   1,0x8352,
   1,0x83EF,
   1,0x8779,
   1,0x8941,
   1,0x8986,
   1,0x8996,
   1,0x8ABF,
   1,0x8AF8,
   1,0x8ACB,
   1,0x8B01,
   1,0x8AFE,
   1,0x8AED,
   1,0x8B39,
   1,0x8B8A,
   1,0x8D08,
   1,0x8F38,
   1,0x9072,
   1,0x9199,
   1,0x9276,
   1,0x967C,
   1,0x96E3,
   1,0x9756,
   1,0x97DB,
   1,0x97FF,
   1,0x980B,
   1,0x983B,
   1,0x9B12,
   1,0x9F9C,
   1,0x2284A,
   1,0x22844,
   1,0x233D5,
   1,0x3B9D,
   1,0x4018,
   1,0x4039,
   1,0x25249,
   1,0x25CD0,
   1,0x27ED3,
   1,0x9F43,
   1,0x9F8E,
   2, 'f', 'f',
   2, 'f', 'i',
   2, 'f', 'l',
   3, 'f', 'f', 'i',
   3, 'f', 'f', 'l',
   2,0x017F, 't',
   2, 's', 't',
   2,0x0574,0x0576,
   2,0x0574,0x0565,
   2,0x0574,0x056B,
   2,0x057E,0x0576,
   2,0x0574,0x056D,
   1,0x05E2,
   1,0x05D0,
   1,0x05D3,
   1,0x05D4,
   1,0x05DB,
   1,0x05DC,
   1,0x05DD,
   1,0x05E8,
   1,0x05EA,
   1, '+',
   2,0x05D0,0x05DC,
   1,0x203E,
   1,0x203E,
   1,0x203E,
   1,0x203E,
   1, '_',
   1, '_',
   1, '_',
   1, ',',
   1,0x3001,
   1, '.',
   1, ';',
   1, ':',
   1, '?',
   1, '!',
   1,0x2014,
   1, '(',
   1, ')',
   1, '{',
   1, '}',
   1,0x3014,
   1,0x3015,
   1, '#',
   1, '&',
   1, '*',
   1, '+',
   1, '-',
   1, '<',
   1, '>',
   1, '=',
   1,'\\',
   1, '$',
   1, '%',
   1, '@',
   1, '!',
   1, '"',
   1, '#',
   1, '$',
   1, '%',
   1, '&',
   1,'\'',
   1, '(',
   1, ')',
   1, '*',
   1, '+',
   1, ',',
   1, '-',
   1, '.',
   1, '/',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1, ':',
   1, ';',
   1, '<',
   1, '=',
   1, '>',
   1, '?',
   1, '@',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, '[',
   1,'\\',
   1, ']',
   1, '^',
   1, '_',
   1, '`',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, '{',
   1, '|',
   1, '}',
   1, '~',
   1,0x2985,
   1,0x2986,
   1,0x3002,
   1,0x300C,
   1,0x300D,
   1,0x3001,
   1,0x30FB,
   1,0x30F2,
   1,0x30A1,
   1,0x30A3,
   1,0x30A5,
   1,0x30A7,
   1,0x30A9,
   1,0x30E3,
   1,0x30E5,
   1,0x30E7,
   1,0x30C3,
   1,0x30FC,
   1,0x30A2,
   1,0x30A4,
   1,0x30A6,
   1,0x30A8,
   1,0x30AA,
   1,0x30AB,
   1,0x30AD,
   1,0x30AF,
   1,0x30B1,
   1,0x30B3,
   1,0x30B5,
   1,0x30B7,
   1,0x30B9,
   1,0x30BB,
   1,0x30BD,
   1,0x30BF,
   1,0x30C1,
   1,0x30C4,
   1,0x30C6,
   1,0x30C8,
   1,0x30CA,
   1,0x30CB,
   1,0x30CC,
   1,0x30CD,
   1,0x30CE,
   1,0x30CF,
   1,0x30D2,
   1,0x30D5,
   1,0x30D8,
   1,0x30DB,
   1,0x30DE,
   1,0x30DF,
   1,0x30E0,
   1,0x30E1,
   1,0x30E2,
   1,0x30E4,
   1,0x30E6,
   1,0x30E8,
   1,0x30E9,
   1,0x30EA,
   1,0x30EB,
   1,0x30EC,
   1,0x30ED,
   1,0x30EF,
   1,0x30F3,
   1,0x3099,
   1,0x309A,
   1,0x3164,
   1,0x3131,
   1,0x3132,
   1,0x3133,
   1,0x3134,
   1,0x3135,
   1,0x3136,
   1,0x3137,
   1,0x3138,
   1,0x3139,
   1,0x313A,
   1,0x313B,
   1,0x313C,
   1,0x313D,
   1,0x313E,
   1,0x313F,
   1,0x3140,
   1,0x3141,
   1,0x3142,
   1,0x3143,
   1,0x3144,
   1,0x3145,
   1,0x3146,
   1,0x3147,
   1,0x3148,
   1,0x3149,
   1,0x314A,
   1,0x314B,
   1,0x314C,
   1,0x314D,
   1,0x314E,
   1,0x314F,
   1,0x3150,
   1,0x3151,
   1,0x3152,
   1,0x3153,
   1,0x3154,
   1,0x3155,
   1,0x3156,
   1,0x3157,
   1,0x3158,
   1,0x3159,
   1,0x315A,
   1,0x315B,
   1,0x315C,
   1,0x315D,
   1,0x315E,
   1,0x315F,
   1,0x3160,
   1,0x3161,
   1,0x3162,
   1,0x3163,
   1,0xA2,
   1,0xA3,
   1,0xAC,
   1,0xAF,
   1,0xA6,
   1,0xA5,
   1,0x20A9,
   1,0x2502,
   1,0x2190,
   1,0x2191,
   1,0x2192,
   1,0x2193,
   1,0x25A0,
   1,0x25CB,
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'C',
   1, 'D',
   1, 'G',
   1, 'J',
   1, 'K',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'f',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'O',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   1, 'a',
   1, 'b',
   1, 'c',
   1, 'd',
   1, 'e',
   1, 'f',
   1, 'g',
   1, 'h',
   1, 'i',
   1, 'j',
   1, 'k',
   1, 'l',
   1, 'm',
   1, 'n',
   1, 'o',
   1, 'p',
   1, 'q',
   1, 'r',
   1, 's',
   1, 't',
   1, 'u',
   1, 'v',
   1, 'w',
   1, 'x',
   1, 'y',
   1, 'z',
   1,0x0131,
   1,0x0237,
   1,0x0391,
   1,0x0392,
   1,0x0393,
   1,0x0394,
   1,0x0395,
   1,0x0396,
   1,0x0397,
   1,0x0398,
   1,0x0399,
   1,0x039A,
   1,0x039B,
   1,0x039C,
   1,0x039D,
   1,0x039E,
   1,0x039F,
   1,0x03A0,
   1,0x03A1,
   1,0x03F4,
   1,0x03A3,
   1,0x03A4,
   1,0x03A5,
   1,0x03A6,
   1,0x03A7,
   1,0x03A8,
   1,0x03A9,
   1,0x2207,
   1,0x03B1,
   1,0x03B2,
   1,0x03B3,
   1,0x03B4,
   1,0x03B5,
   1,0x03B6,
   1,0x03B7,
   1,0x03B8,
   1,0x03B9,
   1,0x03BA,
   1,0x03BB,
   1,0x03BC,
   1,0x03BD,
   1,0x03BE,
   1,0x03BF,
   1,0x03C0,
   1,0x03C1,
   1,0x03C2,
   1,0x03C3,
   1,0x03C4,
   1,0x03C5,
   1,0x03C6,
   1,0x03C7,
   1,0x03C8,
   1,0x03C9,
   1,0x2202,
   1,0x03F5,
   1,0x03D1,
   1,0x03F0,
   1,0x03D5,
   1,0x03F1,
   1,0x03D6,
   1,0x0391,
   1,0x0392,
   1,0x0393,
   1,0x0394,
   1,0x0395,
   1,0x0396,
   1,0x0397,
   1,0x0398,
   1,0x0399,
   1,0x039A,
   1,0x039B,
   1,0x039C,
   1,0x039D,
   1,0x039E,
   1,0x039F,
   1,0x03A0,
   1,0x03A1,
   1,0x03F4,
   1,0x03A3,
   1,0x03A4,
   1,0x03A5,
   1,0x03A6,
   1,0x03A7,
   1,0x03A8,
   1,0x03A9,
   1,0x2207,
   1,0x03B1,
   1,0x03B2,
   1,0x03B3,
   1,0x03B4,
   1,0x03B5,
   1,0x03B6,
   1,0x03B7,
   1,0x03B8,
   1,0x03B9,
   1,0x03BA,
   1,0x03BB,
   1,0x03BC,
   1,0x03BD,
   1,0x03BE,
   1,0x03BF,
   1,0x03C0,
   1,0x03C1,
   1,0x03C2,
   1,0x03C3,
   1,0x03C4,
   1,0x03C5,
   1,0x03C6,
   1,0x03C7,
   1,0x03C8,
   1,0x03C9,
   1,0x2202,
   1,0x03F5,
   1,0x03D1,
   1,0x03F0,
   1,0x03D5,
   1,0x03F1,
   1,0x03D6,
   1,0x0391,
   1,0x0392,
   1,0x0393,
   1,0x0394,
   1,0x0395,
   1,0x0396,
   1,0x0397,
   1,0x0398,
   1,0x0399,
   1,0x039A,
   1,0x039B,
   1,0x039C,
   1,0x039D,
   1,0x039E,
   1,0x039F,
   1,0x03A0,
   1,0x03A1,
   1,0x03F4,
   1,0x03A3,
   1,0x03A4,
   1,0x03A5,
   1,0x03A6,
   1,0x03A7,
   1,0x03A8,
   1,0x03A9,
   1,0x2207,
   1,0x03B1,
   1,0x03B2,
   1,0x03B3,
   1,0x03B4,
   1,0x03B5,
   1,0x03B6,
   1,0x03B7,
   1,0x03B8,
   1,0x03B9,
   1,0x03BA,
   1,0x03BB,
   1,0x03BC,
   1,0x03BD,
   1,0x03BE,
   1,0x03BF,
   1,0x03C0,
   1,0x03C1,
   1,0x03C2,
   1,0x03C3,
   1,0x03C4,
   1,0x03C5,
   1,0x03C6,
   1,0x03C7,
   1,0x03C8,
   1,0x03C9,
   1,0x2202,
   1,0x03F5,
   1,0x03D1,
   1,0x03F0,
   1,0x03D5,
   1,0x03F1,
   1,0x03D6,
   1,0x0391,
   1,0x0392,
   1,0x0393,
   1,0x0394,
   1,0x0395,
   1,0x0396,
   1,0x0397,
   1,0x0398,
   1,0x0399,
   1,0x039A,
   1,0x039B,
   1,0x039C,
   1,0x039D,
   1,0x039E,
   1,0x039F,
   1,0x03A0,
   1,0x03A1,
   1,0x03F4,
   1,0x03A3,
   1,0x03A4,
   1,0x03A5,
   1,0x03A6,
   1,0x03A7,
   1,0x03A8,
   1,0x03A9,
   1,0x2207,
   1,0x03B1,
   1,0x03B2,
   1,0x03B3,
   1,0x03B4,
   1,0x03B5,
   1,0x03B6,
   1,0x03B7,
   1,0x03B8,
   1,0x03B9,
   1,0x03BA,
   1,0x03BB,
   1,0x03BC,
   1,0x03BD,
   1,0x03BE,
   1,0x03BF,
   1,0x03C0,
   1,0x03C1,
   1,0x03C2,
   1,0x03C3,
   1,0x03C4,
   1,0x03C5,
   1,0x03C6,
   1,0x03C7,
   1,0x03C8,
   1,0x03C9,
   1,0x2202,
   1,0x03F5,
   1,0x03D1,
   1,0x03F0,
   1,0x03D5,
   1,0x03F1,
   1,0x03D6,
   1,0x0391,
   1,0x0392,
   1,0x0393,
   1,0x0394,
   1,0x0395,
   1,0x0396,
   1,0x0397,
   1,0x0398,
   1,0x0399,
   1,0x039A,
   1,0x039B,
   1,0x039C,
   1,0x039D,
   1,0x039E,
   1,0x039F,
   1,0x03A0,
   1,0x03A1,
   1,0x03F4,
   1,0x03A3,
   1,0x03A4,
   1,0x03A5,
   1,0x03A6,
   1,0x03A7,
   1,0x03A8,
   1,0x03A9,
   1,0x2207,
   1,0x03B1,
   1,0x03B2,
   1,0x03B3,
   1,0x03B4,
   1,0x03B5,
   1,0x03B6,
   1,0x03B7,
   1,0x03B8,
   1,0x03B9,
   1,0x03BA,
   1,0x03BB,
   1,0x03BC,
   1,0x03BD,
   1,0x03BE,
   1,0x03BF,
   1,0x03C0,
   1,0x03C1,
   1,0x03C2,
   1,0x03C3,
   1,0x03C4,
   1,0x03C5,
   1,0x03C6,
   1,0x03C7,
   1,0x03C8,
   1,0x03C9,
   1,0x2202,
   1,0x03F5,
   1,0x03D1,
   1,0x03F0,
   1,0x03D5,
   1,0x03F1,
   1,0x03D6,
   1,0x03DC,
   1,0x03DD,
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1,0x0627,
   1,0x0628,
   1,0x062C,
   1,0x062F,
   1,0x0648,
   1,0x0632,
   1,0x062D,
   1,0x0637,
   1,0x064A,
   1,0x0643,
   1,0x0644,
   1,0x0645,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0641,
   1,0x0635,
   1,0x0642,
   1,0x0631,
   1,0x0634,
   1,0x062A,
   1,0x062B,
   1,0x062E,
   1,0x0630,
   1,0x0636,
   1,0x0638,
   1,0x063A,
   1,0x066E,
   1,0x06BA,
   1,0x06A1,
   1,0x066F,
   1,0x0628,
   1,0x062C,
   1,0x0647,
   1,0x062D,
   1,0x064A,
   1,0x0643,
   1,0x0644,
   1,0x0645,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0641,
   1,0x0635,
   1,0x0642,
   1,0x0634,
   1,0x062A,
   1,0x062B,
   1,0x062E,
   1,0x0636,
   1,0x063A,
   1,0x062C,
   1,0x062D,
   1,0x064A,
   1,0x0644,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0635,
   1,0x0642,
   1,0x0634,
   1,0x062E,
   1,0x0636,
   1,0x063A,
   1,0x06BA,
   1,0x066F,
   1,0x0628,
   1,0x062C,
   1,0x0647,
   1,0x062D,
   1,0x0637,
   1,0x064A,
   1,0x0643,
   1,0x0645,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0641,
   1,0x0635,
   1,0x0642,
   1,0x0634,
   1,0x062A,
   1,0x062B,
   1,0x062E,
   1,0x0636,
   1,0x0638,
   1,0x063A,
   1,0x066E,
   1,0x06A1,
   1,0x0627,
   1,0x0628,
   1,0x062C,
   1,0x062F,
   1,0x0647,
   1,0x0648,
   1,0x0632,
   1,0x062D,
   1,0x0637,
   1,0x064A,
   1,0x0644,
   1,0x0645,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0641,
   1,0x0635,
   1,0x0642,
   1,0x0631,
   1,0x0634,
   1,0x062A,
   1,0x062B,
   1,0x062E,
   1,0x0630,
   1,0x0636,
   1,0x0638,
   1,0x063A,
   1,0x0628,
   1,0x062C,
   1,0x062F,
   1,0x0648,
   1,0x0632,
   1,0x062D,
   1,0x0637,
   1,0x064A,
   1,0x0644,
   1,0x0645,
   1,0x0646,
   1,0x0633,
   1,0x0639,
   1,0x0641,
   1,0x0635,
   1,0x0642,
   1,0x0631,
   1,0x0634,
   1,0x062A,
   1,0x062B,
   1,0x062E,
   1,0x0630,
   1,0x0636,
   1,0x0638,
   1,0x063A,
   2, '0', '.',
   2, '0', ',',
   2, '1', ',',
   2, '2', ',',
   2, '3', ',',
   2, '4', ',',
   2, '5', ',',
   2, '6', ',',
   2, '7', ',',
   2, '8', ',',
   2, '9', ',',
   3, '(', 'A', ')',
   3, '(', 'B', ')',
   3, '(', 'C', ')',
   3, '(', 'D', ')',
   3, '(', 'E', ')',
   3, '(', 'F', ')',
   3, '(', 'G', ')',
   3, '(', 'H', ')',
   3, '(', 'I', ')',
   3, '(', 'J', ')',
   3, '(', 'K', ')',
   3, '(', 'L', ')',
   3, '(', 'M', ')',
   3, '(', 'N', ')',
   3, '(', 'O', ')',
   3, '(', 'P', ')',
   3, '(', 'Q', ')',
   3, '(', 'R', ')',
   3, '(', 'S', ')',
   3, '(', 'T', ')',
   3, '(', 'U', ')',
   3, '(', 'V', ')',
   3, '(', 'W', ')',
   3, '(', 'X', ')',
   3, '(', 'Y', ')',
   3, '(', 'Z', ')',
   3,0x3014, 'S',0x3015,
   3, '(', 'C', ')',
   3, '(', 'R', ')',
   4, '(', 'C', 'D', ')',
   4, '(', 'W', 'Z', ')',
   1, 'A',
   1, 'B',
   1, 'C',
   1, 'D',
   1, 'E',
   1, 'F',
   1, 'G',
   1, 'H',
   1, 'I',
   1, 'J',
   1, 'K',
   1, 'L',
   1, 'M',
   1, 'N',
   1, 'O',
   1, 'P',
   1, 'Q',
   1, 'R',
   1, 'S',
   1, 'T',
   1, 'U',
   1, 'V',
   1, 'W',
   1, 'X',
   1, 'Y',
   1, 'Z',
   2, 'H', 'V',
   2, 'M', 'V',
   2, 'S', 'D',
   2, 'S', 'S',
   3, 'P', 'P', 'V',
   2, 'W', 'C',
   2, 'D', 'J',
   2,0x307B,0x304B,
   2,0x30B3,0x30B3,
   1,0x30B5,
   1,0x624B,
   1,0x5B57,
   1,0x53CC,
   1,0x30C7,
   1,0x4E8C,
   1,0x591A,
   1,0x89E3,
   1,0x5929,
   1,0x4EA4,
   1,0x6620,
   1,0x7121,
   1,0x6599,
   1,0x524D,
   1,0x5F8C,
   1,0x518D,
   1,0x65B0,
   1,0x521D,
   1,0x7D42,
   1,0x751F,
   1,0x8CA9,
   1,0x58F0,
   1,0x5439,
   1,0x6F14,
   1,0x6295,
   1,0x6355,
   1,0x4E00,
   1,0x4E09,
   1,0x904A,
   1,0x5DE6,
   1,0x4E2D,
   1,0x53F3,
   1,0x6307,
   1,0x8D70,
   1,0x6253,
   1,0x7981,
   1,0x7A7A,
   1,0x5408,
   1,0x6E80,
   1,0x6709,
   1,0x6708,
   1,0x7533,
   1,0x5272,
   1,0x55B6,
   1,0x914D,
   3,0x3014,0x672C,0x3015,
   3,0x3014,0x4E09,0x3015,
   3,0x3014,0x4E8C,0x3015,
   3,0x3014,0x5B89,0x3015,
   3,0x3014,0x70B9,0x3015,
   3,0x3014,0x6253,0x3015,
   3,0x3014,0x76D7,0x3015,
   3,0x3014,0x52DD,0x3015,
   3,0x3014,0x6557,0x3015,
   3, '(',0x5F97, ')',
   3, '(',0x53EF, ')',
   3, '/', '<', '3',
   5, '/', '<', '/', '/', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, ':', '-', 'D',
   3, ':', '-', 'D',
   3, ':','\'', 'D',
   3, ':', '-', 'D',
   3, ':', '-', 'D',
   3, ':', '-', 'D',
   3, ':', '-', 'D',
   4, 'O', ':', '-', ')',
   4, '/', '>', ':', ')',
   3, ';', '-', ')',
   3, ':', '-', ')',
   3, ':', '-', 'P',
   3, ':', '-', ')',
   3, ':', '-', '*',
   3, 'B', '-', ')',
   3, ';', '-', ')',
   3, ':', '-', '|',
   3, ':', '-', '|',
   3, ':', '-', '|',
   4, ':','\'', '-', '|',
   3, ':', '-', '|',
   4, ':', '-', '/', '/',
   3, ':', '-', 'S',
   3, ':', '-', '*',
   3, ':', '-', '*',
   3, ':', '-', '*',
   3, ':', '-', '*',
   3, ':', '-', 'P',
   3, ';', '-', 'P',
   3, 'X', '-', 'P',
   3, ':', '-', '(',
   3, ':', '-', '(',
   5, '/', '>', ':', '-', '(',
   3, ':', '-', '(',
   4, ':','\'', '-', '(',
   3, 'X', '-', '(',
   3, ':', '-', 'O',
   3, ':', '-', 'O',
   3, ':', '-', 'O',
   3, ':', '-', 'O',
   4, ':', '"', '-', '(',
   3, ':', '-', 'O',
   3, ':', '-', 'O',
   4, ':','\'', '-', 'O',
   3, ':', '-', 'O',
   3, ':', '-', 'O',
   3, ':', '-', '3',
   4, ':','\'', '-', '3',
   3, ':', '-', '3',
   3, ':', '-', '3',
   3, ';', '-', '3',
   3, ':', '-', '3',
   3, ':', '-', '(',
   3, ':', '-', ')',
   3, '(', '-', ':',
   3, '/', '<', '3',
   3, '/', '<', '3',
   3, '/', '<', '3',
   1, '0',
   1, '1',
   1, '2',
   1, '3',
   1, '4',
   1, '5',
   1, '6',
   1, '7',
   1, '8',
   1, '9',
   1,0x4E3D,
   1,0x4E38,
   1,0x4E41,
   1,0x20122,
   1,0x4F60,
   1,0x4FAE,
   1,0x4FBB,
   1,0x5002,
   1,0x507A,
   1,0x5099,
   1,0x50E7,
   1,0x50CF,
   1,0x349E,
   1,0x2063A,
   1,0x514D,
   1,0x5154,
   1,0x5164,
   1,0x5177,
   1,0x2051C,
   1,0x34B9,
   1,0x5167,
   1,0x518D,
   1,0x2054B,
   1,0x5197,
   1,0x51A4,
   1,0x4ECC,
   1,0x51AC,
   1,0x51B5,
   1,0x291DF,
   1,0x51F5,
   1,0x5203,
   1,0x34DF,
   1,0x523B,
   1,0x5246,
   1,0x5272,
   1,0x5277,
   1,0x3515,
   1,0x52C7,
   1,0x52C9,
   1,0x52E4,
   1,0x52FA,
   1,0x5305,
   1,0x5306,
   1,0x5317,
   1,0x5349,
   1,0x5351,
   1,0x535A,
   1,0x5373,
   1,0x537D,
   1,0x537F,
   1,0x537F,
   1,0x537F,
   1,0x20A2C,
   1,0x7070,
   1,0x53CA,
   1,0x53DF,
   1,0x20B63,
   1,0x53EB,
   1,0x53F1,
   1,0x5406,
   1,0x549E,
   1,0x5438,
   1,0x5448,
   1,0x5468,
   1,0x54A2,
   1,0x54F6,
   1,0x5510,
   1,0x5553,
   1,0x5563,
   1,0x5584,
   1,0x5584,
   1,0x5599,
   1,0x55AB,
   1,0x55B3,
   1,0x55C2,
   1,0x5716,
   1,0x5606,
   1,0x5717,
   1,0x5651,
   1,0x5674,
   1,0x5207,
   1,0x58EE,
   1,0x57CE,
   1,0x57F4,
   1,0x580D,
   1,0x578B,
   1,0x5832,
   1,0x5831,
   1,0x58AC,
   1,0x214E4,
   1,0x58F2,
   1,0x58F7,
   1,0x5906,
   1,0x591A,
   1,0x5922,
   1,0x5962,
   1,0x216A8,
   1,0x216EA,
   1,0x59EC,
   1,0x5A1B,
   1,0x5A27,
   1,0x59D8,
   1,0x5A66,
   1,0x36EE,
   1,0x36FC,
   1,0x5B08,
   1,0x5B3E,
   1,0x5B3E,
   1,0x219C8,
   1,0x5BC3,
   1,0x5BD8,
   1,0x5BE7,
   1,0x5BF3,
   1,0x21B18,
   1,0x5BFF,
   1,0x5C06,
   1,0x5F53,
   1,0x5C22,
   1,0x3781,
   1,0x5C60,
   1,0x5C6E,
   1,0x5CC0,
   1,0x5C8D,
   1,0x21DE4,
   1,0x5D43,
   1,0x21DE6,
   1,0x5D6E,
   1,0x5D6B,
   1,0x5D7C,
   1,0x5DE1,
   1,0x5DE2,
   1,0x382F,
   1,0x5DFD,
   1,0x5E28,
   1,0x5E3D,
   1,0x5E69,
   1,0x3862,
   1,0x22183,
   1,0x387C,
   1,0x5EB0,
   1,0x5EB3,
   1,0x5EB6,
   1,0x5ECA,
   1,0x2A392,
   1,0x5EFE,
   1,0x22331,
   1,0x22331,
   1,0x8201,
   1,0x5F22,
   1,0x5F22,
   1,0x38C7,
   1,0x232B8,
   1,0x261DA,
   1,0x5F62,
   1,0x5F6B,
   1,0x38E3,
   1,0x5F9A,
   1,0x5FCD,
   1,0x5FD7,
   1,0x5FF9,
   1,0x6081,
   1,0x393A,
   1,0x391C,
   1,0x6094,
   1,0x226D4,
   1,0x60C7,
   1,0x6148,
   1,0x614C,
   1,0x614E,
   1,0x614C,
   1,0x617A,
   1,0x618E,
   1,0x61B2,
   1,0x61A4,
   1,0x61AF,
   1,0x61DE,
   1,0x61F2,
   1,0x61F6,
   1,0x6210,
   1,0x621B,
   1,0x625D,
   1,0x62B1,
   1,0x62D4,
   1,0x6350,
   1,0x22B0C,
   1,0x633D,
   1,0x62FC,
   1,0x6368,
   1,0x6383,
   1,0x63E4,
   1,0x22BF1,
   1,0x6422,
   1,0x63C5,
   1,0x63A9,
   1,0x3A2E,
   1,0x6469,
   1,0x647E,
   1,0x649D,
   1,0x6477,
   1,0x3A6C,
   1,0x654F,
   1,0x656C,
   1,0x2300A,
   1,0x65E3,
   1,0x66F8,
   1,0x6649,
   1,0x3B19,
   1,0x6691,
   1,0x3B08,
   1,0x3AE4,
   1,0x5192,
   1,0x5195,
   1,0x6700,
   1,0x669C,
   1,0x80AD,
   1,0x43D9,
   1,0x6717,
   1,0x671B,
   1,0x6721,
   1,0x675E,
   1,0x6753,
   1,0x233C3,
   1,0x3B49,
   1,0x67FA,
   1,0x6785,
   1,0x6852,
   1,0x6885,
   1,0x2346D,
   1,0x688E,
   1,0x681F,
   1,0x6914,
   1,0x3B9D,
   1,0x6942,
   1,0x69A3,
   1,0x69EA,
   1,0x6AA8,
   1,0x236A3,
   1,0x6ADB,
   1,0x3C18,
   1,0x6B21,
   1,0x238A7,
   1,0x6B54,
   1,0x3C4E,
   1,0x6B72,
   1,0x6B9F,
   1,0x6BBA,
   1,0x6BBB,
   1,0x23A8D,
   1,0x21D0B,
   1,0x23AFA,
   1,0x6C4E,
   1,0x23CBC,
   1,0x6CBF,
   1,0x6CCD,
   1,0x6C67,
   1,0x6D16,
   1,0x6D3E,
   1,0x6D77,
   1,0x6D41,
   1,0x6D69,
   1,0x6D78,
   1,0x6D85,
   1,0x23D1E,
   1,0x6D34,
   1,0x6E2F,
   1,0x6E6E,
   1,0x3D33,
   1,0x6ECB,
   1,0x6EC7,
   1,0x23ED1,
   1,0x6DF9,
   1,0x6F6E,
   1,0x23F5E,
   1,0x23F8E,
   1,0x6FC6,
   1,0x7039,
   1,0x701E,
   1,0x701B,
   1,0x3D96,
   1,0x704A,
   1,0x707D,
   1,0x7077,
   1,0x70AD,
   1,0x20525,
   1,0x7145,
   1,0x24263,
   1,0x719C,
   1,0x243AB,
   1,0x7228,
   1,0x7235,
   1,0x7250,
   1,0x24608,
   1,0x7280,
   1,0x7295,
   1,0x24735,
   1,0x24814,
   1,0x737A,
   1,0x738B,
   1,0x3EAC,
   1,0x73A5,
   1,0x3EB8,
   1,0x3EB8,
   1,0x7447,
   1,0x745C,
   1,0x7471,
   1,0x7485,
   1,0x74CA,
   1,0x3F1B,
   1,0x7524,
   1,0x24C36,
   1,0x753E,
   1,0x24C92,
   1,0x7570,
   1,0x2219F,
   1,0x7610,
   1,0x24FA1,
   1,0x24FB8,
   1,0x25044,
   1,0x3FFC,
   1,0x4008,
   1,0x76F4,
   1,0x250F3,
   1,0x250F2,
   1,0x25119,
   1,0x25133,
   1,0x771E,
   1,0x771F,
   1,0x771F,
   1,0x774A,
   1,0x4039,
   1,0x778B,
   1,0x4046,
   1,0x4096,
   1,0x2541D,
   1,0x784E,
   1,0x788C,
   1,0x78CC,
   1,0x40E3,
   1,0x25626,
   1,0x7956,
   1,0x2569A,
   1,0x256C5,
   1,0x798F,
   1,0x79EB,
   1,0x412F,
   1,0x7A40,
   1,0x7A4A,
   1,0x7A4F,
   1,0x2597C,
   1,0x25AA7,
   1,0x25AA7,
   1,0x7AEE,
   1,0x4202,
   1,0x25BAB,
   1,0x7BC6,
   1,0x7BC9,
   1,0x4227,
   1,0x25C80,
   1,0x7CD2,
   1,0x42A0,
   1,0x7CE8,
   1,0x7CE3,
   1,0x7D00,
   1,0x25F86,
   1,0x7D63,
   1,0x4301,
   1,0x7DC7,
   1,0x7E02,
   1,0x7E45,
   1,0x4334,
   1,0x26228,
   1,0x26247,
   1,0x4359,
   1,0x262D9,
   1,0x7F7A,
   1,0x2633E,
   1,0x7F95,
   1,0x7FFA,
   1,0x8005,
   1,0x264DA,
   1,0x26523,
   1,0x8060,
   1,0x265A8,
   1,0x8070,
   1,0x2335F,
   1,0x43D5,
   1,0x80B2,
   1,0x8103,
   1,0x440B,
   1,0x813E,
   1,0x5AB5,
   1,0x267A7,
   1,0x267B5,
   1,0x23393,
   1,0x2339C,
   1,0x8201,
   1,0x8204,
   1,0x8F9E,
   1,0x446B,
   1,0x8291,
   1,0x828B,
   1,0x829D,
   1,0x52B3,
   1,0x82B1,
   1,0x82B3,
   1,0x82BD,
   1,0x82E6,
   1,0x26B3C,
   1,0x82E5,
   1,0x831D,
   1,0x8363,
   1,0x83AD,
   1,0x8323,
   1,0x83BD,
   1,0x83E7,
   1,0x8457,
   1,0x8353,
   1,0x83CA,
   1,0x83CC,
   1,0x83DC,
   1,0x26C36,
   1,0x26D6B,
   1,0x26CD5,
   1,0x452B,
   1,0x84F1,
   1,0x84F3,
   1,0x8516,
   1,0x273CA,
   1,0x8564,
   1,0x26F2C,
   1,0x455D,
   1,0x4561,
   1,0x26FB1,
   1,0x270D2,
   1,0x456B,
   1,0x8650,
   1,0x865C,
   1,0x8667,
   1,0x8669,
   1,0x86A9,
   1,0x8688,
   1,0x870E,
   1,0x86E2,
   1,0x8779,
   1,0x8728,
   1,0x876B,
   1,0x8786,
   1,0x45D7,
   1,0x87E1,
   1,0x8801,
   1,0x45F9,
   1,0x8860,
   1,0x8863,
   1,0x27667,
   1,0x88D7,
   1,0x88DE,
   1,0x4635,
   1,0x88FA,
   1,0x34BB,
   1,0x278AE,
   1,0x27966,
   1,0x46BE,
   1,0x46C7,
   1,0x8AA0,
   1,0x8AED,
   1,0x8B8A,
   1,0x8C55,
   1,0x27CA8,
   1,0x8CAB,
   1,0x8CC1,
   1,0x8D1B,
   1,0x8D77,
   1,0x27F2F,
   1,0x20804,
   1,0x8DCB,
   1,0x8DBC,
   1,0x8DF0,
   1,0x208DE,
   1,0x8ED4,
   1,0x8F38,
   1,0x285D2,
   1,0x285ED,
   1,0x9094,
   1,0x90F1,
   1,0x9111,
   1,0x2872E,
   1,0x911B,
   1,0x9238,
   1,0x92D7,
   1,0x92D8,
   1,0x927C,
   1,0x93F9,
   1,0x9415,
   1,0x28BFA,
   1,0x958B,
   1,0x4995,
   1,0x95B7,
   1,0x28D77,
   1,0x49E6,
   1,0x96C3,
   1,0x5DB2,
   1,0x9723,
   1,0x29145,
   1,0x2921A,
   1,0x4A6E,
   1,0x4A76,
   1,0x97E0,
   1,0x2940A,
   1,0x4AB2,
   1,0x29496,
   1,0x980B,
   1,0x980B,
   1,0x9829,
   1,0x295B6,
   1,0x98E2,
   1,0x4B33,
   1,0x9929,
   1,0x99A7,
   1,0x99C2,
   1,0x99FE,
   1,0x4BCE,
   1,0x29B30,
   1,0x9B12,
   1,0x9C40,
   1,0x9CFD,
   1,0x4CCE,
   1,0x4CED,
   1,0x9D67,
   1,0x2A0CE,
   1,0x4CF8,
   1,0x2A105,
   1,0x2A20E,
   1,0x2A291,
   1,0x9EBB,
   1,0x4D56,
   1,0x9EF9,
   1,0x9EFE,
   1,0x9F05,
   1,0x9F0F,
   1,0x9F16,
   1,0x9F3B,
   1,0x2A600,
};

static const short translit_page00[344] = {
     0,    2,    4,    6,   -1,    9,   13,   15, /* 0xa0-0xa7 */
    18,   20,   24,   26,   29,   33,   35,   -1, /* 0xa8-0xaf */
    39,   42,   46,   49,   52,   54,   56,   58, /* 0xb0-0xb7 */
    60,   62,   65,   67,   70,   76,   82,   88, /* 0xb8-0xbf */
    90,   93,   96,   99,  102,  105,  107,  110, /* 0xc0-0xc7 */
   112,  115,  118,  121,  124,  127,  130,  133, /* 0xc8-0xcf */
   136,  138,  141,  144,  147,  150,  153,  156, /* 0xd0-0xd7 */
   158,  160,  163,  166,  169,  172,  175,  178, /* 0xd8-0xdf */
   181,  184,  187,  190,  193,  196,  198,  201, /* 0xe0-0xe7 */
   203,  206,  209,  212,  215,  218,  221,  224, /* 0xe8-0xef */
   227,  229,  232,  235,  238,  241,  244,  247, /* 0xf0-0xf7 */
   249,  251,  254,  257,  260,  263,  266,  269, /* 0xf8-0xff */
  /* 0x0100 */
   272,  274,  276,  278,  280,  282,  284,  287, /* 0x00-0x07 */
   290,  293,  296,  298,  300,  302,  304,  306, /* 0x08-0x0f */
   308,  310,  312,  314,  316,  318,  320,  322, /* 0x10-0x17 */
   324,  326,  328,  330,  332,  335,  338,  340, /* 0x18-0x1f */
   342,  344,  346,  348,  350,  353,  356,  358, /* 0x20-0x27 */
   360,  363,  366,  368,  370,  372,  374,  376, /* 0x28-0x2f */
   378,  380,  382,  385,  388,  391,  394,  396, /* 0x30-0x37 */
    -1,  398,  400,  402,  404,  406,  408,  410, /* 0x38-0x3f */
   412,  414,  416,  418,  421,  424,  426,  428, /* 0x40-0x47 */
   430,  432,   -1,   -1,  435,  437,  439,  441, /* 0x48-0x4f */
   443,  446,  449,  452,  455,  458,  461,  463, /* 0x50-0x57 */
   465,  467,  469,  472,  475,  478,  481,  483, /* 0x58-0x5f */
   485,  487,  489,  491,  493,  495,  497,  499, /* 0x60-0x67 */
   501,  504,  507,  509,  511,  513,  515,  517, /* 0x68-0x6f */
   519,  522,  525,  527,  529,  532,  535,  538, /* 0x70-0x77 */
   541,  544,  547,  550,  552,  554,  556,  558, /* 0x78-0x7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x80-0x87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x88-0x8f */
    -1,   -1,  560,   -1,   -1,   -1,   -1,   -1, /* 0x90-0x97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x98-0x9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xa0-0xa7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xa8-0xaf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb0-0xb7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb8-0xbf */
    -1,   -1,   -1,   -1,  562,  565,  568,  571, /* 0xc0-0xc7 */
   574,  577,  580,  583,  586,   -1,   -1,   -1, /* 0xc8-0xcf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd0-0xd7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd8-0xdf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe0-0xe7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe8-0xef */
    -1,  589,  592,  595,   -1,   -1,   -1,   -1, /* 0xf0-0xf7 */
};
static const short translit_page02[8] = {
   598,  600,  602,  604,   -1,   -1,   -1,   -1, /* 0x18-0x1f */
};
static const short translit_page02_1[40] = {
    -1,  606,  608,  610,  612,  614,   -1,   -1, /* 0xb8-0xbf */
    -1,   -1,   -1,   -1,   -1,   -1,  616,   -1, /* 0xc0-0xc7 */
   618,  620,  622,  624,   -1,  626,   -1,   -1, /* 0xc8-0xcf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd0-0xd7 */
    -1,   -1,   -1,   -1,  628,  630,   -1,   -1, /* 0xd8-0xdf */
};
static const short translit_page03[48] = {
   632,  634,  636,   -1,   -1,  638,  640,   -1, /* 0xd0-0xd7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd8-0xdf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe0-0xe7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe8-0xef */
   642,  644,  646,   -1,  648,  650,   -1,   -1, /* 0xf0-0xf7 */
    -1,  652,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xf8-0xff */
};
static const short translit_page05[8] = {
   657,  660,  663,   -1,   -1,   -1,   -1,   -1, /* 0xf0-0xf7 */
};
static const short translit_page06[16] = {
    -1,   -1,   -1,   -1,   -1,  666,  669,  672, /* 0x70-0x77 */
   675,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x78-0x7f */
};
static const short translit_page0e[48] = {
    -1,   -1,   -1,  681,   -1,   -1,   -1,   -1, /* 0xb0-0xb7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb8-0xbf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc0-0xc7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc8-0xcf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd0-0xd7 */
    -1,   -1,   -1,   -1,  684,  687,   -1,   -1, /* 0xd8-0xdf */
};
static const short translit_page0f[16] = {
    -1,   -1,   -1,   -1,   -1,   -1,   -1,  690, /* 0x70-0x77 */
    -1,  693,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x78-0x7f */
};
static const short translit_page1e[160] = {
    -1,   -1,  696,  698,   -1,   -1,   -1,   -1, /* 0x00-0x07 */
    -1,   -1,  700,  702,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x10-0x17 */
    -1,   -1,   -1,   -1,   -1,   -1,  704,  706, /* 0x18-0x1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
   708,  710,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,   -1,   -1,   -1,  712,  714, /* 0x50-0x57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x58-0x5f */
   716,  718,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x60-0x67 */
    -1,   -1,  720,  722,   -1,   -1,   -1,   -1, /* 0x68-0x6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x70-0x77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x78-0x7f */
   724,  727,  730,  733,  736,  739,   -1,   -1, /* 0x80-0x87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x88-0x8f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x90-0x97 */
    -1,   -1,  742,   -1,   -1,   -1,   -1,   -1, /* 0x98-0x9f */
};
static const short translit_page1e_1[8] = {
    -1,   -1,  745,  748,   -1,   -1,   -1,   -1, /* 0xf0-0xf7 */
};
static const short translit_page20[88] = {
    -1,   -1,  751,  753,  755,  757,  759,   -1, /* 0x00-0x07 */
   761,  763,  765,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
   767,  769,  771,  773,  775,  777,   -1,   -1, /* 0x10-0x17 */
   779,  781,  783,  785,  787,  789,  791,  793, /* 0x18-0x1f */
   795,   -1,  797,   -1,  799,  801,  804,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2f */
   808,   -1,  813,  815,  818,   -1,  822,  825, /* 0x30-0x37 */
    -1,  829,  831,   -1,  833,   -1,   -1,   -1, /* 0x38-0x3f */
    -1,   -1,   -1,   -1,  836,   -1,   -1,  838, /* 0x40-0x47 */
   841,  844,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,  847, /* 0x50-0x57 */
};
static const short translit_page20_1[8] = {
   852,   -1,   -1,  855,  860,   -1,   -1,   -1, /* 0xa8-0xaf */
};
static const short translit_page21[216] = {
   864,  868,  872,  874,   -1,  877,  881,  885, /* 0x00-0x07 */
    -1,  887,  890,  892,  894,  896,  898,  900, /* 0x08-0x0f */
   902,  904,  906,  908,   -1,  910,  912,   -1, /* 0x10-0x17 */
    -1,  915,  917,  919,  921,  923,   -1,   -1, /* 0x18-0x1f */
    -1,  925,  929,   -1,  932,   -1,  934,   -1, /* 0x20-0x27 */
   938,   -1,   -1,   -1,  940,  942,  944,  946, /* 0x28-0x2f */
   948,  950,   -1,  952,  954,  956,  958,  960, /* 0x30-0x37 */
   962,  964,   -1,  966,  970,  972,  974,  976, /* 0x38-0x3f */
   978,   -1,   -1,   -1,   -1,  980,  982,  984, /* 0x40-0x47 */
   986,  988,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,  990,  996, 1002, 1008, 1014, /* 0x50-0x57 */
  1020, 1026, 1032, 1038, 1044, 1050, 1056, 1062, /* 0x58-0x5f */
  1066, 1068, 1071, 1075, 1078, 1080, 1083, 1087, /* 0x60-0x67 */
  1092, 1095, 1097, 1100, 1104, 1106, 1108, 1110, /* 0x68-0x6f */
  1112, 1114, 1117, 1121, 1124, 1126, 1129, 1133, /* 0x70-0x77 */
  1138, 1141, 1143, 1146, 1150, 1152, 1154, 1156, /* 0x78-0x7f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x80-0x87 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x88-0x8f */
  1158, 1161, 1163, 1166, 1168,   -1,   -1,   -1, /* 0x90-0x97 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x98-0x9f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xa0-0xa7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xa8-0xaf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb0-0xb7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb8-0xbf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc0-0xc7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc8-0xcf */
  1172,   -1, 1175,   -1, 1178,   -1,   -1,   -1, /* 0xd0-0xd7 */
};
static const short translit_page22[96] = {
    -1,   -1, 1182,   -1,   -1, 1184, 1186, 1188, /* 0x10-0x17 */
    -1, 1190,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x18-0x1f */
    -1,   -1,   -1, 1192,   -1,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1, 1194, 1197,   -1, 1201, /* 0x28-0x2f */
  1204,   -1,   -1,   -1,   -1,   -1, 1208,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1, 1210,   -1,   -1,   -1, /* 0x38-0x3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x50-0x57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x58-0x5f */
  1212,   -1,   -1,   -1, 1215, 1218,   -1,   -1, /* 0x60-0x67 */
    -1,   -1, 1221, 1224,   -1,   -1,   -1,   -1, /* 0x68-0x6f */
};
static const short translit_page22_1[48] = {
    -1,   -1,   -1,   -1,   -1, 1227,   -1,   -1, /* 0xc0-0xc7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc8-0xcf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd0-0xd7 */
  1229, 1233,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd8-0xdf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe0-0xe7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1, 1237, /* 0xe8-0xef */
};
static const short translit_page24[240] = {
  1241, 1247, 1253, 1259, 1265, 1271, 1277, 1283, /* 0x00-0x07 */
  1289, 1294, 1299, 1304, 1309, 1314, 1319, 1324, /* 0x08-0x0f */
  1329, 1335, 1341, 1347, 1353, 1359, 1365, 1371, /* 0x10-0x17 */
  1377, 1383, 1388, 1394, 1400, 1405, 1410, 1415, /* 0x18-0x1f */
  1420, 1425,   -1,   -1, 1431,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x50-0x57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x58-0x5f */
  1436, 1440, 1444, 1448, 1452, 1456, 1460, 1464, /* 0x60-0x67 */
  1468, 1472, 1477, 1482, 1487, 1492, 1497, 1502, /* 0x68-0x6f */
  1507, 1512, 1517, 1522, 1527, 1531, 1535, 1539, /* 0x70-0x77 */
  1543, 1547, 1551, 1555, 1559, 1563, 1568, 1573, /* 0x78-0x7f */
  1578, 1583, 1588, 1593, 1598, 1603, 1608, 1613, /* 0x80-0x87 */
  1618, 1621, 1624, 1627, 1630, 1633, 1636, 1639, /* 0x88-0x8f */
  1642, 1645, 1649, 1653, 1657, 1661, 1665, 1669, /* 0x90-0x97 */
  1673, 1677, 1681, 1685, 1689, 1693, 1697, 1701, /* 0x98-0x9f */
  1705, 1709, 1713, 1717, 1721, 1725, 1729, 1733, /* 0xa0-0xa7 */
  1737, 1741, 1745, 1749, 1753, 1757, 1761, 1765, /* 0xa8-0xaf */
  1769, 1773, 1777, 1781, 1785, 1789, 1793, 1797, /* 0xb0-0xb7 */
  1801, 1805, 1809, 1813, 1817, 1821, 1825, 1829, /* 0xb8-0xbf */
  1833, 1837, 1841, 1845, 1849, 1853, 1857, 1861, /* 0xc0-0xc7 */
  1865, 1869, 1873, 1877, 1881, 1885, 1889, 1893, /* 0xc8-0xcf */
  1897, 1901, 1905, 1909, 1913, 1917, 1921, 1925, /* 0xd0-0xd7 */
  1929, 1933, 1937, 1941, 1945, 1949, 1953, 1957, /* 0xd8-0xdf */
  1961, 1965, 1969, 1973, 1977, 1981, 1985, 1989, /* 0xe0-0xe7 */
  1993, 1997, 2001,   -1,   -1,   -1,   -1,   -1, /* 0xe8-0xef */
};
static const short translit_page25[64] = {
  2005,   -1, 2007,   -1,   -1,   -1,   -1,   -1, /* 0x00-0x07 */
    -1,   -1,   -1,   -1, 2009,   -1,   -1,   -1, /* 0x08-0x0f */
  2011,   -1,   -1,   -1, 2013,   -1,   -1,   -1, /* 0x10-0x17 */
  2015,   -1,   -1,   -1, 2017,   -1,   -1,   -1, /* 0x18-0x1f */
    -1,   -1,   -1,   -1, 2019,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1, 2021,   -1,   -1,   -1, /* 0x28-0x2f */
    -1,   -1,   -1,   -1, 2023,   -1,   -1,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1, 2025,   -1,   -1,   -1, /* 0x38-0x3f */
};
static const short translit_page26[8] = {
    -1, 2029,   -1,   -1,   -1, 2033,   -1,   -1, /* 0x60-0x67 */
};
static const short translit_page27[16] = {
    -1,   -1,   -1,   -1,   -1,   -1, 2041, 2044, /* 0xe0-0xe7 */
  2047, 2049, 2051, 2054, 2057, 2060, 2063, 2065, /* 0xe8-0xef */
};
static const short translit_page29[16] = {
  2067,   -1,   -1, 2071, 2074, 2077, 2080, 2083, /* 0x80-0x87 */
  2086, 2089, 2092,   -1,   -1,   -1,   -1,   -1, /* 0x88-0x8f */
};
static const short translit_page29_1[32] = {
    -1,   -1,   -1, 2095,   -1, 2097,   -1,   -1, /* 0xe0-0xe7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xe8-0xef */
    -1,   -1,   -1,   -1,   -1, 2099,   -1,   -1, /* 0xf0-0xf7 */
  2101, 2103,   -1,   -1, 2105, 2107, 2109, 2111, /* 0xf8-0xff */
};
static const short translit_page2a[8] = {
    -1,   -1,   -1,   -1, 2118, 2122, 2125,   -1, /* 0x70-0x77 */
};
static const short translit_page2f[216] = {
  2133, 2135, 2137, 2139, 2141, 2143, 2145, 2147, /* 0x00-0x07 */
  2149, 2151, 2153, 2155, 2157, 2159, 2161, 2163, /* 0x08-0x0f */
  2165, 2167, 2169, 2171, 2173, 2175, 2177, 2179, /* 0x10-0x17 */
  2181, 2183, 2185, 2187, 2189, 2191, 2193, 2195, /* 0x18-0x1f */
  2197, 2199, 2201, 2203, 2205, 2207, 2209, 2211, /* 0x20-0x27 */
  2213, 2215, 2217, 2219, 2221, 2223, 2225, 2227, /* 0x28-0x2f */
  2229, 2231, 2233, 2235, 2237, 2239, 2241, 2243, /* 0x30-0x37 */
  2245, 2247, 2249, 2251, 2253, 2255, 2257, 2259, /* 0x38-0x3f */
  2261, 2263, 2265, 2267, 2269, 2271, 2273, 2275, /* 0x40-0x47 */
  2277, 2279, 2281, 2283, 2285, 2287, 2289, 2291, /* 0x48-0x4f */
  2293, 2295, 2297, 2299, 2301, 2303, 2305, 2307, /* 0x50-0x57 */
  2309, 2311, 2313, 2315, 2317, 2319, 2321, 2323, /* 0x58-0x5f */
  2325, 2327, 2329, 2331, 2333, 2335, 2337, 2339, /* 0x60-0x67 */
  2341, 2343, 2345, 2347, 2349, 2351, 2353, 2355, /* 0x68-0x6f */
  2357, 2359, 2361, 2363, 2365, 2367, 2369, 2371, /* 0x70-0x77 */
  2373, 2375, 2377, 2379, 2381, 2383, 2385, 2387, /* 0x78-0x7f */
  2389, 2391, 2393, 2395, 2397, 2399, 2401, 2403, /* 0x80-0x87 */
  2405, 2407, 2409, 2411, 2413, 2415, 2417, 2419, /* 0x88-0x8f */
  2421, 2423, 2425, 2427, 2429, 2431, 2433, 2435, /* 0x90-0x97 */
  2437, 2439, 2441, 2443, 2445, 2447, 2449, 2451, /* 0x98-0x9f */
  2453, 2455, 2457, 2459, 2461, 2463, 2465, 2467, /* 0xa0-0xa7 */
  2469, 2471, 2473, 2475, 2477, 2479, 2481, 2483, /* 0xa8-0xaf */
  2485, 2487, 2489, 2491, 2493, 2495, 2497, 2499, /* 0xb0-0xb7 */
  2501, 2503, 2505, 2507, 2509, 2511, 2513, 2515, /* 0xb8-0xbf */
  2517, 2519, 2521, 2523, 2525, 2527, 2529, 2531, /* 0xc0-0xc7 */
  2533, 2535, 2537, 2539, 2541, 2543, 2545, 2547, /* 0xc8-0xcf */
  2549, 2551, 2553, 2555, 2557, 2559,   -1,   -1, /* 0xd0-0xd7 */
};
static const short translit_page30[248] = {
  2561,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x00-0x07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x10-0x17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x18-0x1f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2f */
    -1,   -1,   -1,   -1,   -1,   -1, 2563,   -1, /* 0x30-0x37 */
  2565, 2567, 2569,   -1,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
    -1, 2571,   -1, 2573,   -1, 2575,   -1, 2577, /* 0x40-0x47 */
    -1, 2579,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x50-0x57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x58-0x5f */
    -1,   -1,   -1, 2581,   -1,   -1,   -1,   -1, /* 0x60-0x67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x68-0x6f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x70-0x77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x78-0x7f */
    -1,   -1,   -1, 2583,   -1, 2585,   -1, 2587, /* 0x80-0x87 */
    -1,   -1,   -1,   -1,   -1,   -1, 2589,   -1, /* 0x88-0x8f */
    -1,   -1,   -1,   -1,   -1, 2591, 2593,   -1, /* 0x90-0x97 */
    -1,   -1,   -1, 2595, 2598,   -1,   -1,   -1, /* 0x98-0x9f */
  2601, 2603,   -1, 2605,   -1, 2607,   -1, 2609, /* 0xa0-0xa7 */
    -1, 2611,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xa8-0xaf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb0-0xb7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xb8-0xbf */
    -1,   -1,   -1, 2613,   -1,   -1,   -1,   -1, /* 0xc0-0xc7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xc8-0xcf */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd0-0xd7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd8-0xdf */
    -1,   -1,   -1, 2615,   -1, 2617,   -1, 2619, /* 0xe0-0xe7 */
    -1,   -1,   -1,   -1,   -1,   -1, 2621,   -1, /* 0xe8-0xef */
    -1,   -1,   -1,   -1,   -1, 2623, 2625,   -1, /* 0xf0-0xf7 */
};
static const short translit_page31[96] = {
    -1, 2627, 2629, 2631, 2633, 2635, 2637, 2639, /* 0x30-0x37 */
  2641, 2643, 2645, 2647, 2649, 2651, 2653, 2655, /* 0x38-0x3f */
  2657, 2659, 2661, 2663, 2665, 2667, 2669, 2671, /* 0x40-0x47 */
  2673, 2675, 2677, 2679, 2681, 2683, 2685, 2687, /* 0x48-0x4f */
  2689, 2691, 2693, 2695, 2697, 2699, 2701, 2703, /* 0x50-0x57 */
  2705, 2707, 2709, 2711, 2713, 2715, 2717, 2719, /* 0x58-0x5f */
  2721, 2723, 2725, 2727, 2729, 2731, 2733, 2735, /* 0x60-0x67 */
  2737, 2739, 2741, 2743, 2745, 2747, 2749, 2751, /* 0x68-0x6f */
  2753, 2755, 2757, 2759, 2761, 2763, 2765, 2767, /* 0x70-0x77 */
  2769, 2771, 2773, 2775, 2777, 2779, 2781, 2783, /* 0x78-0x7f */
  2785, 2787, 2789, 2791, 2793, 2795, 2797, 2799, /* 0x80-0x87 */
  2801, 2803, 2805, 2807, 2809, 2811, 2813,   -1, /* 0x88-0x8f */
};
static const short translit_page31_1[528] = {
  2815, 2817, 2819, 2821, 2823, 2825, 2827, 2829, /* 0xf0-0xf7 */
  2831, 2833, 2835, 2837, 2839, 2841, 2843, 2845, /* 0xf8-0xff */
  /* 0x3200 */
  2847, 2851, 2855, 2859, 2863, 2867, 2871, 2875, /* 0x00-0x07 */
  2879, 2883, 2887, 2891, 2895, 2899, 2903, 2908, /* 0x08-0x0f */
  2913, 2918, 2923, 2928, 2933, 2938, 2943, 2948, /* 0x10-0x17 */
  2953, 2958, 2963, 2968, 2973, 2978, 2986,   -1, /* 0x18-0x1f */
  2993, 2997, 3001, 3005, 3009, 3013, 3017, 3021, /* 0x20-0x27 */
  3025, 3029, 3033, 3037, 3041, 3045, 3049, 3053, /* 0x28-0x2f */
  3057, 3061, 3065, 3069, 3073, 3077, 3081, 3085, /* 0x30-0x37 */
  3089, 3093, 3097, 3101, 3105, 3109, 3113, 3117, /* 0x38-0x3f */
  3121, 3125, 3129, 3133, 3137, 3141, 3145, 3149, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
  3153, 3157, 3162, 3167, 3172, 3177, 3182, 3187, /* 0x50-0x57 */
  3192, 3197, 3202, 3207, 3212, 3217, 3222, 3227, /* 0x58-0x5f */
  3232, 3236, 3240, 3244, 3248, 3252, 3256, 3260, /* 0x60-0x67 */
  3264, 3268, 3272, 3276, 3280, 3284, 3288, 3293, /* 0x68-0x6f */
  3298, 3303, 3308, 3313, 3318, 3323, 3328, 3333, /* 0x70-0x77 */
  3338, 3343, 3348, 3353, 3358, 3366, 3373,   -1, /* 0x78-0x7f */
  3378, 3382, 3386, 3390, 3394, 3398, 3402, 3406, /* 0x80-0x87 */
  3410, 3414, 3418, 3422, 3426, 3430, 3434, 3438, /* 0x88-0x8f */
  3442, 3446, 3450, 3454, 3458, 3462, 3466, 3470, /* 0x90-0x97 */
  3474, 3478, 3482, 3486, 3490, 3494, 3498, 3502, /* 0x98-0x9f */
  3506, 3510, 3514, 3518, 3522, 3526, 3530, 3534, /* 0xa0-0xa7 */
  3538, 3542, 3546, 3550, 3554, 3558, 3562, 3566, /* 0xa8-0xaf */
  3570, 3574, 3579, 3584, 3589, 3594, 3599, 3604, /* 0xb0-0xb7 */
  3609, 3614, 3619, 3624, 3629, 3634, 3639, 3644, /* 0xb8-0xbf */
  3649, 3652, 3655, 3658, 3661, 3664, 3667, 3670, /* 0xc0-0xc7 */
  3673, 3676, 3680, 3684, 3688, 3691, 3695, 3698, /* 0xc8-0xcf */
  3702, 3706, 3710, 3714, 3718, 3722, 3726, 3730, /* 0xd0-0xd7 */
  3734, 3738, 3742, 3746, 3750, 3754, 3758, 3762, /* 0xd8-0xdf */
  3766, 3770, 3774, 3778, 3782, 3786, 3790, 3794, /* 0xe0-0xe7 */
  3798, 3802, 3806, 3810, 3814, 3818, 3822, 3826, /* 0xe8-0xef */
  3830, 3834, 3838, 3842, 3846, 3850, 3854, 3858, /* 0xf0-0xf7 */
  3862, 3866, 3870, 3874, 3878, 3882, 3886, 3890, /* 0xf8-0xff */
  /* 0x3300 */
  3893, 3898, 3903, 3908, 3912, 3917, 3921, 3925, /* 0x00-0x07 */
  3931, 3936, 3940, 3944, 3948, 3953, 3958, 3962, /* 0x08-0x0f */
  3966, 3969, 3973, 3978, 3983, 3986, 3992, 3999, /* 0x10-0x17 */
  4005, 4009, 4015, 4021, 4026, 4030, 4034, 4038, /* 0x18-0x1f */
  4043, 4049, 4054, 4058, 4062, 4066, 4069, 4072, /* 0x20-0x27 */
  4075, 4078, 4082, 4086, 4092, 4096, 4101, 4107, /* 0x28-0x2f */
  4111, 4114, 4117, 4123, 4128, 4134, 4138, 4144, /* 0x30-0x37 */
  4147, 4151, 4155, 4159, 4163, 4167, 4172, 4176, /* 0x38-0x3f */
  4179, 4183, 4187, 4191, 4196, 4200, 4204, 4208, /* 0x40-0x47 */
  4214, 4219, 4222, 4228, 4231, 4236, 4241, 4245, /* 0x48-0x4f */
  4249, 4253, 4258, 4261, 4265, 4270, 4273, 4279, /* 0x50-0x57 */
  4283, 4286, 4289, 4292, 4295, 4298, 4301, 4304, /* 0x58-0x5f */
  4307, 4310, 4313, 4317, 4321, 4325, 4329, 4333, /* 0x60-0x67 */
  4337, 4341, 4345, 4349, 4353, 4357, 4361, 4365, /* 0x68-0x6f */
  4369, 4373, 4377, 4380, 4383, 4387, 4390, 4393, /* 0x70-0x77 */
  4396, 4401, 4406, 4409, 4412, 4415, 4418, 4421, /* 0x78-0x7f */
  4426, 4429, 4432, 4435, 4438, 4441, 4444, 4447, /* 0x80-0x87 */
  4450, 4454, 4459, 4462, 4465, 4468, 4471, 4474, /* 0x88-0x8f */
  4477, 4480, 4484, 4488, 4492, 4496, 4499, 4502, /* 0x90-0x97 */
  4505, 4508, 4511, 4514, 4517, 4520, 4523, 4526, /* 0x98-0x9f */
  4531, 4536, 4540, 4545, 4550, 4555, 4559, 4564, /* 0xa0-0xa7 */
  4568, 4574, 4577, 4581, 4585, 4589, 4593, 4599, /* 0xa8-0xaf */
  4607, 4610, 4613, 4616, 4619, 4622, 4625, 4628, /* 0xb0-0xb7 */
  4631, 4634, 4637, 4640, 4643, 4646, 4649, 4652, /* 0xb8-0xbf */
  4655, 4658, 4661, 4666, 4669, 4672, 4675, 4680, /* 0xc0-0xc7 */
  4684, 4687, 4690, 4693, 4696, 4699, 4702, 4705, /* 0xc8-0xcf */
  4708, 4711, 4714, 4718, 4721, 4724, 4728, 4732, /* 0xd0-0xd7 */
  4735, 4740, 4744, 4747, 4750, 4753, 4756, 4760, /* 0xd8-0xdf */
  4764, 4767, 4770, 4773, 4776, 4779, 4782, 4785, /* 0xe0-0xe7 */
  4788, 4791, 4795, 4799, 4803, 4807, 4811, 4815, /* 0xe8-0xef */
  4819, 4823, 4827, 4831, 4835, 4839, 4843, 4847, /* 0xf0-0xf7 */
  4851, 4855, 4859, 4863, 4867, 4871, 4875, 4879, /* 0xf8-0xff */
};
static const short translit_pagef9[480] = {
  4883, 4885, 4887, 4889, 4891, 4893, 4895, 4897, /* 0x00-0x07 */
  4899, 4901, 4903, 4905, 4907, 4909, 4911, 4913, /* 0x08-0x0f */
  4915, 4917, 4919, 4921, 4923, 4925, 4927, 4929, /* 0x10-0x17 */
  4931, 4933, 4935, 4937, 4939, 4941, 4943, 4945, /* 0x18-0x1f */
  4947, 4949, 4951, 4953, 4955, 4957, 4959, 4961, /* 0x20-0x27 */
  4963, 4965, 4967, 4969, 4971, 4973, 4975, 4977, /* 0x28-0x2f */
  4979, 4981, 4983, 4985, 4987, 4989, 4991, 4993, /* 0x30-0x37 */
  4995, 4997, 4999, 5001, 5003, 5005, 5007, 5009, /* 0x38-0x3f */
  5011, 5013, 5015, 5017, 5019, 5021, 5023, 5025, /* 0x40-0x47 */
  5027, 5029, 5031, 5033, 5035, 5037, 5039, 5041, /* 0x48-0x4f */
  5043, 5045, 5047, 5049, 5051, 5053, 5055, 5057, /* 0x50-0x57 */
  5059, 5061, 5063, 5065, 5067, 5069, 5071, 5073, /* 0x58-0x5f */
  5075, 5077, 5079, 5081, 5083, 5085, 5087, 5089, /* 0x60-0x67 */
  5091, 5093, 5095, 5097, 5099, 5101, 5103, 5105, /* 0x68-0x6f */
  5107, 5109, 5111, 5113, 5115, 5117, 5119, 5121, /* 0x70-0x77 */
  5123, 5125, 5127, 5129, 5131, 5133, 5135, 5137, /* 0x78-0x7f */
  5139, 5141, 5143, 5145, 5147, 5149, 5151, 5153, /* 0x80-0x87 */
  5155, 5157, 5159, 5161, 5163, 5165, 5167, 5169, /* 0x88-0x8f */
  5171, 5173, 5175, 5177, 5179, 5181, 5183, 5185, /* 0x90-0x97 */
  5187, 5189, 5191, 5193, 5195, 5197, 5199, 5201, /* 0x98-0x9f */
  5203, 5205, 5207, 5209, 5211, 5213, 5215, 5217, /* 0xa0-0xa7 */
  5219, 5221, 5223, 5225, 5227, 5229, 5231, 5233, /* 0xa8-0xaf */
  5235, 5237, 5239, 5241, 5243, 5245, 5247, 5249, /* 0xb0-0xb7 */
  5251, 5253, 5255, 5257, 5259, 5261, 5263, 5265, /* 0xb8-0xbf */
  5267, 5269, 5271, 5273, 5275, 5277, 5279, 5281, /* 0xc0-0xc7 */
  5283, 5285, 5287, 5289, 5291, 5293, 5295, 5297, /* 0xc8-0xcf */
  5299, 5301, 5303, 5305, 5307, 5309, 5311, 5313, /* 0xd0-0xd7 */
  5315, 5317, 5319, 5321, 5323, 5325, 5327, 5329, /* 0xd8-0xdf */
  5331, 5333, 5335, 5337, 5339, 5341, 5343, 5345, /* 0xe0-0xe7 */
  5347, 5349, 5351, 5353, 5355, 5357, 5359, 5361, /* 0xe8-0xef */
  5363, 5365, 5367, 5369, 5371, 5373, 5375, 5377, /* 0xf0-0xf7 */
  5379, 5381, 5383, 5385, 5387, 5389, 5391, 5393, /* 0xf8-0xff */
  /* 0xfa00 */
  5395, 5397, 5399, 5401, 5403, 5405, 5407, 5409, /* 0x00-0x07 */
  5411, 5413, 5415, 5417, 5419, 5421,   -1,   -1, /* 0x08-0x0f */
  5423,   -1, 5425,   -1,   -1, 5427, 5429, 5431, /* 0x10-0x17 */
  5433, 5435, 5437, 5439, 5441, 5443, 5445,   -1, /* 0x18-0x1f */
  5447,   -1, 5449,   -1,   -1, 5451, 5453,   -1, /* 0x20-0x27 */
    -1,   -1, 5455, 5457, 5459, 5461, 5463, 5465, /* 0x28-0x2f */
  5467, 5469, 5471, 5473, 5475, 5477, 5479, 5481, /* 0x30-0x37 */
  5483, 5485, 5487, 5489, 5491, 5493, 5495, 5497, /* 0x38-0x3f */
  5499, 5501, 5503, 5505, 5507, 5509, 5511, 5513, /* 0x40-0x47 */
  5515, 5517, 5519, 5521, 5523, 5525, 5527, 5529, /* 0x48-0x4f */
  5531, 5533, 5535, 5537, 5539, 5541, 5543, 5545, /* 0x50-0x57 */
  5547, 5549, 5551, 5553, 5555, 5557, 5559, 5561, /* 0x58-0x5f */
  5563, 5565, 5567, 5569, 5571, 5573, 5575, 5577, /* 0x60-0x67 */
  5579, 5581, 5583, 5585, 5587, 5589,   -1,   -1, /* 0x68-0x6f */
  5591, 5593, 5595, 5597, 5599, 5601, 5603, 5605, /* 0x70-0x77 */
  5607, 5609, 5611, 5613, 5615, 5617, 5619, 5621, /* 0x78-0x7f */
  5623, 5625, 5627, 5629, 5631, 5633, 5635, 5637, /* 0x80-0x87 */
  5639, 5641, 5643, 5645, 5647, 5649, 5651, 5653, /* 0x88-0x8f */
  5655, 5657, 5659, 5661, 5663, 5665, 5667, 5669, /* 0x90-0x97 */
  5671, 5673, 5675, 5677, 5679, 5681, 5683, 5685, /* 0x98-0x9f */
  5687, 5689, 5691, 5693, 5695, 5697, 5699, 5701, /* 0xa0-0xa7 */
  5703, 5705, 5707, 5709, 5711, 5713, 5715, 5717, /* 0xa8-0xaf */
  5719, 5721, 5723, 5725, 5727, 5729, 5731, 5733, /* 0xb0-0xb7 */
  5735, 5737, 5739, 5741, 5743, 5745, 5747, 5749, /* 0xb8-0xbf */
  5751, 5753, 5755, 5757, 5759, 5761, 5763, 5765, /* 0xc0-0xc7 */
  5767, 5769, 5771, 5773, 5775, 5777, 5779, 5781, /* 0xc8-0xcf */
  5783, 5785, 5787, 5789, 5791, 5793, 5795, 5797, /* 0xd0-0xd7 */
  5799, 5801,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xd8-0xdf */
};
static const short translit_pagefb[80] = {
  5803, 5806, 5809, 5812, 5816, 5820, 5823,   -1, /* 0x00-0x07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
    -1,   -1,   -1, 5826, 5829, 5832, 5835, 5838, /* 0x10-0x17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x18-0x1f */
  5841, 5843, 5845, 5847, 5849, 5851, 5853, 5855, /* 0x20-0x27 */
  5857, 5859,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1, 5861, /* 0x48-0x4f */
};
static const short translit_pagefe[40] = {
    -1, 5864, 5866, 5868, 5870, 5872, 5874, 5876, /* 0x48-0x4f */
  5878, 5880, 5882,   -1, 5884, 5886, 5888, 5890, /* 0x50-0x57 */
  5892, 5894, 5896, 5898, 5900, 5902, 5904, 5906, /* 0x58-0x5f */
  5908, 5910, 5912, 5914, 5916, 5918, 5920,   -1, /* 0x60-0x67 */
  5922, 5924, 5926, 5928,   -1,   -1,   -1,   -1, /* 0x68-0x6f */
};
static const short translit_pageff[240] = {
    -1, 5930, 5932, 5934, 5936, 5938, 5940, 5942, /* 0x00-0x07 */
  5944, 5946, 5948, 5950, 5952, 5954, 5956, 5958, /* 0x08-0x0f */
  5960, 5962, 5964, 5966, 5968, 5970, 5972, 5974, /* 0x10-0x17 */
  5976, 5978, 5980, 5982, 5984, 5986, 5988, 5990, /* 0x18-0x1f */
  5992, 5994, 5996, 5998, 6000, 6002, 6004, 6006, /* 0x20-0x27 */
  6008, 6010, 6012, 6014, 6016, 6018, 6020, 6022, /* 0x28-0x2f */
  6024, 6026, 6028, 6030, 6032, 6034, 6036, 6038, /* 0x30-0x37 */
  6040, 6042, 6044, 6046, 6048, 6050, 6052, 6054, /* 0x38-0x3f */
  6056, 6058, 6060, 6062, 6064, 6066, 6068, 6070, /* 0x40-0x47 */
  6072, 6074, 6076, 6078, 6080, 6082, 6084, 6086, /* 0x48-0x4f */
  6088, 6090, 6092, 6094, 6096, 6098, 6100, 6102, /* 0x50-0x57 */
  6104, 6106, 6108, 6110, 6112, 6114, 6116, 6118, /* 0x58-0x5f */
  6120, 6122, 6124, 6126, 6128, 6130, 6132, 6134, /* 0x60-0x67 */
  6136, 6138, 6140, 6142, 6144, 6146, 6148, 6150, /* 0x68-0x6f */
  6152, 6154, 6156, 6158, 6160, 6162, 6164, 6166, /* 0x70-0x77 */
  6168, 6170, 6172, 6174, 6176, 6178, 6180, 6182, /* 0x78-0x7f */
  6184, 6186, 6188, 6190, 6192, 6194, 6196, 6198, /* 0x80-0x87 */
  6200, 6202, 6204, 6206, 6208, 6210, 6212, 6214, /* 0x88-0x8f */
  6216, 6218, 6220, 6222, 6224, 6226, 6228, 6230, /* 0x90-0x97 */
  6232, 6234, 6236, 6238, 6240, 6242, 6244, 6246, /* 0x98-0x9f */
  6248, 6250, 6252, 6254, 6256, 6258, 6260, 6262, /* 0xa0-0xa7 */
  6264, 6266, 6268, 6270, 6272, 6274, 6276, 6278, /* 0xa8-0xaf */
  6280, 6282, 6284, 6286, 6288, 6290, 6292, 6294, /* 0xb0-0xb7 */
  6296, 6298, 6300, 6302, 6304, 6306, 6308,   -1, /* 0xb8-0xbf */
    -1,   -1, 6310, 6312, 6314, 6316, 6318, 6320, /* 0xc0-0xc7 */
    -1,   -1, 6322, 6324, 6326, 6328, 6330, 6332, /* 0xc8-0xcf */
    -1,   -1, 6334, 6336, 6338, 6340, 6342, 6344, /* 0xd0-0xd7 */
    -1,   -1, 6346, 6348, 6350,   -1,   -1,   -1, /* 0xd8-0xdf */
  6352, 6354, 6356, 6358, 6360, 6362, 6364,   -1, /* 0xe0-0xe7 */
  6366, 6368, 6370, 6372, 6374, 6376, 6378,   -1, /* 0xe8-0xef */
};
static const short translit_page1d4[1024] = {
  6380, 6382, 6384, 6386, 6388, 6390, 6392, 6394, /* 0x00-0x07 */
  6396, 6398, 6400, 6402, 6404, 6406, 6408, 6410, /* 0x08-0x0f */
  6412, 6414, 6416, 6418, 6420, 6422, 6424, 6426, /* 0x10-0x17 */
  6428, 6430, 6432, 6434, 6436, 6438, 6440, 6442, /* 0x18-0x1f */
  6444, 6446, 6448, 6450, 6452, 6454, 6456, 6458, /* 0x20-0x27 */
  6460, 6462, 6464, 6466, 6468, 6470, 6472, 6474, /* 0x28-0x2f */
  6476, 6478, 6480, 6482, 6484, 6486, 6488, 6490, /* 0x30-0x37 */
  6492, 6494, 6496, 6498, 6500, 6502, 6504, 6506, /* 0x38-0x3f */
  6508, 6510, 6512, 6514, 6516, 6518, 6520, 6522, /* 0x40-0x47 */
  6524, 6526, 6528, 6530, 6532, 6534, 6536, 6538, /* 0x48-0x4f */
  6540, 6542, 6544, 6546, 6548,   -1, 6550, 6552, /* 0x50-0x57 */
  6554, 6556, 6558, 6560, 6562, 6564, 6566, 6568, /* 0x58-0x5f */
  6570, 6572, 6574, 6576, 6578, 6580, 6582, 6584, /* 0x60-0x67 */
  6586, 6588, 6590, 6592, 6594, 6596, 6598, 6600, /* 0x68-0x6f */
  6602, 6604, 6606, 6608, 6610, 6612, 6614, 6616, /* 0x70-0x77 */
  6618, 6620, 6622, 6624, 6626, 6628, 6630, 6632, /* 0x78-0x7f */
  6634, 6636, 6638, 6640, 6642, 6644, 6646, 6648, /* 0x80-0x87 */
  6650, 6652, 6654, 6656, 6658, 6660, 6662, 6664, /* 0x88-0x8f */
  6666, 6668, 6670, 6672, 6674, 6676, 6678, 6680, /* 0x90-0x97 */
  6682, 6684, 6686, 6688, 6690,   -1, 6692, 6694, /* 0x98-0x9f */
    -1,   -1, 6696,   -1,   -1, 6698, 6700,   -1, /* 0xa0-0xa7 */
    -1, 6702, 6704, 6706, 6708,   -1, 6710, 6712, /* 0xa8-0xaf */
  6714, 6716, 6718, 6720, 6722, 6724, 6726, 6728, /* 0xb0-0xb7 */
  6730, 6732,   -1, 6734,   -1, 6736, 6738, 6740, /* 0xb8-0xbf */
  6742, 6744, 6746, 6748,   -1, 6750, 6752, 6754, /* 0xc0-0xc7 */
  6756, 6758, 6760, 6762, 6764, 6766, 6768, 6770, /* 0xc8-0xcf */
  6772, 6774, 6776, 6778, 6780, 6782, 6784, 6786, /* 0xd0-0xd7 */
  6788, 6790, 6792, 6794, 6796, 6798, 6800, 6802, /* 0xd8-0xdf */
  6804, 6806, 6808, 6810, 6812, 6814, 6816, 6818, /* 0xe0-0xe7 */
  6820, 6822, 6824, 6826, 6828, 6830, 6832, 6834, /* 0xe8-0xef */
  6836, 6838, 6840, 6842, 6844, 6846, 6848, 6850, /* 0xf0-0xf7 */
  6852, 6854, 6856, 6858, 6860, 6862, 6864, 6866, /* 0xf8-0xff */
  /* 0x1d500 */
  6868, 6870, 6872, 6874, 6876, 6878,   -1, 6880, /* 0x00-0x07 */
  6882, 6884, 6886,   -1,   -1, 6888, 6890, 6892, /* 0x08-0x0f */
  6894, 6896, 6898, 6900, 6902,   -1, 6904, 6906, /* 0x10-0x17 */
  6908, 6910, 6912, 6914, 6916,   -1, 6918, 6920, /* 0x18-0x1f */
  6922, 6924, 6926, 6928, 6930, 6932, 6934, 6936, /* 0x20-0x27 */
  6938, 6940, 6942, 6944, 6946, 6948, 6950, 6952, /* 0x28-0x2f */
  6954, 6956, 6958, 6960, 6962, 6964, 6966, 6968, /* 0x30-0x37 */
  6970, 6972,   -1, 6974, 6976, 6978, 6980,   -1, /* 0x38-0x3f */
  6982, 6984, 6986, 6988, 6990,   -1, 6992,   -1, /* 0x40-0x47 */
    -1,   -1, 6994, 6996, 6998, 7000, 7002, 7004, /* 0x48-0x4f */
  7006,   -1, 7008, 7010, 7012, 7014, 7016, 7018, /* 0x50-0x57 */
  7020, 7022, 7024, 7026, 7028, 7030, 7032, 7034, /* 0x58-0x5f */
  7036, 7038, 7040, 7042, 7044, 7046, 7048, 7050, /* 0x60-0x67 */
  7052, 7054, 7056, 7058, 7060, 7062, 7064, 7066, /* 0x68-0x6f */
  7068, 7070, 7072, 7074, 7076, 7078, 7080, 7082, /* 0x70-0x77 */
  7084, 7086, 7088, 7090, 7092, 7094, 7096, 7098, /* 0x78-0x7f */
  7100, 7102, 7104, 7106, 7108, 7110, 7112, 7114, /* 0x80-0x87 */
  7116, 7118, 7120, 7122, 7124, 7126, 7128, 7130, /* 0x88-0x8f */
  7132, 7134, 7136, 7138, 7140, 7142, 7144, 7146, /* 0x90-0x97 */
  7148, 7150, 7152, 7154, 7156, 7158, 7160, 7162, /* 0x98-0x9f */
  7164, 7166, 7168, 7170, 7172, 7174, 7176, 7178, /* 0xa0-0xa7 */
  7180, 7182, 7184, 7186, 7188, 7190, 7192, 7194, /* 0xa8-0xaf */
  7196, 7198, 7200, 7202, 7204, 7206, 7208, 7210, /* 0xb0-0xb7 */
  7212, 7214, 7216, 7218, 7220, 7222, 7224, 7226, /* 0xb8-0xbf */
  7228, 7230, 7232, 7234, 7236, 7238, 7240, 7242, /* 0xc0-0xc7 */
  7244, 7246, 7248, 7250, 7252, 7254, 7256, 7258, /* 0xc8-0xcf */
  7260, 7262, 7264, 7266, 7268, 7270, 7272, 7274, /* 0xd0-0xd7 */
  7276, 7278, 7280, 7282, 7284, 7286, 7288, 7290, /* 0xd8-0xdf */
  7292, 7294, 7296, 7298, 7300, 7302, 7304, 7306, /* 0xe0-0xe7 */
  7308, 7310, 7312, 7314, 7316, 7318, 7320, 7322, /* 0xe8-0xef */
  7324, 7326, 7328, 7330, 7332, 7334, 7336, 7338, /* 0xf0-0xf7 */
  7340, 7342, 7344, 7346, 7348, 7350, 7352, 7354, /* 0xf8-0xff */
  /* 0x1d600 */
  7356, 7358, 7360, 7362, 7364, 7366, 7368, 7370, /* 0x00-0x07 */
  7372, 7374, 7376, 7378, 7380, 7382, 7384, 7386, /* 0x08-0x0f */
  7388, 7390, 7392, 7394, 7396, 7398, 7400, 7402, /* 0x10-0x17 */
  7404, 7406, 7408, 7410, 7412, 7414, 7416, 7418, /* 0x18-0x1f */
  7420, 7422, 7424, 7426, 7428, 7430, 7432, 7434, /* 0x20-0x27 */
  7436, 7438, 7440, 7442, 7444, 7446, 7448, 7450, /* 0x28-0x2f */
  7452, 7454, 7456, 7458, 7460, 7462, 7464, 7466, /* 0x30-0x37 */
  7468, 7470, 7472, 7474, 7476, 7478, 7480, 7482, /* 0x38-0x3f */
  7484, 7486, 7488, 7490, 7492, 7494, 7496, 7498, /* 0x40-0x47 */
  7500, 7502, 7504, 7506, 7508, 7510, 7512, 7514, /* 0x48-0x4f */
  7516, 7518, 7520, 7522, 7524, 7526, 7528, 7530, /* 0x50-0x57 */
  7532, 7534, 7536, 7538, 7540, 7542, 7544, 7546, /* 0x58-0x5f */
  7548, 7550, 7552, 7554, 7556, 7558, 7560, 7562, /* 0x60-0x67 */
  7564, 7566, 7568, 7570, 7572, 7574, 7576, 7578, /* 0x68-0x6f */
  7580, 7582, 7584, 7586, 7588, 7590, 7592, 7594, /* 0x70-0x77 */
  7596, 7598, 7600, 7602, 7604, 7606, 7608, 7610, /* 0x78-0x7f */
  7612, 7614, 7616, 7618, 7620, 7622, 7624, 7626, /* 0x80-0x87 */
  7628, 7630, 7632, 7634, 7636, 7638, 7640, 7642, /* 0x88-0x8f */
  7644, 7646, 7648, 7650, 7652, 7654, 7656, 7658, /* 0x90-0x97 */
  7660, 7662, 7664, 7666, 7668, 7670, 7672, 7674, /* 0x98-0x9f */
  7676, 7678, 7680, 7682, 7684, 7686,   -1,   -1, /* 0xa0-0xa7 */
  7688, 7690, 7692, 7694, 7696, 7698, 7700, 7702, /* 0xa8-0xaf */
  7704, 7706, 7708, 7710, 7712, 7714, 7716, 7718, /* 0xb0-0xb7 */
  7720, 7722, 7724, 7726, 7728, 7730, 7732, 7734, /* 0xb8-0xbf */
  7736, 7738, 7740, 7742, 7744, 7746, 7748, 7750, /* 0xc0-0xc7 */
  7752, 7754, 7756, 7758, 7760, 7762, 7764, 7766, /* 0xc8-0xcf */
  7768, 7770, 7772, 7774, 7776, 7778, 7780, 7782, /* 0xd0-0xd7 */
  7784, 7786, 7788, 7790, 7792, 7794, 7796, 7798, /* 0xd8-0xdf */
  7800, 7802, 7804, 7806, 7808, 7810, 7812, 7814, /* 0xe0-0xe7 */
  7816, 7818, 7820, 7822, 7824, 7826, 7828, 7830, /* 0xe8-0xef */
  7832, 7834, 7836, 7838, 7840, 7842, 7844, 7846, /* 0xf0-0xf7 */
  7848, 7850, 7852, 7854, 7856, 7858, 7860, 7862, /* 0xf8-0xff */
  /* 0x1d700 */
  7864, 7866, 7868, 7870, 7872, 7874, 7876, 7878, /* 0x00-0x07 */
  7880, 7882, 7884, 7886, 7888, 7890, 7892, 7894, /* 0x08-0x0f */
  7896, 7898, 7900, 7902, 7904, 7906, 7908, 7910, /* 0x10-0x17 */
  7912, 7914, 7916, 7918, 7920, 7922, 7924, 7926, /* 0x18-0x1f */
  7928, 7930, 7932, 7934, 7936, 7938, 7940, 7942, /* 0x20-0x27 */
  7944, 7946, 7948, 7950, 7952, 7954, 7956, 7958, /* 0x28-0x2f */
  7960, 7962, 7964, 7966, 7968, 7970, 7972, 7974, /* 0x30-0x37 */
  7976, 7978, 7980, 7982, 7984, 7986, 7988, 7990, /* 0x38-0x3f */
  7992, 7994, 7996, 7998, 8000, 8002, 8004, 8006, /* 0x40-0x47 */
  8008, 8010, 8012, 8014, 8016, 8018, 8020, 8022, /* 0x48-0x4f */
  8024, 8026, 8028, 8030, 8032, 8034, 8036, 8038, /* 0x50-0x57 */
  8040, 8042, 8044, 8046, 8048, 8050, 8052, 8054, /* 0x58-0x5f */
  8056, 8058, 8060, 8062, 8064, 8066, 8068, 8070, /* 0x60-0x67 */
  8072, 8074, 8076, 8078, 8080, 8082, 8084, 8086, /* 0x68-0x6f */
  8088, 8090, 8092, 8094, 8096, 8098, 8100, 8102, /* 0x70-0x77 */
  8104, 8106, 8108, 8110, 8112, 8114, 8116, 8118, /* 0x78-0x7f */
  8120, 8122, 8124, 8126, 8128, 8130, 8132, 8134, /* 0x80-0x87 */
  8136, 8138, 8140, 8142, 8144, 8146, 8148, 8150, /* 0x88-0x8f */
  8152, 8154, 8156, 8158, 8160, 8162, 8164, 8166, /* 0x90-0x97 */
  8168, 8170, 8172, 8174, 8176, 8178, 8180, 8182, /* 0x98-0x9f */
  8184, 8186, 8188, 8190, 8192, 8194, 8196, 8198, /* 0xa0-0xa7 */
  8200, 8202, 8204, 8206, 8208, 8210, 8212, 8214, /* 0xa8-0xaf */
  8216, 8218, 8220, 8222, 8224, 8226, 8228, 8230, /* 0xb0-0xb7 */
  8232, 8234, 8236, 8238, 8240, 8242, 8244, 8246, /* 0xb8-0xbf */
  8248, 8250, 8252, 8254, 8256, 8258, 8260, 8262, /* 0xc0-0xc7 */
  8264, 8266, 8268, 8270,   -1,   -1, 8272, 8274, /* 0xc8-0xcf */
  8276, 8278, 8280, 8282, 8284, 8286, 8288, 8290, /* 0xd0-0xd7 */
  8292, 8294, 8296, 8298, 8300, 8302, 8304, 8306, /* 0xd8-0xdf */
  8308, 8310, 8312, 8314, 8316, 8318, 8320, 8322, /* 0xe0-0xe7 */
  8324, 8326, 8328, 8330, 8332, 8334, 8336, 8338, /* 0xe8-0xef */
  8340, 8342, 8344, 8346, 8348, 8350, 8352, 8354, /* 0xf0-0xf7 */
  8356, 8358, 8360, 8362, 8364, 8366, 8368, 8370, /* 0xf8-0xff */
};
static const short translit_page1ee[192] = {
  8372, 8374, 8376, 8378,   -1, 8380, 8382, 8384, /* 0x00-0x07 */
  8386, 8388, 8390, 8392, 8394, 8396, 8398, 8400, /* 0x08-0x0f */
  8402, 8404, 8406, 8408, 8410, 8412, 8414, 8416, /* 0x10-0x17 */
  8418, 8420, 8422, 8424, 8426, 8428, 8430, 8432, /* 0x18-0x1f */
    -1, 8434, 8436,   -1, 8438,   -1,   -1, 8440, /* 0x20-0x27 */
    -1, 8442, 8444, 8446, 8448, 8450, 8452, 8454, /* 0x28-0x2f */
  8456, 8458, 8460,   -1, 8462, 8464, 8466, 8468, /* 0x30-0x37 */
    -1, 8470,   -1, 8472,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
    -1,   -1, 8474,   -1,   -1,   -1,   -1, 8476, /* 0x40-0x47 */
    -1, 8478,   -1, 8480,   -1, 8482, 8484, 8486, /* 0x48-0x4f */
    -1, 8488, 8490,   -1, 8492,   -1,   -1, 8494, /* 0x50-0x57 */
    -1, 8496,   -1, 8498,   -1, 8500,   -1, 8502, /* 0x58-0x5f */
    -1, 8504, 8506,   -1, 8508,   -1,   -1, 8510, /* 0x60-0x67 */
  8512, 8514, 8516,   -1, 8518, 8520, 8522, 8524, /* 0x68-0x6f */
  8526, 8528, 8530,   -1, 8532, 8534, 8536, 8538, /* 0x70-0x77 */
    -1, 8540, 8542, 8544, 8546,   -1, 8548,   -1, /* 0x78-0x7f */
  8550, 8552, 8554, 8556, 8558, 8560, 8562, 8564, /* 0x80-0x87 */
  8566, 8568,   -1, 8570, 8572, 8574, 8576, 8578, /* 0x88-0x8f */
  8580, 8582, 8584, 8586, 8588, 8590, 8592, 8594, /* 0x90-0x97 */
  8596, 8598, 8600, 8602,   -1,   -1,   -1,   -1, /* 0x98-0x9f */
    -1, 8604, 8606, 8608,   -1, 8610, 8612, 8614, /* 0xa0-0xa7 */
  8616, 8618,   -1, 8620, 8622, 8624, 8626, 8628, /* 0xa8-0xaf */
  8630, 8632, 8634, 8636, 8638, 8640, 8642, 8644, /* 0xb0-0xb7 */
  8646, 8648, 8650, 8652,   -1,   -1,   -1,   -1, /* 0xb8-0xbf */
};
static const short translit_page1f1[80] = {
  8654, 8657, 8660, 8663, 8666, 8669, 8672, 8675, /* 0x00-0x07 */
  8678, 8681, 8684,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
  8687, 8691, 8695, 8699, 8703, 8707, 8711, 8715, /* 0x10-0x17 */
  8719, 8723, 8727, 8731, 8735, 8739, 8743, 8747, /* 0x18-0x1f */
  8751, 8755, 8759, 8763, 8767, 8771, 8775, 8779, /* 0x20-0x27 */
  8783, 8787, 8791, 8795, 8799, 8803, 8808,   -1, /* 0x28-0x2f */
  8813, 8815, 8817, 8819, 8821, 8823, 8825, 8827, /* 0x30-0x37 */
  8829, 8831, 8833, 8835, 8837, 8839, 8841, 8843, /* 0x38-0x3f */
  8845, 8847, 8849, 8851, 8853, 8855, 8857, 8859, /* 0x40-0x47 */
  8861, 8863, 8865, 8868, 8871, 8874, 8877, 8881, /* 0x48-0x4f */
};
static const short translit_page1f2[88] = {
  8887, 8890, 8893,   -1,   -1,   -1,   -1,   -1, /* 0x00-0x07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0f */
  8895, 8897, 8899, 8901, 8903, 8905, 8907, 8909, /* 0x10-0x17 */
  8911, 8913, 8915, 8917, 8919, 8921, 8923, 8925, /* 0x18-0x1f */
  8927, 8929, 8931, 8933, 8935, 8937, 8939, 8941, /* 0x20-0x27 */
  8943, 8945, 8947, 8949, 8951, 8953, 8955, 8957, /* 0x28-0x2f */
  8959, 8961, 8963, 8965, 8967, 8969, 8971, 8973, /* 0x30-0x37 */
  8975, 8977, 8979, 8981,   -1,   -1,   -1,   -1, /* 0x38-0x3f */
  8983, 8987, 8991, 8995, 8999, 9003, 9007, 9011, /* 0x40-0x47 */
  9015,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4f */
  9019, 9023,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x50-0x57 */
};
static const short translit_page1f4[16] = {
    -1,   -1,   -1, 9027, 9031,   -1, 9037, 9041, /* 0x90-0x97 */
    -1, 9045, 9049, 9053, 9057,   -1,   -1,   -1, /* 0x98-0x9f */
};
static const short translit_page1f6[72] = {
  9065, 9069, 9073, 9077, 9081, 9085, 9089, 9093, /* 0x00-0x07 */
  9098, 9103, 9107, 9111, 9115, 9119, 9123, 9127, /* 0x08-0x0f */
  9131, 9135, 9139, 9143, 9148, 9152, 9157, 9161, /* 0x10-0x17 */
  9165, 9169, 9173, 9177, 9181, 9185, 9189, 9193, /* 0x18-0x1f */
  9197, 9203, 9207, 9212,   -1,   -1, 9216, 9220, /* 0x20-0x27 */
  9224, 9228,   -1,   -1,   -1, 9232, 9237, 9241, /* 0x28-0x2f */
  9245, 9250, 9254,   -1,   -1,   -1,   -1,   -1, /* 0x30-0x37 */
  9258, 9262, 9267, 9271, 9275, 9279,   -1,   -1, /* 0x38-0x3f */
    -1, 9283, 9287, 9291,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
};
static const short translit_page1f9[8] = {
    -1,   -1,   -1,   -1,   -1, 9295, 9299,   -1, /* 0x08-0x0f */
};
static const short translit_page1fb[16] = {
  9307, 9309, 9311, 9313, 9315, 9317, 9319, 9321, /* 0xf0-0xf7 */
  9323, 9325,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xf8-0xff */
};
static const short translit_page2f8[544] = {
  9327, 9329, 9331, 9333, 9335, 9337, 9339, 9341, /* 0x00-0x07 */
  9343, 9345, 9347, 9349, 9351, 9353, 9355, 9357, /* 0x08-0x0f */
  9359, 9361, 9363, 9365, 9367, 9369, 9371, 9373, /* 0x10-0x17 */
  9375, 9377, 9379, 9381, 9383, 9385, 9387, 9389, /* 0x18-0x1f */
  9391, 9393, 9395, 9397, 9399, 9401, 9403, 9405, /* 0x20-0x27 */
  9407, 9409, 9411, 9413, 9415, 9417, 9419, 9421, /* 0x28-0x2f */
  9423, 9425, 9427, 9429, 9431, 9433, 9435, 9437, /* 0x30-0x37 */
  9439, 9441, 9443, 9445, 9447, 9449, 9451, 9453, /* 0x38-0x3f */
  9455, 9457, 9459, 9461, 9463, 9465, 9467, 9469, /* 0x40-0x47 */
  9471, 9473, 9475, 9477, 9479, 9481, 9483, 9485, /* 0x48-0x4f */
  9487, 9489, 9491, 9493, 9495, 9497, 9499, 9501, /* 0x50-0x57 */
  9503, 9505, 9507, 9509, 9511, 9513, 9515, 9517, /* 0x58-0x5f */
  9519, 9521, 9523, 9525, 9527, 9529, 9531, 9533, /* 0x60-0x67 */
  9535, 9537, 9539, 9541, 9543, 9545, 9547, 9549, /* 0x68-0x6f */
  9551, 9553, 9555, 9557, 9559, 9561, 9563, 9565, /* 0x70-0x77 */
  9567, 9569, 9571, 9573, 9575, 9577, 9579, 9581, /* 0x78-0x7f */
  9583, 9585, 9587, 9589, 9591, 9593, 9595, 9597, /* 0x80-0x87 */
  9599, 9601, 9603, 9605, 9607, 9609, 9611, 9613, /* 0x88-0x8f */
  9615, 9617, 9619, 9621, 9623, 9625, 9627, 9629, /* 0x90-0x97 */
  9631, 9633, 9635, 9637, 9639, 9641, 9643, 9645, /* 0x98-0x9f */
  9647, 9649, 9651, 9653, 9655, 9657, 9659, 9661, /* 0xa0-0xa7 */
  9663, 9665, 9667, 9669, 9671, 9673, 9675, 9677, /* 0xa8-0xaf */
  9679, 9681, 9683, 9685, 9687, 9689, 9691, 9693, /* 0xb0-0xb7 */
  9695, 9697, 9699, 9701, 9703, 9705, 9707, 9709, /* 0xb8-0xbf */
  9711, 9713, 9715, 9717, 9719, 9721, 9723, 9725, /* 0xc0-0xc7 */
  9727, 9729, 9731, 9733, 9735, 9737, 9739, 9741, /* 0xc8-0xcf */
  9743, 9745, 9747, 9749, 9751, 9753, 9755, 9757, /* 0xd0-0xd7 */
  9759, 9761, 9763, 9765, 9767, 9769, 9771, 9773, /* 0xd8-0xdf */
  9775, 9777, 9779, 9781, 9783, 9785, 9787, 9789, /* 0xe0-0xe7 */
  9791, 9793, 9795, 9797, 9799, 9801, 9803, 9805, /* 0xe8-0xef */
  9807, 9809, 9811, 9813, 9815, 9817, 9819, 9821, /* 0xf0-0xf7 */
  9823, 9825, 9827, 9829, 9831, 9833, 9835, 9837, /* 0xf8-0xff */
  /* 0x2f900 */
  9839, 9841, 9843, 9845, 9847, 9849, 9851, 9853, /* 0x00-0x07 */
  9855, 9857, 9859, 9861, 9863, 9865, 9867, 9869, /* 0x08-0x0f */
  9871, 9873, 9875, 9877, 9879, 9881, 9883, 9885, /* 0x10-0x17 */
  9887, 9889, 9891, 9893, 9895, 9897, 9899, 9901, /* 0x18-0x1f */
  9903, 9905, 9907, 9909, 9911, 9913, 9915, 9917, /* 0x20-0x27 */
  9919, 9921, 9923, 9925, 9927, 9929, 9931, 9933, /* 0x28-0x2f */
  9935, 9937, 9939, 9941, 9943, 9945, 9947, 9949, /* 0x30-0x37 */
  9951, 9953, 9955, 9957, 9959, 9961, 9963, 9965, /* 0x38-0x3f */
  9967, 9969, 9971, 9973, 9975, 9977, 9979, 9981, /* 0x40-0x47 */
  9983, 9985, 9987, 9989, 9991, 9993, 9995, 9997, /* 0x48-0x4f */
  9999, 10001, 10003, 10005, 10007, 10009, 10011, 10013, /* 0x50-0x57 */
  10015, 10017, 10019, 10021, 10023, 10025, 10027, 10029, /* 0x58-0x5f */
  10031, 10033, 10035, 10037, 10039, 10041, 10043, 10045, /* 0x60-0x67 */
  10047, 10049, 10051, 10053, 10055, 10057, 10059, 10061, /* 0x68-0x6f */
  10063, 10065, 10067, 10069, 10071, 10073, 10075, 10077, /* 0x70-0x77 */
  10079, 10081, 10083, 10085, 10087, 10089, 10091, 10093, /* 0x78-0x7f */
  10095, 10097, 10099, 10101, 10103, 10105, 10107, 10109, /* 0x80-0x87 */
  10111, 10113, 10115, 10117, 10119, 10121, 10123, 10125, /* 0x88-0x8f */
  10127, 10129, 10131, 10133, 10135, 10137, 10139, 10141, /* 0x90-0x97 */
  10143, 10145, 10147, 10149, 10151, 10153, 10155, 10157, /* 0x98-0x9f */
  10159, 10161, 10163, 10165, 10167, 10169, 10171, 10173, /* 0xa0-0xa7 */
  10175, 10177, 10179, 10181, 10183, 10185, 10187, 10189, /* 0xa8-0xaf */
  10191, 10193, 10195, 10197, 10199, 10201, 10203, 10205, /* 0xb0-0xb7 */
  10207, 10209, 10211, 10213, 10215, 10217, 10219, 10221, /* 0xb8-0xbf */
  10223, 10225, 10227, 10229, 10231, 10233, 10235, 10237, /* 0xc0-0xc7 */
  10239, 10241, 10243, 10245, 10247, 10249, 10251, 10253, /* 0xc8-0xcf */
  10255, 10257, 10259, 10261, 10263, 10265, 10267, 10269, /* 0xd0-0xd7 */
  10271, 10273, 10275, 10277, 10279, 10281, 10283, 10285, /* 0xd8-0xdf */
  10287, 10289, 10291, 10293, 10295, 10297, 10299, 10301, /* 0xe0-0xe7 */
  10303, 10305, 10307, 10309, 10311, 10313, 10315, 10317, /* 0xe8-0xef */
  10319, 10321, 10323, 10325, 10327, 10329, 10331, 10333, /* 0xf0-0xf7 */
  10335, 10337, 10339, 10341, 10343, 10345, 10347, 10349, /* 0xf8-0xff */
  /* 0x2fa00 */
  10351, 10353, 10355, 10357, 10359, 10361, 10363, 10365, /* 0x00-0x07 */
  10367, 10369, 10371, 10373, 10375, 10377, 10379, 10381, /* 0x08-0x0f */
  10383, 10385, 10387, 10389, 10391, 10393, 10395, 10397, /* 0x10-0x17 */
  10399, 10401, 10403, 10405, 10407, 10409,   -1,   -1, /* 0x18-0x1f */
};

#define translit_index(wc) \
  (wc >= 0x00a0 && wc < 0x01f8 ? translit_page00[wc-0x00a0] : \
   wc >= 0x0218 && wc < 0x0220 ? translit_page02[wc-0x0218] : \
   wc >= 0x02b8 && wc < 0x02e0 ? translit_page02_1[wc-0x02b8] : \
   wc >= 0x03d0 && wc < 0x0400 ? translit_page03[wc-0x03d0] : \
   wc == 0x0587 ? 654 : \
   wc >= 0x05f0 && wc < 0x05f8 ? translit_page05[wc-0x05f0] : \
   wc >= 0x0670 && wc < 0x0680 ? translit_page06[wc-0x0670] : \
   wc == 0x0e33 ? 678 : \
   wc >= 0x0eb0 && wc < 0x0ee0 ? translit_page0e[wc-0x0eb0] : \
   wc >= 0x0f70 && wc < 0x0f80 ? translit_page0f[wc-0x0f70] : \
   wc >= 0x1e00 && wc < 0x1ea0 ? translit_page1e[wc-0x1e00] : \
   wc >= 0x1ef0 && wc < 0x1ef8 ? translit_page1e_1[wc-0x1ef0] : \
   wc >= 0x2000 && wc < 0x2058 ? translit_page20[wc-0x2000] : \
   wc >= 0x20a8 && wc < 0x20b0 ? translit_page20_1[wc-0x20a8] : \
   wc >= 0x2100 && wc < 0x21d8 ? translit_page21[wc-0x2100] : \
   wc >= 0x2210 && wc < 0x2270 ? translit_page22[wc-0x2210] : \
   wc >= 0x22c0 && wc < 0x22f0 ? translit_page22_1[wc-0x22c0] : \
   wc >= 0x2400 && wc < 0x24f0 ? translit_page24[wc-0x2400] : \
   wc >= 0x2500 && wc < 0x2540 ? translit_page25[wc-0x2500] : \
   wc == 0x25e6 ? 2027 : \
   wc >= 0x2660 && wc < 0x2668 ? translit_page26[wc-0x2660] : \
   wc == 0x2764 ? 2037 : \
   wc >= 0x27e0 && wc < 0x27f0 ? translit_page27[wc-0x27e0] : \
   wc >= 0x2980 && wc < 0x2990 ? translit_page29[wc-0x2980] : \
   wc >= 0x29e0 && wc < 0x2a00 ? translit_page29_1[wc-0x29e0] : \
   wc == 0x2a0c ? 2113 : \
   wc >= 0x2a70 && wc < 0x2a78 ? translit_page2a[wc-0x2a70] : \
   wc == 0x2e9f ? 2129 : \
   wc == 0x2ef3 ? 2131 : \
   wc >= 0x2f00 && wc < 0x2fd8 ? translit_page2f[wc-0x2f00] : \
   wc >= 0x3000 && wc < 0x30f8 ? translit_page30[wc-0x3000] : \
   wc >= 0x3130 && wc < 0x3190 ? translit_page31[wc-0x3130] : \
   wc >= 0x31f0 && wc < 0x3400 ? translit_page31_1[wc-0x31f0] : \
   wc >= 0xf900 && wc < 0xfae0 ? translit_pagef9[wc-0xf900] : \
   wc >= 0xfb00 && wc < 0xfb50 ? translit_pagefb[wc-0xfb00] : \
   wc >= 0xfe48 && wc < 0xfe70 ? translit_pagefe[wc-0xfe48] : \
   wc >= 0xff00 && wc < 0xfff0 ? translit_pageff[wc-0xff00] : \
   wc >= 0x1d400 && wc < 0x1d800 ? translit_page1d4[wc-0x1d400] : \
   wc >= 0x1ee00 && wc < 0x1eec0 ? translit_page1ee[wc-0x1ee00] : \
   wc >= 0x1f100 && wc < 0x1f150 ? translit_page1f1[wc-0x1f100] : \
   wc == 0x1f190 ? 8884 : \
   wc >= 0x1f200 && wc < 0x1f258 ? translit_page1f2[wc-0x1f200] : \
   wc >= 0x1f490 && wc < 0x1f4a0 ? translit_page1f4[wc-0x1f490] : \
   wc == 0x1f5a4 ? 9061 : \
   wc >= 0x1f600 && wc < 0x1f648 ? translit_page1f6[wc-0x1f600] : \
   wc >= 0x1f908 && wc < 0x1f910 ? translit_page1f9[wc-0x1f908] : \
   wc == 0x1f9e1 ? 9303 : \
   wc >= 0x1fbf0 && wc < 0x1fc00 ? translit_page1fb[wc-0x1fbf0] : \
   wc >= 0x2f800 && wc < 0x2fa20 ? translit_page2f8[wc-0x2f800] : \
   -1)
