/* Copyright (C) 1997, 1998, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* Define the machine-dependent type `jmp_buf'.  Intel 386 version.  */

#ifndef _SETJMP_H
# error "Never include <bits/setjmp.h> directly; use <setjmp.h> instead."
#endif

#if defined __USE_MISC || defined _ASM
# define JB_BX	0
# define JB_SI	1
# define JB_DI	2
# define JB_BP	3
# define JB_SP	4
# define JB_PC	5
# define JB_SIZE 24
#endif

#ifdef	_ASM
/* We internally convert all setjmp (buf) calls to sigsetjmp (buf, mask),
   so we must shift with the call frame to insert the mask argument.  */
# if __BOUNDED_POINTERS__
#  define PUSH_SIGNAL_MASK(MASK)				\
	popl %eax;		/* return address */		\
	popl %ecx;		/* jmp_buf value */		\
	popl %edx;		/* jmp_buf low bound */		\
	pushl 0(%esp);		/* jmp_buf high bound */	\
	movl $MASK, 4(%esp);					\
	pushl %edx;						\
	pushl %ecx;						\
	pushl %eax
# else
#  define PUSH_SIGNAL_MASK(MASK)			\
	popl %eax;		/* return address */	\
	popl %ecx;		/* jmp_buf */		\
	pushl $MASK;					\
	pushl %ecx;					\
	pushl %eax
# endif
#else
typedef int __jmp_buf[6];
#endif

/* Test if longjmp to JMPBUF would unwind the frame
   containing a local variable at ADDRESS.  */
#define _JMPBUF_UNWINDS(jmpbuf, address) \
  ((void *) (address) < (void *) (jmpbuf)[JB_SP])
