/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractCharVector;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.Sequences;
import gnu.lists.SimpleVector;
import java.io.IOException;
import java.io.Writer;

public class GapManager
implements IntSequence {
    protected int gapStart;
    protected int gapEnd;
    protected int size;

    private GapManager() {
    }

    public GapManager(SimpleVector vector) {
        int sz;
        this.size = sz = vector.size();
        this.gapStart = sz;
        this.gapEnd = vector.getBufferLength();
    }

    public static GapManager getEmptyInstance(SimpleVector vector) {
        GapManager manager = new GapManager();
        manager.gapStart = 0;
        manager.gapEnd = vector.getBufferLength();
        manager.size = 0;
        return manager;
    }

    public int getGapStart() {
        return this.gapStart;
    }

    public int getGapEnd() {
        return this.gapEnd;
    }

    @Override
    public int intAt(int index) {
        return index < this.gapStart ? index : index + (this.gapEnd - this.gapStart);
    }

    @Override
    public IntSequence subList(int fromIx, int toIx) {
        Range.IntRange range = new Range.IntRange(fromIx, 1, toIx - fromIx);
        return new Sequences.ComposedIndexes(this, range);
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void gapReserve(SimpleVector base2, int where, int needed) {
        if (needed > this.gapEnd - this.gapStart) {
            int size;
            int minLength;
            int oldLength = base2.size();
            int newLength = oldLength < 16 ? 16 : 2 * oldLength;
            if (newLength < (minLength = (size = oldLength - (this.gapEnd - this.gapStart)) + needed)) {
                newLength = minLength;
            }
            int newGapEnd = newLength - size + where;
            GapManager.resizeShift(base2, this.gapStart, this.gapEnd, where, newGapEnd);
            this.gapStart = where;
            this.gapEnd = newGapEnd;
        } else if (where != this.gapStart) {
            this.shiftGap(base2, where);
        }
    }

    protected void insertUnspecified(SimpleVector base2, int index, int count) {
        this.gapReserve(base2, index, count);
        this.gapStart += count;
        this.size += count;
    }

    protected void delete(SimpleVector base2, int start, int count) {
        this.shiftGap(base2, start);
        this.gapEnd += count;
        this.size -= count;
    }

    protected void shiftGap(SimpleVector base2, int newGapStart) {
        int delta = newGapStart - this.gapStart;
        if (delta > 0) {
            base2.shift(this.gapEnd, this.gapStart, delta);
        } else if (delta < 0) {
            base2.shift(newGapStart, this.gapEnd + delta, -delta);
        }
        this.gapEnd += delta;
        this.gapStart = newGapStart;
    }

    static void resizeShift(SimpleVector base2, int oldGapStart, int oldGapEnd, int newGapStart, int newGapEnd) {
        int gapDelta;
        base2.checkCanWrite();
        int oldGapSize = oldGapEnd - oldGapStart;
        int newGapSize = newGapEnd - newGapStart;
        int oldLength = base2.getBufferLength();
        int newLength = oldLength - oldGapSize + newGapSize;
        if (newLength > oldLength) {
            base2.setBufferLength(newLength);
        }
        if ((gapDelta = oldGapStart - newGapStart) >= 0) {
            int endLength = oldLength - oldGapEnd;
            base2.shift(oldGapEnd, newLength - endLength, endLength);
            if (gapDelta > 0) {
                base2.shift(newGapStart, newGapEnd, gapDelta);
            }
        } else {
            int endLength = newLength - newGapEnd;
            base2.shift(oldLength - endLength, newGapEnd, endLength);
            base2.shift(oldGapEnd, oldGapStart, newGapStart - oldGapStart);
        }
        base2.clearBuffer(newGapStart, newGapSize);
    }

    protected void adjustPositions(int low, int high, int delta) {
    }

    protected int getSegment(SimpleVector<?> base2, int where, int len, boolean readOnly) {
        int length = base2.size();
        if (where < 0 || where > length) {
            return -1;
        }
        if (len < 0) {
            len = 0;
        } else if (where + len > length) {
            len = length - where;
        }
        if (where + len <= this.gapStart) {
            return where;
        }
        if (where >= this.gapStart) {
            return where + (this.gapEnd - this.gapStart);
        }
        if (readOnly) {
            return -1;
        }
        if (this.gapStart - where > len >> 1) {
            this.shiftGap(base2, where + len);
            return where;
        }
        this.shiftGap(base2, where);
        return where + (this.gapEnd - this.gapStart);
    }

    protected void writeTo(AbstractCharVector base2, int start, int count, Writer dest) throws IOException {
        char[] array = base2.data;
        if (start < this.gapStart) {
            int count0 = this.gapStart - start;
            if (count0 > count) {
                count0 = count;
            }
            dest.write(array, start, count0);
            start += (count -= count0);
        }
        if (count > 0) {
            dest.write(array, start += this.gapEnd - this.gapStart, count);
        }
    }

    public String toString() {
        return "GapManager[gap:(" + this.gapStart + " " + this.gapEnd + ") size:" + this.size + "]";
    }
}

