/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.Keyword;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.ArrayPrint;
import gnu.kawa.io.CheckConsole;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.PrettyWriter;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.models.Picture;
import gnu.kawa.models.SVGUtils;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.AbstractFormat;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.GeneralArray;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PrintConsumer;
import gnu.lists.Range;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.Namespace;
import gnu.mapping.Promise;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.text.Char;
import gnu.text.Printable;
import gnu.xml.XMLPrinter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;

public class DisplayFormat
extends AbstractFormat {
    public static final ThreadLocation outBase = new ThreadLocation("out-base");
    public static final ThreadLocation outRadix;
    public static final DisplayFormat schemeDisplayFormat;
    public static final DisplayFormat schemeWriteSimpleFormat;
    public static final DisplayFormat schemeWriteFormat;
    public static final DisplayFormat schemeWriteSharedFormat;
    public int checkSharing = -1;
    boolean readable;
    char language;
    static Pattern r5rsIdentifierMinusInteriorColons;

    public DisplayFormat(boolean readable, char language) {
        this.readable = readable;
        this.language = language;
    }

    public static DisplayFormat getEmacsLispFormat(boolean readable) {
        return new DisplayFormat(readable, 'E');
    }

    public static DisplayFormat getCommonLispFormat(boolean readable) {
        return new DisplayFormat(readable, 'C');
    }

    public static DisplayFormat getSchemeFormat(boolean readable) {
        return new DisplayFormat(readable, 'S');
    }

    public boolean getReadableOutput() {
        return this.readable;
    }

    @Override
    public boolean textIsCopied() {
        return !this.readable;
    }

    @Override
    public void writeBoolean(boolean v, Consumer out) {
        this.write(this.language == 'S' ? (v ? "#t" : "#f") : (v ? "t" : "nil"), out);
    }

    @Override
    public void write(int v, Consumer out) {
        if (!this.getReadableOutput()) {
            Char.print(v, out);
        } else if (this.language == 'E' && v > 32) {
            out.write(63);
            Char.print(v, out);
        } else {
            this.write(Char.toScmReadableString(v), out);
        }
    }

    public void writeList(LList value, Consumer out) {
        PrettyWriter pout = out instanceof PrintConsumer ? ((PrintConsumer)out).getPrettyWriter() : null;
        int[] posnStack = null;
        Object[] tailStack = null;
        int stackTail = 0;
        Object list = value;
        PrintConsumer.startLogicalBlock("(", false, ")", out);
        while (list instanceof Pair) {
            Pair pair = (Pair)list;
            this.writeObject(pair.getCar(), out);
            list = pair.getCdr();
            if (!this.getReadableOutput()) {
                list = Promise.force(list);
            }
            if (list == LList.Empty) break;
            PrintConsumer.writeSpaceFill(out);
            if (!(list instanceof Pair)) {
                out.write(". ");
                this.writeObject(LList.checkNonList(list), out);
                break;
            }
            if (pout == null || this.checkSharing < 0) continue;
            int hashIndex = pout.IDHashLookup(list);
            int posn = pout.IDHashGetFromIndex(hashIndex);
            if (posn == -1) {
                posn = pout.writePositionMarker(true);
                if (posnStack == null) {
                    posnStack = new int[128];
                    tailStack = new Object[128];
                } else if (stackTail >= posnStack.length) {
                    int[] newPStack = new int[posnStack.length << 1];
                    System.arraycopy(posnStack, 0, newPStack, 0, stackTail);
                    posnStack = newPStack;
                    Object[] newTStack = new Object[posnStack.length << 1];
                    System.arraycopy(tailStack, 0, newTStack, 0, stackTail);
                    tailStack = newTStack;
                }
                posnStack[stackTail] = posn;
                tailStack[stackTail++] = list;
                pout.IDHashPutAtIndex(list, posn, hashIndex);
                continue;
            }
            out.write(". ");
            pout.writeBreak(70);
            pout.writeBackReference(posn);
            list = LList.Empty;
            break;
        }
        while (--stackTail >= 0) {
            pout.writePairEnd((int)posnStack[stackTail]);
            if (this.checkSharing != 0) continue;
            pout.IDHashRemove(tailStack[stackTail]);
        }
        PrintConsumer.endLogicalBlock(")", out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object obj, Consumer out) {
        PrettyWriter pout = out instanceof PrintConsumer ? ((PrintConsumer)out).getPrettyWriter() : null;
        boolean popIDHashNeeded = false;
        boolean space = false;
        boolean skip = false;
        if (!(!(out instanceof PrintConsumer) || obj instanceof UntypedAtomic || obj instanceof Values || !this.getReadableOutput() && (obj instanceof Char || obj instanceof Character || obj instanceof CharSequence))) {
            ((PrintConsumer)out).writeWordStart();
            space = true;
        }
        boolean removeNeeded = false;
        try {
            if (pout != null && this.checkSharing >= 0 && this.isInteresting(obj)) {
                popIDHashNeeded = pout.initialiseIDHash();
                pout.setSharing(true);
                int hashIndex = pout.IDHashLookup(obj);
                int posn = pout.IDHashGetFromIndex(hashIndex);
                if (posn == -1) {
                    int nposn = pout.writePositionMarker(false);
                    pout.IDHashPutAtIndex(obj, nposn, hashIndex);
                    removeNeeded = this.checkSharing == 0;
                    skip = false;
                } else {
                    pout.writeBackReference(posn);
                    skip = true;
                    space = true;
                }
            }
            if (!skip) {
                this.writeObjectRaw(obj, out);
            }
        }
        finally {
            if (removeNeeded) {
                pout.IDHashRemove(obj);
            }
            if (space) {
                ((PrintConsumer)out).writeWordEnd();
            }
            if (popIDHashNeeded) {
                pout.setSharing(true);
                pout.finishIDHash();
            }
        }
    }

    public void writeObjectRaw(Object obj, Consumer out) {
        if (!this.readable) {
            obj = Promise.force(obj);
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj, out);
        } else if (obj instanceof Char) {
            this.write(((Char)obj).intValue(), out);
        } else if (obj instanceof Character) {
            this.write(((Character)obj).charValue(), out);
        } else if (obj instanceof Symbol) {
            Symbol sym = (Symbol)obj;
            Namespace ns = sym.getNamespace();
            if (ns == XmlNamespace.HTML) {
                this.write("html:", out);
                this.write(sym.getLocalPart(), out);
            } else if (ns == LispLanguage.entityNamespace || ns == LispLanguage.constructNamespace) {
                this.write(ns.getPrefix(), out);
                this.write(":", out);
                this.write(sym.getLocalPart(), out);
            } else {
                this.writeSymbol(sym, out, this.readable);
            }
        } else if (obj instanceof URI && this.getReadableOutput() && out instanceof PrintWriter) {
            this.write("#,(URI ", out);
            Strings.printQuoted(obj.toString(), (PrintWriter)((Object)out), 1);
            out.write(41);
        } else if (obj instanceof CharSequence) {
            CharSequence str = (CharSequence)obj;
            if (this.getReadableOutput() && out instanceof PrintWriter) {
                Strings.printQuoted(str, (PrintWriter)((Object)out), 1);
            } else if (obj instanceof String) {
                out.write((String)obj);
            } else if (obj instanceof CharSeq) {
                CharSeq seq = (CharSeq)obj;
                seq.consume(0, seq.size(), out);
            } else {
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    out.write(str.charAt(i));
                }
            }
        } else if (obj instanceof LList) {
            this.writeList((LList)obj, out);
        } else if (obj instanceof Range && (this.getReadableOutput() || ((Range)obj).isUnspecifiedStart())) {
            Range range = (Range)obj;
            PrintConsumer.startLogicalBlock("[", false, "]", out);
            Object rstart = range.getStart();
            Object rstep = range.getStep();
            IntNum istep = IntNum.asIntNumOrNull(rstep);
            IntNum istart = IntNum.asIntNumOrNull(rstart);
            if (range.isUnspecifiedStart()) {
                if (istep.isOne()) {
                    out.write("<:");
                } else if (istep.isMinusOne()) {
                    out.write(">:");
                } else {
                    out.write("by: ");
                    this.writeObject(rstep, out);
                }
            } else {
                this.writeObject(rstart, out);
                int rsize = range.size();
                if (!range.isUnbounded() && istart != null && istep != null && (istep.isOne() || istep.isMinusOne())) {
                    if (istep.isOne()) {
                        out.write(" <: ");
                        this.writeObject((Object)IntNum.add(istart, rsize), out);
                    } else {
                        out.write(" >: ");
                        this.writeObject((Object)IntNum.add(istart, -rsize), out);
                    }
                } else {
                    out.write(" by: ");
                    this.writeObject(rstep, out);
                    if (!range.isUnbounded()) {
                        out.write(" size: ");
                        out.writeInt(rsize);
                    }
                }
            }
            PrintConsumer.endLogicalBlock("]", out);
        } else if (obj instanceof List) {
            String end;
            String start;
            String tag;
            List vec = (List)obj;
            String string = tag = vec instanceof SimpleVector ? ((SimpleVector)vec).getTag() : null;
            if (this.language == 'E') {
                start = "[";
                end = "]";
            } else if ("b".equals(tag)) {
                start = "#*";
                end = "";
            } else {
                start = tag == null ? "#(" : "#" + tag + "(";
                end = ")";
            }
            PrintConsumer.startLogicalBlock(start, false, end, out);
            if ("b".equals(tag)) {
                SimpleVector bvec = (SimpleVector)vec;
                int blen = vec.size();
                for (int i = 0; i < blen; ++i) {
                    boolean b = bvec.getBooleanRaw(bvec.effectiveIndex(i));
                    out.write(b ? 49 : 48);
                }
            } else if (vec instanceof SimpleVector && tag != null) {
                int endpos = vec.size() << 1;
                for (int ipos = 0; ipos < endpos; ipos += 2) {
                    if (ipos > 0) {
                        PrintConsumer.writeSpaceFill(out);
                    }
                    if (((SimpleVector)vec).consumeNext(ipos, out)) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean first = true;
                for (Object el : vec) {
                    if (first) {
                        first = false;
                    } else {
                        PrintConsumer.writeSpaceFill(out);
                    }
                    this.writeObject(el, out);
                }
            }
            PrintConsumer.endLogicalBlock(end, out);
        } else if (obj instanceof gnu.lists.Array) {
            if (!this.getReadableOutput() && out instanceof OutPort && ((OutPort)out).atLineStart() && ((OutPort)out).isPrettyPrinting()) {
                this.write(ArrayPrint.print(obj, null), out);
            } else {
                this.write((gnu.lists.Array)obj, 0, 0, out);
            }
        } else if (obj instanceof KNode) {
            boolean escapeForDomTerm = false;
            if (this.getReadableOutput()) {
                this.write("#", out);
            } else if (CheckConsole.forDomTerm(out)) {
                this.write("\u001b]72;", out);
                escapeForDomTerm = true;
            }
            new XMLPrinter(out).writeObject(obj);
            if (escapeForDomTerm) {
                this.write("\u0007", out);
            }
        } else if (obj instanceof Picture && !this.getReadableOutput() && CheckConsole.forDomTerm(out)) {
            this.write("\u001b]72;" + SVGUtils.toSVG((Picture)obj) + "\u0007", out);
        } else if (obj == Values.empty && this.getReadableOutput()) {
            this.write("#!void", out);
        } else if (!(!(obj instanceof Consumable) || this.readable && obj instanceof Printable)) {
            ((Consumable)obj).consume(out);
        } else if (obj instanceof Printable) {
            ((Printable)obj).print(out);
        } else if (obj instanceof RatNum || obj instanceof Number && (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof BigInteger)) {
            int b = 10;
            boolean showRadix = false;
            Object base2 = outBase.get(null);
            Object printRadix = outRadix.get(null);
            if (printRadix != null && (printRadix == Boolean.TRUE || "yes".equals(printRadix.toString()))) {
                showRadix = true;
            }
            if (base2 instanceof Number) {
                b = ((IntNum)base2).intValue();
            } else if (base2 != null) {
                b = Integer.parseInt(base2.toString());
            }
            String asString = Arithmetic.asRatNum(obj).toString(b);
            if (showRadix) {
                if (b == 16) {
                    this.write("#x", out);
                } else if (b == 8) {
                    this.write("#o", out);
                } else if (b == 2) {
                    this.write("#b", out);
                } else if (b != 10 || !(obj instanceof IntNum)) {
                    this.write("#" + base2 + "r", out);
                }
            }
            this.write(asString, out);
            if (showRadix && b == 10 && obj instanceof IntNum) {
                this.write(".", out);
            }
        } else if (obj instanceof Enum && this.getReadableOutput()) {
            this.write(obj.getClass().getName(), out);
            this.write(":", out);
            this.write(((Enum)obj).name(), out);
        } else {
            String asString;
            if (obj == null) {
                asString = null;
            } else {
                Class<?> cl = obj.getClass();
                if (cl.isArray()) {
                    int len = Array.getLength(obj);
                    PrintConsumer.startLogicalBlock("[", false, "]", out);
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            PrintConsumer.writeSpaceFill(out);
                        }
                        this.writeObject(Array.get(obj, i), out);
                    }
                    PrintConsumer.endLogicalBlock("]", out);
                    return;
                }
                asString = obj.toString();
            }
            if (asString == null) {
                this.write("#!null", out);
            } else {
                this.write(asString, out);
            }
        }
    }

    int write(gnu.lists.Array array, int index, int level, Consumer out) {
        String start;
        int rank = array.rank();
        int count = 0;
        if (level > 0) {
            start = "(";
        } else {
            boolean printDims = false;
            int i = rank;
            while (--i >= 0 && array.getLowBound(i) == 0 && array.getSize(i) != 0) {
            }
            StringBuilder sbuf = new StringBuilder();
            sbuf.append('#');
            sbuf.append(rank);
            String tag = array instanceof GeneralArray ? ((GeneralArray)array).getTag() : null;
            sbuf.append(tag == null ? Character.valueOf('a') : tag);
            if (i >= 0) {
                for (i = 0; i < rank; ++i) {
                    int low = array.getLowBound(i);
                    if (low != 0) {
                        sbuf.append('@');
                        sbuf.append(low);
                    }
                    sbuf.append(':');
                    sbuf.append(array.getSize(i));
                }
            }
            sbuf.append(rank == 0 ? (char)' ' : '(');
            start = sbuf.toString();
        }
        String end = rank == 0 ? "" : ")";
        PrintConsumer.startLogicalBlock(start, false, end, out);
        if (rank > 0) {
            int size = array.getSize(level);
            ++level;
            for (int i = 0; i < size; ++i) {
                int step;
                if (i > 0) {
                    PrintConsumer.writeSpaceFill(out);
                }
                if (level == rank) {
                    this.writeObject(array.getRowMajor(index), out);
                    step = 1;
                } else {
                    step = this.write(array, index, level, out);
                }
                index += step;
                count += step;
            }
        } else {
            this.writeObject(array.getRowMajor(index), out);
        }
        PrintConsumer.endLogicalBlock(end, out);
        return count;
    }

    void writeSymbol(Symbol sym, Consumer out, boolean readable) {
        String prefix = sym.getPrefix();
        Namespace namespace = sym.getNamespace();
        String uri = namespace == null ? null : namespace.getName();
        boolean hasUri = uri != null && uri.length() > 0;
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean suffixColon = false;
        if (namespace == Keyword.keywordNamespace) {
            if (this.language == 'C' || this.language == 'E') {
                out.write(58);
            } else {
                suffixColon = true;
            }
        } else if (hasPrefix || hasUri) {
            if (hasPrefix) {
                this.writeSymbol(prefix, out, readable);
            }
            if (hasUri && (readable || !hasPrefix)) {
                out.write(123);
                out.write(uri);
                out.write(125);
            }
            out.write(58);
        }
        this.writeSymbol(sym.getName(), out, readable);
        if (suffixColon) {
            out.write(58);
        }
    }

    void writeSymbol(String sym, Consumer out, boolean readable) {
        if (readable && !r5rsIdentifierMinusInteriorColons.matcher(sym).matches()) {
            int len = sym.length();
            boolean r7rsStyle = true;
            if (r7rsStyle) {
                out.write(124);
                for (int i = 0; i < len; ++i) {
                    char next;
                    int ch = sym.charAt(i);
                    if (ch >= 55296 && ch <= 56319 && (next = sym.charAt(++i)) >= '\udc00' && next <= '\udfff') {
                        ch = (ch - 55296 << 10) + (next - 56320) + 65536;
                    }
                    if (ch == 124 || ch == 92 || ch < 32 || ch == 127) {
                        out.write(92);
                        switch (ch) {
                            case 7: {
                                out.write(97);
                                break;
                            }
                            case 8: {
                                out.write(98);
                                break;
                            }
                            case 10: {
                                out.write(110);
                                break;
                            }
                            case 13: {
                                out.write(114);
                                break;
                            }
                            case 9: {
                                out.write(116);
                                break;
                            }
                            case 92: {
                                out.write(92);
                                break;
                            }
                            case 124: {
                                out.write(124);
                                break;
                            }
                            default: {
                                out.write(120);
                                DisplayFormat.writeHexDigits(ch, out);
                                out.write(59);
                                break;
                            }
                        }
                        continue;
                    }
                    Char.print(ch, out);
                }
                out.write(124);
            } else if (len == 0) {
                this.write("||", out);
            } else {
                boolean inVerticalBars = false;
                for (int i = 0; i < len; ++i) {
                    char ch = sym.charAt(i);
                    if (ch == '|') {
                        this.write(inVerticalBars ? "|\\" : "\\", out);
                        inVerticalBars = false;
                    } else if (!inVerticalBars) {
                        out.write(124);
                        inVerticalBars = true;
                    }
                    out.write(ch);
                }
                if (inVerticalBars) {
                    out.write(124);
                }
            }
            return;
        }
        this.write(sym, out);
    }

    static void writeHexDigits(int i, Consumer out) {
        int high = i >>> 4;
        if (high != 0) {
            DisplayFormat.writeHexDigits(high, out);
            i &= 0xF;
        }
        out.write("0123456789ABCDEF".charAt(i));
    }

    private boolean isInteresting(Object obj) {
        return obj instanceof Pair || obj instanceof SimpleVector;
    }

    static {
        outBase.setGlobal(IntNum.ten());
        outRadix = new ThreadLocation("out-radix");
        schemeDisplayFormat = new DisplayFormat(false, 'S');
        schemeWriteSimpleFormat = new DisplayFormat(true, 'S');
        schemeWriteFormat = new DisplayFormat(true, 'S');
        schemeWriteSharedFormat = new DisplayFormat(true, 'S');
        DisplayFormat.schemeWriteFormat.checkSharing = 0;
        DisplayFormat.schemeWriteSharedFormat.checkSharing = 1;
        r5rsIdentifierMinusInteriorColons = Pattern.compile("(([a-zA-Z]|[!$%&*/:<=>?^_~])([a-zA-Z]|[!$%&*/<=>?^_~]|[0-9]|([-+.@]))*[:]?)|([-+]|[.][.][.])");
    }
}

