/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.expr.TypeValue;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Namespace;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Char;
import gnu.text.SourceLocator;
import java.lang.reflect.Field;

public class Declaration
implements SourceLocator {
    static int counter;
    protected int id = ++counter;
    Object symbol;
    public ScopeExp context;
    protected Type type;
    protected Expression typeExp;
    Declaration next;
    int evalIndex;
    Variable var;
    Declaration nextCapturedVar;
    public Declaration base;
    public gnu.bytecode.Field field;
    protected Expression value = QuoteExp.undefined_exp;
    static final String UNKNOWN_PREFIX = "loc$";
    public static final String PRIVATE_PREFIX = "$Prvt$";
    static final int INDIRECT_BINDING = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int CAN_WRITE = 8;
    static final int IS_FLUID = 16;
    static final int PRIVATE = 32;
    static final int IS_SIMPLE = 64;
    static final int PROCEDURE = 128;
    public static final int IS_ALIAS = 256;
    public static final int NOT_DEFINING = 512;
    public static final int EXPORT_SPECIFIED = 1024;
    public static final int STATIC_SPECIFIED = 2048;
    public static final int NONSTATIC_SPECIFIED = 4096;
    public static final int TYPE_SPECIFIED = 8192;
    public static final int IS_CONSTANT = 16384;
    public static final int IS_SYNTAX = 32768;
    public static final int IS_UNKNOWN = 65536;
    public static final int IS_IMPORTED = 131072;
    public static final int IS_SINGLE_VALUE = 262144;
    public static final int EXTERNAL_ACCESS = 524288;
    public static final int FIELD_OR_METHOD = 0x100000;
    public static final int IS_NAMESPACE_PREFIX = 0x200000;
    public static final int PRIVATE_ACCESS = 0x1000000;
    public static final int PRIVATE_SPECIFIED = 0x1000000;
    public static final int PROTECTED_ACCESS = 0x2000000;
    public static final int PUBLIC_ACCESS = 0x4000000;
    public static final int PACKAGE_ACCESS = 0x8000000;
    public static final int IS_DYNAMIC = 0x10000000;
    public static final int EARLY_INIT = 0x20000000;
    public static final int MODULE_REFERENCE = 0x40000000;
    protected int flags = 64;
    public ApplyExp firstCall;
    Method makeLocationMethod = null;
    String filename;
    int position;

    public void setCode(int n) {
        if (n >= 0) {
            throw new Error("code must be negative");
        }
        this.id = n;
    }

    public int getCode() {
        return this.id;
    }

    public final Expression getTypeExp() {
        return this.typeExp;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
        if (this.var != null) {
            this.var.setType(type);
        }
        this.typeExp = QuoteExp.getInstance(type);
    }

    public final void setTypeExp(Expression expression) {
        Object object2;
        this.typeExp = expression;
        Type type = expression instanceof TypeValue ? ((TypeValue)((Object)expression)).getImplementationType() : (expression instanceof QuoteExp ? ((object2 = ((QuoteExp)expression).getValue()) instanceof Type ? (Type)object2 : (object2 instanceof Class ? Type.make((Class)object2) : Type.pointer_type)) : Type.pointer_type);
        this.type = type;
        if (this.var != null) {
            this.var.setType(type);
        }
    }

    public final String getName() {
        return this.symbol == null ? null : (this.symbol instanceof Symbol ? ((Symbol)this.symbol).getName() : this.symbol.toString());
    }

    public final void setName(Object object2) {
        this.symbol = object2;
    }

    public final Object getSymbol() {
        return this.symbol;
    }

    public final void setSymbol(Object object2) {
        this.symbol = object2;
    }

    public final Declaration nextDecl() {
        return this.next;
    }

    public final void setNext(Declaration declaration) {
        this.next = declaration;
    }

    public Variable getVariable() {
        return this.var;
    }

    public final boolean isSimple() {
        return (this.flags & 0x40) != 0;
    }

    public final void setSimple(boolean bl) {
        this.setFlag(bl, 64);
        if (this.var != null && !this.var.isParameter()) {
            this.var.setSimple(bl);
        }
    }

    public final void setSyntax() {
        this.setSimple(false);
        this.setFlag(49152);
    }

    public final ScopeExp getContext() {
        return this.context;
    }

    void loadOwningObject(Declaration declaration, Compilation compilation) {
        if (declaration == null) {
            declaration = this.base;
        }
        if (declaration != null) {
            declaration.load(null, 0, compilation, Target.pushObject);
        } else {
            this.getContext().currentLambda().loadHeapFrame(compilation);
        }
    }

    public void load(AccessExp accessExp, int n, Compilation compilation, Target target) {
        Object object2;
        Object object3;
        Declaration declaration;
        if (target instanceof IgnoreTarget) {
            return;
        }
        Declaration declaration2 = declaration = accessExp == null ? null : accessExp.contextDecl();
        if (this.isAlias() && this.value instanceof ReferenceExp) {
            object3 = (ReferenceExp)this.value;
            object2 = ((ReferenceExp)object3).binding;
            if (!(object2 == null || (n & 1) != 0 && !((Declaration)object2).isIndirectBinding() || declaration != null && ((Declaration)object2).needsContext())) {
                ((Declaration)object2).load((AccessExp)object3, n, compilation, target);
                return;
            }
        }
        object3 = compilation.getCode();
        object2 = this.getType();
        if ((n & 8) != 0) {
            Method method;
            ClassType classType;
            if (this.field == null) {
                throw new Error("internal error: cannot take location of " + this);
            }
            boolean bl = compilation.immediate;
            if (this.field.getStaticFlag()) {
                classType = ClassType.make("gnu.kawa.reflect.StaticFieldLocation");
                method = classType.getDeclaredMethod("make", bl ? 1 : 2);
            } else {
                classType = ClassType.make("gnu.kawa.reflect.FieldLocation");
                method = classType.getDeclaredMethod("make", bl ? 2 : 3);
                this.loadOwningObject(declaration, compilation);
            }
            if (bl) {
                compilation.compileConstant(this);
            } else {
                compilation.compileConstant(this.field.getDeclaringClass().getName());
                compilation.compileConstant(this.field.getName());
            }
            ((CodeAttr)object3).emitInvokeStatic(method);
            object2 = classType;
        } else {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (this.field != null) {
                compilation.usedClass(this.field.getDeclaringClass());
                compilation.usedClass(this.field.getType());
                if (!this.field.getStaticFlag()) {
                    this.loadOwningObject(declaration, compilation);
                    ((CodeAttr)object3).emitGetField(this.field);
                } else {
                    ((CodeAttr)object3).emitGetStatic(this.field);
                }
            } else if (this.isIndirectBinding() && compilation.immediate && this.getVariable() == null) {
                object7 = Environment.getCurrent();
                object6 = this.symbol instanceof Symbol ? (Symbol)this.symbol : ((Environment)object7).getSymbol(this.symbol.toString());
                object5 = null;
                if (this.isProcedureDecl() && compilation.getLanguage().hasSeparateFunctionNamespace()) {
                    object5 = EnvironmentKey.FUNCTION;
                }
                object4 = ((Environment)object7).getLocation((Symbol)object6, object5);
                compilation.compileConstant(object4, Target.pushValue(Compilation.typeLocation));
            } else {
                Object object8;
                if (compilation.immediate && (object8 = this.getConstantValue()) != null) {
                    compilation.compileConstant(object8, target);
                    return;
                }
                object7 = this.getVariable();
                if (this.context instanceof ClassExp && object7 == null && !this.getFlag(128) && ((ClassExp)(object6 = (ClassExp)this.context)).isMakingClassPair()) {
                    object5 = ClassExp.slotToMethodName("get", this.getName());
                    object4 = ((ClassExp)object6).type.getDeclaredMethod((String)object5, 0);
                    ((LambdaExp)object6).loadHeapFrame(compilation);
                    ((CodeAttr)object3).emitInvoke((Method)object4);
                } else {
                    if (object7 == null) {
                        object7 = this.allocateVariable((CodeAttr)object3);
                    }
                    ((CodeAttr)object3).emitLoad((Variable)object7);
                }
            }
            if (this.isIndirectBinding() && (n & 1) == 0) {
                int n2;
                if (accessExp != null && (object7 = accessExp.getFileName()) != null && (n2 = accessExp.getLineNumber()) > 0) {
                    object5 = ClassType.make("gnu.mapping.UnboundLocationException");
                    boolean bl = ((CodeAttr)object3).isInTry();
                    int n3 = accessExp.getColumnNumber();
                    Label label = new Label((CodeAttr)object3);
                    label.define((CodeAttr)object3);
                    ((CodeAttr)object3).emitInvokeVirtual(Compilation.getLocationMethod);
                    Label label2 = new Label((CodeAttr)object3);
                    label2.define((CodeAttr)object3);
                    Label label3 = new Label((CodeAttr)object3);
                    label3.setTypes((CodeAttr)object3);
                    if (bl) {
                        ((CodeAttr)object3).emitGoto(label3);
                    } else {
                        ((CodeAttr)object3).setUnreachable();
                    }
                    int n4 = 0;
                    if (!bl) {
                        n4 = ((CodeAttr)object3).beginFragment(label3);
                    }
                    ((CodeAttr)object3).addHandler(label, label2, (ClassType)object5);
                    ((CodeAttr)object3).emitDup((Type)object5);
                    ((CodeAttr)object3).emitPushString((String)object7);
                    ((CodeAttr)object3).emitPushInt(n2);
                    ((CodeAttr)object3).emitPushInt(n3);
                    ((CodeAttr)object3).emitInvokeVirtual(((ClassType)object5).getDeclaredMethod("setLine", 3));
                    ((CodeAttr)object3).emitThrow();
                    if (bl) {
                        label3.define((CodeAttr)object3);
                    } else {
                        ((CodeAttr)object3).endFragment(n4);
                    }
                } else {
                    ((CodeAttr)object3).emitInvokeVirtual(Compilation.getLocationMethod);
                }
                object2 = Type.pointer_type;
            }
        }
        target.compileFromStack(compilation, (Type)object2);
    }

    public void compileStore(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (this.isSimple()) {
            codeAttr.emitStore(this.getVariable());
        } else if (!this.field.getStaticFlag()) {
            this.loadOwningObject(null, compilation);
            codeAttr.emitSwap();
            codeAttr.emitPutField(this.field);
        } else {
            codeAttr.emitPutStatic(this.field);
        }
    }

    public final Expression getValue() {
        if (this.value == QuoteExp.undefined_exp && this.field != null && (this.field.getModifiers() & 0x18) == 24 && !this.isIndirectBinding()) {
            try {
                this.value = new QuoteExp(this.field.getReflectField().get(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.value;
    }

    public final void setValue(Expression expression) {
        this.value = expression;
    }

    public final Object getConstantValue() {
        Expression expression = this.getValue();
        if (!(expression instanceof QuoteExp) || expression == QuoteExp.undefined_exp) {
            return null;
        }
        return ((QuoteExp)expression).getValue();
    }

    public final boolean hasConstantValue() {
        Expression expression = this.getValue();
        return expression instanceof QuoteExp && expression != QuoteExp.undefined_exp;
    }

    public final boolean needsExternalAccess() {
        return (this.flags & 0x80020) == 524320 || (this.flags & 0x200020) == 0x200020;
    }

    public final boolean needsContext() {
        return this.base == null && this.field != null && !this.field.getStaticFlag();
    }

    public final boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public final void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final void setFlag(int n) {
        this.flags |= n;
    }

    public final boolean isPublic() {
        return this.context instanceof ModuleExp && (this.flags & 0x20) == 0;
    }

    public final boolean isPrivate() {
        return (this.flags & 0x20) != 0;
    }

    public final void setPrivate(boolean bl) {
        this.setFlag(bl, 32);
    }

    public short getAccessFlags(short s) {
        if (this.getFlag(0x1000000)) {
            return 2;
        }
        if (this.getFlag(0x2000000)) {
            return 4;
        }
        if (this.getFlag(0x8000000)) {
            return 0;
        }
        if (this.getFlag(0x4000000)) {
            return 1;
        }
        return s;
    }

    public final boolean isAlias() {
        return (this.flags & 0x100) != 0;
    }

    public final void setAlias(boolean bl) {
        this.setFlag(bl, 256);
    }

    public final boolean isFluid() {
        return (this.flags & 0x10) != 0;
    }

    public final void setFluid(boolean bl) {
        this.setFlag(bl, 16);
    }

    public final boolean isProcedureDecl() {
        return (this.flags & 0x80) != 0;
    }

    public final void setProcedureDecl(boolean bl) {
        this.setFlag(bl, 128);
    }

    public final boolean isNamespaceDecl() {
        return (this.flags & 0x200000) != 0;
    }

    public final boolean isIndirectBinding() {
        return (this.flags & 1) != 0;
    }

    public final void setIndirectBinding(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean bl) {
        this.setFlag(bl, 2);
    }

    public final void setCanRead() {
        this.setFlag(true, 2);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean bl) {
        this.setFlag(bl, 4);
    }

    public final void setCanCall() {
        this.setFlag(true, 4);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanWrite() {
        return (this.flags & 8) != 0;
    }

    public final void setCanWrite(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setCanWrite() {
        this.flags |= 8;
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean isThisParameter() {
        return this.symbol == ThisExp.THIS_NAME;
    }

    public boolean ignorable() {
        if (this.getCanRead() || this.isPublic()) {
            return false;
        }
        if (this.getCanWrite() && this.getFlag(65536)) {
            return false;
        }
        if (!this.getCanCall()) {
            return true;
        }
        Expression expression = this.getValue();
        if (expression == null || !(expression instanceof LambdaExp)) {
            return false;
        }
        LambdaExp lambdaExp = (LambdaExp)expression;
        return !lambdaExp.isHandlingTailCalls() || lambdaExp.getInlineOnly();
    }

    public boolean needsInit() {
        return !this.ignorable() && (this.value != QuoteExp.nullExp || this.base == null);
    }

    public boolean isStatic() {
        if (this.getFlag(2048)) {
            return true;
        }
        if (this.getFlag(4096)) {
            return false;
        }
        LambdaExp lambdaExp = this.context.currentLambda();
        return lambdaExp instanceof ModuleExp && ((ModuleExp)lambdaExp).isStatic();
    }

    public final boolean isLexical() {
        return (this.flags & 0x10010010) == 0;
    }

    public static final boolean isUnknown(Declaration declaration) {
        return declaration == null || declaration.getFlag(65536);
    }

    public void noteValue(Expression expression) {
        if (this.value == QuoteExp.undefined_exp) {
            if (expression instanceof LambdaExp) {
                ((LambdaExp)expression).nameDecl = this;
            }
            this.value = expression;
        } else if (this.value != expression) {
            if (this.value instanceof LambdaExp) {
                ((LambdaExp)this.value).nameDecl = null;
            }
            this.value = null;
        }
    }

    protected Declaration() {
    }

    public Declaration(Variable variable) {
        this((Object)variable.getName(), variable.getType());
        this.var = variable;
    }

    public Declaration(Object object2) {
        this(object2, Type.pointer_type);
    }

    public Declaration(Object object2, Type type) {
        this.setName(object2);
        this.setType(type);
    }

    public Declaration(Object object2, gnu.bytecode.Field field) {
        this(object2, field.getType());
        this.field = field;
        this.setSimple(false);
    }

    public void pushIndirectBinding(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPushString(this.getName());
        if (this.makeLocationMethod == null) {
            Type[] typeArray = new Type[]{Type.pointer_type, Type.string_type};
            this.makeLocationMethod = Compilation.typeLocation.addMethod("make", typeArray, Compilation.typeLocation, 9);
        }
        codeAttr.emitInvokeStatic(this.makeLocationMethod);
    }

    public final Variable allocateVariable(CodeAttr codeAttr) {
        if (!this.isSimple() || this.var == null) {
            String string = null;
            if (this.symbol != null) {
                string = Compilation.mangleNameIfNeeded(this.getName());
            }
            if (this.isAlias() && this.getValue() instanceof ReferenceExp) {
                Declaration declaration = Declaration.followAliases(this);
                this.var = declaration == null ? null : declaration.var;
            } else {
                ClassType classType = this.isIndirectBinding() ? Compilation.typeLocation : this.getType().getImplementationType();
                this.var = this.context.getVarScope().addVariable(codeAttr, classType, string);
            }
        }
        return this.var;
    }

    public final void setLocation(SourceLocator sourceLocator) {
        this.filename = sourceLocator.getFileName();
        this.setLine(sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
    }

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setLine(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.position = (n << 12) + n2;
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final String getFileName() {
        return this.filename;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public final int getLineNumber() {
        int n = this.position >> 12;
        return n == 0 ? -1 : n;
    }

    public final int getColumnNumber() {
        int n = this.position & 0xFFF;
        return n == 0 ? -1 : n;
    }

    public boolean isStableSourceLocation() {
        return true;
    }

    public void printInfo(OutPort outPort) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printInfo(stringBuffer);
        outPort.print(stringBuffer.toString());
    }

    public void printInfo(StringBuffer stringBuffer) {
        stringBuffer.append(this.symbol);
        stringBuffer.append('/');
        stringBuffer.append(this.id);
        stringBuffer.append("/fl:");
        stringBuffer.append(Integer.toHexString(this.flags));
        if (this.ignorable()) {
            stringBuffer.append("(ignorable)");
        }
        Expression expression = this.typeExp;
        Type type = this.getType();
        if (expression != null && !(expression instanceof QuoteExp)) {
            stringBuffer.append("::");
            stringBuffer.append(expression);
        } else if (this.type != null && type != Type.pointer_type) {
            stringBuffer.append("::");
            stringBuffer.append(type.getName());
        }
    }

    public String toString() {
        return "Declaration[" + this.symbol + '/' + this.id + ']';
    }

    public static Declaration followAliases(Declaration declaration) {
        Expression expression;
        while (declaration != null && declaration.isAlias() && (expression = declaration.getValue()) instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration2 = referenceExp.binding;
            if (declaration2 == null) break;
            declaration = declaration2;
        }
        return declaration;
    }

    public void makeField(Compilation compilation, Expression expression) {
        this.setSimple(false);
        this.makeField(compilation.mainClass, compilation, expression);
    }

    public void makeField(ClassType classType, Compilation compilation, Expression expression) {
        int n;
        String string;
        boolean bl = this.needsExternalAccess();
        int n2 = 0;
        boolean bl2 = this.getFlag(16384);
        boolean bl3 = this.getFlag(8192);
        if (this.isPublic() && !bl2 && !bl3) {
            this.setIndirectBinding(true);
        }
        if (this.isPublic() || bl || compilation.immediate) {
            n2 |= 1;
        }
        if (this.isStatic() || bl2 && expression instanceof QuoteExp || this.getFlag(0x10010010) && this.isIndirectBinding() && !this.isAlias() || expression instanceof ClassExp && !((LambdaExp)expression).getNeedsClosureEnv()) {
            n2 |= 8;
        }
        if ((this.isIndirectBinding() || bl2) && (this.context instanceof ClassExp || this.context instanceof ModuleExp)) {
            n2 |= 0x10;
        }
        Type type = this.getType().getImplementationType();
        if (this.isIndirectBinding() && !type.isSubtype(Compilation.typeLocation)) {
            type = this.getFlag(0x20000000) && this.isAlias() ? ClassType.make("gnu.kawa.reflect.FieldLocation") : Compilation.typeLocation;
        }
        if ((string = this.getName()) == null) {
            string = "$unnamed$0";
            n = string.length() - 2;
        } else {
            string = Compilation.mangleNameIfNeeded(string);
            if (this.getFlag(65536)) {
                string = UNKNOWN_PREFIX + string;
            }
            if (bl && !this.getFlag(0x40000000)) {
                string = PRIVATE_PREFIX + string;
            }
            n = string.length();
        }
        int n3 = 0;
        while (classType.getDeclaredField(string) != null) {
            string = string.substring(0, n) + '$' + ++n3;
        }
        this.field = classType.addField(string, type, n2);
        if (expression instanceof QuoteExp) {
            Object object2 = ((QuoteExp)expression).getValue();
            if (object2.getClass().getName().equals(type.getName())) {
                Literal literal = compilation.litTable.findLiteral(object2);
                if (literal.field == null) {
                    literal.assign(this.field, compilation.litTable);
                }
            } else if (type instanceof PrimType || "java.lang.String".equals(type.getName())) {
                if (object2 instanceof Char) {
                    object2 = IntNum.make(((Char)object2).intValue());
                }
                this.field.setConstantValue(object2, classType);
                return;
            }
        }
        if (!this.getFlag(0x20000000) && (this.isIndirectBinding() || expression != null && !(expression instanceof ClassExp))) {
            BindingInitializer.create(this, expression, compilation);
        }
    }

    Location makeIndirectLocationFor() {
        Symbol symbol = this.symbol instanceof Symbol ? (Symbol)this.symbol : Namespace.EmptyNamespace.getSymbol(this.symbol.toString().intern());
        return Location.make(symbol);
    }

    public static Declaration getDeclarationFromStatic(String string, String string2) {
        ClassType classType = ClassType.make(string);
        gnu.bytecode.Field field = classType.getDeclaredField(string2);
        Declaration declaration = new Declaration((Object)string2, field);
        declaration.setFlag(18432);
        return declaration;
    }

    public static Declaration getDeclarationValueFromStatic(String string, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Object object2 = field.get(null);
            Declaration declaration = new Declaration((Object)string3, ClassType.make(string).getDeclaredField(string2));
            declaration.noteValue(new QuoteExp(object2));
            declaration.setFlag(18432);
            return declaration;
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public static Declaration getDeclaration(Named named) {
        return Declaration.getDeclaration(named, named.getName());
    }

    public static Declaration getDeclaration(Object object2, String string) {
        int n;
        Object object3;
        Class clazz;
        gnu.bytecode.Field field = null;
        if (string != null && (clazz = PrimProcedure.getProcedureClass(object2)) != null) {
            object3 = (ClassType)Type.make(clazz);
            String string2 = Compilation.mangleNameIfNeeded(string);
            field = ((ClassType)object3).getDeclaredField(string2);
        }
        if (field != null && ((n = field.getModifiers()) & 8) != 0) {
            object3 = new Declaration((Object)string, field);
            ((Declaration)object3).noteValue(new QuoteExp(object2));
            if ((n & 0x10) != 0) {
                ((Declaration)object3).setFlag(16384);
            }
            return object3;
        }
        return null;
    }
}

