/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure2;
import kawa.standard.Scheme;

public class Convert
extends Procedure2
implements CanInline,
Inlineable {
    public static final Convert as = new Convert();
    static ClassType typeType;
    static Method coerceMethod;

    public static Convert getInstance() {
        return as;
    }

    public Object apply2(Object object2, Object object3) {
        Type type = (Type)object2;
        return type.coerceFromObject(object3);
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        return Invoke.inlineClassName(applyExp, 0, (InlineCalls)expWalker);
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length != 2) {
            throw new Error("wrong number of arguments to " + this.getName());
        }
        CodeAttr codeAttr = compilation.getCode();
        Type type = Scheme.getTypeValue(expressionArray[0]);
        if (type != null) {
            expressionArray[1].compile(compilation, Target.pushValue(type));
            if (codeAttr.reachableHere()) {
                target.compileFromStack(compilation, type);
            }
        } else {
            if (typeType == null) {
                typeType = ClassType.make("gnu.bytecode.Type");
                coerceMethod = typeType.addMethod("coerceFromObject", Compilation.apply1args, Type.pointer_type, 1);
            }
            expressionArray[0].compile(compilation, typeType);
            expressionArray[1].compile(compilation, Target.pushObject);
            codeAttr.emitInvokeVirtual(coerceMethod);
            target.compileFromStack(compilation, Type.pointer_type);
        }
    }

    public Type getReturnType(Expression[] expressionArray) {
        Type type;
        if (expressionArray != null && expressionArray.length == 2 && (type = Scheme.getTypeValue(expressionArray[0])) != null) {
            return type;
        }
        return Type.pointer_type;
    }

    public static Expression makeCoercion(Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression2, expression};
        QuoteExp quoteExp = new QuoteExp(Convert.getInstance());
        return new ApplyExp(quoteExp, expressionArray);
    }

    public static Expression makeCoercion(Expression expression, Type type) {
        return Convert.makeCoercion(expression, new QuoteExp(type));
    }

    public static void setCoercedReturnValue(LambdaExp lambdaExp, Expression expression, Language language) {
        Type type = language.getTypeFor(expression);
        if (type != null) {
            Expression expression2 = lambdaExp.body;
            lambdaExp.body = Convert.makeCoercion(expression2, expression);
            lambdaExp.body.setLine(expression2);
            lambdaExp.setReturnType(type);
        }
    }

    static {
        as.setName("as");
    }
}

