/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;

public class FindTailCalls
extends ExpWalker {
    boolean inTailContext = true;

    public static void findTailCalls(Expression expression, Compilation compilation) {
        FindTailCalls findTailCalls = new FindTailCalls();
        findTailCalls.setContext(compilation);
        findTailCalls.walk(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkApplyExp(ApplyExp applyExp) {
        if (this.inTailContext) {
            applyExp.setTailCall(true);
        }
        applyExp.context = this.currentLambda;
        boolean bl = this.inTailContext;
        LambdaExp lambdaExp = null;
        try {
            this.inTailContext = false;
            boolean bl2 = false;
            if (applyExp.func instanceof ReferenceExp) {
                ReferenceExp referenceExp = (ReferenceExp)applyExp.func;
                Declaration declaration = Declaration.followAliases(referenceExp.binding);
                if (declaration != null) {
                    applyExp.nextCall = declaration.firstCall;
                    declaration.firstCall = applyExp;
                    declaration.setCanCall();
                    Expression expression = declaration.getValue();
                    if (expression instanceof LambdaExp) {
                        lambdaExp = (LambdaExp)expression;
                    }
                }
            } else if (applyExp.func instanceof LambdaExp && !(applyExp.func instanceof ClassExp)) {
                lambdaExp = (LambdaExp)applyExp.func;
                this.walkLambdaExp(lambdaExp, false);
                lambdaExp.setCanCall(true);
            } else if (applyExp.func instanceof QuoteExp && ((QuoteExp)applyExp.func).getValue() == AppendValues.appendValues) {
                bl2 = true;
            } else {
                applyExp.func = applyExp.func.walk(this);
            }
            if (!(lambdaExp == null || lambdaExp.returnContinuation == applyExp || lambdaExp == this.currentLambda && bl)) {
                lambdaExp.returnContinuation = lambdaExp.returnContinuation == null ? applyExp : LambdaExp.unknownContinuation;
            }
            if (bl2 && applyExp.args.length > 0) {
                int n = applyExp.args.length - 1;
                applyExp.args = this.walkExps(applyExp.args, n);
                this.inTailContext = bl;
                applyExp.args[n] = this.walk(applyExp.args[n]);
            } else {
                applyExp.args = this.walkExps(applyExp.args);
            }
            ApplyExp applyExp2 = applyExp;
            return applyExp2;
        }
        finally {
            this.inTailContext = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkBeginExp(BeginExp beginExp) {
        boolean bl = this.inTailContext;
        try {
            int n = beginExp.length - 1;
            for (int i = 0; i <= n; ++i) {
                this.inTailContext = i == n && bl;
                beginExp.exps[i] = beginExp.exps[i].walk(this);
            }
            BeginExp beginExp2 = beginExp;
            return beginExp2;
        }
        finally {
            this.inTailContext = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        for (Declaration declaration = fluidLetExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            declaration.setCanRead(true);
            declaration.setCanWrite(true);
            if (declaration.base == null) continue;
            declaration.base.setCanRead(true);
            declaration.base.setCanWrite(true);
        }
        boolean bl = this.inTailContext;
        this.inTailContext = false;
        try {
            Expression expression = super.walkFluidLetExp(fluidLetExp);
            return expression;
        }
        finally {
            this.inTailContext = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkLetExp(LetExp letExp) {
        int n = letExp.inits.length;
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration declaration = letExp.firstDecl();
            int n2 = 0;
            while (n2 < n) {
                Expression expression;
                Expression expression2 = this.walkSetExp(declaration, letExp.inits[n2]);
                if (expression2 == QuoteExp.undefined_exp && ((expression = declaration.getValue()) instanceof LambdaExp || expression != expression2 && expression instanceof QuoteExp)) {
                    expression2 = expression;
                }
                letExp.inits[n2] = expression2;
                ++n2;
                declaration = declaration.nextDecl();
            }
        }
        finally {
            this.inTailContext = bl;
        }
        letExp.body = letExp.body.walk(this);
        this.walkDecls(letExp);
        return letExp;
    }

    public void walkDecls(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Declaration declaration2;
            Expression expression;
            Expression expression2 = declaration.getValue();
            if (expression2 instanceof LambdaExp) {
                expression = (LambdaExp)expression2;
                if (declaration.getCanRead()) {
                    ((LambdaExp)expression).setCanRead(true);
                }
                if (declaration.getCanCall()) {
                    ((LambdaExp)expression).setCanCall(true);
                }
            }
            if (!declaration.getFlag(1024) || !(expression2 instanceof ReferenceExp) || (declaration2 = ((AccessExp)(expression = (ReferenceExp)expression2)).contextDecl()) == null || !declaration2.isPrivate()) continue;
            declaration2.setFlag(524288);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkIfExp(IfExp ifExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            ifExp.test = ifExp.test.walk(this);
        }
        finally {
            this.inTailContext = bl;
        }
        ifExp.then_clause = ifExp.then_clause.walk(this);
        Expression expression = ifExp.else_clause;
        if (expression != null) {
            ifExp.else_clause = expression.walk(this);
        }
        return ifExp;
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        this.walkLambdaExp(lambdaExp, true);
        return lambdaExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void walkLambdaExp(LambdaExp lambdaExp, boolean bl) {
        boolean bl2 = this.inTailContext;
        LambdaExp lambdaExp2 = this.currentLambda;
        this.currentLambda = lambdaExp;
        if (bl) {
            lambdaExp.setCanRead(true);
        }
        try {
            this.inTailContext = false;
            if (lambdaExp.defaultArgs != null) {
                lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
            }
            boolean bl3 = this.inTailContext = lambdaExp.getInlineOnly() ? bl2 : true;
            if (this.exitValue == null && lambdaExp.body != null) {
                lambdaExp.body = lambdaExp.body.walk(this);
            }
        }
        finally {
            this.inTailContext = bl2;
            this.currentLambda = lambdaExp2;
        }
        this.walkDecls(lambdaExp);
        LambdaExp lambdaExp3 = lambdaExp.firstChild;
        while (lambdaExp3 != null) {
            if (lambdaExp3.getCanRead() || lambdaExp3.isClassMethod() || lambdaExp3.min_args != lambdaExp3.max_args) {
                lambdaExp3.flags |= 0x20;
            } else {
                ApplyExp applyExp = lambdaExp3.returnContinuation;
                if (applyExp != LambdaExp.unknownContinuation && !this.comp.usingCPStyle()) {
                    lambdaExp3.setInlineOnly(true);
                }
            }
            lambdaExp3 = lambdaExp3.nextSibling;
        }
        lambdaExp3 = lambdaExp.firstChild;
        while (lambdaExp3 != null) {
            if ((lambdaExp3.flags & 0x21) != 0) {
                // empty if block
            }
            lambdaExp3 = lambdaExp3.nextSibling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkClassExp(ClassExp classExp) {
        boolean bl = this.inTailContext;
        LambdaExp lambdaExp = this.currentLambda;
        this.currentLambda = classExp;
        classExp.setCanRead(true);
        try {
            this.inTailContext = false;
            LambdaExp lambdaExp2 = classExp.firstChild;
            while (lambdaExp2 != null && this.exitValue == null) {
                this.walkLambdaExp(lambdaExp2, false);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        finally {
            this.inTailContext = bl;
            this.currentLambda = lambdaExp;
        }
        return classExp;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration;
        Declaration declaration2 = Declaration.followAliases(referenceExp.binding);
        if (declaration2 != null) {
            declaration2.setCanRead(true);
        }
        if ((declaration = referenceExp.contextDecl()) != null) {
            declaration.setCanRead(true);
        }
        return referenceExp;
    }

    final Expression walkSetExp(Declaration declaration, Expression expression) {
        if (declaration != null && declaration.getValue() == expression && expression instanceof LambdaExp && !(expression instanceof ClassExp) && !declaration.isPublic()) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            this.walkLambdaExp(lambdaExp, false);
            return lambdaExp;
        }
        return expression.walk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSetExp(SetExp setExp) {
        boolean bl = this.inTailContext;
        try {
            Declaration declaration;
            this.inTailContext = false;
            Declaration declaration2 = setExp.binding;
            if (declaration2 != null && declaration2.isAlias()) {
                if (setExp.isDefining()) {
                    setExp.new_value = setExp.new_value.walk(this);
                    SetExp setExp2 = setExp;
                    return setExp2;
                }
                declaration2 = Declaration.followAliases(declaration2);
            }
            if (declaration2 != null) {
                declaration2.setCanWrite();
            }
            if ((declaration = setExp.contextDecl()) != null) {
                declaration.setCanRead(true);
            }
            Expression expression = this.walkSetExp(declaration2, setExp.new_value);
            if (declaration2 != null && declaration2.context instanceof LetExp && expression == declaration2.getValue() && (expression instanceof LambdaExp || expression instanceof QuoteExp)) {
                QuoteExp quoteExp = QuoteExp.voidExp;
                return quoteExp;
            }
            setExp.new_value = expression;
            SetExp setExp3 = setExp;
            return setExp3;
        }
        finally {
            this.inTailContext = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkTryExp(TryExp tryExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkTryExp(tryExp);
            return expression;
        }
        finally {
            this.inTailContext = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkSynchronizedExp(synchronizedExp);
            return expression;
        }
        finally {
            this.inTailContext = bl;
        }
    }
}

