/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    boolean simple;
    boolean explicitInit;
    ClassType instanceType;
    boolean makeClassPair;
    public Expression[] supers;
    public LambdaExp initMethod;
    public LambdaExp clinitMethod;
    boolean partsDeclared;

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setMakingClassPair(boolean bl) {
        this.makeClassPair = bl;
    }

    public boolean isMakingClassPair() {
        return this.makeClassPair;
    }

    public ClassExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        ClassType classType = this.compile(compilation);
        this.compilePushClass(compilation, target);
    }

    public void compilePushClass(Compilation compilation, Target target) {
        int n;
        ClassType classType;
        ClassType classType2 = this.type;
        CodeAttr codeAttr = compilation.getCode();
        compilation.loadClassRef(classType2.getName());
        boolean bl = this.getNeedsClosureEnv();
        if (this.isMakingClassPair() || bl) {
            compilation.loadClassRef(this.instanceType.getName());
            classType = ClassType.make("gnu.expr.PairClassType");
            n = bl ? 3 : 2;
        } else {
            classType = ClassType.make("gnu.bytecode.Type");
            n = 1;
        }
        Type[] typeArray = new Type[n];
        if (bl) {
            compilation.curLambda.loadHeapFrame(compilation);
            typeArray[--n] = Type.pointer_type;
        }
        ClassType classType3 = ClassType.make("java.lang.Class");
        while (--n >= 0) {
            typeArray[n] = classType3;
        }
        Method method = classType.addMethod("make", typeArray, classType, 9);
        codeAttr.emitInvokeStatic(method);
        target.compileFromStack(compilation, classType);
    }

    public String getJavaName() {
        String string = this.getName();
        return string == null ? "object" : Compilation.mangleNameIfNeeded(string);
    }

    protected ClassType getCompiledClassType(Compilation compilation) {
        return this.type;
    }

    void setParts(ExpWalker expWalker, Compilation compilation) {
        if (!this.partsDeclared) {
            if (this.type == null) {
                this.setTypes(compilation);
            }
            this.declareParts(compilation);
        }
        if (this.type.getName() == null) {
            int n;
            String string = this.getName();
            if (string == null) {
                string = "object";
            } else {
                n = string.length();
                if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                    string = string.substring(1, n - 1);
                }
            }
            if (!this.isSimple() || this instanceof ObjectExp) {
                string = compilation.generateClassName(string);
            } else {
                int n2;
                n = 0;
                StringBuffer stringBuffer = new StringBuffer(100);
                while ((n2 = string.indexOf(46, n)) >= 0) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n, n2)));
                    stringBuffer.append('.');
                    n = n2 + 1;
                }
                if (n == 0) {
                    int n3;
                    String string2 = compilation.mainClass == null ? null : compilation.mainClass.getName();
                    int n4 = n3 = string2 == null ? -1 : string2.lastIndexOf(46);
                    if (n3 > 0) {
                        stringBuffer.append(string2.substring(0, n3 + 1));
                    } else if (compilation.classPrefix != null) {
                        stringBuffer.append(compilation.classPrefix);
                    }
                }
                if (n < string.length()) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n)));
                }
                string = stringBuffer.toString();
            }
            this.type.setName(string);
        }
    }

    void setTypes(Compilation compilation) {
        ClassType[] classTypeArray;
        ClassType[] classTypeArray2;
        int n = this.supers == null ? 0 : this.supers.length;
        ClassType[] classTypeArray3 = new ClassType[n];
        Object object2 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            Object object3;
            block14: {
                classTypeArray2 = Language.getDefaultLanguage().getTypeFor(this.supers[i]);
                if (classTypeArray2 == null || !(classTypeArray2 instanceof ClassType)) {
                    object3 = "invalid super type";
                    if (compilation == null) {
                        throw new Error((String)object3);
                    }
                    compilation.error('e', (String)object3);
                }
                object3 = (ClassType)classTypeArray2;
                try {
                    n3 = ((ClassType)object3).getModifiers();
                }
                catch (RuntimeException runtimeException) {
                    n3 = 0;
                    if (compilation == null) break block14;
                    compilation.error('e', "unknown super-type " + ((Type)object3).getName());
                }
            }
            if ((n3 & 0x200) == 0) {
                if (n2 < i) {
                    String string = "duplicate superclass for " + this;
                    if (compilation == null) {
                        throw new Error(string);
                    }
                    compilation.error('e', string);
                }
                object2 = object3;
                continue;
            }
            classTypeArray3[n2++] = object3;
        }
        if (object2 == null) {
            if (!this.isSimple()) {
                PairClassType pairClassType = new PairClassType();
                this.type = pairClassType;
                this.setMakingClassPair(true);
                this.instanceType = new ClassType();
                this.type.setInterface(true);
                classTypeArray2 = new ClassType[]{this.type};
                this.instanceType.setSuper(Type.pointer_type);
                this.instanceType.setInterfaces(classTypeArray2);
                pairClassType.instanceType = this.instanceType;
            } else {
                this.instanceType = this.type = new ClassType();
            }
            this.type.setSuper(Type.pointer_type);
        } else {
            this.instanceType = this.type = new ClassType();
            this.type.setSuper((ClassType)object2);
        }
        this.instanceType.setModifiers(32);
        if (n2 == n) {
            classTypeArray = classTypeArray3;
        } else {
            classTypeArray = new ClassType[n2];
            System.arraycopy(classTypeArray3, 0, classTypeArray, 0, n2);
        }
        this.type.setInterfaces(classTypeArray);
    }

    public Type getType() {
        if (this.type == null) {
            this.setTypes(null);
        }
        return this.type;
    }

    public void declareParts(Compilation compilation) {
        Object object2;
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        for (object2 = this.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            Object object3;
            if (!((Declaration)object2).getCanRead()) continue;
            int n = ((Declaration)object2).getAccessFlags((short)1);
            if (((Declaration)object2).getFlag(2048)) {
                n |= 8;
            }
            if (this.isMakingClassPair()) {
                object3 = ((Declaration)object2).getType().getImplementationType();
                this.type.addMethod(ClassExp.slotToMethodName("get", ((Declaration)object2).getName()), n |= 0x400, Type.typeArray0, (Type)object3);
                Type[] typeArray = new Type[]{object3};
                this.type.addMethod(ClassExp.slotToMethodName("set", ((Declaration)object2).getName()), n, typeArray, Type.void_type);
                continue;
            }
            object3 = Compilation.mangleNameIfNeeded(((Declaration)object2).getName());
            ((Declaration)object2).field = this.instanceType.addField((String)object3, ((Declaration)object2).getType(), n);
            ((Declaration)object2).setSimple(false);
        }
        object2 = this.firstChild;
        while (object2 != null) {
            if ("*init*".equals(((Procedure)object2).getName())) {
                this.explicitInit = true;
            }
            if (object2 != this.initMethod && object2 != this.clinitMethod || !this.isMakingClassPair()) {
                ((LambdaExp)object2).addMethodFor(this.type, compilation, null);
            }
            if (this.isMakingClassPair()) {
                ((LambdaExp)object2).addMethodFor(this.instanceType, compilation, this.type);
            }
            object2 = ((LambdaExp)object2).nextSibling;
        }
        if (!this.explicitInit && this.nameDecl != null && this.nameDecl.getFlag(2048)) {
            Compilation.getConstructor(this.instanceType, this);
        }
    }

    static void getImplMethods(ClassType classType, String string, Type[] typeArray, Vector vector) {
        Type[] typeArray2;
        ClassType classType2;
        if (classType instanceof PairClassType) {
            classType2 = ((PairClassType)classType).instanceType;
        } else {
            if (!classType.isInterface()) {
                return;
            }
            typeArray2 = classType.getName() + "$class";
            classType2 = ClassType.make((String)typeArray2);
        }
        typeArray2 = new Type[typeArray.length + 1];
        typeArray2[0] = classType;
        System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
        Method method = classType2.getDeclaredMethod(string, typeArray2);
        if (method != null) {
            int n = vector.size();
            if (n == 0 || !vector.elementAt(n - 1).equals(method)) {
                vector.addElement(method);
            }
        } else {
            ClassType[] classTypeArray = classType.getInterfaces();
            for (int i = 0; i < classTypeArray.length; ++i) {
                ClassExp.getImplMethods(classTypeArray[i], string, typeArray, vector);
            }
        }
    }

    private static void usedSuperClasses(ClassType classType, Compilation compilation) {
        compilation.usedClass(classType.getSuperclass());
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                compilation.usedClass(classTypeArray[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string;
            Object object7;
            Object object8;
            String string2;
            ClassType classType2;
            compilation.curClass = classType2 = this.getCompiledClassType(compilation);
            ClassExp.usedSuperClasses(this.type, compilation);
            if (this.type != this.instanceType) {
                ClassExp.usedSuperClasses(this.instanceType, compilation);
            }
            if ((string2 = this.getFile()) != null) {
                classType2.setSourceFile(string2);
            }
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.allocFrame(compilation);
            if (this.getNeedsStaticLink()) {
                Object object9 = object8 = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
                if (object8 != null) {
                    this.closureEnvField = this.staticLinkField = this.instanceType.addField("this$0", ((Location)object8).getType());
                }
            }
            if (!this.explicitInit) {
                compilation.generateConstructor(this.instanceType, this);
            }
            Object object10 = this.firstChild;
            while (object10 != null) {
                Method method2 = compilation.method;
                object7 = compilation.curLambda;
                string = compilation.getFile();
                int n = compilation.getLine();
                int n2 = compilation.getColumn();
                compilation.setLine((Expression)object10);
                compilation.method = ((LambdaExp)object10).getMainMethod();
                object6 = ((LambdaExp)object10).nameDecl;
                if (object6 == null || !((Declaration)object6).getFlag(2048)) {
                    ((LambdaExp)object10).declareThis(compilation.curClass);
                }
                compilation.curClass = this.instanceType;
                compilation.curLambda = object10;
                compilation.method.initCode();
                ((LambdaExp)object10).allocChildClasses(compilation);
                ((LambdaExp)object10).allocParameters(compilation);
                ((LambdaExp)object10).enterFunction(compilation);
                if ("*init*".equals(((Procedure)object10).getName())) {
                    object8 = compilation.getCode();
                    Expression expression = ((LambdaExp)object10).body;
                    while (expression instanceof BeginExp) {
                        object5 = (BeginExp)expression;
                        if (((BeginExp)object5).length == 0) {
                            expression = null;
                            continue;
                        }
                        expression = ((BeginExp)object5).exps[0];
                    }
                    object5 = null;
                    if (expression instanceof ApplyExp && (object4 = ((ApplyExp)expression).func) instanceof QuoteExp && (object3 = ((QuoteExp)object4).getValue()) instanceof PrimProcedure && ((PrimProcedure)(object2 = (PrimProcedure)object3)).isSpecial() && "<init>".equals(((PrimProcedure)object2).method.getName())) {
                        object5 = ((PrimProcedure)object2).method.getDeclaringClass();
                    }
                    object2 = this.instanceType.getSuperclass();
                    if (object5 != null) {
                        expression.compileWithPosition(compilation, Target.Ignore);
                        if (object5 != this.instanceType && object5 != object2) {
                            compilation.error('e', "call to <init> for not this or super class");
                        }
                    } else if (object5 != object2) {
                        Method method3 = ((ClassType)object2).getDeclaredMethod("<init>", 0);
                        if (method3 == null) {
                            compilation.error('e', "super class does not have a default constructor");
                        } else {
                            ((CodeAttr)object8).emitPushThis();
                            ((CodeAttr)object8).emitInvokeSpecial(method3);
                        }
                    }
                    if (object5 != this.instanceType) {
                        compilation.callInitMethods(this.getCompiledClassType(compilation), new Vector(10));
                    }
                    if (object5 != null) {
                        Expression.compileButFirst(((LambdaExp)object10).body, compilation);
                    } else {
                        ((LambdaExp)object10).compileBody(compilation);
                    }
                } else {
                    ((LambdaExp)object10).compileBody(compilation);
                }
                ((LambdaExp)object10).compileEnd(compilation);
                ((LambdaExp)object10).compileChildMethods(compilation);
                compilation.method = method2;
                compilation.curClass = classType2;
                compilation.curLambda = object7;
                compilation.setLine(string, n, n2);
                object10 = ((LambdaExp)object10).nextSibling;
            }
            object10 = this.type.getMethods((Filter)AbstractMethodFilter.instance, 2);
            for (int i = 0; i < ((Method[])object10).length; ++i) {
                char c;
                object7 = object10[i];
                string = ((Method)object7).getName();
                Type[] typeArray = ((Method)object7).getParameterTypes();
                Type type = ((Method)object7).getReturnType();
                object6 = this.instanceType.getMethod(string, typeArray);
                if (object6 != null && !((Method)object6).isAbstract()) continue;
                if (string.length() > 3 && string.charAt(2) == 't' && string.charAt(1) == 'e' && ((c = string.charAt(0)) == 'g' || c == 's')) {
                    if (c == 's' && type.isVoid() && typeArray.length == 1) {
                        object5 = typeArray[0];
                    } else {
                        if (c != 'g' || typeArray.length != 0) continue;
                        object5 = type;
                    }
                    object3 = Character.toLowerCase(string.charAt(3)) + string.substring(4);
                    object4 = this.instanceType.getField((String)object3);
                    if (object4 == null) {
                        object4 = this.instanceType.addField((String)object3, (Type)object5, 1);
                    }
                    object2 = this.instanceType.addMethod(string, 1, typeArray, type);
                    object8 = ((Method)object2).startCode();
                    ((CodeAttr)object8).emitPushThis();
                    if (c == 'g') {
                        ((CodeAttr)object8).emitGetField((Field)object4);
                    } else {
                        ((CodeAttr)object8).emitLoad(((CodeAttr)object8).getArg(1));
                        ((CodeAttr)object8).emitPutField((Field)object4);
                    }
                    ((CodeAttr)object8).emitReturn();
                    continue;
                }
                object5 = new Vector();
                ClassExp.getImplMethods(this.type, string, typeArray, object5);
                if (((Vector)object5).size() != 1) {
                    object3 = ((Vector)object5).size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                    compilation.error('e', (String)object3 + object7 + " mname:" + string);
                    continue;
                }
                object3 = this.instanceType.addMethod(string, 1, typeArray, type);
                object8 = ((Method)object3).startCode();
                for (object4 = ((CodeAttr)object8).getCurrentScope().firstVar(); object4 != null; object4 = ((Variable)object4).nextVar()) {
                    ((CodeAttr)object8).emitLoad((Variable)object4);
                }
                object4 = (Method)((Vector)object5).elementAt(0);
                ((CodeAttr)object8).emitInvokeStatic((Method)object4);
                ((CodeAttr)object8).emitReturn();
            }
            compilation.curLambda = lambdaExp;
            ClassType classType3 = classType2;
            return classType3;
        }
        finally {
            compilation.curClass = classType;
            compilation.method = method;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walk(ExpWalker expWalker) {
        Compilation compilation = expWalker.getCompilation();
        if (compilation == null) {
            return expWalker.walkClassExp(this);
        }
        ClassType classType = compilation.curClass;
        try {
            this.setParts(expWalker, compilation);
            compilation.curClass = this.type;
            Expression expression = expWalker.walkClassExp(this);
            return expression;
        }
        finally {
            compilation.curClass = classType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkChildren(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            LambdaExp lambdaExp2 = this.firstChild;
            while (lambdaExp2 != null && expWalker.exitValue == null) {
                Declaration declaration;
                if (this.instanceType != null && (declaration = lambdaExp2.firstDecl()) != null && declaration.isThisParameter()) {
                    declaration.setType(this.type);
                }
                expWalker.walkLambdaExp(lambdaExp2);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        finally {
            expWalker.currentLambda = lambdaExp;
        }
    }

    public void print(OutPort outPort) {
        Object object2;
        outPort.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        Object object3 = this.getSymbol();
        if (object3 != null) {
            outPort.print(object3);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print("/ (");
        Object var3_3 = null;
        int n = 0;
        boolean bl = false;
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        int n3 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        for (object2 = this.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            if (n > 0) {
                outPort.print(' ');
            }
            outPort.print(object2);
            ++n;
        }
        outPort.print(") ");
        object2 = this.firstChild;
        while (object2 != null) {
            outPort.writeBreakLinear();
            ((LambdaExp)object2).print(outPort);
            object2 = ((LambdaExp)object2).nextSibling;
        }
        if (this.body != null) {
            outPort.writeBreakLinear();
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Field compileSetField(Compilation compilation) {
        return new ClassInitializer((ClassExp)this, (Compilation)compilation).field;
    }

    public static String slotToMethodName(String string, String string2) {
        if (!Compilation.isValidJavaName(string2)) {
            string2 = Compilation.mangleName(string2, false);
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 3);
        stringBuffer.append(string);
        stringBuffer.append(Character.toTitleCase(string2.charAt(0)));
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    private static class AbstractMethodFilter
    implements Filter {
        public static final AbstractMethodFilter instance = new AbstractMethodFilter();

        private AbstractMethodFilter() {
        }

        public boolean select(Object object2) {
            Method method = (Method)object2;
            return method.isAbstract();
        }
    }
}

