/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DQuantity
extends Quantity
implements Externalizable {
    double factor;
    Unit unt;

    public final Unit unit() {
        return this.unt;
    }

    public final Complex number() {
        return new DFloNum(this.factor);
    }

    public final RealNum re() {
        return new DFloNum(this.factor);
    }

    public final double doubleValue() {
        return this.factor * this.unt.factor;
    }

    public DQuantity(double d, Unit unit) {
        this.factor = d;
        this.unt = unit;
    }

    public boolean isExact() {
        return false;
    }

    public boolean isZero() {
        return this.factor == 0.0;
    }

    public static DQuantity add(DQuantity dQuantity, DQuantity dQuantity2, double d) {
        if (dQuantity.dimensions() != dQuantity2.dimensions()) {
            throw new ArithmeticException("units mis-match");
        }
        double d2 = dQuantity2.unit().factor / dQuantity.unit().factor;
        return new DQuantity(dQuantity.factor + d * d2 * dQuantity2.factor, dQuantity.unit());
    }

    public static DQuantity mul(DQuantity dQuantity, DQuantity dQuantity2) {
        double d = dQuantity.factor * dQuantity2.factor;
        Unit unit = Unit.mul(dQuantity.unit(), dQuantity2.unit());
        return new DQuantity(d, unit);
    }

    public static DQuantity div(DQuantity dQuantity, DQuantity dQuantity2) {
        double d = dQuantity.factor / dQuantity2.factor;
        Unit unit = Unit.div(dQuantity.unit(), dQuantity2.unit());
        return new DQuantity(d, unit);
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof DQuantity) {
            return DQuantity.add(this, (DQuantity)object2, (double)n);
        }
        if (this.dimensions() == Dimensions.Empty && object2 instanceof RealNum) {
            return new DQuantity(this.factor + (double)n * ((RealNum)object2).doubleValue(), this.unit());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (this.dimensions() == Dimensions.Empty && numeric instanceof RealNum) {
            return new DFloNum(((RealNum)numeric).doubleValue() + (double)n * this.factor);
        }
        throw new IllegalArgumentException();
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof DQuantity) {
            return DQuantity.mul(this, (DQuantity)object2);
        }
        if (object2 instanceof RealNum) {
            return new DQuantity(this.factor * ((RealNum)object2).doubleValue(), this.unit());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (numeric instanceof RealNum) {
            return new DQuantity(((RealNum)numeric).doubleValue() * this.factor, this.unit());
        }
        throw new IllegalArgumentException();
    }

    public Numeric div(Object object2) {
        if (object2 instanceof DQuantity) {
            DQuantity dQuantity = (DQuantity)object2;
            if (this.dimensions() == dQuantity.dimensions()) {
                return new DFloNum(this.factor * this.unit().doubleValue() / (dQuantity.factor * dQuantity.unit().factor));
            }
            return DQuantity.div(this, dQuantity);
        }
        if (object2 instanceof RealNum) {
            return new DQuantity(this.factor / ((RealNum)object2).doubleValue(), this.unit());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).divReversed(this);
    }

    public Numeric divReversed(Numeric numeric) {
        if (numeric instanceof RealNum) {
            return new DQuantity(((RealNum)numeric).doubleValue() / this.factor, Unit.div(Unit.Empty, this.unit()));
        }
        throw new IllegalArgumentException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.factor);
        objectOutput.writeObject(this.unt);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.factor = objectInput.readDouble();
        this.unt = (Unit)objectInput.readObject();
    }
}

