/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ResolveNames;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.functions.CountValues;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.xml.Document;
import gnu.kawa.xml.MakeUnescapedData;
import gnu.kawa.xml.SortNodes;
import gnu.kawa.xml.WriteTo;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.SymbolEnumeration;
import gnu.mapping.Values;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.XMLPrinter;
import gnu.xquery.lang.Prompter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.util.Average;
import gnu.xquery.util.BooleanValue;
import gnu.xquery.util.IndexOf;
import gnu.xquery.util.IsEmptySequence;
import gnu.xquery.util.ItemAt;
import gnu.xquery.util.LastIndexOf;
import gnu.xquery.util.MinMax;
import gnu.xquery.util.NumberValue;
import gnu.xquery.util.Reduce;
import gnu.xquery.util.StringValue;
import gnu.xquery.util.SubList;
import gnu.xquery.util.XMLFormat;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import kawa.standard.Scheme;

public class XQuery
extends Interpreter {
    public static final String XQUERY_FUNCTION_NAMESPACE = "http://www.w3.org/2003/05/xpath-functions";
    public static final String KAWA_FUNCTION_NAMESPACE = "http://kawa.gnu.org/";
    static boolean charIsInt = false;
    public static final int PARSE_WITH_FOCUS = 65536;
    static XQuery instance;
    static int envCounter;
    public static Environment extensionsEnvEnv;
    public static final XMLFormat writeFormat;
    LangPrimType booleanType;
    static Object[] typeMap;

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public boolean isTrue(Object object2) {
        return BooleanValue.booleanValue(object2);
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        XQParser xQParser = new XQParser(inPort, sourceMessages);
        xQParser.interpreter = this;
        return xQParser;
    }

    public Compilation parse(Lexer lexer, int n) throws IOException, SyntaxException {
        Compilation.defaultCallConvention = 2;
        Compilation compilation = new Compilation(this, lexer.getMessages());
        compilation.immediate = (n & 1) != 0;
        compilation.mustCompileHere();
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(lexer.getName());
        compilation.push(moduleExp);
        if ((n & 2) != 0) {
            Expression expression = ((XQParser)lexer).parse(compilation);
            if (expression == null) {
                return null;
            }
            moduleExp.body = expression;
        } else if ((n & 0x10000) != 0) {
            LambdaExp lambdaExp = new LambdaExp(3);
            Declaration declaration = lambdaExp.addDeclaration("$dot$");
            declaration.setFlag(262144);
            declaration.noteValue(null);
            lambdaExp.addDeclaration("$position$", Type.int_type);
            lambdaExp.addDeclaration("$last$", Type.int_type);
            compilation.push(lambdaExp);
            lambdaExp.body = ((XQParser)lexer).parse(compilation);
            compilation.pop(lambdaExp);
            moduleExp.body = lambdaExp;
        } else {
            Expression expression;
            Vector<Expression> vector = new Vector<Expression>(10);
            while ((expression = ((XQParser)lexer).parse(compilation)) != null) {
                vector.addElement(expression);
            }
            int n2 = vector.size();
            if (n2 == 0) {
                moduleExp.body = QuoteExp.voidExp;
            } else if (n2 == 1) {
                moduleExp.body = (Expression)vector.elementAt(0);
            } else {
                Object[] objectArray = new Expression[n2];
                vector.copyInto(objectArray);
                moduleExp.body = new BeginExp((Expression[])objectArray);
            }
        }
        compilation.pop(moduleExp);
        ResolveNames.resolveNames(moduleExp, compilation.lexical);
        return compilation;
    }

    public int getNamespaceOf(Declaration declaration) {
        return declaration.isProcedureDecl() ? 2 : 1;
    }

    public void define(String string, Object object2) {
        if (object2 instanceof Procedure) {
            Environment.defineFunction(this.environ, string, object2);
        } else {
            this.environ.define(string, object2);
        }
    }

    protected void define_method(String string, String string2, String string3) {
        Environment.defineFunction(this.environ, string, ClassMethods.apply(string2, string3));
    }

    public String getName() {
        return "XQuery";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        callContext.setArgs(object2, IntNum.make(n), IntNum.make(n2));
        callContext.proc = procedure;
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            callContext.runUntilDone();
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2, int n, int n2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n3 = callContext.startFromContext();
        try {
            callContext.setArgs(object2, IntNum.make(n), IntNum.make(n2));
            callContext.proc = procedure;
            return callContext.getFromContext(n3);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            this.applyWithFocus$X(procedure, object2, callContext);
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            this.applyWithFocus$X(procedure, object2, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void applyWithFocus$X(Procedure procedure, Object object2, CallContext callContext) throws Throwable {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.size();
            if (n == 0) {
                return;
            }
            int n2 = 0;
            IntNum intNum = IntNum.make(n);
            int n3 = 1;
            while (true) {
                callContext.setArgs(values.getPosNext(n2), IntNum.make(n3), intNum);
                callContext.proc = procedure;
                callContext.runUntilDone();
                if (n3 != n) {
                    n2 = values.nextPos(n2);
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            IntNum intNum = IntNum.one();
            callContext.setArgs(object2, intNum, intNum);
            callContext.proc = procedure;
            callContext.runUntilDone();
        }
    }

    public Procedure evalToFocusProc(String string) throws Throwable {
        SourceMessages sourceMessages = new SourceMessages();
        Procedure procedure = this.evalToFocusProc(new CharArrayInPort(string), sourceMessages);
        if (sourceMessages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
        }
        return procedure;
    }

    public Procedure evalToFocusProc(Reader reader, SourceMessages sourceMessages) throws Throwable {
        InPort inPort = reader instanceof InPort ? (InPort)reader : new InPort(reader);
        Compilation compilation = this.parse(inPort, sourceMessages, 65536);
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            ModuleExp.evalModule(this.environ, callContext, compilation);
            return (Procedure)callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, consumer);
    }

    public Object evalWithFocus(String string, Object object2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2);
    }

    public Object evalWithFocus(String string, Object object2, int n, int n2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2, n, n2);
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, n, n2, consumer);
    }

    public void eval_with_focus$X(String string, Object object2, CallContext callContext) throws Throwable {
        this.applyWithFocus$X(this.evalToFocusProc(string), object2, callContext);
    }

    public void eval_with_focus$X(String string, Object object2, int n, int n2, CallContext callContext) throws Throwable {
        Procedure procedure = this.evalToFocusProc(string);
        callContext.setArgs(object2, IntNum.make(n), IntNum.make(n2));
        callContext.proc = procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQuery() {
        Environment environment = Scheme.builtin();
        this.environ = Environment.getInstance(XQUERY_FUNCTION_NAMESPACE);
        this.environ.setPrevious(extensionsEnvEnv);
        ModuleBody.setMainPrintValues(true);
        if (instance == null) {
            instance = this;
        }
        Environment environment2 = Environment.getCurrent();
        try {
            Environment.setCurrent(environment);
            SymbolEnumeration symbolEnumeration = environment.enumerateAllSymbols();
            while (symbolEnumeration.hasMoreElements()) {
                Symbol symbol = symbolEnumeration.nextSymbol();
                Object object2 = symbol.get(null);
                if (!(object2 instanceof Procedure)) continue;
                extensionsEnvEnv.getSymbol(symbol.getName()).setFunctionValue(object2);
            }
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.kawa.slib.HTTP");
            this.loadClass("gnu.kawa.slib.XStrings");
        }
        catch (Throwable throwable) {
        }
        finally {
            Environment.setCurrent(environment2);
        }
        this.define("document", Document.document);
        this.define("doc", Document.document);
        this.define("unescaped-data", MakeUnescapedData.unescapedData);
        this.define("item-at", ItemAt.itemAt);
        this.define("count", CountValues.countValues);
        this.define("min", MinMax.min);
        this.define("max", MinMax.max);
        this.define("sum", Reduce.sum);
        this.define("avg", Average.avg);
        this.define("index-of", IndexOf.indexOf);
        this.define("last-index-of", LastIndexOf.lastIndexOf);
        this.define("sublist", SubList.subList);
        this.define("empty", IsEmptySequence.isEmptySequence);
        this.define("false", new ConstantFunction0("false", Boolean.FALSE));
        this.define("true", new ConstantFunction0("true", Boolean.TRUE));
        this.define("number", NumberValue.numberValue);
        this.define("string-value", StringValue.stringValue);
        this.define("string", StringValue.string);
        this.define_method("trace", "gnu.xquery.util.Debug", "trace");
        this.define("write-to", WriteTo.writeTo);
        this.define_field("iterator-items", "gnu.kawa.xml.IteratorItems", "iteratorItems");
        this.define_field("list-items", "gnu.kawa.xml.ListItems", "listItems");
        this.define_field("base-uri", "gnu.kawa.functions.BaseUri", "baseUri");
        this.define_method("node-name", "gnu.kawa.xml.NodeName", "nodeName");
        this.define_method("root", "gnu.kawa.xml.Nodes", "root");
        this.define_method("lower-case", "gnu.xquery.util.StringValue", "lowerCase");
        this.define_method("upper-case", "gnu.xquery.util.StringValue", "upperCase");
        this.define_method("substring", "gnu.xquery.util.StringValue", "substring");
        this.define_method("string-length", "gnu.xquery.util.StringValue", "stringLength");
        this.define_method("substring-before", "gnu.xquery.util.StringValue", "substringBefore");
        this.define_method("substring-after", "gnu.xquery.util.StringValue", "substringAfter");
        this.define_method("translate", "gnu.xquery.util.StringValue", "translate");
        this.define_method("string-pad", "gnu.xquery.util.StringValue", "stringPad");
        this.define_method("contains", "gnu.xquery.util.StringValue", "contains");
        this.define_method("starts-with", "gnu.xquery.util.StringValue", "startsWith");
        this.define_method("ends-with", "gnu.xquery.util.StringValue", "endsWith");
        this.define_method("string-join", "gnu.xquery.util.StringValue", "stringJoin");
        this.define_method("concat", "gnu.xquery.util.StringValue", "concat");
        this.define("distinct-nodes", SortNodes.sortNodes);
    }

    public static XQuery getInstance() {
        if (instance == null) {
            instance = new XQuery();
        }
        return instance;
    }

    public static void registerEnvironment() {
        XQuery xQuery = new XQuery();
        Interpreter.defaultInterpreter = xQuery;
        Environment.setCurrent(xQuery.getEnvironment());
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return XQParser.readObject(inPort);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return writeFormat;
    }

    public Consumer getOutputConsumer(Writer writer) {
        return new XMLPrinter(writer, false);
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        String string2 = string.startsWith("xs:") ? string.substring(3) : string;
        int n = typeMap.length;
        while ((n -= 2) >= 0) {
            if (!typeMap[n].equals(string2)) continue;
            Object object2 = typeMap[n + 1];
            if (object2 instanceof String) {
                return Scheme.string2Type((String)object2);
            }
            return (Type)object2;
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static {
        envCounter = 0;
        extensionsEnvEnv = Environment.getInstance(KAWA_FUNCTION_NAMESPACE);
        writeFormat = new XMLFormat();
        typeMap = new Object[]{"string", Type.string_type, "boolean", Type.boolean_type, "integer", "gnu.math.IntNum", "positiveInteger", "gnu.math.IntNum", "nonPositiveInteger", "gnu.math.IntNum", "negativeInteger", "gnu.math.IntNum", "nonNegativeInteger", "gnu.math.IntNum", "decimal", "gnu.math.RealNum"};
    }
}

