/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Sequence;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SeqPosition
implements ListIterator,
Enumeration {
    public AbstractSequence sequence;
    public int ipos;

    public SeqPosition() {
    }

    public SeqPosition(AbstractSequence abstractSequence) {
        this.sequence = abstractSequence;
    }

    public SeqPosition(AbstractSequence abstractSequence, int n, boolean bl) {
        this.sequence = abstractSequence;
        this.ipos = abstractSequence.createPos(n, bl);
    }

    public SeqPosition(AbstractSequence abstractSequence, int n) {
        this.sequence = abstractSequence;
        this.ipos = n;
    }

    public static SeqPosition make(AbstractSequence abstractSequence, int n) {
        return new SeqPosition(abstractSequence, abstractSequence.copyPos(n));
    }

    public SeqPosition copy() {
        return new SeqPosition(this.sequence, this.sequence.copyPos(this.getPos()));
    }

    public final void gotoStart(AbstractSequence abstractSequence) {
        this.setPos(abstractSequence, abstractSequence.startPos());
    }

    public final void gotoEnd(AbstractSequence abstractSequence) {
        this.setPos(abstractSequence, abstractSequence.endPos());
    }

    public boolean gotoChildrenStart() {
        int n = this.sequence.firstChildPos(this.getPos());
        if (n == 0) {
            return false;
        }
        this.ipos = n;
        return true;
    }

    public final boolean hasMoreElements() {
        return this.hasNext();
    }

    public boolean hasNext() {
        return this.sequence.hasNext(this.getPos());
    }

    public int getNextKind() {
        return this.sequence.getNextKind(this.getPos());
    }

    public String getNextTypeName() {
        return this.sequence.getNextTypeName(this.getPos());
    }

    public Object getNextTypeObject() {
        return this.sequence.getNextTypeObject(this.getPos());
    }

    public boolean hasPrevious() {
        return this.sequence.hasPrevious(this.getPos());
    }

    public Object next() {
        Object object2 = this.getNext();
        if (object2 == Sequence.eofValue || !this.gotoNext()) {
            throw new NoSuchElementException();
        }
        return object2;
    }

    public boolean gotoNext() {
        int n = this.sequence.nextPos(this.ipos);
        if (n != 0) {
            this.ipos = n;
            return true;
        }
        this.ipos = -1;
        return false;
    }

    public boolean gotoPrevious() {
        int n = this.sequence.previousPos(this.ipos);
        if (n != -1) {
            this.ipos = n;
            return true;
        }
        this.ipos = 0;
        return false;
    }

    public Object previous() {
        Object object2 = this.sequence.getPosPrevious(this.getPos());
        if (object2 == Sequence.eofValue || !this.gotoPrevious()) {
            throw new NoSuchElementException();
        }
        return object2;
    }

    public final Object nextElement() throws NoSuchElementException {
        return this.next();
    }

    public Object getNext() {
        return this.sequence.getPosNext(this.getPos());
    }

    public Object getPrevious() {
        return this.sequence.getPosPrevious(this.getPos());
    }

    public int nextIndex() {
        return this.sequence.nextIndex(this.getPos());
    }

    public final int fromEndIndex() {
        return this.sequence.fromEndIndex(this.getPos());
    }

    public int getContainingSequenceSize() {
        return this.sequence.getContainingSequenceSize(this.getPos());
    }

    public final int previousIndex() {
        return this.sequence.nextIndex(this.getPos()) - 1;
    }

    public boolean isAfter() {
        return this.sequence.isAfterPos(this.getPos());
    }

    public final void set(Object object2) {
        if (this.isAfter()) {
            this.setPrevious(object2);
        } else {
            this.setNext(object2);
        }
    }

    public void setNext(Object object2) {
        this.sequence.setPosNext(this.getPos(), object2);
    }

    public void setPrevious(Object object2) {
        this.sequence.setPosPrevious(this.getPos(), object2);
    }

    public void remove() {
        this.sequence.removePos(this.getPos(), this.isAfter() ? -1 : 1);
    }

    public void add(Object object2) {
        this.setPos(this.sequence.addPos(this.getPos(), object2));
    }

    public int getPos() {
        return this.ipos;
    }

    public void setPos(AbstractSequence abstractSequence, int n) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
        }
        this.ipos = n;
        this.sequence = abstractSequence;
    }

    public void setPos(int n) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
        }
        this.ipos = n;
    }

    public void set(AbstractSequence abstractSequence, int n, boolean bl) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.ipos);
        }
        this.sequence = abstractSequence;
        this.ipos = abstractSequence.createPos(n, bl);
    }

    public void set(SeqPosition seqPosition) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.ipos);
        }
        this.sequence = seqPosition.sequence;
        seqPosition.ipos = this.sequence.copyPos(seqPosition.ipos);
    }

    public void release() {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
            this.sequence = null;
        }
    }

    public void finalize() {
        this.release();
    }

    public String toString() {
        if (this.sequence == null) {
            return this.toInfo();
        }
        Object object2 = this.sequence.getPosNext(this.ipos);
        if (object2 == null) {
            return this.toInfo();
        }
        return object2.toString();
    }

    public String toInfo() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('{');
        if (this.sequence == null) {
            stringBuffer.append("null sequence");
        } else {
            stringBuffer.append(this.sequence.getClass().getName());
            stringBuffer.append('@');
            stringBuffer.append(System.identityHashCode(this.sequence));
        }
        stringBuffer.append(" ipos: ");
        stringBuffer.append(this.ipos);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

