/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.kawa.functions.AddOp;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;

public class DivideOp
extends ProcedureN
implements CanInline {
    public static final DivideOp $Sl = new DivideOp("/");
    static ClassType typeRatNum = ClassType.make("gnu.math.RatNum");

    public DivideOp(String string) {
        super(string);
    }

    public Object applyN(Object[] objectArray) {
        int n;
        Numeric numeric = objectArray.length == 1 ? IntNum.one() : (Numeric)objectArray[n++];
        for (n = 0; n < objectArray.length; ++n) {
            numeric = numeric.div(objectArray[n]);
        }
        return numeric;
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        Expression expression = applyExp.inlineIfConstant(this, expWalker);
        if (expression != applyExp) {
            return expression;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > 2) {
            return AddOp.pairwise(this, applyExp.getFunction(), expressionArray, expWalker);
        }
        if (expressionArray.length == 2) {
            Expression expression2;
            Type type = expressionArray[0].getType();
            Type type2 = expressionArray[1].getType();
            int n = AddOp.classify(type);
            int n2 = AddOp.classify(type2);
            if ((n == 4 || type.isSubtype(typeRatNum)) && (n2 == 4 || type2.isSubtype(typeRatNum))) {
                return new ApplyExp(typeRatNum.getDeclaredMethod("divide", 2), expressionArray);
            }
            if (n >= 3 && n2 >= 3 && (expression2 = AddOp.primInline(108, applyExp)) != applyExp) {
                return expression2;
            }
            if (n >= 2 && n2 >= 2) {
                return new ApplyExp(AddOp.typeRealNum.getDeclaredMethod("divide", 2), expressionArray);
            }
        }
        return applyExp;
    }
}

