/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import java.util.Vector;

public class BeginExp
extends Expression {
    Expression[] exps;
    int length;
    Vector compileOptions;

    public BeginExp() {
    }

    public BeginExp(Expression[] expressionArray) {
        this.exps = expressionArray;
        this.length = expressionArray.length;
    }

    public BeginExp(Expression expression, Expression expression2) {
        this.exps = new Expression[2];
        this.exps[0] = expression;
        this.exps[1] = expression2;
        this.length = 2;
    }

    public static final Expression canonicalize(Expression expression) {
        if (expression instanceof BeginExp) {
            BeginExp beginExp = (BeginExp)expression;
            if (beginExp.compileOptions != null) {
                return expression;
            }
            int n = beginExp.length;
            if (n == 0) {
                return QuoteExp.voidExp;
            }
            if (n == 1) {
                return BeginExp.canonicalize(beginExp.exps[0]);
            }
        }
        return expression;
    }

    public static final Expression canonicalize(Expression[] expressionArray) {
        int n = expressionArray.length;
        if (n == 0) {
            return QuoteExp.voidExp;
        }
        if (n == 1) {
            return BeginExp.canonicalize(expressionArray[0]);
        }
        return new BeginExp(expressionArray);
    }

    public final void add(Expression expression) {
        if (this.exps == null) {
            this.exps = new Expression[8];
        }
        if (this.length == this.exps.length) {
            Expression[] expressionArray = new Expression[2 * this.length];
            System.arraycopy(this.exps, 0, expressionArray, 0, this.length);
            this.exps = expressionArray;
        }
        this.exps[this.length++] = expression;
    }

    public final Expression[] getExpressions() {
        return this.exps;
    }

    public final void setExpressions(Expression[] expressionArray) {
        this.exps = expressionArray;
        this.length = expressionArray.length;
    }

    public void setCompileOptions(Vector vector) {
        this.compileOptions = vector;
    }

    public Object eval(Environment environment) throws Throwable {
        int n;
        int n2 = this.length;
        for (n = 0; n < n2 - 1; ++n) {
            this.exps[n].eval(environment);
        }
        return this.exps[n].eval(environment);
    }

    public void pushOptions(Compilation compilation) {
        if (this.compileOptions != null && compilation != null) {
            compilation.currentOptions.pushOptionValues(this.compileOptions);
        }
    }

    public void popOptions(Compilation compilation) {
        if (this.compileOptions != null && compilation != null) {
            compilation.currentOptions.popOptionValues(this.compileOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Compilation compilation, Target target) {
        this.pushOptions(compilation);
        try {
            int n;
            int n2 = this.length;
            for (n = 0; n < n2 - 1; ++n) {
                this.exps[n].compileWithPosition(compilation, Target.Ignore);
            }
            this.exps[n].compileWithPosition(compilation, target);
        }
        finally {
            this.popOptions(compilation);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkBeginExp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkChildren(ExpWalker expWalker) {
        this.pushOptions(expWalker.comp);
        try {
            this.exps = expWalker.walkExps(this.exps, this.length);
        }
        finally {
            this.popOptions(expWalker.comp);
        }
    }

    public void print(OutPort outPort) {
        int n;
        int n2;
        outPort.startLogicalBlock("(Begin", ")", 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        if (this.compileOptions != null) {
            outPort.writeSpaceFill();
            outPort.startLogicalBlock("(CompileOptions", ")", 2);
            n2 = this.compileOptions.size();
            for (n = 0; n < n2; n += 3) {
                Object e = this.compileOptions.elementAt(n);
                Object e2 = this.compileOptions.elementAt(n + 2);
                outPort.writeSpaceFill();
                outPort.startLogicalBlock("", "", 2);
                outPort.print(e);
                outPort.print(':');
                outPort.writeSpaceLinear();
                outPort.print(e2);
                outPort.endLogicalBlock("");
            }
            outPort.endLogicalBlock(")");
        }
        n2 = this.length;
        for (n = 0; n < n2; ++n) {
            outPort.writeSpaceLinear();
            this.exps[n].print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Type getType() {
        return this.exps[this.length - 1].getType();
    }
}

