/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: CompilationException.java,v 1.4 2000/08/28 20:05:53 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998,1999 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */
package gnu.jel;
import gnu.jel.generated.ParseException;
import gnu.jel.generated.TokenMgrError;
import gnu.jel.generated.Token;
import gnu.jel.debug.Debug;
import java.util.ResourceBundle;
import java.util.PropertyResourceBundle;
import java.text.MessageFormat;

public class CompilationException extends Exception {
  
  int col;
  private int code=-1; // error code
  private Object[] params=null; // parameters to generate messages
  private final static ResourceBundle msgs;
  
  static {
    ResourceBundle resB=null;
    try {
      Class c=Class.forName("gnu.jel.CompilationException");
      resB=
        new PropertyResourceBundle(c.getResourceAsStream("JEL.properties"));
    } catch (Exception exc) {
      if (Debug.enabled)
        Debug.reportThrowable(exc);
    };
    msgs=resB;
  };

  public CompilationException(int col,String message) {
    super(message);
    this.col=col;
  };

  public CompilationException(Token tok,String message) {
    super(message);
    col=tok.beginColumn;
  };
  
//    public CompilationException(ParseException pe) {
//      if (pe.currentToken.next.kind!=0) {
//        code=2;
//        params=new Object[1];
//        params[0]=pe.currentToken.next;
//      } else code=1;
//      col=pe.currentToken.next.beginColumn;
//    };

  

//    public CompilationException(TokenMgrError pe) {
//      if (!pe.isEOF) {
//        code=3;
//        params=new Object[1];
//        params[0]=new Character(pe.encountered);
//      } else code=1;
//      col=pe.col;
//    };

  public CompilationException(int col,int code, Object param) {
    this.code=code;
    Object[] temp={param};
    this.params=temp;
    this.col=col;
  };

  public CompilationException(int col,int code, Object[] params) {
    this.code=code;
    this.params=params;
    this.col=col;
  };

  public int getColumn() {
    return col;
  };

  public void setColumn(int col) {
    this.col=col;
  };

  public int getType() {
    return code;
  };

  public String getMessage() {
    if (Debug.enabled)
      Debug.assert(col>=0);
    if (code>=0)
      return MessageFormat.format(msgs.getString("e"+code),params);
    else 
      return super.getMessage();
  };


};


