/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.Library;
import gnu.jel.PatchableByteArrayOutputStream;
import gnu.jel.TypesStack;
import gnu.jel.debug.Tester;
import gnu.jel.reflect.LocalField;
import gnu.jel.reflect.LocalMethod;
import gnu.jel.reflect.Member;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    int nMethods = 0;
    int nMethodsPatch;
    protected PatchableByteArrayOutputStream textData;
    private DataOutputStream text;
    private boolean isInterface;
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
    protected LocalMethod currMethod = null;
    int[] paramsVars = null;
    protected TypesStack typesStk = new TypesStack();
    protected int currJump = 0;
    protected boolean invert_next_jump = false;
    private IntegerStack jumps = new IntegerStack();
    private IntegerStack jumps0 = new IntegerStack();
    private IntegerStack jumps1 = new IntegerStack();
    private IntegerStack blocks0 = new IntegerStack();
    private IntegerStack blocks1 = new IntegerStack();
    private IntegerStack branchStack = new IntegerStack();
    private static final int[] load_ints = new int[]{2, 3, 4, 5, 6, 7, 8};
    private static final int[] load_long_ints = new int[]{34050, 9, 10, 34053, 34054, 34055, 34056};

    public ClassFile(int n, String string, Class clazz, Class[] classArray, LocalField[] localFieldArray) {
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.textData = new PatchableByteArrayOutputStream();
        this.text = new DataOutputStream(this.textData);
        try {
            this.getUTFIndex(ClassFile.toHistoricalForm(string));
            this.isInterface = (n & 0x200) > 0;
            this.text.writeShort(n | 0x20);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.text.writeShort(2);
            this.text.writeShort(this.getIndex(clazz, 9));
            int n2 = classArray == null ? 0 : classArray.length;
            this.text.writeShort(n2);
            int n3 = 0;
            while (n3 < n2) {
                this.text.writeShort(this.getIndex(classArray[n3], 9));
                ++n3;
            }
            int n4 = localFieldArray == null ? 0 : localFieldArray.length;
            this.text.writeShort(n4);
            int n5 = 0;
            while (n5 < n4) {
                LocalField localField = localFieldArray[n5];
                this.text.writeShort(localField.getModifiers() & 0xFFFF);
                String string2 = localField.getName();
                this.text.writeShort(this.getUTFIndex(string2));
                this.text.writeShort(this.getUTFIndex(ClassFile.getSignature(localField.getType())));
                this.text.writeShort(0);
                ++n5;
            }
            this.nMethodsPatch = this.textData.size();
            this.text.writeShort(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object clone() {
        ClassFile classFile = null;
        try {
            classFile = (ClassFile)super.clone();
            classFile.Items = (Hashtable)classFile.Items.clone();
            classFile.UTFs = (Hashtable)classFile.UTFs.clone();
            classFile.paramsVars = (int[])classFile.paramsVars.clone();
            classFile.typesStk = (TypesStack)classFile.typesStk.clone();
            classFile.jumps = (IntegerStack)classFile.jumps.clone();
            classFile.jumps0 = (IntegerStack)classFile.jumps0.clone();
            classFile.jumps1 = (IntegerStack)classFile.jumps1.clone();
            classFile.blocks0 = (IntegerStack)classFile.blocks0.clone();
            classFile.blocks1 = (IntegerStack)classFile.blocks1.clone();
            classFile.branchStack = (IntegerStack)classFile.branchStack.clone();
            classFile.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(classFile.constPoolData);
            classFile.constPool = new DataOutputStream(classFile.constPoolData);
            classFile.textData = new PatchableByteArrayOutputStream();
            this.text.flush();
            this.textData.writeTo(classFile.textData);
            classFile.text = new DataOutputStream(classFile.textData);
        }
        catch (IOException iOException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return classFile;
    }

    public void newMethod(LocalMethod localMethod, Class[] classArray) {
        try {
            this.finishMethod();
            ++this.nMethods;
            int n = localMethod.getModifiers() & 0xFFFF;
            if (this.isInterface) {
                n |= 0x400;
            }
            boolean bl = (n & 0x400) > 0;
            this.text.writeShort(n);
            this.text.writeShort(this.getUTFIndex(localMethod.getName()));
            this.text.writeShort(this.getUTFIndex(ClassFile.getSignature(localMethod)));
            int n2 = 0;
            Class[] classArray2 = localMethod.getExceptionTypes();
            if (classArray2.length > 0) {
                ++n2;
            }
            if (!bl) {
                ++n2;
            }
            this.text.writeShort(n2);
            n2 = classArray2.length;
            if (n2 > 0) {
                this.text.writeShort(this.getUTFIndex("Exceptions"));
                this.text.writeInt((n2 + 1) * 2);
                this.text.writeShort(n2);
                int n3 = 0;
                while (n3 < n2) {
                    this.text.writeShort(this.getIndex(classArray2[n3], 9));
                    ++n3;
                }
            }
            if (!bl) {
                this.startCodeAttr = this.textData.size();
                this.text.writeShort(this.getUTFIndex("Code"));
                this.text.writeInt(0);
                this.text.writeShort(0);
                Class[] classArray3 = localMethod.getParameterTypes();
                int n4 = classArray3 == null ? 0 : classArray3.length;
                int n5 = classArray == null ? 0 : classArray.length;
                int n6 = (n & 8) == 0 ? 1 : 0;
                int n7 = n4 + n5 + n6;
                this.paramsVars = new int[n7];
                int n8 = 0;
                int n9 = 0;
                while (n9 < this.paramsVars.length) {
                    int n10 = n9 - n6;
                    int n11 = n9 < n6 ? 8 : TypesStack.primitiveID(n10 < n4 ? classArray3[n10] : classArray[n10 - n4]);
                    this.paramsVars[n9] = n8;
                    n8 += TypesStack.stkoccup[n11];
                    ++n9;
                }
                this.text.writeShort(n8);
                this.text.writeInt(0);
                this.startCode = this.textData.size();
            }
            this.typesStk.resetStats();
            if (!bl) {
                this.currMethod = localMethod;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finishMethod() throws IOException {
        if (this.currMethod != null) {
            int n = this.textData.size();
            this.text.writeShort(0);
            this.text.writeShort(0);
            int n2 = this.textData.size();
            this.textData.patchAddressInt(this.startCodeAttr + 2, n2 - this.startCodeAttr - 6);
            this.textData.patchAddress(this.startCodeAttr + 6, this.typesStk.getMaxOccupation());
            this.textData.patchAddress(this.startCode - 2, n - this.startCode);
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            this.text.writeShort(0);
            this.textData.patchAddress(this.nMethodsPatch, this.nMethods);
            byteArrayOutputStream.write(prologue);
            byteArrayOutputStream.write(this.poolEntries >>> 8 & 0xFF);
            byteArrayOutputStream.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(byteArrayOutputStream);
            this.textData.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static final int invert_jump_bytecode(int n) {
        return (n - 1 ^ 1) + 1;
    }

    protected void labels_block() {
        this.blocks0.push(this.jumps0.size());
        this.blocks1.push(this.jumps1.size());
    }

    protected void labels_unblock() {
        this.blocks0.pop_throw();
        this.blocks1.pop_throw();
    }

    protected void labels_unblock_not() {
        this.ensure_jump();
        IntegerStack.swap(this.jumps1, this.blocks1.pop(), this.jumps0, this.blocks0.pop());
        this.invert_next_jump = !this.invert_next_jump;
    }

    protected final void ensure_jump() {
        if (this.currJump != 0) {
            return;
        }
        Class clazz = this.typesStk.pop();
        this.currJump = 157;
    }

    protected final void ensure_value() {
        if (this.currJump == 0) {
            boolean bl;
            int n = 0;
            if (this.blocks0.size() > 0) {
                n = this.blocks0.peek();
            }
            int n2 = 0;
            if (this.blocks1.size() > 0) {
                n2 = this.blocks1.peek();
            }
            boolean bl2 = bl = this.jumps0.size() == n && this.jumps1.size() == n2;
            if (bl) {
                return;
            }
        }
        this.branch_true();
        this.codeLDC(Boolean.TRUE, 0);
        this.branch_false();
        this.codeLDC(Boolean.FALSE, 0);
        this.branch_end();
    }

    private final void mkLabel(IntegerStack integerStack) {
        int n = this.textData.size();
        integerStack.push(n);
        this.codeI(0);
    }

    private final void landLabel(IntegerStack integerStack) {
        int n = this.textData.size();
        int n2 = integerStack.pop();
        this.textData.patchAddress(n2, n - n2 + 1);
    }

    private final void landLabels(IntegerStack integerStack, IntegerStack integerStack2) {
        int n = 0;
        if (integerStack2.size() > 0) {
            n = integerStack2.peek();
        }
        while (integerStack.size() > n) {
            this.landLabel(integerStack);
        }
    }

    public void branch_true() {
        this.ensure_jump();
        if (!this.invert_next_jump) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(this.jumps0);
        this.landLabels(this.jumps1, this.blocks1);
        this.blocks0.push(this.jumps0.size());
        this.branchStack.push(this.typesStk.size());
    }

    public void branch_false() {
        this.ensure_value();
        this.blocks0.pop_throw();
        int n = this.branchStack.pop();
        while (n < this.typesStk.size()) {
            this.typesStk.pop();
        }
        this.code(167);
        this.mkLabel(this.jumps);
        this.landLabels(this.jumps0, this.blocks0);
    }

    public void branch_end() {
        this.ensure_value();
        this.landLabel(this.jumps);
    }

    protected void logical_param(boolean bl) {
        IntegerStack integerStack;
        IntegerStack integerStack2;
        IntegerStack integerStack3;
        IntegerStack integerStack4;
        if (bl) {
            integerStack4 = this.jumps0;
            integerStack3 = this.jumps1;
            integerStack2 = this.blocks0;
            integerStack = this.blocks1;
        } else {
            integerStack4 = this.jumps1;
            integerStack3 = this.jumps0;
            integerStack2 = this.blocks1;
            integerStack = this.blocks0;
        }
        this.ensure_jump();
        if (this.invert_next_jump ^ bl) {
            this.currJump = ClassFile.invert_jump_bytecode(this.currJump);
        }
        this.invert_next_jump = false;
        this.code(this.currJump);
        this.currJump = 0;
        this.mkLabel(integerStack4);
        this.landLabels(integerStack3, integerStack);
        integerStack2.push(integerStack4.size());
    }

    protected void logical_end(boolean bl) {
        if (bl) {
            this.blocks0.pop_throw();
        } else {
            this.blocks1.pop_throw();
        }
    }

    protected final void code(int n) {
        try {
            while (n != 0) {
                this.text.write(n & 0xFF);
                n >>>= 8;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void codeLDC(Object object, int n) {
        block23: {
            int n2 = 0;
            int n3 = -1;
            switch (n) {
                case 0: {
                    n3 = (Boolean)object != false ? 1 : 0;
                }
                case 2: {
                    if (n3 < 0) {
                        n3 = ((Character)object).charValue();
                    }
                }
                case 1: 
                case 3: 
                case 4: {
                    if (n3 < 0) {
                        n3 = ((Number)object).intValue();
                    }
                    if (n3 >= -1 && n3 <= 5) {
                        n2 = n3 + 3;
                        break;
                    }
                    if (n3 < -128 || n3 > 127) break;
                    n2 = 0x10 | (n3 & 0xFF) << 8;
                    break;
                }
                case 5: {
                    long l = (Long)object;
                    if (l < -1L || l > 5L) break;
                    n2 = load_long_ints[(int)l + 1];
                    break;
                }
                case 6: {
                    float f = ((Float)object).floatValue();
                    if (f == 0.0f) {
                        n2 = 11;
                        break;
                    }
                    if (f == 1.0f) {
                        n2 = 12;
                        break;
                    }
                    if (f != 2.0f) break;
                    n2 = 13;
                    break;
                }
                case 7: {
                    double d = (Double)object;
                    if (d == 0.0) {
                        n2 = 14;
                        break;
                    }
                    if (d != 1.0) break;
                    n2 = 15;
                    break;
                }
                case 8: {
                    if (object != null) break;
                    n2 = 1;
                    break;
                }
            }
            if (n2 == 0) {
                try {
                    boolean bl = n == 5 || n == 7;
                    int n4 = this.getIndex(object, n);
                    if (!bl && n4 <= 255) {
                        this.text.write(18);
                        this.text.write(n4);
                        break block23;
                    }
                    int n5 = 19;
                    if (bl) {
                        ++n5;
                    }
                    this.text.write(n5);
                    this.text.writeShort(n4);
                }
                catch (IOException iOException) {}
            } else {
                this.code(n2);
            }
        }
        if (n != 8) {
            this.typesStk.pushID(n);
        } else {
            this.typesStk.push(object != null ? object.getClass() : null);
        }
    }

    protected final void codeI(int n) {
        try {
            this.text.writeShort(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getUTFIndex(String string) {
        Integer n = (Integer)this.UTFs.get(string);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.UTFs.put(string, n);
        }
        return n;
    }

    private int typeID(Object object) {
        int n = TypesStack.primitiveID(object);
        if (n < 8) {
            return n;
        }
        if (object instanceof String) {
            return 8;
        }
        if (object instanceof Class) {
            return 9;
        }
        if (object instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object object) {
        return this.getIndex(object, this.typeID(object));
    }

    protected int getIndex(Object object, int n) {
        Integer n2 = (Integer)this.Items.get(object);
        if (n2 == null) {
            int n3 = -1;
            try {
                int n4 = -1;
                switch (n) {
                    case 0: {
                        n4 = (Boolean)object != false ? 1 : 0;
                    }
                    case 2: {
                        if (n4 < 0) {
                            n4 = ((Character)object).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (n4 < 0) {
                            n4 = ((Number)object).intValue();
                        }
                        n3 = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(n4);
                        break;
                    }
                    case 5: {
                        n3 = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)object);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        n3 = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)object).floatValue());
                        break;
                    }
                    case 7: {
                        n3 = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)object);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int n5 = this.getUTFIndex((String)object);
                        n3 = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(n5);
                        break;
                    }
                    case 9: {
                        String string = ClassFile.toHistoricalForm(((Class)object).getName());
                        int n6 = this.getUTFIndex(string);
                        n3 = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(n6);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)object;
                        Class<?> clazz = member.getDeclaringClass();
                        int n7 = member.getModifiers() >>> 16 == 1 ? 9 : (clazz != null && clazz.isInterface() ? 11 : 10);
                        n3 = this.writeMemberRef(member, n7);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n2 = new Integer(n3);
            this.Items.put(object, n2);
        }
        return n2;
    }

    private int writeMemberRef(Member member, int n) throws IOException {
        int n2 = this.getUTFIndex(member.getName());
        int n3 = this.getUTFIndex(ClassFile.getSignature(member));
        Class<?> clazz = member.getDeclaringClass();
        int n4 = clazz == null ? 2 : this.getIndex(clazz, 9);
        int n5 = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(n2);
        this.constPool.writeShort(n3);
        int n6 = this.poolEntries++;
        this.constPool.write(n);
        this.constPool.writeShort(n4);
        this.constPool.writeShort(n5);
        return n6;
    }

    public static String getSignature(Member member) {
        StringBuffer stringBuffer = new StringBuffer();
        if (member.getModifiers() >>> 16 > 1) {
            Class[] classArray = member.getParameterTypes();
            stringBuffer.append('(');
            int n = 0;
            while (n < classArray.length) {
                ClassFile.appendSignature(stringBuffer, classArray[n]);
                ++n;
            }
            stringBuffer.append(')');
        }
        ClassFile.appendSignature(stringBuffer, member.getType());
        return stringBuffer.toString();
    }

    public static String getSignature(Class clazz) {
        return ClassFile.appendSignature(new StringBuffer(), clazz).toString();
    }

    private static StringBuffer appendSignature(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isPrimitive()) {
            stringBuffer.append(TypesStack.primitiveCodes[TypesStack.primitiveID(clazz)]);
        } else if (clazz.isArray()) {
            stringBuffer.append('[');
            ClassFile.appendSignature(stringBuffer, clazz.getComponentType());
        } else {
            stringBuffer.append('L');
            ClassFile.appendHistoricalForm(stringBuffer, clazz.getName());
            stringBuffer.append(';');
        }
        return stringBuffer;
    }

    private static String toHistoricalForm(String string) {
        return ClassFile.appendHistoricalForm(new StringBuffer(), string).toString();
    }

    private static StringBuffer appendHistoricalForm(StringBuffer stringBuffer, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '.') {
                c = '/';
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) {
    }

    static void dumpImage(ClassFile classFile) {
    }

    public static void test(Tester tester) {
    }

    private static void exprTest(String string, Object[] objectArray, Library library, Object object, ClassFile classFile, int n, LocalMethod[] localMethodArray, Tester tester, boolean bl) {
    }
}

