/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OPlist;
import gnu.jel.debug.Debug;
import java.lang.reflect.Method;

class OP_call
extends OP_function {
    Method m;
    int nargs = 999;
    Class[] args;
    boolean interpretable = false;

    OP_call() {
    }

    boolean canInterpret() {
        return this.interpretable && this.operandsReady(this.nargs, true);
    }

    void setMethod(OPlist list, Method m, int id, boolean interpretable) {
        this.args = m.getParameterTypes();
        this.nargs = this.args.length;
        this.interpretable = interpretable;
        this.m = m;
        int cpar = this.args.length - 1;
        OP cop = this.prev;
        while (cop != null && cpar >= 0) {
            OP_param copp;
            if (cop instanceof OP_param && (copp = (OP_param)cop).getFunction() == this) {
                copp.setConvert(list, this.args[cpar--]);
                copp.setMethod(m, id);
            }
            cop = cop.prev;
        }
        Debug.assert(cop != null && cpar == -1, "Not all parameters are present at function call");
        OP_start ops = null;
        while (cop != null && ops == null) {
            if (cop instanceof OP_start && (ops = (OP_start)cop).getFunction() != this) {
                ops = null;
            }
            cop = cop.prev;
        }
        Debug.assert(ops != null, "OP_start was not found.");
        ops.setMethod(m, id);
    }

    void interpret(OPlist list) throws Throwable {
        Object[] args = new Object[this.nargs];
        OP cop = this.prev;
        int argc = this.nargs - 1;
        while (argc >= 0) {
            args[argc--] = ((OP_load)cop.prev).what;
            cop = cop.prev.prev;
        }
        Debug.assert(cop instanceof OP_start, "Wrongly formed function call.");
        Object val = this.m.invoke(null, args);
        OP_load result = new OP_load(this.m.getReturnType(), val);
        this.consume(list, result, this.nargs, true);
    }

    void compile(ExpressionImage ei) {
        ei.asm_func_call();
    }

    public String toString() {
        return String.valueOf(this.m.getName()) + "]";
    }
}

