/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

typedef struct _phbook Phbook;

struct _phbook {
	GtkDialog *main;
	GtkButton *closeButton;
	GtkButton *deleteBookButton;
	GtkButton *addBookButton;
	GtkButton *gnomeCardButton;
	GtkCList *phoneBookCList;
	GtkCList *phoneItemCList;
	Destination *dest;
	GtkDialog *addPBWindow;
	GtkButton *addPBCancelButton;
	GtkButton *addPBOkButton;
	GnomeFileEntry *addPBFileEntry;
	GtkEntry *addPBEntry;
	gchar *currentPhoneBookSelection;
};


static void on_close_clicked(GtkWidget *widget);
static void on_deleteBook_clicked(GtkWidget *widget);
static void on_addBook_clicked(GtkWidget *widget);
static void on_gnomeCard_clicked(GtkWidget *widget);
static gint read_vcard_file(gchar *filename);
static void update_phoneBook_CList(void);
static void on_addPBCancelButton_clicked(GtkWidget *button);
static void on_addPBOkButton_clicked(GtkWidget *button);
static void select_row(GtkCList *clist, gint row, gint col, GdkEvent *event);
