/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   pschwartau@netscape.com
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Date: 2001-07-12
 *
 * SUMMARY: Regression test for bug 89443
 * See http://bugzilla.mozilla.org/show_bug.cgi?id=89443
 *
 * Just seeing if this script will compile without stack overflow.
 */
//-----------------------------------------------------------------------------
var gTestfile = 'regress-89443.js';
var BUGNUMBER = 89443;
var summary = 'Testing this script will compile without stack overflow';

printBugNumber(BUGNUMBER);
printStatus (summary);


//  I don't know what these functions are supposed to be; use dummies -
function isPlainHostName()
{
}

function dnsDomainIs()
{
}

// Here's the big function -
function FindProxyForURL(url, host)
{

  if (isPlainHostName(host)
      || dnsDomainIs(host, ".hennepin.lib.mn.us")
      || dnsDomainIs(host, ".hclib.org")
    )
    return "DIRECT";
  else if (isPlainHostName(host)

// subscription database access

	   || dnsDomainIs(host, ".asahi.com")
	   || dnsDomainIs(host, ".2facts.com")
	   || dnsDomainIs(host, ".oclc.org")
	   || dnsDomainIs(host, ".collegesource.com")
	   || dnsDomainIs(host, ".cq.com")
	   || dnsDomainIs(host, ".grolier.com")
	   || dnsDomainIs(host, ".groveart.com")
	   || dnsDomainIs(host, ".groveopera.com")
	   || dnsDomainIs(host, ".fsonline.com")
	   || dnsDomainIs(host, ".carl.org")
	   || dnsDomainIs(host, ".newslibrary.com")
	   || dnsDomainIs(host, ".pioneerplanet.com")
	   || dnsDomainIs(host, ".startribune.com")
	   || dnsDomainIs(host, ".poemfinder.com")
	   || dnsDomainIs(host, ".umi.com")
	   || dnsDomainIs(host, ".referenceusa.com")
	   || dnsDomainIs(host, ".sirs.com")
	   || dnsDomainIs(host, ".krmediastream.com")
	   || dnsDomainIs(host, ".gale.com")
	   || dnsDomainIs(host, ".galenet.com")
	   || dnsDomainIs(host, ".galegroup.com")
	   || dnsDomainIs(host, ".facts.com")
	   || dnsDomainIs(host, ".eb.com")
	   || dnsDomainIs(host, ".worldbookonline.com")
	   || dnsDomainIs(host, ".galegroup.com")
	   || dnsDomainIs(host, ".accessscience.com")
	   || dnsDomainIs(host, ".booksinprint.com")
	   || dnsDomainIs(host, ".infolearning.com")
	   || dnsDomainIs(host, ".standardpoor.com")

// image servers
	   || dnsDomainIs(host, ".akamaitech.net")
	   || dnsDomainIs(host, ".akamai.net")
	   || dnsDomainIs(host, ".yimg.com")
	   || dnsDomainIs(host, ".imgis.com")
	   || dnsDomainIs(host, ".ibsys.com")

//  KidsClick-linked kids search engines
	   || dnsDomainIs(host, ".edview.com")
	   || dnsDomainIs(host, ".searchopolis.com")
	   || dnsDomainIs(host, ".onekey.com")
	   || dnsDomainIs(host, ".askjeeves.com")
 
//  Non-subscription Reference Tools URLs from the RecWebSites DBData table
	   || dnsDomainIs(host, "www.cnn.com")
	   || dnsDomainIs(host, "www.emulateme.com")
	   || dnsDomainIs(host, "terraserver.microsoft.com")
	   || dnsDomainIs(host, "www.theodora.com")
	   || dnsDomainIs(host, "www.3datlas.com")
	   || dnsDomainIs(host, "www.infoplease.com")
	   || dnsDomainIs(host, "www.switchboard.com")
	   || dnsDomainIs(host, "www.bartleby.com")
	   || dnsDomainIs(host, "www.mn-politics.com")
	   || dnsDomainIs(host, "www.thesaurus.com")
	   || dnsDomainIs(host, "www.usnews.com")
	   || dnsDomainIs(host, "www.petersons.com")
	   || dnsDomainIs(host, "www.collegenet.com")
	   || dnsDomainIs(host, "www.m-w.com")
	   || dnsDomainIs(host, "clever.net")
	   || dnsDomainIs(host, "maps.expedia.com")
	   || dnsDomainIs(host, "www.CollegeEdge.com")
	   || dnsDomainIs(host, "www.homeworkcentral.com")
	   || dnsDomainIs(host, "www.studyweb.com")
	   || dnsDomainIs(host, "www.mnpro.com")
 
//  custom URLs for local and other access
	   || dnsDomainIs(host, ".dsdukes.com")
	   || dnsDomainIs(host, ".spsaints.com")
	   || dnsDomainIs(host, ".mnzoo.com")
	   || dnsDomainIs(host, ".realaudio.com")
	   || dnsDomainIs(host, ".co.hennepin.mn.us")
	   || dnsDomainIs(host, ".gov")
	   || dnsDomainIs(host, ".org")
	   || dnsDomainIs(host, ".edu")
	   || dnsDomainIs(host, ".fox29.com")
	   || dnsDomainIs(host, ".wcco.com")
	   || dnsDomainIs(host, ".kstp.com")
	   || dnsDomainIs(host, ".kmsp.com")
	   || dnsDomainIs(host, ".kare11.com")
	   || dnsDomainIs(host, ".macromedia.com")
	   || dnsDomainIs(host, ".shockwave.com")
	   || dnsDomainIs(host, ".wwf.com")
	   || dnsDomainIs(host, ".wwfsuperstars.com")
	   || dnsDomainIs(host, ".summerslam.com")
	   || dnsDomainIs(host, ".yahooligans.com")
	   || dnsDomainIs(host, ".mhoob.com")
	   || dnsDomainIs(host, "www.hmonginternet.com")
	   || dnsDomainIs(host, "www.hmongonline.com")
	   || dnsDomainIs(host, ".yahoo.com")
	   || dnsDomainIs(host, ".pokemon.com")
	   || dnsDomainIs(host, ".bet.com")
	   || dnsDomainIs(host, ".smallworld.com")
	   || dnsDomainIs(host, ".cartoonnetwork.com")
	   || dnsDomainIs(host, ".carmensandiego.com")
	   || dnsDomainIs(host, ".disney.com")
	   || dnsDomainIs(host, ".powerpuffgirls.com")
	   || dnsDomainIs(host, ".aol.com")

// Smithsonian
	   || dnsDomainIs(host, "160.111.100.190")

// Hotmail
	   || dnsDomainIs(host, ".passport.com")
	   || dnsDomainIs(host, ".hotmail.com")
	   || dnsDomainIs(host, "216.33.236.24")
	   || dnsDomainIs(host, "216.32.182.251")
	   || dnsDomainIs(host, ".hotmail.msn.com")

//  K12 schools
	   || dnsDomainIs(host, ".k12.al.us")
	   || dnsDomainIs(host, ".k12.ak.us")
	   || dnsDomainIs(host, ".k12.ar.us")
	   || dnsDomainIs(host, ".k12.az.us")
	   || dnsDomainIs(host, ".k12.ca.us")
	   || dnsDomainIs(host, ".k12.co.us")
	   || dnsDomainIs(host, ".k12.ct.us")
	   || dnsDomainIs(host, ".k12.dc.us")
	   || dnsDomainIs(host, ".k12.de.us")
	   || dnsDomainIs(host, ".k12.fl.us")
	   || dnsDomainIs(host, ".k12.ga.us")
	   || dnsDomainIs(host, ".k12.hi.us")
	   || dnsDomainIs(host, ".k12.id.us")
	   || dnsDomainIs(host, ".k12.il.us")
	   || dnsDomainIs(host, ".k12.in.us")
	   || dnsDomainIs(host, ".k12.ia.us")
	   || dnsDomainIs(host, ".k12.ks.us")
	   || dnsDomainIs(host, ".k12.ky.us")
	   || dnsDomainIs(host, ".k12.la.us")
	   || dnsDomainIs(host, ".k12.me.us")
	   || dnsDomainIs(host, ".k12.md.us")
	   || dnsDomainIs(host, ".k12.ma.us")
	   || dnsDomainIs(host, ".k12.mi.us")
	   || dnsDomainIs(host, ".k12.mn.us")
	   || dnsDomainIs(host, ".k12.ms.us")
	   || dnsDomainIs(host, ".k12.mo.us")
	   || dnsDomainIs(host, ".k12.mt.us")
	   || dnsDomainIs(host, ".k12.ne.us")
	   || dnsDomainIs(host, ".k12.nv.us")
	   || dnsDomainIs(host, ".k12.nh.us")
	   || dnsDomainIs(host, ".k12.nj.us")
	   || dnsDomainIs(host, ".k12.nm.us")
	   || dnsDomainIs(host, ".k12.ny.us")
	   || dnsDomainIs(host, ".k12.nc.us")
	   || dnsDomainIs(host, ".k12.nd.us")
	   || dnsDomainIs(host, ".k12.oh.us")
	   || dnsDomainIs(host, ".k12.ok.us")
	   || dnsDomainIs(host, ".k12.or.us")
	   || dnsDomainIs(host, ".k12.pa.us")
	   || dnsDomainIs(host, ".k12.ri.us")
	   || dnsDomainIs(host, ".k12.sc.us")
	   || dnsDomainIs(host, ".k12.sd.us")
	   || dnsDomainIs(host, ".k12.tn.us")
	   || dnsDomainIs(host, ".k12.tx.us")
	   || dnsDomainIs(host, ".k12.ut.us")
	   || dnsDomainIs(host, ".k12.vt.us")
	   || dnsDomainIs(host, ".k12.va.us")
	   || dnsDomainIs(host, ".k12.wa.us")
	   || dnsDomainIs(host, ".k12.wv.us")
	   || dnsDomainIs(host, ".k12.wi.us")
	   || dnsDomainIs(host, ".k12.wy.us")

//  U.S. Libraries
	   || dnsDomainIs(host, ".lib.al.us")
	   || dnsDomainIs(host, ".lib.ak.us")
	   || dnsDomainIs(host, ".lib.ar.us")
	   || dnsDomainIs(host, ".lib.az.us")
	   || dnsDomainIs(host, ".lib.ca.us")
	   || dnsDomainIs(host, ".lib.co.us")
	   || dnsDomainIs(host, ".lib.ct.us")
	   || dnsDomainIs(host, ".lib.dc.us")
	   || dnsDomainIs(host, ".lib.de.us")
	   || dnsDomainIs(host, ".lib.fl.us")
	   || dnsDomainIs(host, ".lib.ga.us")
	   || dnsDomainIs(host, ".lib.hi.us")
	   || dnsDomainIs(host, ".lib.id.us")
	   || dnsDomainIs(host, ".lib.il.us")
	   || dnsDomainIs(host, ".lib.in.us")
	   || dnsDomainIs(host, ".lib.ia.us")
	   || dnsDomainIs(host, ".lib.ks.us")
	   || dnsDomainIs(host, ".lib.ky.us")
	   || dnsDomainIs(host, ".lib.la.us")
	   || dnsDomainIs(host, ".lib.me.us")
	   || dnsDomainIs(host, ".lib.md.us")
	   || dnsDomainIs(host, ".lib.ma.us")
	   || dnsDomainIs(host, ".lib.mi.us")
	   || dnsDomainIs(host, ".lib.mn.us")
	   || dnsDomainIs(host, ".lib.ms.us")
	   || dnsDomainIs(host, ".lib.mo.us")
	   || dnsDomainIs(host, ".lib.mt.us")
	   || dnsDomainIs(host, ".lib.ne.us")
	   || dnsDomainIs(host, ".lib.nv.us")
	   || dnsDomainIs(host, ".lib.nh.us")
	   || dnsDomainIs(host, ".lib.nj.us")
	   || dnsDomainIs(host, ".lib.nm.us")
	   || dnsDomainIs(host, ".lib.ny.us")
	   || dnsDomainIs(host, ".lib.nc.us")
	   || dnsDomainIs(host, ".lib.nd.us")
	   || dnsDomainIs(host, ".lib.oh.us")
	   || dnsDomainIs(host, ".lib.ok.us")
	   || dnsDomainIs(host, ".lib.or.us")
	   || dnsDomainIs(host, ".lib.pa.us")
	   || dnsDomainIs(host, ".lib.ri.us")
	   || dnsDomainIs(host, ".lib.sc.us")
	   || dnsDomainIs(host, ".lib.sd.us")
	   || dnsDomainIs(host, ".lib.tn.us")
	   || dnsDomainIs(host, ".lib.tx.us")
	   || dnsDomainIs(host, ".lib.ut.us")
	   || dnsDomainIs(host, ".lib.vt.us")
	   || dnsDomainIs(host, ".lib.va.us")
	   || dnsDomainIs(host, ".lib.wa.us")
	   || dnsDomainIs(host, ".lib.wv.us")
	   || dnsDomainIs(host, ".lib.wi.us")
	   || dnsDomainIs(host, ".lib.wy.us")

//  U.S. Cities
	   || dnsDomainIs(host, ".ci.al.us")
	   || dnsDomainIs(host, ".ci.ak.us")
	   || dnsDomainIs(host, ".ci.ar.us")
	   || dnsDomainIs(host, ".ci.az.us")
	   || dnsDomainIs(host, ".ci.ca.us")
	   || dnsDomainIs(host, ".ci.co.us")
	   || dnsDomainIs(host, ".ci.ct.us")
	   || dnsDomainIs(host, ".ci.dc.us")
	   || dnsDomainIs(host, ".ci.de.us")
	   || dnsDomainIs(host, ".ci.fl.us")
	   || dnsDomainIs(host, ".ci.ga.us")
	   || dnsDomainIs(host, ".ci.hi.us")
	   || dnsDomainIs(host, ".ci.id.us")
	   || dnsDomainIs(host, ".ci.il.us")
	   || dnsDomainIs(host, ".ci.in.us")
	   || dnsDomainIs(host, ".ci.ia.us")
	   || dnsDomainIs(host, ".ci.ks.us")
	   || dnsDomainIs(host, ".ci.ky.us")
	   || dnsDomainIs(host, ".ci.la.us")
	   || dnsDomainIs(host, ".ci.me.us")
	   || dnsDomainIs(host, ".ci.md.us")
	   || dnsDomainIs(host, ".ci.ma.us")
	   || dnsDomainIs(host, ".ci.mi.us")
	   || dnsDomainIs(host, ".ci.mn.us")
	   || dnsDomainIs(host, ".ci.ms.us")
	   || dnsDomainIs(host, ".ci.mo.us")
	   || dnsDomainIs(host, ".ci.mt.us")
	   || dnsDomainIs(host, ".ci.ne.us")
	   || dnsDomainIs(host, ".ci.nv.us")
	   || dnsDomainIs(host, ".ci.nh.us")
	   || dnsDomainIs(host, ".ci.nj.us")
	   || dnsDomainIs(host, ".ci.nm.us")
	   || dnsDomainIs(host, ".ci.ny.us")
	   || dnsDomainIs(host, ".ci.nc.us")
	   || dnsDomainIs(host, ".ci.nd.us")
	   || dnsDomainIs(host, ".ci.oh.us")
	   || dnsDomainIs(host, ".ci.ok.us")
	   || dnsDomainIs(host, ".ci.or.us")
	   || dnsDomainIs(host, ".ci.pa.us")
	   || dnsDomainIs(host, ".ci.ri.us")
	   || dnsDomainIs(host, ".ci.sc.us")
	   || dnsDomainIs(host, ".ci.sd.us")
	   || dnsDomainIs(host, ".ci.tn.us")
	   || dnsDomainIs(host, ".ci.tx.us")
	   || dnsDomainIs(host, ".ci.ut.us")
	   || dnsDomainIs(host, ".ci.vt.us")
	   || dnsDomainIs(host, ".ci.va.us")
	   || dnsDomainIs(host, ".ci.wa.us")
	   || dnsDomainIs(host, ".ci.wv.us")
	   || dnsDomainIs(host, ".ci.wi.us")
	   || dnsDomainIs(host, ".ci.wy.us")

//  U.S. Counties
	   || dnsDomainIs(host, ".co.al.us")
	   || dnsDomainIs(host, ".co.ak.us")
	   || dnsDomainIs(host, ".co.ar.us")
	   || dnsDomainIs(host, ".co.az.us")
	   || dnsDomainIs(host, ".co.ca.us")
	   || dnsDomainIs(host, ".co.co.us")
	   || dnsDomainIs(host, ".co.ct.us")
	   || dnsDomainIs(host, ".co.dc.us")
	   || dnsDomainIs(host, ".co.de.us")
	   || dnsDomainIs(host, ".co.fl.us")
	   || dnsDomainIs(host, ".co.ga.us")
	   || dnsDomainIs(host, ".co.hi.us")
	   || dnsDomainIs(host, ".co.id.us")
	   || dnsDomainIs(host, ".co.il.us")
	   || dnsDomainIs(host, ".co.in.us")
	   || dnsDomainIs(host, ".co.ia.us")
	   || dnsDomainIs(host, ".co.ks.us")
	   || dnsDomainIs(host, ".co.ky.us")
	   || dnsDomainIs(host, ".co.la.us")
	   || dnsDomainIs(host, ".co.me.us")
	   || dnsDomainIs(host, ".co.md.us")
	   || dnsDomainIs(host, ".co.ma.us")
	   || dnsDomainIs(host, ".co.mi.us")
	   || dnsDomainIs(host, ".co.mn.us")
	   || dnsDomainIs(host, ".co.ms.us")
	   || dnsDomainIs(host, ".co.mo.us")
	   || dnsDomainIs(host, ".co.mt.us")
	   || dnsDomainIs(host, ".co.ne.us")
	   || dnsDomainIs(host, ".co.nv.us")
	   || dnsDomainIs(host, ".co.nh.us")
	   || dnsDomainIs(host, ".co.nj.us")
	   || dnsDomainIs(host, ".co.nm.us")
	   || dnsDomainIs(host, ".co.ny.us")
	   || dnsDomainIs(host, ".co.nc.us")
	   || dnsDomainIs(host, ".co.nd.us")
	   || dnsDomainIs(host, ".co.oh.us")
	   || dnsDomainIs(host, ".co.ok.us")
	   || dnsDomainIs(host, ".co.or.us")
	   || dnsDomainIs(host, ".co.pa.us")
	   || dnsDomainIs(host, ".co.ri.us")
	   || dnsDomainIs(host, ".co.sc.us")
	   || dnsDomainIs(host, ".co.sd.us")
	   || dnsDomainIs(host, ".co.tn.us")
	   || dnsDomainIs(host, ".co.tx.us")
	   || dnsDomainIs(host, ".co.ut.us")
	   || dnsDomainIs(host, ".co.vt.us")
	   || dnsDomainIs(host, ".co.va.us")
	   || dnsDomainIs(host, ".co.wa.us")
	   || dnsDomainIs(host, ".co.wv.us")
	   || dnsDomainIs(host, ".co.wi.us")
	   || dnsDomainIs(host, ".co.wy.us")

//  U.S. States
	   || dnsDomainIs(host, ".state.al.us")
	   || dnsDomainIs(host, ".state.ak.us")
	   || dnsDomainIs(host, ".state.ar.us")
	   || dnsDomainIs(host, ".state.az.us")
	   || dnsDomainIs(host, ".state.ca.us")
	   || dnsDomainIs(host, ".state.co.us")
	   || dnsDomainIs(host, ".state.ct.us")
	   || dnsDomainIs(host, ".state.dc.us")
	   || dnsDomainIs(host, ".state.de.us")
	   || dnsDomainIs(host, ".state.fl.us")
	   || dnsDomainIs(host, ".state.ga.us")
	   || dnsDomainIs(host, ".state.hi.us")
	   || dnsDomainIs(host, ".state.id.us")
	   || dnsDomainIs(host, ".state.il.us")
	   || dnsDomainIs(host, ".state.in.us")
	   || dnsDomainIs(host, ".state.ia.us")
	   || dnsDomainIs(host, ".state.ks.us")
	   || dnsDomainIs(host, ".state.ky.us")
	   || dnsDomainIs(host, ".state.la.us")
	   || dnsDomainIs(host, ".state.me.us")
	   || dnsDomainIs(host, ".state.md.us")
	   || dnsDomainIs(host, ".state.ma.us")
	   || dnsDomainIs(host, ".state.mi.us")
	   || dnsDomainIs(host, ".state.mn.us")
	   || dnsDomainIs(host, ".state.ms.us")
	   || dnsDomainIs(host, ".state.mo.us")
	   || dnsDomainIs(host, ".state.mt.us")
	   || dnsDomainIs(host, ".state.ne.us")
	   || dnsDomainIs(host, ".state.nv.us")
	   || dnsDomainIs(host, ".state.nh.us")
	   || dnsDomainIs(host, ".state.nj.us")
	   || dnsDomainIs(host, ".state.nm.us")
	   || dnsDomainIs(host, ".state.ny.us")
	   || dnsDomainIs(host, ".state.nc.us")
	   || dnsDomainIs(host, ".state.nd.us")
	   || dnsDomainIs(host, ".state.oh.us")
	   || dnsDomainIs(host, ".state.ok.us")
	   || dnsDomainIs(host, ".state.or.us")
	   || dnsDomainIs(host, ".state.pa.us")
	   || dnsDomainIs(host, ".state.ri.us")
	   || dnsDomainIs(host, ".state.sc.us")
	   || dnsDomainIs(host, ".state.sd.us")
	   || dnsDomainIs(host, ".state.tn.us")
	   || dnsDomainIs(host, ".state.tx.us")
	   || dnsDomainIs(host, ".state.ut.us")
	   || dnsDomainIs(host, ".state.vt.us")
	   || dnsDomainIs(host, ".state.va.us")
	   || dnsDomainIs(host, ".state.wa.us")
	   || dnsDomainIs(host, ".state.wv.us")
	   || dnsDomainIs(host, ".state.wi.us")
	   || dnsDomainIs(host, ".state.wy.us")

// KidsClick URLs

	   || dnsDomainIs(host, "12.16.163.163")
	   || dnsDomainIs(host, "128.59.173.136")
	   || dnsDomainIs(host, "165.112.78.61")
	   || dnsDomainIs(host, "216.55.23.140")
	   || dnsDomainIs(host, "63.111.53.150")
	   || dnsDomainIs(host, "64.94.206.8")

	   || dnsDomainIs(host, "abc.go.com")
	   || dnsDomainIs(host, "acmepet.petsmart.com")
	   || dnsDomainIs(host, "adver-net.com")
	   || dnsDomainIs(host, "aint-it-cool-news.com")
	   || dnsDomainIs(host, "akidsheart.com")
	   || dnsDomainIs(host, "alabanza.com")
	   || dnsDomainIs(host, "allerdays.com")
	   || dnsDomainIs(host, "allgame.com")
	   || dnsDomainIs(host, "allowancenet.com")
	   || dnsDomainIs(host, "amish-heartland.com")
	   || dnsDomainIs(host, "ancienthistory.about.com")
	   || dnsDomainIs(host, "animals.about.com")
	   || dnsDomainIs(host, "antenna.nl")
	   || dnsDomainIs(host, "arcweb.sos.state.or.us")
	   || dnsDomainIs(host, "artistmummer.homestead.com")
	   || dnsDomainIs(host, "artists.vh1.com")
	   || dnsDomainIs(host, "arts.lausd.k12.ca.us")
	   || dnsDomainIs(host, "asiatravel.com")
	   || dnsDomainIs(host, "asterius.com")
	   || dnsDomainIs(host, "atlas.gc.ca")
	   || dnsDomainIs(host, "atschool.eduweb.co.uk")
	   || dnsDomainIs(host, "ayya.pd.net")
	   || dnsDomainIs(host, "babelfish.altavista.com")
	   || dnsDomainIs(host, "babylon5.warnerbros.com")
	   || dnsDomainIs(host, "banzai.neosoft.com")
	   || dnsDomainIs(host, "barneyonline.com")
	   || dnsDomainIs(host, "baroque-music.com")
	   || dnsDomainIs(host, "barsoom.msss.com")
	   || dnsDomainIs(host, "baseball-almanac.com")
	   || dnsDomainIs(host, "bcadventure.com")
	   || dnsDomainIs(host, "beadiecritters.hosting4less.com")
	   || dnsDomainIs(host, "beverlyscrafts.com")
	   || dnsDomainIs(host, "biology.about.com")
	   || dnsDomainIs(host, "birding.about.com")
	   || dnsDomainIs(host, "boatsafe.com")
	   || dnsDomainIs(host, "bombpop.com")
	   || dnsDomainIs(host, "boulter.com")
	   || dnsDomainIs(host, "bright-ideas-software.com")
	   || dnsDomainIs(host, "buckman.pps.k12.or.us")
	   || dnsDomainIs(host, "buffalobills.com")
	   || dnsDomainIs(host, "bvsd.k12.co.us")
	   || dnsDomainIs(host, "cagle.slate.msn.com")
	   || dnsDomainIs(host, "calc.entisoft.com")
	   || dnsDomainIs(host, "canada.gc.ca")
	   || dnsDomainIs(host, "candleandsoap.about.com")
	   || dnsDomainIs(host, "caselaw.lp.findlaw.com")
	   || dnsDomainIs(host, "catalog.com")
	   || dnsDomainIs(host, "catalog.socialstudies.com")
	   || dnsDomainIs(host, "cavern.com")
	   || dnsDomainIs(host, "cbs.sportsline.com")
	   || dnsDomainIs(host, "cc.matsuyama-u.ac.jp")
	   || dnsDomainIs(host, "celt.net")
	   || dnsDomainIs(host, "cgfa.kelloggcreek.com")
	   || dnsDomainIs(host, "channel4000.com")
	   || dnsDomainIs(host, "chess.delorie.com")
	   || dnsDomainIs(host, "chess.liveonthenet.com")
	   || dnsDomainIs(host, "childfun.com")
	   || dnsDomainIs(host, "christmas.com")
	   || dnsDomainIs(host, "citystar.com")
	   || dnsDomainIs(host, "claim.goldrush.com")
	   || dnsDomainIs(host, "clairerosemaryjane.com")
	   || dnsDomainIs(host, "clevermedia.com")
	   || dnsDomainIs(host, "cobblestonepub.com")
	   || dnsDomainIs(host, "codebrkr.infopages.net")
	   || dnsDomainIs(host, "colitz.com")
	   || dnsDomainIs(host, "collections.ic.gc.ca")
	   || dnsDomainIs(host, "coloquio.com")
	   || dnsDomainIs(host, "come.to")
	   || dnsDomainIs(host, "coombs.anu.edu.au")
	   || dnsDomainIs(host, "crafterscommunity.com")
	   || dnsDomainIs(host, "craftsforkids.about.com")
	   || dnsDomainIs(host, "creativity.net")
	   || dnsDomainIs(host, "cslewis.drzeus.net")
	   || dnsDomainIs(host, "cust.idl.com.au")
	   || dnsDomainIs(host, "cvs.anu.edu.au")
	   || dnsDomainIs(host, "cybersleuth-kids.com")
	   || dnsDomainIs(host, "cybertown.com")
	   || dnsDomainIs(host, "darkfish.com")
	   || dnsDomainIs(host, "datadragon.com")
	   || dnsDomainIs(host, "davesite.com")
	   || dnsDomainIs(host, "dbertens.www.cistron.nl")
	   || dnsDomainIs(host, "detnews.com")
	   || dnsDomainIs(host, "dhr.dos.state.fl.us")
	   || dnsDomainIs(host, "dialspace.dial.pipex.com")
	   || dnsDomainIs(host, "dictionaries.travlang.com")
	   || dnsDomainIs(host, "disney.go.com")
	   || dnsDomainIs(host, "disneyland.disney.go.com")
	   || dnsDomainIs(host, "district.gresham.k12.or.us")
	   || dnsDomainIs(host, "dmarie.com")
	   || dnsDomainIs(host, "dreamwater.com")
	   || dnsDomainIs(host, "duke.fuse.net")
	   || dnsDomainIs(host, "earlyamerica.com")
	   || dnsDomainIs(host, "earthsky.com")
	   || dnsDomainIs(host, "easyweb.easynet.co.uk")
	   || dnsDomainIs(host, "ecards1.bansheeweb.com")
	   || dnsDomainIs(host, "edugreen.teri.res.in")
	   || dnsDomainIs(host, "edwardlear.tripod.com")
	   || dnsDomainIs(host, "eelink.net")
	   || dnsDomainIs(host, "elizabethsings.com")
	   || dnsDomainIs(host, "enature.com")
	   || dnsDomainIs(host, "encarta.msn.com")
	   || dnsDomainIs(host, "endangeredspecie.com")
	   || dnsDomainIs(host, "enterprise.america.com")
	   || dnsDomainIs(host, "ericae.net")
	   || dnsDomainIs(host, "esl.about.com")
	   || dnsDomainIs(host, "eveander.com")
	   || dnsDomainIs(host, "exn.ca")
	   || dnsDomainIs(host, "fallscam.niagara.com")
	   || dnsDomainIs(host, "family.go.com")
	   || dnsDomainIs(host, "family2.go.com")
	   || dnsDomainIs(host, "familyeducation.com")
	   || dnsDomainIs(host, "finditquick.com")
	   || dnsDomainIs(host, "fln-bma.yazigi.com.br")
	   || dnsDomainIs(host, "fln-con.yazigi.com.br")
	   || dnsDomainIs(host, "food.epicurious.com")
	   || dnsDomainIs(host, "forums.sympatico.ca")
	   || dnsDomainIs(host, "fotw.vexillum.com")
	   || dnsDomainIs(host, "fox.nstn.ca")
	   || dnsDomainIs(host, "framingham.com")
	   || dnsDomainIs(host, "freevote.com")
	   || dnsDomainIs(host, "freeweb.pdq.net")
	   || dnsDomainIs(host, "games.yahoo.com")
	   || dnsDomainIs(host, "gardening.sierrahome.com")
	   || dnsDomainIs(host, "gardenofpraise.com")
	   || dnsDomainIs(host, "gcclearn.gcc.cc.va.us")
	   || dnsDomainIs(host, "genealogytoday.com")
	   || dnsDomainIs(host, "genesis.ne.mediaone.net")
	   || dnsDomainIs(host, "geniefind.com")
	   || dnsDomainIs(host, "geography.about.com")
	   || dnsDomainIs(host, "gf.state.wy.us")
	   || dnsDomainIs(host, "gi.grolier.com")
	   || dnsDomainIs(host, "golf.com")
	   || dnsDomainIs(host, "greatseal.com")
	   || dnsDomainIs(host, "guardians.net")
	   || dnsDomainIs(host, "hamlet.hypermart.net")
	   || dnsDomainIs(host, "happypuppy.com")
	   || dnsDomainIs(host, "harcourt.fsc.follett.com")
	   || dnsDomainIs(host, "haringkids.com")
	   || dnsDomainIs(host, "harrietmaysavitz.com")
	   || dnsDomainIs(host, "harrypotter.warnerbros.com")
	   || dnsDomainIs(host, "hca.gilead.org.il")
	   || dnsDomainIs(host, "header.future.easyspace.com")
	   || dnsDomainIs(host, "historymedren.about.com")
	   || dnsDomainIs(host, "home.att.net")
	   || dnsDomainIs(host, "home.austin.rr.com")
	   || dnsDomainIs(host, "home.capu.net")
	   || dnsDomainIs(host, "home.cfl.rr.com")
	   || dnsDomainIs(host, "home.clara.net")
	   || dnsDomainIs(host, "home.clear.net.nz")
	   || dnsDomainIs(host, "home.earthlink.net")
	   || dnsDomainIs(host, "home.eznet.net")
	   || dnsDomainIs(host, "home.flash.net")
	   || dnsDomainIs(host, "home.hiwaay.net")
	   || dnsDomainIs(host, "home.hkstar.com")
	   || dnsDomainIs(host, "home.ici.net")
	   || dnsDomainIs(host, "home.inreach.com")
	   || dnsDomainIs(host, "home.interlynx.net")
	   || dnsDomainIs(host, "home.istar.ca")
	   || dnsDomainIs(host, "home.mira.net")
	   || dnsDomainIs(host, "home.nycap.rr.com")
	   || dnsDomainIs(host, "home.online.no")
	   || dnsDomainIs(host, "home.pb.net")
	   || dnsDomainIs(host, "home2.pacific.net.sg")
	   || dnsDomainIs(host, "homearts.com")
	   || dnsDomainIs(host, "homepage.mac.com")
	   || dnsDomainIs(host, "hometown.aol.com")
	   || dnsDomainIs(host, "homiliesbyemail.com")
	   || dnsDomainIs(host, "hotei.fix.co.jp")
	   || dnsDomainIs(host, "hotwired.lycos.com")
	   || dnsDomainIs(host, "hp.vector.co.jp")
	   || dnsDomainIs(host, "hum.amu.edu.pl")
	   || dnsDomainIs(host, "i-cias.com")
	   || dnsDomainIs(host, "icatapults.freeservers.com")
	   || dnsDomainIs(host, "ind.cioe.com")
	   || dnsDomainIs(host, "info.ex.ac.uk")
	   || dnsDomainIs(host, "infocan.gc.ca")
	   || dnsDomainIs(host, "infoservice.gc.ca")
	   || dnsDomainIs(host, "interoz.com")
	   || dnsDomainIs(host, "ireland.iol.ie")
	   || dnsDomainIs(host, "is.dal.ca")
	   || dnsDomainIs(host, "itss.raytheon.com")
	   || dnsDomainIs(host, "iul.com")
	   || dnsDomainIs(host, "jameswhitcombriley.com")
	   || dnsDomainIs(host, "jellieszone.com")
	   || dnsDomainIs(host, "jordan.sportsline.com")
	   || dnsDomainIs(host, "judyanddavid.com")
	   || dnsDomainIs(host, "jurai.murdoch.edu.au")
	   || dnsDomainIs(host, "just.about.com")
	   || dnsDomainIs(host, "kayleigh.tierranet.com")
	   || dnsDomainIs(host, "kcwingwalker.tripod.com")
	   || dnsDomainIs(host, "kidexchange.about.com")
	   || dnsDomainIs(host, "kids-world.colgatepalmolive.com")
	   || dnsDomainIs(host, "kids.mysterynet.com")
	   || dnsDomainIs(host, "kids.ot.com")
	   || dnsDomainIs(host, "kidsartscrafts.about.com")
	   || dnsDomainIs(host, "kidsastronomy.about.com")
	   || dnsDomainIs(host, "kidscience.about.com")
	   || dnsDomainIs(host, "kidscience.miningco.com")
	   || dnsDomainIs(host, "kidscollecting.about.com")
	   || dnsDomainIs(host, "kidsfun.co.uk")
	   || dnsDomainIs(host, "kidsinternet.about.com")
	   || dnsDomainIs(host, "kidslangarts.about.com")
	   || dnsDomainIs(host, "kidspenpals.about.com")
	   || dnsDomainIs(host, "kitecast.com")
	   || dnsDomainIs(host, "knight.city.ba.k12.md.us")
	   || dnsDomainIs(host, "kodak.com")
	   || dnsDomainIs(host, "kwanzaa4kids.homestead.com")
	   || dnsDomainIs(host, "lagos.africaonline.com")
	   || dnsDomainIs(host, "lancearmstrong.com")
	   || dnsDomainIs(host, "landru.i-link-2.net")
	   || dnsDomainIs(host, "lang.nagoya-u.ac.jp")
	   || dnsDomainIs(host, "lascala.milano.it")
	   || dnsDomainIs(host, "latinoculture.about.com")
	   || dnsDomainIs(host, "litcal.yasuda-u.ac.jp")
	   || dnsDomainIs(host, "littlebit.com")
	   || dnsDomainIs(host, "live.edventures.com")
	   || dnsDomainIs(host, "look.net")
	   || dnsDomainIs(host, "lycoskids.infoplease.com")
	   || dnsDomainIs(host, "lynx.uio.no")
	   || dnsDomainIs(host, "macdict.dict.mq.edu.au")
	   || dnsDomainIs(host, "maori.culture.co.nz")
	   || dnsDomainIs(host, "marktwain.about.com")
	   || dnsDomainIs(host, "marktwain.miningco.com")
	   || dnsDomainIs(host, "mars2030.net")
	   || dnsDomainIs(host, "martin.parasitology.mcgill.ca")
	   || dnsDomainIs(host, "martinlutherking.8m.com")
	   || dnsDomainIs(host, "mastercollector.com")
	   || dnsDomainIs(host, "mathcentral.uregina.ca")
	   || dnsDomainIs(host, "members.aol.com")
	   || dnsDomainIs(host, "members.carol.net")
	   || dnsDomainIs(host, "members.cland.net")
	   || dnsDomainIs(host, "members.cruzio.com")
	   || dnsDomainIs(host, "members.easyspace.com")
	   || dnsDomainIs(host, "members.eisa.net.au")
	   || dnsDomainIs(host, "members.home.net")
	   || dnsDomainIs(host, "members.iinet.net.au")
	   || dnsDomainIs(host, "members.nbci.com")
	   || dnsDomainIs(host, "members.ozemail.com.au")
	   || dnsDomainIs(host, "members.surfsouth.com")
	   || dnsDomainIs(host, "members.theglobe.com")
	   || dnsDomainIs(host, "members.tripod.com")
	   || dnsDomainIs(host, "mexplaza.udg.mx")
	   || dnsDomainIs(host, "mgfx.com")
	   || dnsDomainIs(host, "microimg.com")
	   || dnsDomainIs(host, "midusa.net")
	   || dnsDomainIs(host, "mildan.com")
	   || dnsDomainIs(host, "millennianet.com")
	   || dnsDomainIs(host, "mindbreakers.e-fun.nu")
	   || dnsDomainIs(host, "missjanet.xs4all.nl")
	   || dnsDomainIs(host, "mistral.culture.fr")
	   || dnsDomainIs(host, "mobileation.com")
	   || dnsDomainIs(host, "mrshowbiz.go.com")
	   || dnsDomainIs(host, "ms.simplenet.com")
	   || dnsDomainIs(host, "museum.gov.ns.ca")
	   || dnsDomainIs(host, "music.excite.com")
	   || dnsDomainIs(host, "musicfinder.yahoo.com")
	   || dnsDomainIs(host, "my.freeway.net")
	   || dnsDomainIs(host, "mytrains.com")
	   || dnsDomainIs(host, "nativeauthors.com")
	   || dnsDomainIs(host, "nba.com")
	   || dnsDomainIs(host, "nch.ari.net")
	   || dnsDomainIs(host, "neonpeach.tripod.com")
	   || dnsDomainIs(host, "net.indra.com")
	   || dnsDomainIs(host, "ngeorgia.com")
	   || dnsDomainIs(host, "ngp.ngpc.state.ne.us")
	   || dnsDomainIs(host, "nhd.heinle.com")
	   || dnsDomainIs(host, "nick.com")
	   || dnsDomainIs(host, "normandy.eb.com")
	   || dnsDomainIs(host, "northshore.shore.net")
	   || dnsDomainIs(host, "now2000.com")
	   || dnsDomainIs(host, "npc.nunavut.ca")
	   || dnsDomainIs(host, "ns2.carib-link.net")
	   || dnsDomainIs(host, "ntl.sympatico.ca")
	   || dnsDomainIs(host, "oceanographer.navy.mil")
	   || dnsDomainIs(host, "oddens.geog.uu.nl")
	   || dnsDomainIs(host, "officialcitysites.com")
	   || dnsDomainIs(host, "oneida-nation.net")
	   || dnsDomainIs(host, "onlinegeorgia.com")
	   || dnsDomainIs(host, "originator_2.tripod.com")
	   || dnsDomainIs(host, "ortech-engr.com")
	   || dnsDomainIs(host, "osage.voorhees.k12.nj.us")
	   || dnsDomainIs(host, "osiris.sund.ac.uk")
	   || dnsDomainIs(host, "ourworld.compuserve.com")
	   || dnsDomainIs(host, "outdoorphoto.com")
	   || dnsDomainIs(host, "pages.map.com")
	   || dnsDomainIs(host, "pages.prodigy.com")
	   || dnsDomainIs(host, "pages.prodigy.net")
	   || dnsDomainIs(host, "pages.tca.net")
	   || dnsDomainIs(host, "parcsafari.qc.ca")
	   || dnsDomainIs(host, "parenthoodweb.com")
	   || dnsDomainIs(host, "pathfinder.com")
	   || dnsDomainIs(host, "people.clarityconnect.com")
	   || dnsDomainIs(host, "people.enternet.com.au")
	   || dnsDomainIs(host, "people.ne.mediaone.net")
	   || dnsDomainIs(host, "phonics.jazzles.com")
	   || dnsDomainIs(host, "pibburns.com")
	   || dnsDomainIs(host, "pilgrims.net")
	   || dnsDomainIs(host, "pinenet.com")
	   || dnsDomainIs(host, "place.scholastic.com")
	   || dnsDomainIs(host, "playground.kodak.com")
	   || dnsDomainIs(host, "politicalgraveyard.com")
	   || dnsDomainIs(host, "polk.ga.net")
	   || dnsDomainIs(host, "pompstory.home.mindspring.com")
	   || dnsDomainIs(host, "popularmechanics.com")
	   || dnsDomainIs(host, "projects.edtech.sandi.net")
	   || dnsDomainIs(host, "psyche.usno.navy.mil")
	   || dnsDomainIs(host, "pubweb.parc.xerox.com")
	   || dnsDomainIs(host, "puzzlemaker.school.discovery.com")
	   || dnsDomainIs(host, "quest.classroom.com")
	   || dnsDomainIs(host, "quilting.about.com")
	   || dnsDomainIs(host, "rabbitmoon.home.mindspring.com")
	   || dnsDomainIs(host, "radio.cbc.ca")
	   || dnsDomainIs(host, "rats2u.com")
	   || dnsDomainIs(host, "rbcm1.rbcm.gov.bc.ca")
	   || dnsDomainIs(host, "readplay.com")
	   || dnsDomainIs(host, "recipes4children.homestead.com")
	   || dnsDomainIs(host, "redsox.com")
	   || dnsDomainIs(host, "renaissance.district96.k12.il.us")
	   || dnsDomainIs(host, "rhyme.lycos.com")
	   || dnsDomainIs(host, "rhythmweb.com")
	   || dnsDomainIs(host, "riverresource.com")
	   || dnsDomainIs(host, "rockhoundingar.com")
	   || dnsDomainIs(host, "rockies.mlb.com")
	   || dnsDomainIs(host, "rosecity.net")
	   || dnsDomainIs(host, "rr-vs.informatik.uni-ulm.de")
	   || dnsDomainIs(host, "rubens.anu.edu.au")
	   || dnsDomainIs(host, "rummelplatz.uni-mannheim.de")
	   || dnsDomainIs(host, "sandbox.xerox.com")
	   || dnsDomainIs(host, "sarah.fredart.com")
	   || dnsDomainIs(host, "schmidel.com")
	   || dnsDomainIs(host, "scholastic.com")
	   || dnsDomainIs(host, "school.discovery.com")
	   || dnsDomainIs(host, "schoolcentral.com")
	   || dnsDomainIs(host, "seattletimes.nwsource.com")
	   || dnsDomainIs(host, "sericulum.com")
	   || dnsDomainIs(host, "sf.airforce.com")
	   || dnsDomainIs(host, "shop.usps.com")
	   || dnsDomainIs(host, "showcase.netins.net")
	   || dnsDomainIs(host, "sikids.com")
	   || dnsDomainIs(host, "sites.huji.ac.il")
	   || dnsDomainIs(host, "sjliving.com")
	   || dnsDomainIs(host, "skullduggery.com")
	   || dnsDomainIs(host, "skyways.lib.ks.us")
	   || dnsDomainIs(host, "snowdaymovie.nick.com")
	   || dnsDomainIs(host, "sosa21.hypermart.net")
	   || dnsDomainIs(host, "soundamerica.com")
	   || dnsDomainIs(host, "spaceboy.nasda.go.jp")
	   || dnsDomainIs(host, "sports.nfl.com")
	   || dnsDomainIs(host, "sportsillustrated.cnn.com")
	   || dnsDomainIs(host, "starwars.hasbro.com")
	   || dnsDomainIs(host, "statelibrary.dcr.state.nc.us")
	   || dnsDomainIs(host, "streetplay.com")
	   || dnsDomainIs(host, "sts.gsc.nrcan.gc.ca")
	   || dnsDomainIs(host, "sunniebunniezz.com")
	   || dnsDomainIs(host, "sunsite.nus.edu.sg")
	   || dnsDomainIs(host, "sunsite.sut.ac.jp")
	   || dnsDomainIs(host, "superm.bart.nl")
	   || dnsDomainIs(host, "surf.to")
	   || dnsDomainIs(host, "svinet2.fs.fed.us")
	   || dnsDomainIs(host, "swiminfo.com")
	   || dnsDomainIs(host, "tabletennis.about.com")
	   || dnsDomainIs(host, "teacher.scholastic.com")
	   || dnsDomainIs(host, "theforce.net")
	   || dnsDomainIs(host, "thejessicas.homestead.com")
	   || dnsDomainIs(host, "themes.editthispage.com")
	   || dnsDomainIs(host, "theory.uwinnipeg.ca")
	   || dnsDomainIs(host, "theshadowlands.net")
	   || dnsDomainIs(host, "thinks.com")
	   || dnsDomainIs(host, "thryomanes.tripod.com")
	   || dnsDomainIs(host, "time_zone.tripod.com")
	   || dnsDomainIs(host, "titania.cobuild.collins.co.uk")
	   || dnsDomainIs(host, "torre.duomo.pisa.it")
	   || dnsDomainIs(host, "touregypt.net")
	   || dnsDomainIs(host, "toycollecting.about.com")
	   || dnsDomainIs(host, "trace.ntu.ac.uk")
	   || dnsDomainIs(host, "travelwithkids.about.com")
	   || dnsDomainIs(host, "tukids.tucows.com")
	   || dnsDomainIs(host, "tv.yahoo.com")
	   || dnsDomainIs(host, "tycho.usno.navy.mil")
	   || dnsDomainIs(host, "ubl.artistdirect.com")
	   || dnsDomainIs(host, "uk-pages.net")
	   || dnsDomainIs(host, "ukraine.uazone.net")
	   || dnsDomainIs(host, "unmuseum.mus.pa.us")
	   || dnsDomainIs(host, "us.imdb.com")
	   || dnsDomainIs(host, "userpage.chemie.fu-berlin.de")
	   || dnsDomainIs(host, "userpage.fu-berlin.de")
	   || dnsDomainIs(host, "userpages.aug.com")
	   || dnsDomainIs(host, "users.aol.com")
	   || dnsDomainIs(host, "users.bigpond.net.au")
	   || dnsDomainIs(host, "users.breathemail.net")
	   || dnsDomainIs(host, "users.erols.com")
	   || dnsDomainIs(host, "users.imag.net")
	   || dnsDomainIs(host, "users.inetw.net")
	   || dnsDomainIs(host, "users.massed.net")
	   || dnsDomainIs(host, "users.skynet.be")
	   || dnsDomainIs(host, "users.uniserve.com")
	   || dnsDomainIs(host, "venus.spaceports.com")
	   || dnsDomainIs(host, "vgstrategies.about.com")
	   || dnsDomainIs(host, "victorian.fortunecity.com")
	   || dnsDomainIs(host, "vilenski.com")
	   || dnsDomainIs(host, "village.infoweb.ne.jp")
	   || dnsDomainIs(host, "virtual.finland.fi")
	   || dnsDomainIs(host, "vrml.fornax.hu")
	   || dnsDomainIs(host, "vvv.com")
	   || dnsDomainIs(host, "w1.xrefer.com")
	   || dnsDomainIs(host, "w3.one.net")
	   || dnsDomainIs(host, "w3.rz-berlin.mpg.de")
	   || dnsDomainIs(host, "w3.trib.com")
	   || dnsDomainIs(host, "wallofsound.go.com")
	   || dnsDomainIs(host, "web.aimnet.com")
	   || dnsDomainIs(host, "web.ccsd.k12.wy.us")
	   || dnsDomainIs(host, "web.cs.ualberta.ca")
	   || dnsDomainIs(host, "web.idirect.com")
	   || dnsDomainIs(host, "web.kyoto-inet.or.jp")
	   || dnsDomainIs(host, "web.macam98.ac.il")
	   || dnsDomainIs(host, "web.massvacation.com")
	   || dnsDomainIs(host, "web.one.net.au")
	   || dnsDomainIs(host, "web.qx.net")
	   || dnsDomainIs(host, "web.uvic.ca")
	   || dnsDomainIs(host, "web2.airmail.net")
	   || dnsDomainIs(host, "webcoast.com")
	   || dnsDomainIs(host, "webgames.kalisto.com")
	   || dnsDomainIs(host, "webhome.idirect.com")
	   || dnsDomainIs(host, "webpages.homestead.com")
	   || dnsDomainIs(host, "webrum.uni-mannheim.de")
	   || dnsDomainIs(host, "webusers.anet-stl.com")
	   || dnsDomainIs(host, "welcome.to")
	   || dnsDomainIs(host, "wgntv.com")
	   || dnsDomainIs(host, "whales.magna.com.au")
	   || dnsDomainIs(host, "wildheart.com")
	   || dnsDomainIs(host, "wilstar.net")
	   || dnsDomainIs(host, "winter-wonderland.com")
	   || dnsDomainIs(host, "women.com")
	   || dnsDomainIs(host, "woodrow.mpls.frb.fed.us")
	   || dnsDomainIs(host, "wordzap.com")
	   || dnsDomainIs(host, "worldkids.net")
	   || dnsDomainIs(host, "worldwideguide.net")
	   || dnsDomainIs(host, "ww3.bay.k12.fl.us")
	   || dnsDomainIs(host, "ww3.sportsline.com")
	   || dnsDomainIs(host, "www-groups.dcs.st-and.ac.uk")
	   || dnsDomainIs(host, "www-public.rz.uni-duesseldorf.de")
	   || dnsDomainIs(host, "www.1stkids.com")
	   || dnsDomainIs(host, "www.2020tech.com")
	   || dnsDomainIs(host, "www.21stcenturytoys.com")
	   || dnsDomainIs(host, "www.4adventure.com")
	   || dnsDomainIs(host, "www.50states.com")
	   || dnsDomainIs(host, "www.800padutch.com")
	   || dnsDomainIs(host, "www.88.com")
	   || dnsDomainIs(host, "www.a-better.com")
	   || dnsDomainIs(host, "www.aaa.com.au")
	   || dnsDomainIs(host, "www.aacca.com")
	   || dnsDomainIs(host, "www.aalbc.com")
	   || dnsDomainIs(host, "www.aardman.com")
	   || dnsDomainIs(host, "www.aardvarkelectric.com")
	   || dnsDomainIs(host, "www.aawc.com")
	   || dnsDomainIs(host, "www.ababmx.com")
	   || dnsDomainIs(host, "www.abbeville.com")
	   || dnsDomainIs(host, "www.abc.net.au")
	   || dnsDomainIs(host, "www.abcb.com")
	   || dnsDomainIs(host, "www.abctooncenter.com")
	   || dnsDomainIs(host, "www.about.ch")
	   || dnsDomainIs(host, "www.accessart.org.uk")
	   || dnsDomainIs(host, "www.accu.or.jp")
	   || dnsDomainIs(host, "www.accuweather.com")
	   || dnsDomainIs(host, "www.achuka.co.uk")
	   || dnsDomainIs(host, "www.acmecity.com")
	   || dnsDomainIs(host, "www.acorn-group.com")
	   || dnsDomainIs(host, "www.acs.ucalgary.ca")
	   || dnsDomainIs(host, "www.actden.com")
	   || dnsDomainIs(host, "www.actionplanet.com")
	   || dnsDomainIs(host, "www.activityvillage.co.uk")
	   || dnsDomainIs(host, "www.actwin.com")
	   || dnsDomainIs(host, "www.adequate.com")
	   || dnsDomainIs(host, "www.adidas.com")
	   || dnsDomainIs(host, "www.advent-calendars.com")
	   || dnsDomainIs(host, "www.aegis.com")
	   || dnsDomainIs(host, "www.af.mil")
	   || dnsDomainIs(host, "www.africaindex.africainfo.no")
	   || dnsDomainIs(host, "www.africam.com")
	   || dnsDomainIs(host, "www.africancrafts.com")
	   || dnsDomainIs(host, "www.aggressive.com")
	   || dnsDomainIs(host, "www.aghines.com")
	   || dnsDomainIs(host, "www.agirlsworld.com")
	   || dnsDomainIs(host, "www.agora.stm.it")
	   || dnsDomainIs(host, "www.agriculture.com")
	   || dnsDomainIs(host, "www.aikidofaq.com")
	   || dnsDomainIs(host, "www.ajkids.com")
	   || dnsDomainIs(host, "www.akfkoala.gil.com.au")
	   || dnsDomainIs(host, "www.akhlah.com")
	   || dnsDomainIs(host, "www.alabamainfo.com")
	   || dnsDomainIs(host, "www.aland.fi")
	   || dnsDomainIs(host, "www.albion.com")
	   || dnsDomainIs(host, "www.alcoholismhelp.com")
	   || dnsDomainIs(host, "www.alcottweb.com")
	   || dnsDomainIs(host, "www.alfanet.it")
	   || dnsDomainIs(host, "www.alfy.com")
	   || dnsDomainIs(host, "www.algebra-online.com")
	   || dnsDomainIs(host, "www.alienexplorer.com")
	   || dnsDomainIs(host, "www.aliensatschool.com")
	   || dnsDomainIs(host, "www.all-links.com")
	   || dnsDomainIs(host, "www.alldetroit.com")
	   || dnsDomainIs(host, "www.allexperts.com")
	   || dnsDomainIs(host, "www.allmixedup.com")
	   || dnsDomainIs(host, "www.allmusic.com")
	   || dnsDomainIs(host, "www.almanac.com")
	   || dnsDomainIs(host, "www.almaz.com")
	   || dnsDomainIs(host, "www.almondseed.com")
	   || dnsDomainIs(host, "www.aloha.com")
	   || dnsDomainIs(host, "www.aloha.net")
	   || dnsDomainIs(host, "www.altonweb.com")
	   || dnsDomainIs(host, "www.alyeska-pipe.com")
	   || dnsDomainIs(host, "www.am-wood.com")
	   || dnsDomainIs(host, "www.amazingadventure.com")
	   || dnsDomainIs(host, "www.amazon.com")
	   || dnsDomainIs(host, "www.americancheerleader.com")
	   || dnsDomainIs(host, "www.americancowboy.com")
	   || dnsDomainIs(host, "www.americangirl.com")
	   || dnsDomainIs(host, "www.americanparknetwork.com")
	   || dnsDomainIs(host, "www.americansouthwest.net")
	   || dnsDomainIs(host, "www.americanwest.com")
	   || dnsDomainIs(host, "www.ameritech.net")
	   || dnsDomainIs(host, "www.amtexpo.com")
	   || dnsDomainIs(host, "www.anbg.gov.au")
	   || dnsDomainIs(host, "www.anc.org.za")
	   || dnsDomainIs(host, "www.ancientegypt.co.uk")
	   || dnsDomainIs(host, "www.angelfire.com")
	   || dnsDomainIs(host, "www.angelsbaseball.com")
	   || dnsDomainIs(host, "www.anholt.co.uk")
	   || dnsDomainIs(host, "www.animabets.com")
	   || dnsDomainIs(host, "www.animalnetwork.com")
	   || dnsDomainIs(host, "www.animalpicturesarchive.com")
	   || dnsDomainIs(host, "www.anime-genesis.com")
	   || dnsDomainIs(host, "www.annefrank.com")
	   || dnsDomainIs(host, "www.annefrank.nl")
	   || dnsDomainIs(host, "www.annie75.com")
	   || dnsDomainIs(host, "www.antbee.com")
	   || dnsDomainIs(host, "www.antiquetools.com")
	   || dnsDomainIs(host, "www.antiquetoy.com")
	   || dnsDomainIs(host, "www.anzsbeg.org.au")
	   || dnsDomainIs(host, "www.aol.com")
	   || dnsDomainIs(host, "www.aone.com")
	   || dnsDomainIs(host, "www.aphids.com")
	   || dnsDomainIs(host, "www.apl.com")
	   || dnsDomainIs(host, "www.aplusmath.com")
	   || dnsDomainIs(host, "www.applebookshop.co.uk")
	   || dnsDomainIs(host, "www.appropriatesoftware.com")
	   || dnsDomainIs(host, "www.appukids.com")
	   || dnsDomainIs(host, "www.april-joy.com")
	   || dnsDomainIs(host, "www.arab.net")
	   || dnsDomainIs(host, "www.aracnet.com")
	   || dnsDomainIs(host, "www.arborday.com")
	   || dnsDomainIs(host, "www.arcadevillage.com")
	   || dnsDomainIs(host, "www.archiecomics.com")
	   || dnsDomainIs(host, "www.archives.state.al.us")
	   || dnsDomainIs(host, "www.arctic.ca")
	   || dnsDomainIs(host, "www.ardenjohnson.com")
	   || dnsDomainIs(host, "www.aristotle.net")
	   || dnsDomainIs(host, "www.arizhwys.com")
	   || dnsDomainIs(host, "www.arizonaguide.com")
	   || dnsDomainIs(host, "www.arlingtoncemetery.com")
	   || dnsDomainIs(host, "www.armory.com")
	   || dnsDomainIs(host, "www.armwrestling.com")
	   || dnsDomainIs(host, "www.arnprior.com")
	   || dnsDomainIs(host, "www.artabunga.com")
	   || dnsDomainIs(host, "www.artcarte.com")
	   || dnsDomainIs(host, "www.artchive.com")
	   || dnsDomainIs(host, "www.artcontest.com")
	   || dnsDomainIs(host, "www.artcyclopedia.com")
	   || dnsDomainIs(host, "www.artisandevelopers.com")
	   || dnsDomainIs(host, "www.artlex.com")
	   || dnsDomainIs(host, "www.artsandkids.com")
	   || dnsDomainIs(host, "www.artyastro.com")
	   || dnsDomainIs(host, "www.arwhead.com")
	   || dnsDomainIs(host, "www.asahi-net.or.jp")
	   || dnsDomainIs(host, "www.asap.unimelb.edu.au")
	   || dnsDomainIs(host, "www.ascpl.lib.oh.us")
	   || dnsDomainIs(host, "www.asia-art.net")
	   || dnsDomainIs(host, "www.asiabigtime.com")
	   || dnsDomainIs(host, "www.asianart.com")
	   || dnsDomainIs(host, "www.asiatour.com")
	   || dnsDomainIs(host, "www.asiaweek.com")
	   || dnsDomainIs(host, "www.askanexpert.com")
	   || dnsDomainIs(host, "www.askbasil.com")
	   || dnsDomainIs(host, "www.assa.org.au")
	   || dnsDomainIs(host, "www.ast.cam.ac.uk")
	   || dnsDomainIs(host, "www.astronomy.com")
	   || dnsDomainIs(host, "www.astros.com")
	   || dnsDomainIs(host, "www.atek.com")
	   || dnsDomainIs(host, "www.athlete.com")
	   || dnsDomainIs(host, "www.athropolis.com")
	   || dnsDomainIs(host, "www.atkielski.com")
	   || dnsDomainIs(host, "www.atlantabraves.com")
	   || dnsDomainIs(host, "www.atlantafalcons.com")
	   || dnsDomainIs(host, "www.atlantathrashers.com")
	   || dnsDomainIs(host, "www.atlanticus.com")
	   || dnsDomainIs(host, "www.atm.ch.cam.ac.uk")
	   || dnsDomainIs(host, "www.atom.co.jp")
	   || dnsDomainIs(host, "www.atomicarchive.com")
	   || dnsDomainIs(host, "www.att.com")
	   || dnsDomainIs(host, "www.audreywood.com")
	   || dnsDomainIs(host, "www.auntannie.com")
	   || dnsDomainIs(host, "www.auntie.com")
	   || dnsDomainIs(host, "www.avi-writer.com")
	   || dnsDomainIs(host, "www.awesomeclipartforkids.com")
	   || dnsDomainIs(host, "www.awhitehorse.com")
	   || dnsDomainIs(host, "www.axess.com")
	   || dnsDomainIs(host, "www.ayles.com")
	   || dnsDomainIs(host, "www.ayn.ca")
	   || dnsDomainIs(host, "www.azcardinals.com")
	   || dnsDomainIs(host, "www.azdiamondbacks.com")
	   || dnsDomainIs(host, "www.azsolarcenter.com")
	   || dnsDomainIs(host, "www.azstarnet.com")
	   || dnsDomainIs(host, "www.aztecafoods.com")
	   || dnsDomainIs(host, "www.b-witched.com")
	   || dnsDomainIs(host, "www.baberuthmuseum.com")
	   || dnsDomainIs(host, "www.backstreetboys.com")
	   || dnsDomainIs(host, "www.bagheera.com")
	   || dnsDomainIs(host, "www.bahamas.com")
	   || dnsDomainIs(host, "www.baileykids.com")
	   || dnsDomainIs(host, "www.baldeagleinfo.com")
	   || dnsDomainIs(host, "www.balloonhq.com")
	   || dnsDomainIs(host, "www.balloonzone.com")
	   || dnsDomainIs(host, "www.ballparks.com")
	   || dnsDomainIs(host, "www.balmoralsoftware.com")
	   || dnsDomainIs(host, "www.banja.com")
	   || dnsDomainIs(host, "www.banph.com")
	   || dnsDomainIs(host, "www.barbie.com")
	   || dnsDomainIs(host, "www.barkingbuddies.com")
	   || dnsDomainIs(host, "www.barnsdle.demon.co.uk")
	   || dnsDomainIs(host, "www.barrysclipart.com")
	   || dnsDomainIs(host, "www.bartleby.com")
	   || dnsDomainIs(host, "www.baseplate.com")
	   || dnsDomainIs(host, "www.batman-superman.com")
	   || dnsDomainIs(host, "www.batmanbeyond.com")
	   || dnsDomainIs(host, "www.bbc.co.uk")
	   || dnsDomainIs(host, "www.bbhighway.com")
	   || dnsDomainIs(host, "www.bboy.com")
	   || dnsDomainIs(host, "www.bcit.tec.nj.us")
	   || dnsDomainIs(host, "www.bconnex.net")
	   || dnsDomainIs(host, "www.bcpl.net")
	   || dnsDomainIs(host, "www.beach-net.com")
	   || dnsDomainIs(host, "www.beachboys.com")
	   || dnsDomainIs(host, "www.beakman.com")
	   || dnsDomainIs(host, "www.beano.co.uk")
	   || dnsDomainIs(host, "www.beans.demon.co.uk")
	   || dnsDomainIs(host, "www.beartime.com")
	   || dnsDomainIs(host, "www.bearyspecial.co.uk")
	   || dnsDomainIs(host, "www.bedtime.com")
	   || dnsDomainIs(host, "www.beingme.com")
	   || dnsDomainIs(host, "www.belizeexplorer.com")
	   || dnsDomainIs(host, "www.bell-labs.com")
	   || dnsDomainIs(host, "www.bemorecreative.com")
	   || dnsDomainIs(host, "www.bengals.com")
	   || dnsDomainIs(host, "www.benjerry.com")
	   || dnsDomainIs(host, "www.bennygoodsport.com")
	   || dnsDomainIs(host, "www.berenstainbears.com")
	   || dnsDomainIs(host, "www.beringia.com")
	   || dnsDomainIs(host, "www.beritsbest.com")
	   || dnsDomainIs(host, "www.berksweb.com")
	   || dnsDomainIs(host, "www.best.com")
	   || dnsDomainIs(host, "www.betsybyars.com")
	   || dnsDomainIs(host, "www.bfro.net")
	   || dnsDomainIs(host, "www.bgmm.com")
	   || dnsDomainIs(host, "www.bibliography.com")
	   || dnsDomainIs(host, "www.bigblue.com.au")
	   || dnsDomainIs(host, "www.bigchalk.com")
	   || dnsDomainIs(host, "www.bigidea.com")
	   || dnsDomainIs(host, "www.bigtop.com")
	   || dnsDomainIs(host, "www.bikecrawler.com")
	   || dnsDomainIs(host, "www.billboard.com")
	   || dnsDomainIs(host, "www.billybear4kids.com")
	   || dnsDomainIs(host, "www.biography.com")
	   || dnsDomainIs(host, "www.birdnature.com")
	   || dnsDomainIs(host, "www.birdsnways.com")
	   || dnsDomainIs(host, "www.birdtimes.com")
	   || dnsDomainIs(host, "www.birminghamzoo.com")
	   || dnsDomainIs(host, "www.birthdaypartyideas.com")
	   || dnsDomainIs(host, "www.bis.arachsys.com")
	   || dnsDomainIs(host, "www.bkgm.com")
	   || dnsDomainIs(host, "www.blackbaseball.com")
	   || dnsDomainIs(host, "www.blackbeardthepirate.com")
	   || dnsDomainIs(host, "www.blackbeltmag.com")
	   || dnsDomainIs(host, "www.blackfacts.com")
	   || dnsDomainIs(host, "www.blackfeetnation.com")
	   || dnsDomainIs(host, "www.blackhills-info.com")
	   || dnsDomainIs(host, "www.blackholegang.com")
	   || dnsDomainIs(host, "www.blaque.net")
	   || dnsDomainIs(host, "www.blarg.net")
	   || dnsDomainIs(host, "www.blasternaut.com")
	   || dnsDomainIs(host, "www.blizzard.com")
	   || dnsDomainIs(host, "www.blocksite.com")
	   || dnsDomainIs(host, "www.bluejackets.com")
	   || dnsDomainIs(host, "www.bluejays.ca")
	   || dnsDomainIs(host, "www.bluemountain.com")
	   || dnsDomainIs(host, "www.blupete.com")
	   || dnsDomainIs(host, "www.blyton.co.uk")
	   || dnsDomainIs(host, "www.boatnerd.com")
	   || dnsDomainIs(host, "www.boatsafe.com")
	   || dnsDomainIs(host, "www.bonus.com")
	   || dnsDomainIs(host, "www.boowakwala.com")
	   || dnsDomainIs(host, "www.bostonbruins.com")
	   || dnsDomainIs(host, "www.braceface.com")
	   || dnsDomainIs(host, "www.bracesinfo.com")
	   || dnsDomainIs(host, "www.bradkent.com")
	   || dnsDomainIs(host, "www.brainium.com")
	   || dnsDomainIs(host, "www.brainmania.com")
	   || dnsDomainIs(host, "www.brainpop.com")
	   || dnsDomainIs(host, "www.bridalcave.com")
	   || dnsDomainIs(host, "www.brightmoments.com")
	   || dnsDomainIs(host, "www.britannia.com")
	   || dnsDomainIs(host, "www.britannica.com")
	   || dnsDomainIs(host, "www.british-museum.ac.uk")
	   || dnsDomainIs(host, "www.brookes.ac.uk")
	   || dnsDomainIs(host, "www.brookfieldreader.com")
	   || dnsDomainIs(host, "www.btinternet.com")
	   || dnsDomainIs(host, "www.bubbledome.co.nz")
	   || dnsDomainIs(host, "www.buccaneers.com")
	   || dnsDomainIs(host, "www.buffy.com")
	   || dnsDomainIs(host, "www.bullying.co.uk")
	   || dnsDomainIs(host, "www.bumply.com")
	   || dnsDomainIs(host, "www.bungi.com")
	   || dnsDomainIs(host, "www.burlco.lib.nj.us")
	   || dnsDomainIs(host, "www.burlingamepezmuseum.com")
	   || dnsDomainIs(host, "www.bus.ualberta.ca")
	   || dnsDomainIs(host, "www.busprod.com")
	   || dnsDomainIs(host, "www.butlerart.com")
	   || dnsDomainIs(host, "www.butterflies.com")
	   || dnsDomainIs(host, "www.butterflyfarm.co.cr")
	   || dnsDomainIs(host, "www.bway.net")
	   || dnsDomainIs(host, "www.bydonovan.com")
	   || dnsDomainIs(host, "www.ca-mall.com")
	   || dnsDomainIs(host, "www.cabinessence.com")
	   || dnsDomainIs(host, "www.cablecarmuseum.com")
	   || dnsDomainIs(host, "www.cadbury.co.uk")
	   || dnsDomainIs(host, "www.calendarzone.com")
	   || dnsDomainIs(host, "www.calgaryflames.com")
	   || dnsDomainIs(host, "www.californiamissions.com")
	   || dnsDomainIs(host, "www.camalott.com")
	   || dnsDomainIs(host, "www.camelotintl.com")
	   || dnsDomainIs(host, "www.campbellsoup.com")
	   || dnsDomainIs(host, "www.camvista.com")
	   || dnsDomainIs(host, "www.canadiens.com")
	   || dnsDomainIs(host, "www.canals.state.ny.us")
	   || dnsDomainIs(host, "www.candlelightstories.com")
	   || dnsDomainIs(host, "www.candles-museum.com")
	   || dnsDomainIs(host, "www.candystand.com")
	   || dnsDomainIs(host, "www.caneshockey.com")
	   || dnsDomainIs(host, "www.canismajor.com")
	   || dnsDomainIs(host, "www.canucks.com")
	   || dnsDomainIs(host, "www.capecod.net")
	   || dnsDomainIs(host, "www.capital.net")
	   || dnsDomainIs(host, "www.capstonestudio.com")
	   || dnsDomainIs(host, "www.cardblvd.com")
	   || dnsDomainIs(host, "www.caro.net")
	   || dnsDomainIs(host, "www.carolhurst.com")
	   || dnsDomainIs(host, "www.carr.lib.md.us")
	   || dnsDomainIs(host, "www.cartooncorner.com")
	   || dnsDomainIs(host, "www.cartooncritters.com")
	   || dnsDomainIs(host, "www.cartoonnetwork.com")
	   || dnsDomainIs(host, "www.carvingpatterns.com")
	   || dnsDomainIs(host, "www.cashuniversity.com")
	   || dnsDomainIs(host, "www.castles-of-britain.com")
	   || dnsDomainIs(host, "www.castlewales.com")
	   || dnsDomainIs(host, "www.catholic-forum.com")
	   || dnsDomainIs(host, "www.catholic.net")
	   || dnsDomainIs(host, "www.cattle.guelph.on.ca")
	   || dnsDomainIs(host, "www.cavedive.com")
	   || dnsDomainIs(host, "www.caveofthewinds.com")
	   || dnsDomainIs(host, "www.cbc4kids.ca")
	   || dnsDomainIs(host, "www.ccer.ggl.ruu.nl")
	   || dnsDomainIs(host, "www.ccnet.com")
	   || dnsDomainIs(host, "www.celineonline.com")
	   || dnsDomainIs(host, "www.cellsalive.com")
	   || dnsDomainIs(host, "www.centuryinshoes.com")
	   || dnsDomainIs(host, "www.cfl.ca")
	   || dnsDomainIs(host, "www.channel4.com")
	   || dnsDomainIs(host, "www.channel8.net")
	   || dnsDomainIs(host, "www.chanukah99.com")
	   || dnsDomainIs(host, "www.charged.com")
	   || dnsDomainIs(host, "www.chargers.com")
	   || dnsDomainIs(host, "www.charlotte.com")
	   || dnsDomainIs(host, "www.chaseday.com")
	   || dnsDomainIs(host, "www.chateauversailles.fr")
	   || dnsDomainIs(host, "www.cheatcc.com")
	   || dnsDomainIs(host, "www.cheerleading.net")
	   || dnsDomainIs(host, "www.cheese.com")
	   || dnsDomainIs(host, "www.chem4kids.com")
	   || dnsDomainIs(host, "www.chemicool.com")
	   || dnsDomainIs(host, "www.cherbearsden.com")
	   || dnsDomainIs(host, "www.chesskids.com")
	   || dnsDomainIs(host, "www.chessvariants.com")
	   || dnsDomainIs(host, "www.cheungswingchun.com")
	   || dnsDomainIs(host, "www.chevroncars.com")
	   || dnsDomainIs(host, "www.chibi.simplenet.com")
	   || dnsDomainIs(host, "www.chicagobears.com")
	   || dnsDomainIs(host, "www.chicagoblackhawks.com")
	   || dnsDomainIs(host, "www.chickasaw.net")
	   || dnsDomainIs(host, "www.childrensmusic.co.uk")
	   || dnsDomainIs(host, "www.childrenssoftware.com")
	   || dnsDomainIs(host, "www.childrenstory.com")
	   || dnsDomainIs(host, "www.childrenwithdiabetes.com")
	   || dnsDomainIs(host, "www.chinapage.com")
	   || dnsDomainIs(host, "www.chinatoday.com")
	   || dnsDomainIs(host, "www.chinavista.com")
	   || dnsDomainIs(host, "www.chinnet.net")
	   || dnsDomainIs(host, "www.chiquita.com")
	   || dnsDomainIs(host, "www.chisox.com")
	   || dnsDomainIs(host, "www.chivalry.com")
	   || dnsDomainIs(host, "www.christiananswers.net")
	   || dnsDomainIs(host, "www.christianity.com")
	   || dnsDomainIs(host, "www.christmas.com")
	   || dnsDomainIs(host, "www.christmas98.com")
	   || dnsDomainIs(host, "www.chron.com")
	   || dnsDomainIs(host, "www.chronique.com")
	   || dnsDomainIs(host, "www.chuckecheese.com")
	   || dnsDomainIs(host, "www.chucklebait.com")
	   || dnsDomainIs(host, "www.chunkymonkey.com")
	   || dnsDomainIs(host, "www.ci.chi.il.us")
	   || dnsDomainIs(host, "www.ci.nyc.ny.us")
	   || dnsDomainIs(host, "www.ci.phoenix.az.us")
	   || dnsDomainIs(host, "www.ci.san-diego.ca.us")
	   || dnsDomainIs(host, "www.cibc.com")
	   || dnsDomainIs(host, "www.ciderpresspottery.com")
	   || dnsDomainIs(host, "www.cincinnatireds.com")
	   || dnsDomainIs(host, "www.circusparade.com")
	   || dnsDomainIs(host, "www.circusweb.com")
	   || dnsDomainIs(host, "www.cirquedusoleil.com")
	   || dnsDomainIs(host, "www.cit.state.vt.us")
	   || dnsDomainIs(host, "www.citycastles.com")
	   || dnsDomainIs(host, "www.cityu.edu.hk")
	   || dnsDomainIs(host, "www.civicmind.com")
	   || dnsDomainIs(host, "www.civil-war.net")
	   || dnsDomainIs(host, "www.civilization.ca")
	   || dnsDomainIs(host, "www.cl.cam.ac.uk")
	   || dnsDomainIs(host, "www.clantongang.com")
	   || dnsDomainIs(host, "www.clark.net")
	   || dnsDomainIs(host, "www.classicgaming.com")
	   || dnsDomainIs(host, "www.claus.com")
	   || dnsDomainIs(host, "www.clayz.com")
	   || dnsDomainIs(host, "www.clearcf.uvic.ca")
	   || dnsDomainIs(host, "www.clearlight.com")
	   || dnsDomainIs(host, "www.clemusart.com")
	   || dnsDomainIs(host, "www.clevelandbrowns.com")
	   || dnsDomainIs(host, "www.clipartcastle.com")
	   || dnsDomainIs(host, "www.clubi.ie")
	   || dnsDomainIs(host, "www.cnn.com")
	   || dnsDomainIs(host, "www.co.henrico.va.us")
	   || dnsDomainIs(host, "www.coax.net")
	   || dnsDomainIs(host, "www.cocacola.com")
	   || dnsDomainIs(host, "www.cocori.com")
	   || dnsDomainIs(host, "www.codesmiths.com")
	   || dnsDomainIs(host, "www.codetalk.fed.us")
	   || dnsDomainIs(host, "www.coin-gallery.com")
	   || dnsDomainIs(host, "www.colinthompson.com")
	   || dnsDomainIs(host, "www.collectoronline.com")
	   || dnsDomainIs(host, "www.colonialhall.com")
	   || dnsDomainIs(host, "www.coloradoavalanche.com")
	   || dnsDomainIs(host, "www.coloradorockies.com")
	   || dnsDomainIs(host, "www.colormathpink.com")
	   || dnsDomainIs(host, "www.colts.com")
	   || dnsDomainIs(host, "www.comet.net")
	   || dnsDomainIs(host, "www.cometsystems.com")
	   || dnsDomainIs(host, "www.comicbookresources.com")
	   || dnsDomainIs(host, "www.comicspage.com")
	   || dnsDomainIs(host, "www.compassnet.com")
	   || dnsDomainIs(host, "www.compleatbellairs.com")
	   || dnsDomainIs(host, "www.comptons.com")
	   || dnsDomainIs(host, "www.concentric.net")
	   || dnsDomainIs(host, "www.congogorillaforest.com")
	   || dnsDomainIs(host, "www.conjuror.com")
	   || dnsDomainIs(host, "www.conk.com")
	   || dnsDomainIs(host, "www.conservation.state.mo.us")
	   || dnsDomainIs(host, "www.contracostatimes.com")
	   || dnsDomainIs(host, "www.control.chalmers.se")
	   || dnsDomainIs(host, "www.cookierecipe.com")
	   || dnsDomainIs(host, "www.cooljapanesetoys.com")
	   || dnsDomainIs(host, "www.cooper.com")
	   || dnsDomainIs(host, "www.corpcomm.net")
	   || dnsDomainIs(host, "www.corrietenboom.com")
	   || dnsDomainIs(host, "www.corynet.com")
	   || dnsDomainIs(host, "www.corypaints.com")
	   || dnsDomainIs(host, "www.cosmosmith.com")
	   || dnsDomainIs(host, "www.countdown2000.com")
	   || dnsDomainIs(host, "www.cowboy.net")
	   || dnsDomainIs(host, "www.cowboypal.com")
	   || dnsDomainIs(host, "www.cowcreek.com")
	   || dnsDomainIs(host, "www.cowgirl.net")
	   || dnsDomainIs(host, "www.cowgirls.com")
	   || dnsDomainIs(host, "www.cp.duluth.mn.us")
	   || dnsDomainIs(host, "www.cpsweb.com")
	   || dnsDomainIs(host, "www.craftideas.com")
	   || dnsDomainIs(host, "www.craniamania.com")
	   || dnsDomainIs(host, "www.crater.lake.national-park.com")
	   || dnsDomainIs(host, "www.crayoncrawler.com")
	   || dnsDomainIs(host, "www.crazybone.com")
	   || dnsDomainIs(host, "www.crazybones.com")
	   || dnsDomainIs(host, "www.crd.ge.com")
	   || dnsDomainIs(host, "www.create4kids.com")
	   || dnsDomainIs(host, "www.creativemusic.com")
	   || dnsDomainIs(host, "www.crocodilian.com")
	   || dnsDomainIs(host, "www.crop.cri.nz")
	   || dnsDomainIs(host, "www.cruzio.com")
	   || dnsDomainIs(host, "www.crwflags.com")
	   || dnsDomainIs(host, "www.cryptograph.com")
	   || dnsDomainIs(host, "www.cryst.bbk.ac.uk")
	   || dnsDomainIs(host, "www.cs.bilkent.edu.tr")
	   || dnsDomainIs(host, "www.cs.man.ac.uk")
	   || dnsDomainIs(host, "www.cs.sfu.ca")
	   || dnsDomainIs(host, "www.cs.ubc.ca")
	   || dnsDomainIs(host, "www.csd.uu.se")
	   || dnsDomainIs(host, "www.csmonitor.com")
	   || dnsDomainIs(host, "www.csse.monash.edu.au")
	   || dnsDomainIs(host, "www.cstone.net")
	   || dnsDomainIs(host, "www.csu.edu.au")
	   || dnsDomainIs(host, "www.cubs.com")
	   || dnsDomainIs(host, "www.culture.fr")
	   || dnsDomainIs(host, "www.cultures.com")
	   || dnsDomainIs(host, "www.curtis-collection.com")
	   || dnsDomainIs(host, "www.cut-the-knot.com")
	   || dnsDomainIs(host, "www.cws-scf.ec.gc.ca")
	   || dnsDomainIs(host, "www.cyber-dyne.com")
	   || dnsDomainIs(host, "www.cyberbee.com")
	   || dnsDomainIs(host, "www.cyberbee.net")
	   || dnsDomainIs(host, "www.cybercom.net")
	   || dnsDomainIs(host, "www.cybercomm.net")
	   || dnsDomainIs(host, "www.cybercomm.nl")
	   || dnsDomainIs(host, "www.cybercorp.co.nz")
	   || dnsDomainIs(host, "www.cybercs.com")
	   || dnsDomainIs(host, "www.cybergoal.com")
	   || dnsDomainIs(host, "www.cyberkids.com")
	   || dnsDomainIs(host, "www.cyberspaceag.com")
	   || dnsDomainIs(host, "www.cyberteens.com")
	   || dnsDomainIs(host, "www.cybertours.com")
	   || dnsDomainIs(host, "www.cybiko.com")
	   || dnsDomainIs(host, "www.czweb.com")
	   || dnsDomainIs(host, "www.d91.k12.id.us")
	   || dnsDomainIs(host, "www.dailygrammar.com")
	   || dnsDomainIs(host, "www.dakidz.com")
	   || dnsDomainIs(host, "www.dalejarrettonline.com")
	   || dnsDomainIs(host, "www.dallascowboys.com")
	   || dnsDomainIs(host, "www.dallasdogndisc.com")
	   || dnsDomainIs(host, "www.dallasstars.com")
	   || dnsDomainIs(host, "www.damnyankees.com")
	   || dnsDomainIs(host, "www.danceart.com")
	   || dnsDomainIs(host, "www.daniellesplace.com")
	   || dnsDomainIs(host, "www.dare-america.com")
	   || dnsDomainIs(host, "www.darkfish.com")
	   || dnsDomainIs(host, "www.darsbydesign.com")
	   || dnsDomainIs(host, "www.datadragon.com")
	   || dnsDomainIs(host, "www.davidreilly.com")
	   || dnsDomainIs(host, "www.dccomics.com")
	   || dnsDomainIs(host, "www.dcn.davis.ca.us")
	   || dnsDomainIs(host, "www.deepseaworld.com")
	   || dnsDomainIs(host, "www.delawaretribeofindians.nsn.us")
	   || dnsDomainIs(host, "www.demon.co.uk")
	   || dnsDomainIs(host, "www.denverbroncos.com")
	   || dnsDomainIs(host, "www.denverpost.com")
	   || dnsDomainIs(host, "www.dep.state.pa.us")
	   || dnsDomainIs(host, "www.desert-fairy.com")
	   || dnsDomainIs(host, "www.desert-storm.com")
	   || dnsDomainIs(host, "www.desertusa.com")
	   || dnsDomainIs(host, "www.designltd.com")
	   || dnsDomainIs(host, "www.designsbykat.com")
	   || dnsDomainIs(host, "www.detnews.com")
	   || dnsDomainIs(host, "www.detroitlions.com")
	   || dnsDomainIs(host, "www.detroitredwings.com")
	   || dnsDomainIs(host, "www.detroittigers.com")
	   || dnsDomainIs(host, "www.deutsches-museum.de")
	   || dnsDomainIs(host, "www.devilray.com")
	   || dnsDomainIs(host, "www.dhorse.com")
	   || dnsDomainIs(host, "www.diana-ross.co.uk")
	   || dnsDomainIs(host, "www.dianarossandthesupremes.net")
	   || dnsDomainIs(host, "www.diaryproject.com")
	   || dnsDomainIs(host, "www.dickbutkus.com")
	   || dnsDomainIs(host, "www.dickshovel.com")
	   || dnsDomainIs(host, "www.dictionary.com")
	   || dnsDomainIs(host, "www.didyouknow.com")
	   || dnsDomainIs(host, "www.diegorivera.com")
	   || dnsDomainIs(host, "www.digitalcentury.com")
	   || dnsDomainIs(host, "www.digitaldog.com")
	   || dnsDomainIs(host, "www.digiweb.com")
	   || dnsDomainIs(host, "www.dimdima.com")
	   || dnsDomainIs(host, "www.dinodon.com")
	   || dnsDomainIs(host, "www.dinosauria.com")
	   || dnsDomainIs(host, "www.discovereso.com")
	   || dnsDomainIs(host, "www.discovergalapagos.com")
	   || dnsDomainIs(host, "www.discovergames.com")
	   || dnsDomainIs(host, "www.discoveringarchaeology.com")
	   || dnsDomainIs(host, "www.discoveringmontana.com")
	   || dnsDomainIs(host, "www.discoverlearning.com")
	   || dnsDomainIs(host, "www.discovery.com")
	   || dnsDomainIs(host, "www.disknet.com")
	   || dnsDomainIs(host, "www.disney.go.com")
	   || dnsDomainIs(host, "www.distinguishedwomen.com")
	   || dnsDomainIs(host, "www.dkonline.com")
	   || dnsDomainIs(host, "www.dltk-kids.com")
	   || dnsDomainIs(host, "www.dmgi.com")
	   || dnsDomainIs(host, "www.dnr.state.md.us")
	   || dnsDomainIs(host, "www.dnr.state.mi.us")
	   || dnsDomainIs(host, "www.dnr.state.wi.us")
	   || dnsDomainIs(host, "www.dodgers.com")
	   || dnsDomainIs(host, "www.dodoland.com")
	   || dnsDomainIs(host, "www.dog-play.com")
	   || dnsDomainIs(host, "www.dogbreedinfo.com")
	   || dnsDomainIs(host, "www.doginfomat.com")
	   || dnsDomainIs(host, "www.dole5aday.com")
	   || dnsDomainIs(host, "www.dollart.com")
	   || dnsDomainIs(host, "www.dolliedish.com")
	   || dnsDomainIs(host, "www.dome2000.co.uk")
	   || dnsDomainIs(host, "www.domtar.com")
	   || dnsDomainIs(host, "www.donegal.k12.pa.us")
	   || dnsDomainIs(host, "www.dorneypark.com")
	   || dnsDomainIs(host, "www.dorothyhinshawpatent.com")
	   || dnsDomainIs(host, "www.dougweb.com")
	   || dnsDomainIs(host, "www.dps.state.ak.us")
	   || dnsDomainIs(host, "www.draw3d.com")
	   || dnsDomainIs(host, "www.dreamgate.com")
	   || dnsDomainIs(host, "www.dreamkitty.com")
	   || dnsDomainIs(host, "www.dreamscape.com")
	   || dnsDomainIs(host, "www.dreamtime.net.au")
	   || dnsDomainIs(host, "www.drpeppermuseum.com")
	   || dnsDomainIs(host, "www.drscience.com")
	   || dnsDomainIs(host, "www.drseward.com")
	   || dnsDomainIs(host, "www.drtoy.com")
	   || dnsDomainIs(host, "www.dse.nl")
	   || dnsDomainIs(host, "www.dtic.mil")
	   || dnsDomainIs(host, "www.duracell.com")
	   || dnsDomainIs(host, "www.dustbunny.com")
	   || dnsDomainIs(host, "www.dynanet.com")
	   || dnsDomainIs(host, "www.eagerreaders.com")
	   || dnsDomainIs(host, "www.eaglekids.com")
	   || dnsDomainIs(host, "www.earthcalendar.net")
	   || dnsDomainIs(host, "www.earthday.net")
	   || dnsDomainIs(host, "www.earthdog.com")
	   || dnsDomainIs(host, "www.earthwatch.com")
	   || dnsDomainIs(host, "www.ease.com")
	   || dnsDomainIs(host, "www.eastasia.ws")
	   || dnsDomainIs(host, "www.easytype.com")
	   || dnsDomainIs(host, "www.eblewis.com")
	   || dnsDomainIs(host, "www.ebs.hw.ac.uk")
	   || dnsDomainIs(host, "www.eclipse.net")
	   || dnsDomainIs(host, "www.eco-pros.com")
	   || dnsDomainIs(host, "www.edbydesign.com")
	   || dnsDomainIs(host, "www.eddytheeco-dog.com")
	   || dnsDomainIs(host, "www.edgate.com")
	   || dnsDomainIs(host, "www.edmontonoilers.com")
	   || dnsDomainIs(host, "www.edu-source.com")
	   || dnsDomainIs(host, "www.edu.gov.on.ca")
	   || dnsDomainIs(host, "www.edu4kids.com")
	   || dnsDomainIs(host, "www.educ.uvic.ca")
	   || dnsDomainIs(host, "www.educate.org.uk")
	   || dnsDomainIs(host, "www.education-world.com")
	   || dnsDomainIs(host, "www.edunet.com")
	   || dnsDomainIs(host, "www.eduplace.com")
	   || dnsDomainIs(host, "www.edupuppy.com")
	   || dnsDomainIs(host, "www.eduweb.com")
	   || dnsDomainIs(host, "www.ee.ryerson.ca")
	   || dnsDomainIs(host, "www.ee.surrey.ac.uk")
	   || dnsDomainIs(host, "www.eeggs.com")
	   || dnsDomainIs(host, "www.efes.com")
	   || dnsDomainIs(host, "www.egalvao.com")
	   || dnsDomainIs(host, "www.egypt.com")
	   || dnsDomainIs(host, "www.egyptology.com")
	   || dnsDomainIs(host, "www.ehobbies.com")
	   || dnsDomainIs(host, "www.ehow.com")
	   || dnsDomainIs(host, "www.eia.brad.ac.uk")
	   || dnsDomainIs(host, "www.elbalero.gob.mx")
	   || dnsDomainIs(host, "www.eliki.com")
	   || dnsDomainIs(host, "www.elnino.com")
	   || dnsDomainIs(host, "www.elok.com")
	   || dnsDomainIs(host, "www.emf.net")
	   || dnsDomainIs(host, "www.emsphone.com")
	   || dnsDomainIs(host, "www.emulateme.com")
	   || dnsDomainIs(host, "www.en.com")
	   || dnsDomainIs(host, "www.enature.com")
	   || dnsDomainIs(host, "www.enchantedlearning.com")
	   || dnsDomainIs(host, "www.encyclopedia.com")
	   || dnsDomainIs(host, "www.endex.com")
	   || dnsDomainIs(host, "www.enjoyillinois.com")
	   || dnsDomainIs(host, "www.enn.com")
	   || dnsDomainIs(host, "www.enriqueig.com")
	   || dnsDomainIs(host, "www.enteract.com")
	   || dnsDomainIs(host, "www.epals.com")
	   || dnsDomainIs(host, "www.equine-world.co.uk")
	   || dnsDomainIs(host, "www.eric-carle.com")
	   || dnsDomainIs(host, "www.ericlindros.net")
	   || dnsDomainIs(host, "www.escape.com")
	   || dnsDomainIs(host, "www.eskimo.com")
	   || dnsDomainIs(host, "www.essentialsofmusic.com")
	   || dnsDomainIs(host, "www.etch-a-sketch.com")
	   || dnsDomainIs(host, "www.ethanallen.together.com")
	   || dnsDomainIs(host, "www.etoys.com")
	   || dnsDomainIs(host, "www.eurekascience.com")
	   || dnsDomainIs(host, "www.euronet.nl")
	   || dnsDomainIs(host, "www.everyrule.com")
	   || dnsDomainIs(host, "www.ex.ac.uk")
	   || dnsDomainIs(host, "www.excite.com")
	   || dnsDomainIs(host, "www.execpc.com")
	   || dnsDomainIs(host, "www.execulink.com")
	   || dnsDomainIs(host, "www.exn.net")
	   || dnsDomainIs(host, "www.expa.hvu.nl")
	   || dnsDomainIs(host, "www.expage.com")
	   || dnsDomainIs(host, "www.explode.to")
	   || dnsDomainIs(host, "www.explorescience.com")
	   || dnsDomainIs(host, "www.explorezone.com")
	   || dnsDomainIs(host, "www.extremescience.com")
	   || dnsDomainIs(host, "www.eyelid.co.uk")
	   || dnsDomainIs(host, "www.eyeneer.com")
	   || dnsDomainIs(host, "www.eyesofachild.com")
	   || dnsDomainIs(host, "www.eyesofglory.com")
	   || dnsDomainIs(host, "www.ezschool.com")
	   || dnsDomainIs(host, "www.f1-live.com")
	   || dnsDomainIs(host, "www.fables.co.uk")
	   || dnsDomainIs(host, "www.factmonster.com")
	   || dnsDomainIs(host, "www.fairygodmother.com")
	   || dnsDomainIs(host, "www.familybuzz.com")
	   || dnsDomainIs(host, "www.familygames.com")
	   || dnsDomainIs(host, "www.familygardening.com")
	   || dnsDomainIs(host, "www.familyinternet.com")
	   || dnsDomainIs(host, "www.familymoney.com")
	   || dnsDomainIs(host, "www.familyplay.com")
	   || dnsDomainIs(host, "www.famousbirthdays.com")
	   || dnsDomainIs(host, "www.fandom.com")
	   || dnsDomainIs(host, "www.fansites.com")
	   || dnsDomainIs(host, "www.faoschwarz.com")
	   || dnsDomainIs(host, "www.fbe.unsw.edu.au")
	   || dnsDomainIs(host, "www.fcps.k12.va.us")
	   || dnsDomainIs(host, "www.fellersartsfactory.com")
	   || dnsDomainIs(host, "www.ferrari.it")
	   || dnsDomainIs(host, "www.fertnel.com")
	   || dnsDomainIs(host, "www.fh-konstanz.de")
	   || dnsDomainIs(host, "www.fhw.gr")
	   || dnsDomainIs(host, "www.fibblesnork.com")
	   || dnsDomainIs(host, "www.fidnet.com")
	   || dnsDomainIs(host, "www.fieldhockey.com")
	   || dnsDomainIs(host, "www.fieldhockeytraining.com")
	   || dnsDomainIs(host, "www.fieler.com")
	   || dnsDomainIs(host, "www.finalfour.net")
	   || dnsDomainIs(host, "www.finifter.com")
	   || dnsDomainIs(host, "www.fireworks-safety.com")
	   || dnsDomainIs(host, "www.firstcut.com")
	   || dnsDomainIs(host, "www.firstnations.com")
	   || dnsDomainIs(host, "www.fishbc.com")
	   || dnsDomainIs(host, "www.fisher-price.com")
	   || dnsDomainIs(host, "www.fisheyeview.com")
	   || dnsDomainIs(host, "www.fishgeeks.com")
	   || dnsDomainIs(host, "www.fishindex.com")
	   || dnsDomainIs(host, "www.fitzgeraldstudio.com")
	   || dnsDomainIs(host, "www.flags.net")
	   || dnsDomainIs(host, "www.flail.com")
	   || dnsDomainIs(host, "www.flamarlins.com")
	   || dnsDomainIs(host, "www.flausa.com")
	   || dnsDomainIs(host, "www.floodlight-findings.com")
	   || dnsDomainIs(host, "www.floridahistory.com")
	   || dnsDomainIs(host, "www.floridapanthers.com")
	   || dnsDomainIs(host, "www.fng.fi")
	   || dnsDomainIs(host, "www.foodsci.uoguelph.ca")
	   || dnsDomainIs(host, "www.foremost.com")
	   || dnsDomainIs(host, "www.fortress.am")
	   || dnsDomainIs(host, "www.fortunecity.com")
	   || dnsDomainIs(host, "www.fosterclub.com")
	   || dnsDomainIs(host, "www.foundus.com")
	   || dnsDomainIs(host, "www.fourmilab.ch")
	   || dnsDomainIs(host, "www.fox.com")
	   || dnsDomainIs(host, "www.foxfamilychannel.com")
	   || dnsDomainIs(host, "www.foxhome.com")
	   || dnsDomainIs(host, "www.foxkids.com")
	   || dnsDomainIs(host, "www.franceway.com")
	   || dnsDomainIs(host, "www.fred.net")
	   || dnsDomainIs(host, "www.fredpenner.com")
	   || dnsDomainIs(host, "www.freedomknot.com")
	   || dnsDomainIs(host, "www.freejigsawpuzzles.com")
	   || dnsDomainIs(host, "www.freenet.edmonton.ab.ca")
	   || dnsDomainIs(host, "www.frii.com")
	   || dnsDomainIs(host, "www.frisbee.com")
	   || dnsDomainIs(host, "www.fritolay.com")
	   || dnsDomainIs(host, "www.frogsonice.com")
	   || dnsDomainIs(host, "www.frontiernet.net")
	   || dnsDomainIs(host, "www.fs.fed.us")
	   || dnsDomainIs(host, "www.funattic.com")
	   || dnsDomainIs(host, ".funbrain.com")
	   || dnsDomainIs(host, "www.fundango.com")
	   || dnsDomainIs(host, "www.funisland.com")
	   || dnsDomainIs(host, "www.funkandwagnalls.com")
	   || dnsDomainIs(host, "www.funorama.com")
	   || dnsDomainIs(host, "www.funschool.com")
	   || dnsDomainIs(host, "www.funster.com")
	   || dnsDomainIs(host, "www.furby.com")
	   || dnsDomainIs(host, "www.fusion.org.uk")
	   || dnsDomainIs(host, "www.futcher.com")
	   || dnsDomainIs(host, "www.futurescan.com")
	   || dnsDomainIs(host, "www.fyi.net")
	   || dnsDomainIs(host, "www.gailgibbons.com")
	   || dnsDomainIs(host, "www.galegroup.com")
	   || dnsDomainIs(host, "www.gambia.com")
	   || dnsDomainIs(host, "www.gamecabinet.com")
	   || dnsDomainIs(host, "www.gamecenter.com")
	   || dnsDomainIs(host, "www.gamefaqs.com")
	   || dnsDomainIs(host, "www.garfield.com")
	   || dnsDomainIs(host, "www.garyharbo.com")
	   || dnsDomainIs(host, "www.gatefish.com")
	   || dnsDomainIs(host, "www.gateway-va.com")
	   || dnsDomainIs(host, "www.gazillionaire.com")
	   || dnsDomainIs(host, "www.gearhead.com")
	   || dnsDomainIs(host, "www.genesplicing.com")
	   || dnsDomainIs(host, "www.genhomepage.com")
	   || dnsDomainIs(host, "www.geobop.com")
	   || dnsDomainIs(host, "www.geocities.com")
	   || dnsDomainIs(host, "www.geographia.com")
	   || dnsDomainIs(host, "www.georgeworld.com")
	   || dnsDomainIs(host, "www.georgian.net")
	   || dnsDomainIs(host, "www.german-way.com")
	   || dnsDomainIs(host, "www.germanfortravellers.com")
	   || dnsDomainIs(host, "www.germantown.k12.il.us")
	   || dnsDomainIs(host, "www.germany-tourism.de")
	   || dnsDomainIs(host, "www.getmusic.com")
	   || dnsDomainIs(host, "www.gettysburg.com")
	   || dnsDomainIs(host, "www.ghirardellisq.com")
	   || dnsDomainIs(host, "www.ghosttowngallery.com")
	   || dnsDomainIs(host, "www.ghosttownsusa.com")
	   || dnsDomainIs(host, "www.giants.com")
	   || dnsDomainIs(host, "www.gibraltar.gi")
	   || dnsDomainIs(host, "www.gigglepoetry.com")
	   || dnsDomainIs(host, "www.gilchriststudios.com")
	   || dnsDomainIs(host, "www.gillslap.freeserve.co.uk")
	   || dnsDomainIs(host, "www.gilmer.net")
	   || dnsDomainIs(host, "www.gio.gov.tw")
	   || dnsDomainIs(host, "www.girltech.com")
	   || dnsDomainIs(host, "www.girlzone.com")
	   || dnsDomainIs(host, "www.globalgang.org.uk")
	   || dnsDomainIs(host, "www.globalindex.com")
	   || dnsDomainIs(host, "www.globalinfo.com")
	   || dnsDomainIs(host, "www.gloriafan.com")
	   || dnsDomainIs(host, "www.gms.ocps.k12.fl.us")
	   || dnsDomainIs(host, "www.go-go-diggity.com")
	   || dnsDomainIs(host, "www.goals.com")
	   || dnsDomainIs(host, "www.godiva.com")
	   || dnsDomainIs(host, "www.golden-retriever.com")
	   || dnsDomainIs(host, "www.goldenbooks.com")
	   || dnsDomainIs(host, "www.goldeneggs.com.au")
	   || dnsDomainIs(host, "www.golfonline.com")
	   || dnsDomainIs(host, "www.goobo.com")
	   || dnsDomainIs(host, "www.goodearthgraphics.com")
	   || dnsDomainIs(host, "www.goodyear.com")
	   || dnsDomainIs(host, "www.gopbi.com")
	   || dnsDomainIs(host, "www.gorge.net")
	   || dnsDomainIs(host, "www.gorp.com")
	   || dnsDomainIs(host, "www.got-milk.com")
	   || dnsDomainIs(host, "www.gov.ab.ca")
	   || dnsDomainIs(host, "www.gov.nb.ca")
	   || dnsDomainIs(host, "www.grammarbook.com")
	   || dnsDomainIs(host, "www.grammarlady.com")
	   || dnsDomainIs(host, "www.grandparents-day.com")
	   || dnsDomainIs(host, "www.granthill.com")
	   || dnsDomainIs(host, "www.grayweb.com")
	   || dnsDomainIs(host, "www.greatbuildings.com")
	   || dnsDomainIs(host, "www.greatkids.com")
	   || dnsDomainIs(host, "www.greatscience.com")
	   || dnsDomainIs(host, "www.greeceny.com")
	   || dnsDomainIs(host, "www.greenkeepers.com")
	   || dnsDomainIs(host, "www.greylabyrinth.com")
	   || dnsDomainIs(host, "www.grimmy.com")
	   || dnsDomainIs(host, "www.gsrg.nmh.ac.uk")
	   || dnsDomainIs(host, "www.gti.net")
	   || dnsDomainIs(host, "www.guinnessworldrecords.com")
	   || dnsDomainIs(host, "www.guitar.net")
	   || dnsDomainIs(host, "www.guitarplaying.com")
	   || dnsDomainIs(host, "www.gumbyworld.com")
	   || dnsDomainIs(host, "www.gurlwurld.com")
	   || dnsDomainIs(host, "www.gwi.net")
	   || dnsDomainIs(host, "www.gymn-forum.com")
	   || dnsDomainIs(host, "www.gzkidzone.com")
	   || dnsDomainIs(host, "www.haemibalgassi.com")
	   || dnsDomainIs(host, "www.hairstylist.com")
	   || dnsDomainIs(host, "www.halcyon.com")
	   || dnsDomainIs(host, "www.halifax.cbc.ca")
	   || dnsDomainIs(host, "www.halloween-online.com")
	   || dnsDomainIs(host, "www.halloweenkids.com")
	   || dnsDomainIs(host, "www.halloweenmagazine.com")
	   || dnsDomainIs(host, "www.hamill.co.uk")
	   || dnsDomainIs(host, "www.hamsterdance2.com")
	   || dnsDomainIs(host, "www.hamsters.co.uk")
	   || dnsDomainIs(host, "www.hamstertours.com")
	   || dnsDomainIs(host, "www.handsonmath.com")
	   || dnsDomainIs(host, "www.handspeak.com")
	   || dnsDomainIs(host, "www.hansonline.com")
	   || dnsDomainIs(host, "www.happychild.org.uk")
	   || dnsDomainIs(host, "www.happyfamilies.com")
	   || dnsDomainIs(host, "www.happytoy.com")
	   || dnsDomainIs(host, "www.harley-davidson.com")
	   || dnsDomainIs(host, "www.harmonicalessons.com")
	   || dnsDomainIs(host, "www.harperchildrens.com")
	   || dnsDomainIs(host, "www.harvey.com")
	   || dnsDomainIs(host, "www.hasbro-interactive.com")
	   || dnsDomainIs(host, "www.haynet.net")
	   || dnsDomainIs(host, "www.hbc.com")
	   || dnsDomainIs(host, "www.hblewis.com")
	   || dnsDomainIs(host, "www.hbook.com")
	   || dnsDomainIs(host, "www.he.net")
	   || dnsDomainIs(host, "www.headbone.com")
	   || dnsDomainIs(host, "www.healthatoz.com")
	   || dnsDomainIs(host, "www.healthypet.com")
	   || dnsDomainIs(host, "www.heartfoundation.com.au")
	   || dnsDomainIs(host, "www.heatersworld.com")
	   || dnsDomainIs(host, "www.her-online.com")
	   || dnsDomainIs(host, "www.heroesofhistory.com")
	   || dnsDomainIs(host, "www.hersheypa.com")
	   || dnsDomainIs(host, "www.hersheys.com")
	   || dnsDomainIs(host, "www.hevanet.com")
	   || dnsDomainIs(host, "www.heynetwork.com")
	   || dnsDomainIs(host, "www.hgo.com")
	   || dnsDomainIs(host, "www.hhof.com")
	   || dnsDomainIs(host, "www.hideandseekpuppies.com")
	   || dnsDomainIs(host, "www.hifusion.com")
	   || dnsDomainIs(host, "www.highbridgepress.com")
	   || dnsDomainIs(host, "www.his.com")
	   || dnsDomainIs(host, "www.history.navy.mil")
	   || dnsDomainIs(host, "www.historychannel.com")
	   || dnsDomainIs(host, "www.historyhouse.com")
	   || dnsDomainIs(host, "www.historyplace.com")
	   || dnsDomainIs(host, "www.hisurf.com")
	   || dnsDomainIs(host, "www.hiyah.com")
	   || dnsDomainIs(host, "www.hmnet.com")
	   || dnsDomainIs(host, "www.hoboes.com")
	   || dnsDomainIs(host, "www.hockeydb.com")
	   || dnsDomainIs(host, "www.hohnerusa.com")
	   || dnsDomainIs(host, "www.holidaychannel.com")
	   || dnsDomainIs(host, "www.holidayfestival.com")
	   || dnsDomainIs(host, "www.holidays.net")
	   || dnsDomainIs(host, "www.hollywood.com")
	   || dnsDomainIs(host, "www.holoworld.com")
	   || dnsDomainIs(host, "www.homepagers.com")
	   || dnsDomainIs(host, "www.homeschoolzone.com")
	   || dnsDomainIs(host, "www.homestead.com")
	   || dnsDomainIs(host, "www.homeworkspot.com")
	   || dnsDomainIs(host, "www.hompro.com")
	   || dnsDomainIs(host, "www.honey.com")
	   || dnsDomainIs(host, "www.hooked.net")
	   || dnsDomainIs(host, "www.hoophall.com")
	   || dnsDomainIs(host, "www.hooverdam.com")
	   || dnsDomainIs(host, "www.hopepaul.com")
	   || dnsDomainIs(host, "www.horse-country.com")
	   || dnsDomainIs(host, "www.horsechat.com")
	   || dnsDomainIs(host, "www.horsefun.com")
	   || dnsDomainIs(host, "www.horus.ics.org.eg")
	   || dnsDomainIs(host, "www.hotbraille.com")
	   || dnsDomainIs(host, "www.hotwheels.com")
	   || dnsDomainIs(host, "www.howstuffworks.com")
	   || dnsDomainIs(host, "www.hpdigitalbookclub.com")
	   || dnsDomainIs(host, "www.hpj.com")
	   || dnsDomainIs(host, "www.hpl.hp.com")
	   || dnsDomainIs(host, "www.hpl.lib.tx.us")
	   || dnsDomainIs(host, "www.hpnetwork.f2s.com")
	   || dnsDomainIs(host, "www.hsswp.com")
	   || dnsDomainIs(host, "www.hsx.com")
	   || dnsDomainIs(host, "www.humboldt1.com")
	   || dnsDomainIs(host, "www.humongous.com")
	   || dnsDomainIs(host, "www.humph3.freeserve.co.uk")
	   || dnsDomainIs(host, "www.humphreybear.com ")
	   || dnsDomainIs(host, "www.hurricanehunters.com")
	   || dnsDomainIs(host, "www.hyperhistory.com")
	   || dnsDomainIs(host, "www.i2k.com")
	   || dnsDomainIs(host, "www.ibhof.com")
	   || dnsDomainIs(host, "www.ibiscom.com")
	   || dnsDomainIs(host, "www.ibm.com")
	   || dnsDomainIs(host, "www.icangarden.com")
	   || dnsDomainIs(host, "www.icecreamusa.com")
	   || dnsDomainIs(host, "www.icn.co.uk")
	   || dnsDomainIs(host, "www.icomm.ca")
	   || dnsDomainIs(host, "www.idfishnhunt.com")
	   || dnsDomainIs(host, "www.iditarod.com")
	   || dnsDomainIs(host, "www.iei.net")
	   || dnsDomainIs(host, "www.iemily.com")
	   || dnsDomainIs(host, "www.iir.com")
	   || dnsDomainIs(host, "www.ika.com")
	   || dnsDomainIs(host, "www.ikoala.com")
	   || dnsDomainIs(host, "www.iln.net")
	   || dnsDomainIs(host, "www.imagine5.com")
	   || dnsDomainIs(host, "www.imes.boj.or.jp")
	   || dnsDomainIs(host, "www.inch.com")
	   || dnsDomainIs(host, "www.incwell.com")
	   || dnsDomainIs(host, "www.indian-river.fl.us")
	   || dnsDomainIs(host, "www.indians.com")
	   || dnsDomainIs(host, "www.indo.com")
	   || dnsDomainIs(host, "www.indyracingleague.com")
	   || dnsDomainIs(host, "www.indyzoo.com")
	   || dnsDomainIs(host, "www.info-canada.com")
	   || dnsDomainIs(host, "www.infomagic.net")
	   || dnsDomainIs(host, "www.infoplease.com")
	   || dnsDomainIs(host, "www.infoporium.com")
	   || dnsDomainIs(host, "www.infostuff.com")
	   || dnsDomainIs(host, "www.inhandmuseum.com")
	   || dnsDomainIs(host, "www.inil.com")
	   || dnsDomainIs(host, "www.inkspot.com")
	   || dnsDomainIs(host, "www.inkyfingers.com")
	   || dnsDomainIs(host, "www.innerauto.com")
	   || dnsDomainIs(host, "www.innerbody.com")
	   || dnsDomainIs(host, "www.inqpub.com")
	   || dnsDomainIs(host, "www.insecta-inspecta.com")
	   || dnsDomainIs(host, "www.insectclopedia.com")
	   || dnsDomainIs(host, "www.inside-mexico.com")
	   || dnsDomainIs(host, "www.insiders.com")
	   || dnsDomainIs(host, "www.insteam.com")
	   || dnsDomainIs(host, "www.intel.com")
	   || dnsDomainIs(host, "www.intellicast.com")
	   || dnsDomainIs(host, "www.interads.co.uk")
	   || dnsDomainIs(host, "www.intercot.com")
	   || dnsDomainIs(host, "www.intergraffix.com")
	   || dnsDomainIs(host, "www.interknowledge.com")
	   || dnsDomainIs(host, "www.interlog.com")
	   || dnsDomainIs(host, "www.internet4kids.com")
	   || dnsDomainIs(host, "www.intersurf.com")
	   || dnsDomainIs(host, "www.inthe80s.com")
	   || dnsDomainIs(host, "www.inventorsmuseum.com")
	   || dnsDomainIs(host, "www.inwap.com")
	   || dnsDomainIs(host, "www.ioa.com")
	   || dnsDomainIs(host, "www.ionet.net")
	   || dnsDomainIs(host, "www.iowacity.com")
	   || dnsDomainIs(host, "www.ireland-now.com")
	   || dnsDomainIs(host, "www.ireland.com")
	   || dnsDomainIs(host, "www.irelandseye.com")
	   || dnsDomainIs(host, "www.irlgov.ie")
	   || dnsDomainIs(host, "www.isd.net")
	   || dnsDomainIs(host, "www.islandnet.com")
	   || dnsDomainIs(host, "www.isomedia.com")
	   || dnsDomainIs(host, "www.itftennis.com")
	   || dnsDomainIs(host, "www.itpi.dpi.state.nc.us")
	   || dnsDomainIs(host, "www.itskwanzaatime.com")
	   || dnsDomainIs(host, "www.itss.raytheon.com")
	   || dnsDomainIs(host, "www.iuma.com")
	   || dnsDomainIs(host, "www.iwaynet.net")
	   || dnsDomainIs(host, "www.iwc.com")
	   || dnsDomainIs(host, "www.iwight.gov.uk")
	   || dnsDomainIs(host, "www.ixpres.com")
	   || dnsDomainIs(host, "www.j.b.allen.btinternet.co.uk")
	   || dnsDomainIs(host, "www.jabuti.com")
	   || dnsDomainIs(host, "www.jackinthebox.com")
	   || dnsDomainIs(host, "www.jaffebros.com")
	   || dnsDomainIs(host, "www.jaguars.com")
	   || dnsDomainIs(host, "www.jamaica-gleaner.com")
	   || dnsDomainIs(host, "www.jamm.com")
	   || dnsDomainIs(host, "www.janbrett.com")
	   || dnsDomainIs(host, "www.janetstevens.com")
	   || dnsDomainIs(host, "www.japan-guide.com")
	   || dnsDomainIs(host, "www.jargon.net")
	   || dnsDomainIs(host, "www.javelinamx.com")
	   || dnsDomainIs(host, "www.jayjay.com")
	   || dnsDomainIs(host, "www.jazclass.aust.com")
	   || dnsDomainIs(host, "www.jedinet.com")
	   || dnsDomainIs(host, "www.jenniferlopez.com")
	   || dnsDomainIs(host, "www.jlpanagopoulos.com")
	   || dnsDomainIs(host, "www.jmarshall.com")
	   || dnsDomainIs(host, "www.jmccall.demon.co.uk")
	   || dnsDomainIs(host, "www.jmts.com")
	   || dnsDomainIs(host, "www.joesherlock.com")
	   || dnsDomainIs(host, "www.jorvik-viking-centre.co.uk")
	   || dnsDomainIs(host, "www.joycecarolthomas.com")
	   || dnsDomainIs(host, "www.joycone.com")
	   || dnsDomainIs(host, "www.joyrides.com")
	   || dnsDomainIs(host, "www.jps.net")
	   || dnsDomainIs(host, "www.jspub.com")
	   || dnsDomainIs(host, "www.judaica.com")
	   || dnsDomainIs(host, "www.judyblume.com")
	   || dnsDomainIs(host, "www.julen.net")
	   || dnsDomainIs(host, "www.june29.com")
	   || dnsDomainIs(host, "www.juneteenth.com")
	   || dnsDomainIs(host, "www.justuskidz.com")
	   || dnsDomainIs(host, "www.justwomen.com")
	   || dnsDomainIs(host, "www.jwindow.net")
	   || dnsDomainIs(host, "www.k9web.com")
	   || dnsDomainIs(host, "www.kaercher.de")
	   || dnsDomainIs(host, "www.kaleidoscapes.com")
	   || dnsDomainIs(host, "www.kapili.com")
	   || dnsDomainIs(host, "www.kcchiefs.com")
	   || dnsDomainIs(host, "www.kcpl.lib.mo.us")
	   || dnsDomainIs(host, "www.kcroyals.com")
	   || dnsDomainIs(host, "www.kcsd.k12.pa.us")
	   || dnsDomainIs(host, "www.kdu.com")
	   || dnsDomainIs(host, "www.kelloggs.com")
	   || dnsDomainIs(host, "www.kentuckyfriedchicken.com")
	   || dnsDomainIs(host, "www.kenyaweb.com")
	   || dnsDomainIs(host, "www.keypals.com")
	   || dnsDomainIs(host, "www.kfn.com")
	   || dnsDomainIs(host, "www.kid-at-art.com")
	   || dnsDomainIs(host, "www.kid-channel.com")
	   || dnsDomainIs(host, "www.kidallergy.com")
	   || dnsDomainIs(host, "www.kidbibs.com")
	   || dnsDomainIs(host, "www.kidcomics.com")
	   || dnsDomainIs(host, "www.kiddesafety.com")
	   || dnsDomainIs(host, "www.kiddiecampus.com")
	   || dnsDomainIs(host, "www.kididdles.com")
	   || dnsDomainIs(host, "www.kidnews.com")
	   || dnsDomainIs(host, "www.kidocracy.com")
	   || dnsDomainIs(host, "www.kidport.com")
	   || dnsDomainIs(host, "www.kids-channel.co.uk")
	   || dnsDomainIs(host, "www.kids-drawings.com")
	   || dnsDomainIs(host, "www.kids-in-mind.com")
	   || dnsDomainIs(host, "www.kids4peace.com")
	   || dnsDomainIs(host, "www.kidsandcomputers.com")
	   || dnsDomainIs(host, "www.kidsart.co.uk")
	   || dnsDomainIs(host, "www.kidsastronomy.com")
	   || dnsDomainIs(host, "www.kidsbank.com")
	   || dnsDomainIs(host, "www.kidsbookshelf.com")
	   || dnsDomainIs(host, "www.kidsclick.com")
	   || dnsDomainIs(host, "www.kidscom.com")
	   || dnsDomainIs(host, "www.kidscook.com")
	   || dnsDomainIs(host, "www.kidsdoctor.com")
	   || dnsDomainIs(host, "www.kidsdomain.com")
	   || dnsDomainIs(host, "www.kidsfarm.com")
	   || dnsDomainIs(host, "www.kidsfreeware.com")
	   || dnsDomainIs(host, "www.kidsfun.tv")
	   || dnsDomainIs(host, "www.kidsgolf.com")
	   || dnsDomainIs(host, "www.kidsgowild.com")
	   || dnsDomainIs(host, "www.kidsjokes.com")
	   || dnsDomainIs(host, "www.kidsloveamystery.com")
	   || dnsDomainIs(host, "www.kidsmoneycents.com")
	   || dnsDomainIs(host, "www.kidsnewsroom.com")
	   || dnsDomainIs(host, "www.kidsource.com")
	   || dnsDomainIs(host, "www.kidsparties.com")
	   || dnsDomainIs(host, "www.kidsplaytown.com")
	   || dnsDomainIs(host, "www.kidsreads.com")
	   || dnsDomainIs(host, "www.kidsreport.com")
	   || dnsDomainIs(host, "www.kidsrunning.com")
	   || dnsDomainIs(host, "www.kidstamps.com")
	   || dnsDomainIs(host, "www.kidsvideogames.com")
	   || dnsDomainIs(host, "www.kidsway.com")
	   || dnsDomainIs(host, "www.kidswithcancer.com")
	   || dnsDomainIs(host, "www.kidszone.ourfamily.com")
	   || dnsDomainIs(host, "www.kidzup.com")
	   || dnsDomainIs(host, "www.kinderart.com")
	   || dnsDomainIs(host, "www.kineticcity.com")
	   || dnsDomainIs(host, "www.kings.k12.ca.us")
	   || dnsDomainIs(host, "www.kiplinger.com")
	   || dnsDomainIs(host, "www.kiwirecovery.org.nz")
	   || dnsDomainIs(host, "www.klipsan.com")
	   || dnsDomainIs(host, "www.klutz.com")
	   || dnsDomainIs(host, "www.kn.pacbell.com")
	   || dnsDomainIs(host, "www.knex.com")
	   || dnsDomainIs(host, "www.knowledgeadventure.com")
	   || dnsDomainIs(host, "www.knto.or.kr")
	   || dnsDomainIs(host, "www.kodak.com")
	   || dnsDomainIs(host, "www.konica.co.jp")
	   || dnsDomainIs(host, "www.kraftfoods.com")
	   || dnsDomainIs(host, "www.kudzukids.com")
	   || dnsDomainIs(host, "www.kulichki.com")
	   || dnsDomainIs(host, "www.kuttu.com")
	   || dnsDomainIs(host, "www.kv5.com")
	   || dnsDomainIs(host, "www.kyes-world.com")
	   || dnsDomainIs(host, "www.kyohaku.go.jp")
	   || dnsDomainIs(host, "www.kyrene.k12.az.us")
	   || dnsDomainIs(host, "www.kz")
	   || dnsDomainIs(host, "www.la-hq.org.uk")
	   || dnsDomainIs(host, "www.labs.net")
	   || dnsDomainIs(host, "www.labyrinth.net.au")
	   || dnsDomainIs(host, "www.laffinthedark.com")
	   || dnsDomainIs(host, "www.lakhota.com")
	   || dnsDomainIs(host, "www.lakings.com")
	   || dnsDomainIs(host, "www.lam.mus.ca.us")
	   || dnsDomainIs(host, "www.lampstras.k12.pa.us")
	   || dnsDomainIs(host, "www.lams.losalamos.k12.nm.us")
	   || dnsDomainIs(host, "www.landofcadbury.ca")
	   || dnsDomainIs(host, "www.larry-boy.com")
	   || dnsDomainIs(host, "www.lasersite.com")
	   || dnsDomainIs(host, "www.last-word.com")
	   || dnsDomainIs(host, "www.latimes.com")
	   || dnsDomainIs(host, "www.laughon.com")
	   || dnsDomainIs(host, "www.laurasmidiheaven.com")
	   || dnsDomainIs(host, "www.lausd.k12.ca.us")
	   || dnsDomainIs(host, "www.learn2.com")
	   || dnsDomainIs(host, "www.learn2type.com")
	   || dnsDomainIs(host, "www.learnfree-hobbies.com")
	   || dnsDomainIs(host, "www.learningkingdom.com")
	   || dnsDomainIs(host, "www.learningplanet.com")
	   || dnsDomainIs(host, "www.leftjustified.com")
	   || dnsDomainIs(host, "www.legalpadjr.com")
	   || dnsDomainIs(host, "www.legendarysurfers.com")
	   || dnsDomainIs(host, "www.legends.dm.net")
	   || dnsDomainIs(host, "www.legis.state.wi.us")
	   || dnsDomainIs(host, "www.legis.state.wv.us")
	   || dnsDomainIs(host, "www.lego.com")
	   || dnsDomainIs(host, "www.leje.com")
	   || dnsDomainIs(host, "www.leonardodicaprio.com")
	   || dnsDomainIs(host, "www.lessonplanspage.com")
	   || dnsDomainIs(host, "www.letour.fr")
	   || dnsDomainIs(host, "www.levins.com")
	   || dnsDomainIs(host, "www.levistrauss.com")
	   || dnsDomainIs(host, "www.libertystatepark.com")
	   || dnsDomainIs(host, "www.libraryspot.com")
	   || dnsDomainIs(host, "www.lifelong.com")
	   || dnsDomainIs(host, "www.lighthouse.cc")
	   || dnsDomainIs(host, "www.lightlink.com")
	   || dnsDomainIs(host, "www.lightspan.com")
	   || dnsDomainIs(host, "www.lil-fingers.com")
	   || dnsDomainIs(host, "www.linc.or.jp")
	   || dnsDomainIs(host, "www.lindsaysbackyard.com")
	   || dnsDomainIs(host, "www.lindtchocolate.com")
	   || dnsDomainIs(host, "www.lineone.net")
	   || dnsDomainIs(host, "www.lionel.com")
	   || dnsDomainIs(host, "www.lisafrank.com")
	   || dnsDomainIs(host, "www.lissaexplains.com")
	   || dnsDomainIs(host, "www.literacycenter.net")
	   || dnsDomainIs(host, "www.littleartist.com")
	   || dnsDomainIs(host, "www.littlechiles.com")
	   || dnsDomainIs(host, "www.littlecritter.com")
	   || dnsDomainIs(host, "www.littlecrowtoys.com")
	   || dnsDomainIs(host, "www.littlehousebooks.com")
	   || dnsDomainIs(host, "www.littlejason.com")
	   || dnsDomainIs(host, "www.littleplanettimes.com")
	   || dnsDomainIs(host, "www.liveandlearn.com")
	   || dnsDomainIs(host, "www.loadstar.prometeus.net")
	   || dnsDomainIs(host, "www.localaccess.com")
	   || dnsDomainIs(host, "www.lochness.co.uk")
	   || dnsDomainIs(host, "www.lochness.scotland.net")
	   || dnsDomainIs(host, "www.logos.it")
	   || dnsDomainIs(host, "www.lonelyplanet.com")
	   || dnsDomainIs(host, "www.looklearnanddo.com")
	   || dnsDomainIs(host, "www.loosejocks.com")
	   || dnsDomainIs(host, "www.lost-worlds.com")
	   || dnsDomainIs(host, "www.love-story.com")
	   || dnsDomainIs(host, "www.lpga.com")
	   || dnsDomainIs(host, "www.lsjunction.com")
	   || dnsDomainIs(host, "www.lucasarts.com")
	   || dnsDomainIs(host, "www.lucent.com")
	   || dnsDomainIs(host, "www.lucie.com")
	   || dnsDomainIs(host, "www.lunaland.co.za")
	   || dnsDomainIs(host, "www.luth.se")
	   || dnsDomainIs(host, "www.lyricalworks.com")
	   || dnsDomainIs(host, "www.infoporium.com")
	   || dnsDomainIs(host, "www.infostuff.com")
	   || dnsDomainIs(host, "www.inhandmuseum.com")
	   || dnsDomainIs(host, "www.inil.com")
	   || dnsDomainIs(host, "www.inkspot.com")
	   || dnsDomainIs(host, "www.inkyfingers.com")
	   || dnsDomainIs(host, "www.innerauto.com")
	   || dnsDomainIs(host, "www.innerbody.com")
	   || dnsDomainIs(host, "www.inqpub.com")
	   || dnsDomainIs(host, "www.insecta-inspecta.com")
	   || dnsDomainIs(host, "www.insectclopedia.com")
	   || dnsDomainIs(host, "www.inside-mexico.com")
	   || dnsDomainIs(host, "www.insiders.com")
	   || dnsDomainIs(host, "www.insteam.com")
	   || dnsDomainIs(host, "www.intel.com")
	   || dnsDomainIs(host, "www.intellicast.com")
	   || dnsDomainIs(host, "www.interads.co.uk")
	   || dnsDomainIs(host, "www.intercot.com")
	   || dnsDomainIs(host, "www.intergraffix.com")
	   || dnsDomainIs(host, "www.interknowledge.com")
	   || dnsDomainIs(host, "www.interlog.com")
	   || dnsDomainIs(host, "www.internet4kids.com")
	   || dnsDomainIs(host, "www.intersurf.com")
	   || dnsDomainIs(host, "www.inthe80s.com")
	   || dnsDomainIs(host, "www.inventorsmuseum.com")
	   || dnsDomainIs(host, "www.inwap.com")
	   || dnsDomainIs(host, "www.ioa.com")
	   || dnsDomainIs(host, "www.ionet.net")
	   || dnsDomainIs(host, "www.iowacity.com")
	   || dnsDomainIs(host, "www.ireland-now.com")
	   || dnsDomainIs(host, "www.ireland.com")
	   || dnsDomainIs(host, "www.irelandseye.com")
	   || dnsDomainIs(host, "www.irlgov.ie")
	   || dnsDomainIs(host, "www.isd.net")
	   || dnsDomainIs(host, "www.islandnet.com")
	   || dnsDomainIs(host, "www.isomedia.com")
	   || dnsDomainIs(host, "www.itftennis.com")
	   || dnsDomainIs(host, "www.itpi.dpi.state.nc.us")
	   || dnsDomainIs(host, "www.itskwanzaatime.com")
	   || dnsDomainIs(host, "www.itss.raytheon.com")
	   || dnsDomainIs(host, "www.iuma.com")
	   || dnsDomainIs(host, "www.iwaynet.net")
	   || dnsDomainIs(host, "www.iwc.com")
	   || dnsDomainIs(host, "www.iwight.gov.uk")
	   || dnsDomainIs(host, "www.ixpres.com")
	   || dnsDomainIs(host, "www.j.b.allen.btinternet.co.uk")
	   || dnsDomainIs(host, "www.jabuti.com")
	   || dnsDomainIs(host, "www.jackinthebox.com")
	   || dnsDomainIs(host, "www.jaffebros.com")
	   || dnsDomainIs(host, "www.jaguars.com")
	   || dnsDomainIs(host, "www.jamaica-gleaner.com")
	   || dnsDomainIs(host, "www.jamm.com")
	   || dnsDomainIs(host, "www.janbrett.com")
	   || dnsDomainIs(host, "www.janetstevens.com")
	   || dnsDomainIs(host, "www.japan-guide.com")
	   || dnsDomainIs(host, "www.jargon.net")
	   || dnsDomainIs(host, "www.javelinamx.com")
	   || dnsDomainIs(host, "www.jayjay.com")
	   || dnsDomainIs(host, "www.jazclass.aust.com")

    )
    return "PROXY proxy.hclib.org:80";
  else
    return "PROXY 172.16.100.20:8080";
}

reportCompare('No Crash', 'No Crash', '');
