/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrOscopeSinkC.h>
#include <gr_OscopeGuts.h>

GrOscopeSinkC::GrOscopeSinkC (int file_descriptor)
  : GrOscopeSinkX (sizeof (VrComplex)), d_fd (file_descriptor), d_tmp (0)
{
}

GrOscopeSinkC::~GrOscopeSinkC ()
{
  delete d_tmp;
}

void
GrOscopeSinkC::initialize ()
{
  d_guts = new gr_OscopeGuts (2 * numberInputs, getSamplingFrequency (), d_fd);
  d_tmp = new float[2 * numberInputs];
}

int
GrOscopeSinkC::work3 (VrSampleRange output,
		      VrSampleRange inputs[], void *ai[])
{
  sync (output.index);

  VrComplex **in = (VrComplex **) ai;
  int	      ni = numberInputs;

  for (unsigned int i = 0; i < output.size; i++){

    for (int ch = 0; ch < ni; ch++){	// for now, copy the data.  Fix later if reqd
      d_tmp[2*ch + 0] = real (in[ch][i]);
      d_tmp[2*ch + 1] = imag (in[ch][i]);
    }

    d_guts->processSample (d_tmp);
  }

  return output.size;
}
