/* -*-C++-*-
*******************************************************************************
*
* File:         wiggle_pp.cc
* Description:  wiggle parallel port bits
*
*******************************************************************************
*/

/*
 * Copyright 2001,2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <unistd.h>
#include <stdlib.h>
#include <ppio.h>
#include <stdio.h>

int main (int argc, char **argv)
{
  int	which;
  
  if (argc != 2)
    which = 0;
  else
    which = strtol (argv[1], 0, 0);

  ppio *pp = ppio::make (which);
  pp->lock ();

  // clear top 4 bits.  Ensure we're in output mode, no interrupts
  pp->write_control (pp->read_control () & 0xf);

  int	ii = 0;
  while (1){
    pp->write_data (ii);
    pp->write_control (~ii & 0xf);
    ii++;
  }

  pp->unlock ();
  return 0;
}
