#!/usr/bin/env python

import os, string

try:
    srcdir = os.environ['srcdir']
except KeyError, e:
    srcdir = "."
srcdir = srcdir + '/'


def system_chk (cmd):
    r = os.system (cmd)
    if (r != 0):
        # print "FAILED (%d): %s" % (r >> 8, cmd)
        if ((r & 0xff) != 0) :          # killed by signal
            sys.exit (127)
        else :
            sys.exit (r >> 8)
    return 0


def error_rate (output_ts, skip, transport_error_flags = "/tmp/teflags"):
    # system_chk (srcdir + ("mpeg-check-transport-error.py <%s >%s"
    #                       % (output_ts, transport_error_flags)))
    system_chk ("./mpeg_check_transport_error -s %s <%s >%s"
                % (skip, output_ts, transport_error_flags))

    npackets = 0
    nerrors = 0

    f = open (transport_error_flags, "r")
    # print "f = ", f
    line = f.readline ()
    while line:
        # print "line = ", line
        if line[0] == '0':
            npackets = npackets + 1
        elif line[0] == '1':
            npackets = npackets + 1
            nerrors = nerrors + 1
        line = f.readline ()

    if npackets == 0:
        print ("0 errors out of 0 mpeg packets.  0 good packets.  Error rate = 1.000")
        return 1.0
    
    error_rate = float (nerrors) / float (npackets)
    print ("%d errors out of %d mpeg packets.  %d good packets.  Error rate = %5.3g"
           % (nerrors, npackets, npackets - nerrors, error_rate))

    return error_rate



def usage ():
    sys.stderr.write ('usage: mpeg_packet_error_rate.py [-s skip_count] transport_stream\n')
    sys.exit (1)


if __name__ == "__main__":
    import sys, getopt

    skip_count = 0;

    try:
        opts, args = getopt.getopt(sys.argv[1:], "hs:", [])

    except getopt.GetoptError:
        usage ()

    for o, a in opts:
        if o == "-h":
            usage ()
        if o == "-s":
            skip_count = a
            
    if len (args) != 1:
        usage ()
    else:
        error_rate (args[0], skip_count)
        sys.exit (0)
