/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.base.Optional;
import java.math.BigInteger;
import java.util.Arrays;
import org.gnunet.construct.Construct;
import org.gnunet.construct.Message;
import org.gnunet.construct.NestedMessage;
import org.gnunet.secretsharing.Ciphertext;
import org.gnunet.secretsharing.Parameters;
import org.gnunet.secretsharing.ThresholdPublicKey;
import org.gnunet.util.BigIntegers;
import org.gnunet.util.Configuration;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.SignedContentMessage;
import org.gnunet.voting.ChaumPedersenZkp;
import org.gnunet.voting.DisjunctionZkp;
import org.gnunet.voting.InvalidBallotException;

public class EncryptedVote
implements Message,
SignedContentMessage {
    @NestedMessage
    public Ciphertext v;
    @NestedMessage
    public DisjunctionZkp disjunctionZkp;
    @NestedMessage
    public EcdsaPublicKey voterPublicKey;

    public static EncryptedVote parseFromConfiguration(Configuration cfg, EcdsaPublicKey voterPublicKey) {
        Optional<String> optVal = cfg.getValueString("vote", "ENCRYPTED_VOTE_VAL");
        if (!optVal.isPresent()) {
            return null;
        }
        Optional<String> optZkp = cfg.getValueString("vote", "ZKP");
        if (!optZkp.isPresent()) {
            return null;
        }
        EncryptedVote encryptedVote = new EncryptedVote();
        encryptedVote.voterPublicKey = voterPublicKey;
        encryptedVote.v = Ciphertext.fromString((String)optVal.get());
        System.out.println("reading, string size " + ((String)optZkp.get()).length());
        byte[] zkpData = Strings.stringToData((String)optZkp.get());
        if (null == zkpData) {
            throw new InvalidBallotException("could not read ZKP from ballot");
        }
        encryptedVote.disjunctionZkp = Construct.parseAs(zkpData, DisjunctionZkp.class);
        return encryptedVote;
    }

    public static EncryptedVote fromChoice(int choiceId, ThresholdPublicKey thresholdPublicKey, EcdsaPublicKey voterPublicKey, BigInteger[] generators) {
        ChaumPedersenZkp zkp;
        EncryptedVote encryptedVote = new EncryptedVote();
        encryptedVote.v = new Ciphertext();
        encryptedVote.voterPublicKey = voterPublicKey;
        encryptedVote.disjunctionZkp = new DisjunctionZkp();
        encryptedVote.disjunctionZkp.chaumPedersenZkps = new ChaumPedersenZkp[generators.length];
        encryptedVote.disjunctionZkp.numProofs = generators.length;
        BigInteger alpha = Parameters.randomQ();
        BigInteger w = Parameters.randomQ();
        BigInteger h = new BigInteger(1, thresholdPublicKey.bits);
        BigInteger g = Parameters.elgamalG;
        BigInteger p = Parameters.elgamalP;
        BigInteger q = Parameters.elgamalQ;
        BigInteger x = Parameters.modPowG(alpha);
        BigInteger y = h.modPow(alpha, p).multiply(generators[choiceId]).mod(p);
        encryptedVote.v.c_1 = BigIntegers.serializeUnsigned(x, 1024);
        encryptedVote.v.c_2 = BigIntegers.serializeUnsigned(y, 1024);
        BigInteger d_sim_sum = BigInteger.ZERO;
        for (int i = 0; i < generators.length; ++i) {
            if (i == choiceId) continue;
            BigInteger r = Parameters.randomQ();
            BigInteger d = Parameters.randomQ();
            BigInteger a = g.modPow(r, p).multiply(x.modPow(d, p)).mod(p);
            BigInteger b = h.modPow(r, p).multiply(y.multiply(generators[i].modInverse(p)).modPow(d, p)).mod(p);
            d_sim_sum = d_sim_sum.add(d);
            ChaumPedersenZkp zkp2 = new ChaumPedersenZkp();
            zkp2.challenge_d = BigIntegers.serializeUnsigned(d, 1024);
            zkp2.response_r = BigIntegers.serializeUnsigned(r, 1024);
            zkp2.commit_a = BigIntegers.serializeUnsigned(a, 1024);
            zkp2.commit_b = BigIntegers.serializeUnsigned(b, 1024);
            if (!zkp2.verifySim(x, y, generators[i], h)) {
                throw new AssertionError((Object)"crypto not working");
            }
            encryptedVote.disjunctionZkp.chaumPedersenZkps[i] = zkp2;
        }
        encryptedVote.disjunctionZkp.chaumPedersenZkps[choiceId] = zkp = new ChaumPedersenZkp();
        BigInteger a = g.modPow(w, p);
        BigInteger b = h.modPow(w, p);
        zkp.commit_a = BigIntegers.serializeUnsigned(a, 1024);
        zkp.commit_b = BigIntegers.serializeUnsigned(b, 1024);
        BigInteger c = encryptedVote.disjunctionZkp.computeChallengeFromCommits();
        BigInteger d = c.subtract(d_sim_sum).mod(q);
        BigInteger r = w.subtract(alpha.multiply(d)).mod(q);
        zkp.challenge_d = BigIntegers.serializeUnsigned(d, 1024);
        zkp.response_r = BigIntegers.serializeUnsigned(r, 1024);
        if (!zkp.verifySim(x, y, generators[choiceId], h)) {
            throw new AssertionError((Object)"crypto (2) not working");
        }
        encryptedVote.disjunctionZkp.challenge_c = BigIntegers.serializeUnsigned(c, 1024);
        if (!encryptedVote.disjunctionZkp.verifyChallenge()) {
            throw new AssertionError((Object)"crypto not working (3)");
        }
        return encryptedVote;
    }

    public void writeToConfiguration(Configuration cfg) {
        cfg.setValueString("vote", "ENCRYPTED_VOTE_VAL", this.v.toString());
        byte[] zkpData = Construct.toBinary(this.disjunctionZkp);
        String zkpString = Strings.dataToString(zkpData);
        if (zkpString.length() != Strings.getEncodedStringLength(zkpData.length)) {
            throw new AssertionError((Object)"fail");
        }
        if (zkpData.length != Strings.getDecodedDataLength(zkpString.length())) {
            throw new AssertionError((Object)("fail, got " + zkpData.length + " expected " + Strings.getDecodedDataLength(zkpString.length()) + "for string length" + zkpString.length()));
        }
        System.out.println("everyting ok, size binary size" + zkpData.length + " str size " + zkpString.length());
        byte[] zkpData2 = Strings.stringToData(zkpString);
        if (!Arrays.equals(zkpData, zkpData2)) {
            throw new AssertionError((Object)"something wrong");
        }
        System.out.println("everyting ok, size binary size" + zkpData.length + " str size " + zkpString.length());
        cfg.setValueString("vote", "ZKP", zkpString);
    }

    public boolean verify() {
        return false;
    }
}

