/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.gnunet.util.Configuration;
import org.gnunet.util.Resolver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.gnunet.util.getopt.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Program {
    private static final Logger logger = LoggerFactory.getLogger(Program.class);
    protected final Configuration cfg = new Configuration();
    @Argument(shortname="c", longname="config", description="path of the configuration file", argumentName="FILENAME", action=ArgumentAction.STORE_STRING)
    public String cfgFileName;
    @Argument(shortname="h", longname="help", description="print this help message", action=ArgumentAction.SET)
    public boolean printHelp;
    @Argument(shortname="v", longname="version", description="print version", action=ArgumentAction.SET)
    public boolean showVersion;
    @Argument(shortname="L", longname="log", description="configure logging to use LOGLEVEL", argumentName="LOGLEVEL", action=ArgumentAction.STORE_STRING)
    public String logLevel;
    @Argument(shortname="l", longname="logfile", description="configure logging to write logs to LOGFILE", argumentName="LOGFILE", action=ArgumentAction.STORE_STRING)
    public String logFile;
    protected String[] unprocessedArgs;
    private int returnValue = 0;

    public static void configureLogging(String logLevel, String logFile) {
        org.apache.log4j.Logger rootLogger = LogManager.getRootLogger();
        rootLogger.removeAllAppenders();
        PatternLayout layout = new PatternLayout("%d{dd MMM yyyy HH:mm:ss-SSS} %c{2} %p: %m%n");
        if (logFile == null) {
            rootLogger.addAppender((Appender)new ConsoleAppender((Layout)layout, "System.out"));
        } else {
            FileAppender appender = null;
            try {
                appender = new FileAppender((Layout)layout, logFile);
            }
            catch (IOException e) {
                logger.warn("could not open log file {}", (Object)logFile);
            }
            if (appender != null) {
                rootLogger.removeAllAppenders();
                rootLogger.addAppender((Appender)appender);
            }
        }
        if (logLevel == null) {
            rootLogger.setLevel(Level.INFO);
        } else if (logLevel.equalsIgnoreCase("debug")) {
            rootLogger.setLevel(Level.DEBUG);
        } else if (logLevel.equalsIgnoreCase("info")) {
            rootLogger.setLevel(Level.INFO);
        } else if (logLevel.equalsIgnoreCase("warn") || logLevel.equalsIgnoreCase("warning")) {
            rootLogger.setLevel(Level.WARN);
        } else if (logLevel.equalsIgnoreCase("error")) {
            rootLogger.setLevel(Level.ERROR);
        } else if (logLevel.equalsIgnoreCase("off")) {
            rootLogger.setLevel(Level.OFF);
        } else {
            rootLogger.setLevel(Level.INFO);
            logger.info("unknown log level '{}'; defaulting to INFO", (Object)logLevel);
        }
    }

    public static void configureLogging(String logLevel) {
        Program.configureLogging(logLevel, null);
    }

    public static void configureLogging() {
        Program.configureLogging(null, null);
    }

    protected String makeHelpText() {
        return "gnunet-java tool";
    }

    protected String makeVersionDescription() {
        return "development version of gnunet-java";
    }

    protected final void setReturnValue(int x) {
        this.returnValue = x;
    }

    void runHook() {
        this.run();
    }

    protected abstract void run();

    protected final Configuration getConfiguration() {
        return this.cfg;
    }

    public final int start(boolean withScheduler, String ... args) {
        Parser optParser = new Parser(this);
        this.unprocessedArgs = optParser.parse(args);
        Program.configureLogging(this.logLevel, this.logFile);
        this.cfg.loadDefaults();
        if (this.cfgFileName != null) {
            this.cfg.parse(this.cfgFileName);
        }
        Resolver.getInstance().setConfiguration(this.cfg);
        if (this.showVersion) {
            System.out.println(this.makeVersionDescription());
        } else if (this.printHelp) {
            System.out.println(this.makeHelpText());
            System.out.print(optParser.getHelp());
        } else if (withScheduler) {
            Scheduler.run(new Scheduler.Task(){

                @Override
                public void run(Scheduler.RunContext c) {
                    Program.this.runHook();
                }
            });
        } else {
            this.runHook();
        }
        if (Scheduler.hasTasks()) {
            logger.error("scheduler still has pending tasks after program returned");
        }
        return this.returnValue;
    }

    public final int start(String ... args) {
        return this.start(true, args);
    }

    public final int startWithoutScheduler(String ... args) {
        return this.start(false, args);
    }
}

