/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.StringTerminationType;
import org.gnunet.construct.parsers.Parser;

public class VariableSizeStringParser
implements Parser {
    private final Field targetField;
    private ReflectUtil.NumField sizeField;
    private StringTerminationType terminationType;

    public VariableSizeStringParser(StringTerminationType terminationType, Field sizeField, Field arrayField) {
        this.targetField = arrayField;
        this.sizeField = new ReflectUtil.NumField(sizeField);
        this.terminationType = terminationType;
    }

    @Override
    public int getSize(Message src) {
        String str = (String)ReflectUtil.justGet(src, this.targetField);
        if (str == null) {
            throw new RuntimeException("string");
        }
        switch (this.terminationType) {
            case NONE: {
                return str.length();
            }
            case ZERO_EXCLUDED: {
                return str.length() + 1;
            }
            case ZERO_INCLUDED: {
                return str.length() + 1;
            }
        }
        throw new AssertionError();
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int skipSize;
        int strSize;
        int size = (int)this.sizeField.get(dstObj);
        switch (this.terminationType) {
            case NONE: {
                strSize = size;
                skipSize = 0;
                break;
            }
            case ZERO_EXCLUDED: {
                strSize = size;
                skipSize = 1;
                break;
            }
            case ZERO_INCLUDED: {
                strSize = size - 1;
                skipSize = 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        byte[] data = new byte[strSize];
        srcBuf.get(data);
        srcBuf.position(srcBuf.position() + skipSize);
        ReflectUtil.justSet(dstObj, this.targetField, new String(data));
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message src) {
        int n;
        String str = (String)ReflectUtil.justGet(src, this.targetField);
        if (str == null) {
            throw new RuntimeException("string must not be null");
        }
        byte[] data = str.getBytes();
        switch (this.terminationType) {
            case NONE: {
                dstBuf.put(data);
                n = data.length;
                break;
            }
            case ZERO_INCLUDED: {
                dstBuf.put(data);
                dstBuf.put((byte)0);
                n = data.length + 1;
                break;
            }
            case ZERO_EXCLUDED: {
                dstBuf.put(data);
                dstBuf.put((byte)0);
                n = data.length + 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return n;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        String str = (String)ReflectUtil.justGet(m, this.targetField);
        if (str == null) {
            throw new RuntimeException("string must not be null");
        }
        int size = this.terminationType == StringTerminationType.ZERO_INCLUDED ? str.length() + 1 : str.length();
        this.sizeField.set((Object)m, size);
    }

    @Override
    public int getStaticSize() {
        return 0;
    }
}

