/*
    Menu definition code.
    Copyright (C) 1998  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License,  or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef XAW_MENU_H
#define XAW_MENU_H



extern const char help_string[] ;




#include <X11/Intrinsic.h>

typedef void (*CBfunc)(Widget w,  XtPointer clientData,  XtPointer call_data);

typedef struct   {
  Widget parent;
  Widget caller;
} MenuWidgetData ;



struct MenuDef {
  const char * name;
  CBfunc callback;
  XtPointer clientData;
};


struct MessageBoxData {
  int height;
  int width;
  const char *message;
};



struct MenuParameters {
  MenuWidgetData widgets;
  struct MenuDef definition;
};


void showBox (Widget w,  XtPointer clientData,  XtPointer callData);
void popDown (Widget w,  XtPointer clientData,  XtPointer callData);

typedef struct MenuParameters ** Menu;

void destroyMenu (Menu p);


Menu createMenu (Widget shell,
				   Widget launch,
				   struct MenuDef* menuItems,
				   int itemQty);


#endif
