// -*- mode: c++ -*- 
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/**************************************************
*	Class FeatureCombination
* 
*
***************************************************
*
* Compiler Defines
*
***************************************************
*
* Modification History
*
* HM 990108 Put in the documentation
*
***************************************************/
#include "CFeatureCombination.h"
#include <algorithm>
#include <math.h>
#include <assert.h>
#include "gift_features.h"


/***************************************
*
* ()
*
****************************************
*
* modification history
*
* 
*
****************************************/
double CFeatureCombination::operator()(double inRelevanceLevel,
				       int inFeatureType,
				       double inAddendFF,
				       double inCumulatedFF){
  double lReturnValue=0;
  
  if(inRelevanceLevel>0.7){
    lReturnValue=
      inCumulatedFF
      +inAddendFF;
  }else{
    if(inRelevanceLevel<0.3){
	  lReturnValue=
	    inCumulatedFF
	    -inAddendFF;
    }
  }

  return lReturnValue;
}



/***************************************
*
* ()
*
****************************************
*
* modification history
*
* 
*
****************************************/
double CFeatureCombination::operator()(double inRelevanceLevel,
				       int inFeatureType,
				       double inAddendFF){
  return operator()(inRelevanceLevel,
		    inFeatureType,
		    inAddendFF,
		    0);
}


