#!/usr/bin/perl -w # -*- mode: perl -*-

#     GIFT, a flexible content based image retrieval system.
#     Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



use lib '/home/demo/gift-0.1.4e/../GIFTInstall/bin'; # for including CFeedbackClient
use CXMLTreeBuilder;


package CXMLTreeWriter;
use CXTVWriter;

@ISA=qw(Exporter);
@EXPORT_OK=qw(new
	      writeToStream);

sub new(){
  my $class = shift;
  my $self = {};
  bless $self, $class;
  $self->initialize(@_);
  return $self;
}

sub initialize(){
  my$self=shift;
}

sub writeToStream( $$ ){
  my$self=shift;

  my $inRoot=shift;
  my $inStream=shift;

  $self->{visitor}=new CXTVWriter($inStream);

  $self->_traverse($inRoot,$self->{visitor});
}

sub _traverse( $$ ){

  my$self=shift;

  my $lRoot=shift;
  my $lVisitor=shift;

  $lVisitor->startVisit($lRoot);

  if(defined($lRoot->{children})){

    my $i;

    foreach $i (@{$lRoot->{children}}){
      $self->_traverse($i,$lVisitor);
    }
  }

  $lVisitor->endVisit($lRoot);
  return;
}


